'use strict';
/*
 * shoe event template
 */
angular.module('controllers.eventTemplate', [])
        .controller('eventTemplateCtrl', ['$scope', 'dialogService', 'templateSvc',
            function($scope, dialogService, templateSvc) {
                var tempList = [];
                var templateStatus = true;
                var templateName = "";
                var templateId = "";
                $scope.type = $scope.model.type;
                $scope.setSelected = function() {
                    if ($scope.lastSelected) {
                        $scope.lastSelected.selected = '';
                    }
                    this.selected = 'selected';
                    $scope.lastSelected = this;
                };

                $scope.settingsParam = {
                    tmpStatus: true,
                    templateList: tempList,
                    templateLength: 0
                };

                $scope.showAllList = function(flag) {
                    templateSvc.getTemplates(flag, $scope.type, function(template) {
                        if (!flag) {
                            $scope.settingsParam.templateLength = template.length;
                        }
                        $scope.settingsParam.templateList = processTemplateResult(template);
                        $scope.$apply();

                    });
                };

                $scope.showHistory = function(flag) {
                    templateSvc.getTemplates(flag, $scope.type, function(template) {
                        $scope.settingsParam.templateList = processTemplateResult(template);
                        $scope.$apply();

                    });
                };

                $scope.showTemplate = function(flag) {
                    templateSvc.getTemplates(flag, $scope.type, function(template) {
                        $scope.settingsParam.templateLength = template.length;
                        $scope.settingsParam.templateList = processTemplateResult(template);
                        $scope.$apply();
                    });
                };

                $scope.indivdualTemplate = function(tmpId, tmpName) {
                    //color changing code place in here
                    templateId = tmpId;
                    templateName = tmpName;
                };

                $scope.selectTemplate = function() {
                    if (templateName) {
                        $scope.model.selectedTemplate(templateName);
                        dialogService.close("eventTemplateFormPopUp");
                        templateId = "";
                        templateName = "";
                    }
                };

                $scope.deleteTemplate = function() {
                    if (templateId) {
                        templateSvc.deleteTemplate(templateId, function() {
                            templateSvc.getTemplates(true, $scope.type, function(template) {
                                $scope.settingsParam.templateList = processTemplateResult(template);
                                $scope.$apply();
                                templateId = "";
                                templateName = "";
                            });
                        });
                    }
                };

                $scope.createTemplate = function() {
                    var createTemplateModel = {
                        newTemplate: function() {
                            $scope.showAllList(false);
                        }
                    };
                    dialogService.open("createTemplateFormPopUp", "createTemplateForm", createTemplateModel, {title: getMSG('Template_Edit')});
                };

                $scope.editTemplate = function() {
                    if (!templateId || !templateName) {
                        templateSvc.getTemplates(false, $scope.type, function(template) {
                            templateName = template[0].event_name;
                            templateId = template[0].id;
                            templateStatus = false;
                            setEditValues();
                        });
                    } else {
                        templateStatus = true;
                        setEditValues();
                    }
                };

                function setEditValues() {
                    var editTemplateModel = {
                        tmpName: templateName,
                        tmpid: templateId,
                        temStatus: templateStatus,
                        editTemplate: function() {
                            $scope.showAllList(false);
                        }
                    };
                    dialogService.open("editTemplateFormPopUp", "editTemplateForm", editTemplateModel, {title: getMSG('Template_Edit')});
                    templateId = "";
                    templateName = "";
                }

                function processTemplateResult(res) {
                    var templateList = [];
                    var templateItem;
                    for (var i = 0; i < res.length; i++) {
                        if (res[i].event_name !== null) {
                            templateItem = {};
                            templateItem.eventName = res[i].event_name;
                            templateItem.id = res[i].id;
                            templateList.push(templateItem);
                        }
                    }
                    return templateList;
                }
                $scope.showAllList(true);
            }])

        .controller('createTemplateCtrl', ['$scope', 'dialogService', 'templateSvc',
            function($scope, dialogService, templateSvc) {
                $scope.settingsParam = {
                    templateName: ""
                };
                $scope.createNewTemplate = function() {
                    var tm = new TemplateJorte();
                    if ($scope.settingsParam.templateName)
                        tm.event_name = $scope.settingsParam.templateName, tm.flag = 0, tm.create_date = null, tm.update_date = null;
                    templateSvc.createTemplate(tm, function() {
                        dialogService.close("createTemplateFormPopUp");
                        $scope.model.newTemplate();
                    });
                };
                $scope.cancelTemplate = function() {
                    dialogService.close("createTemplateFormPopUp");
                };
                function TemplateJorte() {
                    this.event_name = null; //string null
                    this.flag = null; //int null
                    this.create_date = null; //text 
                    this.update_date = null; //text
                }
            }])
        .controller('editTemplateCtrl', ['$scope', 'dialogService', 'templateSvc',
            function($scope, dialogService, templateSvc) {
                $scope.settingsParam = {
                    templateName: "",
                    templateId: ""
                };
                var stausValue = $scope.model.temStatus;
                if (!stausValue) {
                    $scope.initData = function() {
                        $scope.settingsParam.templateName = $scope.model.tmpName;
                        $scope.settingsParam.templateId = $scope.model.tmpid;
                        $scope.$apply();
                    };
                } else {
                    $scope.settingsParam.templateName = $scope.model.tmpName;
                    $scope.settingsParam.templateId = $scope.model.tmpid;
                }
                $scope.updateTemplate = function() {
                    templateSvc.updateTemplate($scope.settingsParam.templateId, $scope.settingsParam.templateName, function() {
                        $scope.model.editTemplate();
                        dialogService.close("editTemplateFormPopUp");
                    });
                };
                $scope.deleteTemplate = function() {
                    if ($scope.settingsParam.templateId) {
                        templateSvc.deleteTemplate($scope.settingsParam.templateId, function() {
                            $scope.model.editTemplate();
                            dialogService.close("editTemplateFormPopUp");
                        });
                    }
                };
                $scope.cancelTemplate = function() {
                    dialogService.close("editTemplateFormPopUp");
                };
            }]);