'use strict';
/*
 * Jorte controller
 */
angular.module('controllers.googleTimezone', [])
        // Timezone for google
        .controller('googleTimezoneCtrl', ['$scope', 'dialogService', function($scope, dialogService) {
                var timeZoneList = [];
                for (var i in timezone_list) {
                    var mins = timezone_list[i];
                    var h = parseInt(Math.abs(mins / 60));
                    var m = parseInt(mins % 60);
                    var txt = i + " : GMT" + (mins < 0 ? "-" : "+") + (h < 10 ? '0' + h : h) + ":" + (m < 10 ? '0' + m : m);
                    timeZoneList.push({'value': i, 'text': txt});
                }

                $scope.timeZoneList = timeZoneList;
                $scope.gTz = $scope.model.defTz;
                $scope.setGTimezone = function(tz) {
                    $scope.model.googleTimeZoneCb(tz);
                    dialogService.close('googleTimezonePopup');
                };
            }]);