'use strict';
/*
 * Create event controller
 */
angular.module('controllers.iconList', [])

        .controller('iconListCtrl', ['$scope', 'dialogService', function($scope, dialogService) {
                var iconArray = jorteConfig.getStoredIcons();
                $scope.iconParams = {
                    iconList: JorteEventIcons,
                    storedIcons: iconArray,
                    showDelete: false,
                    iconSrc: $scope.model.iconSrc
                };
                if ($scope.iconParams.iconSrc) {
                    // FOR DISPLAYING CANCEL AND DELETE BUTTON
                    $scope.iconParams.showDelete = true;
                }
                $scope.setIcon = function(imgSrc) {
                    $scope.model.eventIcon(imgSrc);

                    var iconArray;
                    if ($scope.iconParams.storedIcons) {
                        iconArray = $scope.iconParams.storedIcons;
                    } else {
                        iconArray = [];
                    }
                    iconArray.unshift(imgSrc);
                    iconArray = createUniqueAray(iconArray);
                    if (iconArray.length > 5) {
                        iconArray.pop();
                    }
                    jorteConfig.setStoredIcons(iconArray);
                    dialogService.close('iconListPopup');
                };

                $scope.delete = function() {
                    $scope.model.eventIcon(null);
                    dialogService.close('iconListPopup');
                };

                $scope.cancel = function() {
                    dialogService.close('iconListPopup');
                };

                // FUNCTION TO CREATE UNIQUE ARRAY
                function createUniqueAray(origArr) {
                    var newArr = [], origLen = origArr.length, found, x, y;

                    for (x = 0; x < origLen; x++) {
                        found = undefined;
                        for (y = 0; y < newArr.length; y++) {
                            if (origArr[x] === newArr[y]) {
                                found = true;
                                break;
                            }
                        }
                        if (!found)
                            newArr.push(origArr[x]);
                    }
                    return newArr;
                }
            }]);