'use strict';

/**
 * Jorte repeat controller
 * 
 */
angular.module('controllers.repeatForm', [])

        //Main repeat controller
        .controller('repeatFormCtrl', ['$scope', 'rruleSvc', 'dialogService',
            function($scope, rruleSvc, dialogService) {

                //From create event controller
                $scope.repeatParams = {};
                $scope.repeatParams = $scope.model.repeatCrtParam;
                $scope.repeatParams.startDate = jorteUtils.formatDate($scope.model.repeatCrtParam.currentDate, getMSG('LongDateFormat6'), cal_string);
                outlineLabel();

                //Open repeat select type popup
                $scope.repeatSelect = function() {
                    var repeatSelectModel = {
                        repeatVal: $scope.repeatParams.type,
                        currentDate: $scope.repeatParams.currentDate,
                        repeatTypeCb: function(type) {
                            $scope.repeatParams.type = type;
                            $scope.repeatParams.label = jorteUtils.getRepeatText(type);                            
                            outlineLabel();
                        }
                    };
                    dialogService.open('repeatSelectPopup', 'repeatSelect', repeatSelectModel, {title: getMSG('SelectHead')});
                };
                //Repeat time interval popup
                $scope.repeatTimeInterval = function() {
                    var repeatIntervalModel = {
                        repeatInterval: $scope.repeatParams.repeatInterval,
                        repeatIntervalCb: function(val) {
                            $scope.repeatParams.repeatInterval = val;
                            outlineLabel();
                        }
                    };
                    dialogService.open('repeatIntervalPopup', 'repeatInterval', repeatIntervalModel, {title: getMSG('SelectHead')});
                };

                $scope.repeatNumberPopup = function() {
                    var repeatNumberModel = {
                        repeatNum: $scope.repeatParams.repNum,
                        repeatNumCb: function(val) {
                            $scope.repeatParams.repNum = val;
                            outlineLabel();
                        }
                    };
                    dialogService.open('repeatNumberPopup', 'repeatNumber', repeatNumberModel, {title: getMSG('SpecifyNumberTimesHead')});
                };

                //Date and time detail area
                $scope.setSpecifyDate = function(dateStr) { //Set start date
                    $scope.repeatParams.specifyDay = new Date(dateStr);
                    $scope.repeatParams.specifyDayLabel = jorteUtils.formatDate(new Date(dateStr), getMSG('LongDateFormat6'), cal_string);
                    var rrRes = rruleSvc.getRRLabel($scope.repeatParams);
                    $scope.repeatParams.outlineLabel = rrRes.label;
                };

                $scope.oneTimeOk = function() {
                    $scope.model.repeatCrtParamsCb($scope.repeatParams);
                    dialogService.close('repeat0Popup');
                };

                $scope.oneTimeCancel = function() {
                    dialogService.close('repeat0Popup');
                };

                $scope.specifyFn = function() {
                    outlineLabel();
                };

                function outlineLabel() {
                    var rrRes = rruleSvc.getRRLabel($scope.repeatParams);
                    var delay = $scope.repeatParams.type !== 0 ? 700 : 10;
                    $scope.repeatParams.specifyDay = rrRes.endDate;
                    $scope.repeatParams.specifyDayLabel = jorteUtils.formatDate(rrRes.endDate, getMSG('LongDateFormat6'), cal_string);
                    $scope.repeatParams.outlineLabel = rrRes.label;
                    setTimeout(function() {
                        dialogService.refresh('repeat0Popup');
                    }, delay);
                }
            }]);