'use strict';

/**
 * Jorte repeat select controller
 * 
 */
angular.module('controllers.repeatSelect', [])

        //Main repeat controller
        .controller('repeatSelectCtrl', ['$rootScope', '$scope', 'dialogService', function($rootScope, $scope, dialogService) {
                $scope.repeatVal = $scope.model.repeatVal;
                $scope.currentDay = jorteUtils.formatDate($scope.model.currentDate, 'ddd');
                var weeklyLabel;
                if ($scope.currentDay === 'Tue' || $scope.currentDay === 'Thu') {
                    weeklyLabel = getMSG('WeeklyTueThuHead');
                } else {
                    weeklyLabel = getMSG('WeeklyMonWedFriHead');
                }
                $scope.repeatLabelWeekDay = weeklyLabel;//Pass to view
                $scope.repeatLabel = jorteUtils.getRepeatText(parseInt($scope.repeatVal));//Pass to view
                //Select repeat type popup
                $scope.repeatType = function(type) {
                    $scope.model.repeatTypeCb(type);
                    dialogService.close('repeatSelectPopup');
                };
            }])

        .controller('repeatTimeIntervalCtrl', ['$scope', 'dialogService', function($scope, dialogService) {
                //Repeat time interval popup
                var timeInterval = [];
                for (var i = 1; i <= 30; i++) {
                    timeInterval.push({val: i});
                }
                $scope.timeIntrvalList = timeInterval;
                $scope.timeInterval = $scope.model.repeatInterval;
                $scope.selectInterval = function(val) {
                    $scope.model.repeatIntervalCb(val);
                    dialogService.close('repeatIntervalPopup');
                };
            }])

        .controller('repeatNumberCtrl', ['$scope', 'dialogService', function($scope, dialogService) {
                //Repeat number popup
                $scope.repeatNum = $scope.model.repeatNum;
                $scope.addNum = function() {
                    if ($scope.repeatNum >= 999) {
                        $scope.repeatNum = 1;
                    } else {
                        $scope.repeatNum++;
                    }
                };

                $scope.subNum = function() {
                    if ($scope.repeatNum === 1) {
                        $scope.repeatNum = 999;
                    } else {
                        $scope.repeatNum--;
                    }
                };

                $scope.repeatNumberOk = function() {
                    $scope.model.repeatNumCb($scope.repeatNum);
                    dialogService.close('repeatNumberPopup');
                };

                $scope.repeatNumberCancel = function() {
                    dialogService.close('repeatNumberPopup');
                };
            }]);