'use strict';

/**
 * Navigation and details popup controller
 * 
 */
angular.module('controllers.eventTaskDetails', [])

        //controller for detail display popup for event/task
        .controller('eventTaskDetailCtrl', ['$sce', '$rootScope', '$scope', 'eventSvc', 'taskSvc', 'evtCalendarSvc', 'syncSvc', 'notificationSvc', 'dialogService',
            function($sce, $rootScope, $scope, eventSvc, taskSvc, evtCalendarSvc, syncSvc, notificationSvc, dialogService) {

                var modelData = $scope.model;
                var itemIndex = modelData.itemIndex;
                var itemList = modelData.renderList;
                var dateObj = modelData.dateObj;
                function processDetails(itemDetail) {
                    var renderDetail = {};
                    var data = itemDetail.details;
                    if (itemDetail.itemType === 0) { //event
                        renderDetail = processEventDetails(data);
                    } else if (itemDetail.itemType === 1) { //task
                        renderDetail = processTaskDetails(data);
                    } else if (itemDetail.itemType === 2) { //deliver event
                        renderDetail = processDeliverEventDetails(data);
                    }
                    return renderDetail;
                }
                function deleteEventProcess(type,item){// 1:single event,2:this & future,3:All events
                    switch (type){
                        case 1:
                            deleteOnlyThisEvent(item);
                            break;
                        case 2:
                            deleteEvent(item.id);
                            break;
                        case 3:
                            deleteThisAndFutureEvents(item);
                            break;
                    }
                }
                function deleteOnlyThisEvent(item){
                    eventSvc.deleteOnlyThisEvent(item,function (del_global_id, parent_global, del_event_id){
                        var itemListObj = itemList[itemIndex];
                        var details = itemListObj.details;
                        for (var i = 0; i < itemList.length; i++) {
                            var itm = itemList[i];
                            if (itm.itemId === item.id) { //delete elements from model list too
                                itemList.splice(i, 1);
                                i--;
                            }
                        }
                        if (itemIndex >= itemList.length) {
                            itemIndex = itemList.length - 1;
                        }
                        fetchItemDetails(showItem);
                        $scope.$apply();
                        var params = {calendar_id: details[0].calendar_id, calendar_type: details[0].calendar_type};
                        if (details[0].global_id) {
                            if (details[0].calendar_type !== 300) {
                                params.jorteCalendar = true;
                                params.del_global_id = del_global_id;
                                params.parent_global = parent_global ? parent_global : null;
                                params.del_event_id = del_event_id;
                            } else {
                                params.googleCalendar = true;
                                params.del_global_id = del_global_id;
                            }
                        }
                        setTimeout(function () {
                            $rootScope.$broadcast('singleRepeatEventDeleted', itemListObj);//broadcast to listeners for update their model/view
                            if (params.del_global_id || params.parent_global) {
                                syncSvc.syncSingleEvent(params, function () {
                                });
                            }
                        }, 10);
                    });
                }
                function deleteThisAndFutureEvents(eventItem) {
                    var itemListObj = itemList[itemIndex];
                    for (var i = 0; i < itemList.length; i++) {
                        var itm = itemList[i];
                        if (itm.itemId === eventItem.id) { //delete elements from model list too
                            itemList.splice(i, 1);
                            i--;
                        }
                    }
                    if (itemIndex >= itemList.length) {
                        itemIndex = itemList.length - 1;
                    }
                    fetchItemDetails(showItem);

                    eventSvc.getSingleEvent(eventItem.id, function (event) {
                        if (eventItem.start_date === event.start_date) {
                            deleteEvent(event.id);
                        } else {
                            var OldRepeatSelectObj, OldRepeat;
                            var update_date = (new Date()).getTime();
                            if (eventItem.repeat) {
                                var OldRepeats = eventItem.repeat.toString();
                                OldRepeatSelectObj = RRule.parseString(OldRepeats);
                                var dateObj = new Date(eventItem.start_date);
                                var rEnd = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate(), dateObj.getHours(), dateObj.getMinutes(), dateObj.getSeconds() - 1);
                                rEnd = jorteUtils.calcTime(eventItem.timezone, rEnd.getTime());
                                delete OldRepeatSelectObj.count;
                                OldRepeatSelectObj.until = rEnd;
                                OldRepeat = new RRule(OldRepeatSelectObj);
                                OldRepeat = OldRepeat.toString();
                            }
                            var rdata = {
                                event_id: eventItem.id,
                                repeat: OldRepeat,
                                update_date: update_date,
                                repeatSelectObj: OldRepeatSelectObj,
                                repeat_end: rEnd
                            };

                            var bData = angular.copy(rdata);
                            eventSvc.updateFutureEventDetails(rdata, function () {
                                bData.clickedDate = new Date(eventItem.start_date);
                                var params = {id: eventItem.id, calendar_id: eventItem.calendar_id, calendar_type: eventItem.calendar_type};
                                if (eventItem.calendar_type !== 300) {
                                    params.jorteCalendar = true;
                                } else {
                                    params.googleCalendar = true;
                                }
                                $rootScope.$broadcast('eventTaskItemDeleted', itemListObj);//broadcast to listeners for update their model/view
                                $rootScope.$broadcast('eventUpdated', bData);
                                if (eventItem.cal_global_id) {
                                    syncSvc.syncSingleEvent(params, function () {
                                        setTimeout(function () {
                                            $rootScope.$broadcast('eventUpdated', bData);
                                        }, 10);
                                    });
                                }
                            });
                        }
                    });
  
                }
                function deleteEvent(delItemId) {
                    eventSvc.deleteEvent(delItemId, function () {
                        var itemListObj = itemList[itemIndex];
                        for (var i = 0; i < itemList.length; i++) {
                            var itm = itemList[i];
                            if (itm.itemId === delItemId) { //delete elements from model list too
                                itemList.splice(i, 1);
                                i--;
                            }
                        }
                        if (itemIndex >= itemList.length) {
                            itemIndex = itemList.length - 1;
                        }
                        fetchItemDetails(showItem);
                        $scope.$apply();
                        if(!itemListObj){
                            return ;
                        }
                        var details = itemListObj.details;
                        var params = {calendar_id: details[0].calendar_id, calendar_type: details[0].calendar_type};
                        if (details[0].global_id) {
                            if (details[0].calendar_type !== 300) {
                                params.jorteCalendar = true;
                                params.del_global_id = details[0].global_id;
                            } else {
                                params.googleCalendar = true;
                                params.id = delItemId;
                            }
                        }
                        setTimeout(function () {
                            $rootScope.$broadcast('eventTaskItemDeleted', itemListObj);//broadcast to listeners for update their model/view
                            if (params.del_global_id || params.id) {
                                syncSvc.syncSingleEvent(params, function () {
                                });
                            }
                        }, 10);

                    }, function () {
                        alert('Item not found for delete');
                    });
                }
                $scope.renderDetail = {};
                $scope.hasNext = false;
                $scope.hasPrev = false;
                function showItem() {
                    if (itemIndex >= 0 && itemList && itemList.length > 0) {
                        $scope.renderDetail = processDetails(itemList[itemIndex]);
                        $scope.hasNext = itemList.length > itemIndex + 1;
                        $scope.hasPrev = itemIndex > 0;
                        if (itemList[itemIndex].itemType === 1) {
                            $scope.titleText = getMSG('TasksandMemosHead');
                        } else {
                            $scope.titleText = jorteUtils.formatDate(dateObj, getMSG('LongDateFormat2'), cal_string);
                        }
                    } else {
                        try {
                            $scope.closePopup();
                        } catch (e) {
                            console.log('Error on closing ', e);
                        }
                    }
                }
                function fetchItemDetails(resultCB) {
                    if (itemIndex >= itemList.length || itemIndex < 0) {//no items
                        resultCB();
                        return;
                    }
                    var curDetail = itemList[itemIndex];
                    if (curDetail.details) {//if already loaded
                        resultCB();
                        return;
                    }
                    if (curDetail.itemType === 0) { // for events
                        var startTime = dateObj.setHours(0, 0, 0, 0);
                        var endTime = dateObj.setHours(23, 59, 59, 999);
                        eventSvc.getEventAndInstancesForEdit(startTime, endTime, curDetail.itemId, curDetail.itemInstanceId, function(data) {
                            curDetail.details = data;
                            resultCB();
                            $scope.$apply();
                        });
                    } else if (curDetail.itemType === 1) { //for task
                        taskSvc.getTaskForEdit(curDetail.itemId, function(data) {
                            curDetail.details = data;
                            resultCB();
                            $scope.$apply();
                        });
                    } else if (curDetail.itemType === 2) { //for event calendar
                        evtCalendarSvc.getDeliverEventDetails(curDetail.itemId, function(data) {
                            curDetail.details = data;
                            resultCB();
                            $scope.$apply();
                        });
                    }
                }
                fetchItemDetails(showItem);
                //Detail popup navigation to previous element
                $scope.movePrev = function() {
                    if (itemIndex <= 0) {
                        return;
                    }
                    itemIndex = itemIndex - 1;
                    fetchItemDetails(showItem);
                };
                //Detail popup navigation to next element
                $scope.moveNext = function() {
                    if (itemIndex >= itemList.length - 1) {
                        return;
                    }
                    itemIndex = itemIndex + 1;
                    fetchItemDetails(showItem);
                };
                //Close popup
                $scope.closePopup = function() {//popup name differs based on from where the detail popup opened.
                    if (dialogService.dialogs['eventTaskDetailPopup_MainEvents']) {
                        dialogService.close('eventTaskDetailPopup_MainEvents');
                    } else if (dialogService.dialogs['eventTaskDetailPopup_BottomTasks']) {
                        dialogService.close('eventTaskDetailPopup_BottomTasks');
                    } else if (dialogService.dialogs['eventTaskDetailPopup']) {
                        dialogService.close('eventTaskDetailPopup');
                    } else if (dialogService.dialogs['eventTaskDetailPopup_BottomEvtsAndTasks']) {
                        dialogService.close('eventTaskDetailPopup_BottomEvtsAndTasks');
                    }
                };
                //Deleting an item
                $scope.onItemDelete = function() {
                    var delItemId = itemList[itemIndex].itemId;
                    var itemType = itemList[itemIndex].itemType;
                    if (itemType === 0) {
                        if (confirm(getMSG('DoYouWantToDeleteThisEventHead'))) {
                            var model = {
                                item: itemList[itemIndex].details[0],
                                repeatEventDeleteCb:deleteEventProcess
                            };
                            if (itemList[itemIndex].details[0].repeat && !itemList[itemIndex].details[0].parent) {
                                var calendarType = itemList[itemIndex].details[0].calendar_type, popupName, popupTitle, minHeight;
                                if (calendarType === 300) {//Google repeat delete requires ok&cancel button
                                    popupName = 'repeatEventDeleteGoogle';
                                    popupTitle = getMSG('DeleteHead');
                                    minHeight = 320;
                                } else {
                                    popupName = 'repeatEventDelete';
                                    popupTitle = getMSG('SelectRepeatDelete');
                                    minHeight = 192;
                                }
                                dialogService.open("repeatEventDeletePopup", popupName, model, {title: popupTitle, minHeight: minHeight, refreshPopup: true});
                            } else {
                                deleteEvent(delItemId);
                            }
                            return 1;
                        }
                    } else if (itemType === 1) {
                        if (confirm(getMSG('DoYouWantToDeleteTheTasksAndMemosHead'))) {
                            taskSvc.deleteTask(delItemId, function(old_instances) {
                                var itemListObj = {};
                                $.extend(itemListObj, itemList[itemIndex]);
                                itemListObj.old_instances = old_instances;
                                var details = itemListObj.details;
                                for (var i = 0; i < itemList.length; i++) {
                                    var itm = itemList[i];
                                    if (itm.itemId === delItemId) { //delete elements from model list too
                                        itemList.splice(i, 1);
                                        i--;
                                    }
                                }
                                if (itemIndex >= itemList.length) {
                                    itemIndex = itemList.length - 1;
                                }
                                fetchItemDetails(showItem);
                                $scope.$apply();
                                var params = {task_list_id: details[0].task_list_id, task_list_type: details[0].task_list_type};
                                if (details[0].global_id) {
                                    if (details[0].task_list_type !== 300) {
                                        params.jorteTaskList = true;
                                        params.del_global_id = details[0].global_id;
                                    } else {
                                        params.googleTaskList = true;
                                        params.id = delItemId;
                                    }
                                }
                                setTimeout(function() {
                                    $rootScope.$broadcast('eventTaskItemDeleted', itemListObj);//broadcast to listeners for update their model/view
                                    if (params.del_global_id || params.id) {
                                        syncSvc.syncSingleTask(params, function() {
                                        });
                                    }
                                }, 10);
                            });
                            return 1;
                        }
                    }
                    return 0;
                };
                //Completing an item
                $scope.onItemComplete = function() {
                    var itemId = itemList[itemIndex].itemId;
                    var itemType = itemList[itemIndex].itemType;
                    var details = itemList[itemIndex].details;
                    if (itemType === 0) { //event
                        if (!details[0].repeat || details[0].parent) {//normal event
                            eventSvc.makeEventCompleted(itemId, function () {
                                details[0].completed = 1;
                                fetchItemDetails(showItem);
                                $scope.$apply();
                                var params = {id: itemId, calendar_id: details[0].calendar_id, calendar_type: details[0].calendar_type};
                                if (details[0].calendar_type !== 300) {
                                    params.jorteCalendar = true;
                                } else {
                                    params.googleCalendar = true;
                                }
                                $rootScope.$broadcast('eventTaskItemCompleted', itemList[itemIndex]);
                                setTimeout(function () {
                                    if (details[0].cal_global_id) {
                                        syncSvc.syncSingleEvent(params, function () {
                                            setTimeout(function () {
                                                $rootScope.$broadcast('eventTaskItemCompleted', itemList[itemIndex]);
                                            }, 10);
                                        });
                                    }
                                }, 10);

                            });
                        }else{
                            if (details[0].calendar_type === 300 && !details[0].global_id) {
                                alert(getMSG('notHaveSyncId'));
                                return;
                            }
                            var parent_eventId = details[0].id;
                            var start_date = details[0].start_date;
                            var completed = 1;
                            var repeat = null, update_date = (new Date()).getTime(), calendar_id = details[0].calendar_id;
                            var type = details[0].calendar_type === 300 ? 300 : 1;
                            var long_flag = false;
                            var date_diff = details[0].end_date - details[0].start_date;
                            if (date_diff > (1000 * 60 * 60 * 24)) {
                                long_flag = true;
                            }
                            var startDate_obj = (details[0].start_date) ? jorteUtils.calcTimeLocal(details[0].timezone, details[0].start_date) : new Date();
                            var cal_global_id = details[0].cal_global_id;
                            var originalStartDate = details[0].start_date;
                            var event = new EventJorte();
                            event.calendar_id = calendar_id, event.name = details[0].name, event.content = details[0].content, event.icon = details[0].icon, event.color = details[0].color,
                                    event.start_date = details[0].start_date, event.end_date = details[0].end_date, event.start_time = details[0].start_time, event.end_time = details[0].end_time,
                                    event.type = type, event.timezone = details[0].timezone, event.repeat = repeat, event.importance = details[0].importance, event.all_day = details[0].all_day,
                                    event.holiday = details[0].holiday, event.day_time = details[0].day_time, event.location = details[0].location, event.completed = completed,
                                    event.complete_date = update_date, event.create_date = update_date, event.update_date = update_date,
                                    event.last_date = null, event.reminders = details[0].reminders, event.rep_flag = repeat ? 1 : 0, event.long_flag = long_flag ? 1 : 0,
                                    event.originalStartDate = originalStartDate, event.originalTimezone = details[0].timezone, event.parent = details[0].id, event.parent_global = details[0].global_id;
                            event.seqno = details[0].seqno, event.sync_version = details[0].sync_version;
                            var instance_dates = [new Date(details[0].start_date).toString()];
                            var data = {
                                event: event,
                                instance_dates: instance_dates,
                                repeatSelectObj: null,
                                date_diff: date_diff,
                                completed: 1
                            };
                            eventSvc.getChildEventCountForADay(parent_eventId,start_date, function (events_count) {
                                if (events_count === 0) {
                                    eventSvc.createEvent(data, function (eventId) {
                                        details[0].completed = 1;
                                        fetchItemDetails(showItem);
                                        $scope.$apply();
                                        data.event.id = eventId;
                                        notificationSvc.itemUpdateStatusCheck(eventId, true);
                                        var params = {id: eventId, calendar_id: calendar_id, calendar_type: type};
                                        if (type !== 300) {
                                            params.jorteCalendar = true;
                                        } else {
                                            params.googleCalendar = true;
                                        }
                                        $rootScope.$broadcast('eventAdded', {createdDate: startDate_obj, event_id: eventId, dataObj: data, make_completed : 1});
                                        if (cal_global_id) {
                                            var cData = angular.copy(data);
                                            cData.clickedDate = startDate_obj;
                                            cData.event_id = eventId;
                                            cData.completed = 1;
                                            cData.make_completed = 1;
                                            syncSvc.syncSingleEvent(params, function () {
                                                setTimeout(function () {
                                                    $rootScope.$broadcast('eventUpdated', cData);
                                                }, 10);
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    } else if (itemType === 1) {
                        taskSvc.makeTaskCompleted(itemId, function() {
                            details[0].completed = 1;
                            fetchItemDetails(showItem);
                            $scope.$apply();
                            var params = {id: itemId, task_list_id: details[0].task_list_id, task_list_type: details[0].task_list_type};
                            if (details[0].task_list_type !== 300) {
                                params.jorteTaskList = true;
                            } else {
                                params.googleTaskList = true;
                            }
                            
                            $rootScope.$broadcast('eventTaskItemCompleted', itemList[itemIndex]);
                            setTimeout(function() {
                                if (details[0].tlist_global_id) {
                                    syncSvc.syncSingleTask(params, function () {
                                        setTimeout(function () {
                                            $rootScope.$broadcast('eventTaskItemCompleted', itemList[itemIndex]);
                                        }, 10);
                                    });
                                }
                            }, 10);

                        });
                    }
                };
                //Edit item
                $scope.onItemEdit = function() {
                    var itemType = itemList[itemIndex].itemType, minHeight;
                    switch (itemType) {
                        case 0:
                            var title = jorteUtils.formatDate(dateObj, getMSG('LongDateFormat2'), cal_string);
                            var editModel = {
                                title: title,
                                clickedDate: dateObj,
                                item: itemList[itemIndex].details[0],
                                deleteClickCb: deleteClickCb
                            };
                            var options = { 
                                title: getMSG('SelectHead'), 
                                refreshPopup: true
                            };
                            if (itemList[itemIndex].details[0].repeat && !itemList[itemIndex].details[0].parent) {
                                if(itemList[itemIndex].details[0].calendar_type === 300) {
                                    minHeight = 260;
                                } else {
                                    minHeight = 200;
                                }
                                options.minHeight = minHeight;
                                dialogService.open("repeatEventSelectPopup", "repeatEventSelect", editModel, options);
                            } else {
                                dialogService.open("eventEditPopup", "editEvent", editModel, {title: title});
                            }
                            break;
                        case 1:
                            dialogService.open("taskEditPopup", "taskEdit",
                                    {'data': itemList[itemIndex],
                                        'deleteClickCb': deleteClickCb}, {title: getMSG('EditTasksAndMemosHead')});
                            break;
                    }
                };

                function deleteClickCb() {//duplicating delete feature for edit popup of Task/Event 
                    return $scope.onItemDelete();
                }
                function processNavigation(newList, newDt) {
                    var curItem = itemIndex >= 0 && itemIndex < itemList.length ? itemList[itemIndex] : null;
                    if (curItem) {//try to show the last shown item with updated values. unless show next/prev item.
                        for (var i = 0; i < newList.length; i++) {
                            if (newList[i] && newList[i].itemType === curItem.itemType && newList[i].itemId === curItem.itemId) {
                                itemIndex = i;
                                break;
                            }
                        }
                    }
                    if (newDt) {//date will be given by the main events page only
                        dateObj = newDt;
                    }
                    itemList = newList;
                    if (itemIndex >= itemList.length) {
                        itemIndex = itemList.length - 1;
                    }
                    fetchItemDetails(showItem);
                    if (itemIndex >= 0) {
                        $scope.$apply();
                    }
                }
                //Broadcast recieved on navgation items list change
                $scope.$on('navigItemsListChanged', function(evt, newList, newDt) {//item list of page/popup which opened this detail popup has changed.
                    processNavigation(newList, newDt);
                });

                function processEventDetails(data) {//process for events
                    var renderItem = {};
                    renderItem.type = 0;
                    var item;
                    for (var i = 0; data && i < data.length; i++) {
                        var diff, time = '', time1 = '', time2 = '', name = getMSG('NoSubjectHead'),
                                start_date = null, end_date = null, sdate = null, edate = null, newSdate = null, newEdate = null,
                                days = 0;
                        item = data[i];
                        renderItem.location = item.location;
                        if (item.start_date) {
                            start_date = new Date(item.start_date);
                            sdate = jorteUtils.formatDate(start_date, getMSG('LongDateFormat2'), cal_string);
                            newSdate = new Date(start_date.getFullYear(), start_date.getMonth(), start_date.getDate(), 0, 0, 0);
                        }
                        if (item.end_date) {
                            end_date = new Date(item.end_date);
                            edate = jorteUtils.formatDate(end_date, getMSG('LongDateFormat2'), cal_string);
                            newEdate = new Date(end_date.getFullYear(), end_date.getMonth(), end_date.getDate(), 0, 0, 0);
                        }
                        if (newSdate && newEdate) {
                            diff = newEdate - newSdate;
                            days = diff / 1000 / 60 / 60 / 24;
                        }
                        renderItem.days = days;
                        if (days > 0) {
                            if (item.day_time !== 0) {
                                time1 = jorteUtils.dayTimefinder(item.day_time);
                                time2 = " ";
                            } else if (item.day_time === 0) {
                                if (item.start_time !== null) {
                                    time1 = jorteUtils.TimeConvertOption(item.start_date, getMSG('TimeFormat1'));
                                } else {
                                    time1 = "--:--";
                                }
                                if (item.end_time !== null) {
                                    time2 = jorteUtils.TimeConvertOption(item.end_date, getMSG('TimeFormat1'));
                                } else {
                                    time2 = "--:--";
                                }
                            }
                            if (item.holiday === 1) {// Set All day if it is
                                // holiday
                                time1 = " " + jorteUtils.dayTimefinder(item.holiday);
                                time2 = " ";
                            }

                            renderItem.startDate = sdate;
                            renderItem.time1 = time1;
                            renderItem.endDate = edate;
                            renderItem.time2 = time2;
                        } else {
                            if (item.holiday === 1 || item.all_day === 1) {
                                time = getMSG('AllDayHead');
                            } else {

                                if (item.day_time === 0) {
                                    time = '';
                                    if (item.start_time !== null) {
                                        time = jorteUtils.TimeConvertOption(item.start_date, getMSG('TimeFormat1'));
                                    } else {
                                        time = "--:--";
                                    }
                                    if (item.end_time !== null) {
                                        time += " - " + jorteUtils.TimeConvertOption(item.end_date, getMSG('TimeFormat1'));
                                    } else {
                                        time += " - " + "--:--";
                                    }
                                } else {
                                    time = jorteUtils.dayTimefinder(item.day_time);
                                    if (item.day_time === 1) {
                                        if (item.end_time !== null) {
                                            time += " " + jorteUtils.TimeConvertOption(item.end_date, getMSG('TimeFormat1'));
                                        }
                                    }
                                }
                            }
                            renderItem.time = time;
                        }

                        renderItem.memo = (item.content) ? jorteUtils.htmlEscape(item.content) : '';

                        if (item.reminders.length !== 0) {
                            renderItem.reminderTexts = [];
                            for (var i = 0; i < item.reminders.length; i++) {
                                var reminder_data = jorteUtils.getReminderText(item.reminders[i].type);
                                renderItem.reminderTexts.push(reminder_data);
                            }
                        }

                        if (item.name) {
                            name = item.name;
                        } else if (item.holiday === 1) {
                            name = getMSG('NoSubjectHoliday');
                        }

                        renderItem.has_privilege = false;

                        if (item.calendar_type === 0) {
                            var jorteAccount = jorteConfig.getJorteSync() || null;
                            var jorteId = null;
                            if (jorteAccount) {
                                jorteId = jorteAccount.jorteId;
                            }
                            if (item.owner_account === jorteId) {
                                renderItem.has_privilege = true;
                            }
                        } else if (item.calendar_type === 300 && item.is_public) {
                            renderItem.has_privilege = true;
                        }
                        renderItem.colorCode = jorteUtils.getColor(item);
                        renderItem.name = name;
                        renderItem.icon = item.icon;
                        renderItem.itemId = item.id;
                        renderItem.statusImportant = item.importance ? getMSG('ImportantHead') : '';
                        renderItem.statusCompleted = item.completed ? getMSG('CompletedHead') : '';
                        renderItem.completed = item.completed;
                        renderItem.start_date = item.start_date;
                        renderItem.calendar = item.calendar;
                        renderItem.global_id = item.global_id;
                        renderItem.calendar_id = item.calendar_id;
                        renderItem.calendar_type = item.calendar_type;
                        renderItem.is_public = item.is_public;
                        renderItem.is_share = item.is_share;
                        renderItem.event_start = item.event_start;
                        renderItem.event_end = item.event_end;

                    }
                    return renderItem;
                }

                function processTaskDetails(data) {
                    var item;
                    var renderItem = {};
                    renderItem.type = 1;
                    for (var i = 0; data && i < data.length; i++) {
                        var s_date = "";
                        var d_date = "";
                        var start_time = '', end_time = '';
                        item = data[i];
                        if (item.start_date) {
                            var start_date = new Date(item.start_date);
                            s_date = jorteUtils.formatDate(start_date, getMSG('LongDateFormat2'), cal_string);
                        }
                        if (item.start_time !== null) {
                            start_time = jorteUtils.parseMinutes(item.start_time);
                        }
                        if (item.due_date) {
                            var due_date = new Date(item.due_date);
                            d_date = jorteUtils.formatDate(due_date, getMSG('LongDateFormat2'), cal_string);
                        }
                        if (item.due_time !== null) {
                            end_time = jorteUtils.parseMinutes(item.due_time);
                        }

                        var color_code = jorteConfig.COLORS.taskDefault; //#8c66d9

                        renderItem.memo = item.memo;
                        renderItem.s_date = s_date;
                        renderItem.start_time = start_time;
                        renderItem.d_date = d_date;
                        renderItem.end_time = end_time;
                        color_code = item.task_color ? item.task_color : color_code;
                        color_code = item.importance ? jorteConfig.COLORS.red : color_code;
                        color_code = item.completed ? jorteConfig.COLORS.completed : color_code;
                        renderItem.statusImportant = item.importance ? getMSG('ImportantHead') : '';
                        renderItem.statusCompleted = item.completed ? getMSG('CompletedHead') : '';
                        renderItem.taskListName = item.task_list_name;
                        renderItem.color_code = color_code;
                        renderItem.name = item.name ? item.name : getMSG('NoSubjectHead');
                        renderItem.itemId = item.id;
                        renderItem.completed = item.completed;
                        renderItem.start_date = start_date;
                        renderItem.reminders = [];
                        for (var i = 0; i < item.reminders.length; i++) {
                            var reminder_data = jorteUtils.getReminderText(item.reminders[i].type);
                            renderItem.reminders.push(reminder_data);
                        }
                        renderItem.task_type = item.task_type;
                        renderItem.global_id = item.global_id;
                        renderItem.task_list_type = item.task_list_type;
                        renderItem.task_list_id = item.task_list_id;
                        renderItem.has_privilege = true;
                    }
                    return renderItem;
                }

                function processDeliverEventDetails(data) {
                    var item;
                    var renderItem = {};
                    renderItem.type = 2;
                    for (var i = 0; i < data.length; i++) {
                        var icon = '', start_date = '', date = '';
                        item = data[i];
                        var color_code = item.color ? item.color : jorteConfig.COLORS.eventDefault;
                        if (item.all_day === 1) {
                            date = getMSG('AllDayHead');
                        } else {
                            if (item.start_date) {
                                start_date = new Date(item.start_date);
                                date = jorteUtils.formatDate(start_date, getMSG('LongDateFormat7'), cal_string);
                            }
                            if (item.end_date) {
                                date += ' - ' + jorteUtils.formatDate(new Date(item.end_date), getMSG('ShortDateFormat3'), cal_string);
                            }
                        }

                        var icon = item.icon;
                        if (icon) {
                            if (icon.indexOf("http") !== -1) {
                                renderItem.deliverEventIconWidth = '100%';
                                renderItem.deliverEventIcon = icon;
                            } else {
                                var iconMap = JSON.parse(item.icon_map);
                                if (iconMap['default']) {
                                    iconMap = iconMap['default'];
                                } else if (iconMap['logo']) {
                                    iconMap = iconMap['logo'];
                                } else {
                                    iconMap = [''];
                                }
                                var iconArray = icon.split(/[\/|_!\-\+&,:\*]/);
                                var symbol = icon.match(/[\/|_!\-\+&,:\*]/g);
                                renderItem.deliverEventIcon = (iconMap[iconArray[0]].indexOf("http") !== -1) ? iconMap[iconArray[0]] : item.icon_data;
                                renderItem.deliverEventIconWidth = (iconArray.length === 1) ? '100%' : '45%';
                                if (iconArray.length > 1) {
                                    if (symbol[0]) {
                                        renderItem.deliverEventSymbol = symbol[0];
                                    }
                                    renderItem.deliverEventIcon2 = iconMap[iconArray[1]];
                                    renderItem.deliverEventIcon2Width = (iconArray.length === 1) ? '100%' : '45%';
                                }
                            }
                        } else {
                            renderItem.deliverEventIcon = item.icon_data;
                            renderItem.deliverEventIconWidth = '100%';
                        }

                        renderItem.name = item.name;
                        renderItem.color_code = color_code;
                        renderItem.date = date;
                        if (item.location) {
                            renderItem.location = item.location;
                        }

                        if (item.content) {
                            var urls = jorteUtils.findUrl(item.content);
                            var replacedContent;
                            if (urls) {
                                var internalLink = urls;
                                replacedContent = item.content.replace(urls, '<a target="new" href="'
                                        + internalLink + '"><span class="link_color">' + urls + '</span></a>');
                            } else {
                                replacedContent = item.content;
                            }
                            renderItem.itemContent = $sce.trustAsHtml(replacedContent);
                        }

                        if (item.value) { //Large image is stored in value field
                            var image = item.value.split(",");
                            if (image[0]) {
                                renderItem.imageValue = image[0];
                            }
                        }
                        if (item.url && item.url.length > 0) {
                            renderItem.itemUrl = item.url[0];
                            renderItem.seeMoreLabel = getMSG('SeeMoreCalandersHead');
                        }
                        renderItem.aboutCalLabel = getMSG('AboutCalendar');
                        renderItem.global_id = item.global_id;
                        renderItem.calendar_id = item.calendar_id;
                        renderItem.has_privilege = true;

                    }
                    return renderItem;
                }
                //Show location in map
                $scope.showInMap = function(mapLocation) {
                    window.open(jorteConfig.GMAP.mapUrl + decodeURIComponent(mapLocation));
                };
                //Opening calendar webpage
                $scope.openUrl = function(location) {
                    window.open(location);
                };
                //About calendar in event calendar
                $scope.onEvtCalAboutClick = function() {
                    var calId = itemList[itemIndex].details[0].calendar_id;
                    var modelData = {
                        calendarId: calId
                    };
                    dialogService.open("evtCalDetailPopup", "evtCalDetailPopup", modelData, {title: getMSG('ChooseEventCalandarHead')});
                };
                //Broadcast recieved on event calandar deletion
                $scope.$on('eventCalendarDeleted', function(evt, item) {// listen from event calendar delete from its about calendar popup.
                    $rootScope.$broadcast('eventTaskItemDeleted', itemList[itemIndex]);

                    for (var i = 0; i < itemList.length; i++) {
                        if (itemList[i].calendarId === item.calendarId) {
                            itemList.splice(i, 1);
                            i--;
                        }
                    }
                    if (itemIndex >= itemList.length) {
                        itemIndex = itemList.length - 1;
                    }

                    fetchItemDetails(showItem);
                    if (itemIndex >= 0) {
                        $scope.$apply();
                    }
                });
            }]);
