'use strict';
/**
 * Jorte main controllers
 * 
 */
angular.module('controllers.main', [])

        // main controller
        .controller('mainCtrl', ['$rootScope', '$scope', '$compile', '$timeout', '$location', 'mainSvc', 'eventSvc', 'taskSvc', 'dialogService',
            function($rootScope, $scope, $compile, $timeout, $location, mainSvc, eventSvc, taskSvc, dialogService) {
                var SC;
                var viewType = jorteConfig.getDefaultView();
                var speed = 500, maxImages = 3, calScroller = null, currentMonth = null, lastMonth = null, firstMonth = null,
                        monthsLoaded = 5, isRest = true, isSwipeStart, isSwipeEnd, nxtWeek = null, preWeek = null, currentWeek = null, currentScreen = 1;
                var calViewSettings = (viewType === 1) ? jorteConfig.getMonthSettings() : jorteConfig.getWeekSettings();
                var calData = [];
                var cal_no = 0;
                var is_first = false;
                $scope.params = {
                    viewType: viewType,
                    clickedDate: null,
                    current_date: null,
                    refillMenu: false,
                    dispImpEvents: calViewSettings.dispImpEvent,
                    dispTaskMemo: calViewSettings.dispTaskMemo,
                    reverseBar: calViewSettings.reverseBar,
                    fontSize: calViewSettings.fontSize,
                    iconSize: calViewSettings.iconSize,
                    settings: false
                };
                function currentSlide() {
                    var viewType = jorteConfig.getDefaultView();
                    var currSlide, cal_start, cal_end;
                    switch (viewType) {
                        case 1:
                            currSlide = currentMonth;
                            currSlide = jorteUtils.cloneDate(currSlide);
                            currSlide.setDate(1);
                            cal_start = jorteUtils.addDays(currSlide, -((currSlide.getDay() - Math.max(jorteConfig.getFirstDayOfMonth(), 0) + 7) % 7));
                            var t = cal_start;
                            cal_end = jorteUtils.cloneDate(t);
                            jorteUtils.addDays(cal_end, 77);
                            jorteUtils.addDays(cal_start, -28);
                            break;
                        case 2:
                            currSlide = currentWeek;
                            currSlide = jorteUtils.cloneDate(currSlide);
                            cal_start = jorteUtils.addDays(currSlide, -((currSlide.getDay() - Math.max(jorteConfig.getFirstDayOfWeek(), 0) + 7) % 7));                        
                            var t = cal_start;
                            cal_end = jorteUtils.cloneDate(t);
                            jorteUtils.addDays(cal_end, 14);
                            jorteUtils.addDays(cal_start, -7);
                            cal_end.setHours(23, 59, 59, 0);
                            break;
                    }
                    return {cal_start: cal_start, cal_end: cal_end};
                }
                function getSlide(elmID, date, inc, data, isLimit, cb) {
                    var startStr, endStr;
                    var time = (new Date()).getTime();
                    var dateP = date ? date : new Date();
                    if (!calData && !data) {
                        $(elmID).html('<div class="cal_slide_loader"><img src="style/icons/load3.gif" alt=""></div>');
                    }
                    switch (viewType) {
                        case 1:
                            if (inc) {
                                jorteUtils.addMonths(dateP, inc);
                                dateP.setDate(1);
                            }
                            var start = jorteUtils.cloneDate(dateP, true);
                            start.setDate(1);
                            var end = jorteUtils.addMonths(jorteUtils.cloneDate(start), 1);
                            var visStart = jorteUtils.cloneDate(start);
                            jorteUtils.addDays(visStart, -((visStart.getDay() - Math.max(jorteConfig.getFirstDayOfMonth(), 0) + 7) % 7));
                            var visEnd = jorteUtils.cloneDate(visStart);
                            jorteUtils.addDays(visEnd, 42);

                            startStr = start;
                            endStr = end;
                            break;
                        case 2:
                            if (inc) {
                                jorteUtils.addDays(dateP, inc * 7);
                            }

                            var start = jorteUtils.cloneDate(dateP, true);
                            var end = jorteUtils.addDays(jorteUtils.cloneDate(start), 6);

                            var visStart = jorteUtils.cloneDate(start);
                            visStart.setHours(0, 0, 0, 0);
                            var nwe = 0;
                            jorteUtils.addDays(visStart, -((visStart.getDay() - Math.max(jorteConfig.getFirstDayOfWeek(), nwe) + 7) % 7));
                            var visEnd = jorteUtils.cloneDate(visStart);
                            jorteUtils.addDays(visEnd, 6);
                            visEnd.setHours(23, 59, 59, 0);

                            startStr = start;
                            endStr = end;
                            break;
                    }

                    start = visStart.getTime();
                    end = visEnd.getTime();
                    //Fetching calendar data
                    var calendarType = [];
                    if (jorteConfig.getJorteCalendarEnabled()) {
                        calendarType.push(0);
                    }
                    if (jorteConfig.getNationalHolidaysEnabled()) {
                        calendarType.push(200);
                    }
                    if (jorteConfig.getGoogleCalendarEnabled()) {
                        calendarType.push(300);
                    }

                    var startDate = new Date(start);
                    var endDate = new Date(end);
                    var i = 0;
                    if (isLimit) {//For reload calendar after insert,update,delete event or task
                        if (data && data.length > 0) {
                            for (var j = 0; j < data.length; j++) {
                                if(data[j].day_time && data[j].day_time === 8){
//                                    var end = data[j].end;
//                                    data[j].end_inst = end;
                                    var end_obj = new Date(data[j].end);
                                    var edate = new Date(end_obj.getFullYear(), end_obj.getMonth(), end_obj.getDate() - 1, 23, 59, 0);
                                    data[j].end = edate.getTime();
                                    calData['#'+data[j].instance_id] = data[j];
                                }else{
                                    calData['#'+data[j].instance_id] = data[j];
                                }
                                if (data.length === (j + 1)) {
                                    setTimeout(function() {
                                        populateData(calData);
                                    }, 10);
                                    cb && cb();
                                }
                            }

                        } else {
                            setTimeout(function() {
                                populateData(calData);
                            }, 10);
                            cb && cb();
                        }
                    } else {// For reset calendar,slide calendar to next/prevous month
                        populateData(null);
                        if (!$rootScope.syncRunning) { //Check for sync is running
                            setTimeout(function() {
                                if (!is_first) {
                                    is_first = true;
                                    fetchData(true);
                                } else {
                                    fetchData(false);
                                }
                            }, 500);
                        }
                    }
                    function fetchData(has_repeat) {
                        mainSvc.loadEventsTaskCount(start, end, jorteConfig.getDisplayTask(), !jorteConfig.getHideCompletedTask(), calCount);
                        function calCount(dt) {
                            if (dt > 500) {
                                while (startDate < endDate && i < 6) {
                                    var stDt;
                                    if (i > 0) {
                                        stDt = startDate.setDate(startDate.getDate() + 1);
                                    } else {
                                        stDt = startDate.setDate(startDate.getDate());
                                    }
                                    var endDt = startDate.setDate(startDate.getDate() + 6);
                                    mainSvc.loadEventsLimit(stDt, (endDt + (1000 * 60 * 60 * 24) - (1000)), start, end, calendarType, jorteConfig.getDisplayTask(), !jorteConfig.getHideCompletedTask(), has_repeat, calendarDataLimit);
                                    i++;
                                }
                            } else if (dt <= 500) {
                                mainSvc.loadEventsLimit(start, (end + (1000 * 60 * 60 * 24) - (1000)), start, end, calendarType, jorteConfig.getDisplayTask(), !jorteConfig.getHideCompletedTask(), has_repeat, calendarDataLimit);
                            }
                        }
                    }
                    function calendarDataLimit(dt,newTrans) {
                        if (newTrans) {
                            switch (viewType) {
                                case 1:
                                    var newTransMonth = lastMonth;
                                    reloadCalendar(jorteUtils.addMonths(newTransMonth, -1, true));
                                    break;
                                case 2:
                                    reloadCalendar(currentWeek);
                                    break;
                            }
                            return;
                        }
                        if (dt.length > 0) {
                            for (var i = 0; i < dt.length; i++) {
                                if(dt[i].day_time && dt[i].day_time === 8){
                                    var end_obj = new Date(dt[i].end);
                                    var edate = new Date(end_obj.getFullYear(), end_obj.getMonth(), end_obj.getDate() - 1, 23, 59, 0);
                                    dt[i].end = edate.getTime();
                                    calData['#'+ dt[i].instance_id] = dt[i];
                                }else{
                                    calData['#'+ dt[i].instance_id] = dt[i];
                                }
                                if (dt.length === (i + 1)) {
                                    setTimeout(function() {
                                        populateData(calData);
                                        ++cal_no;
                                        $rootScope.$broadcast('eventTaskItems', calData);
                                    }, 10);
                                    cb && cb();
                                }
                            }

                        } else {
                            ++cal_no;
                            setTimeout(function() {
                                populateData(calData);
                                $rootScope.$broadcast('eventTaskItems', calData);
                            }, 10);
                            cb && cb();
                        }
                    }
                    function populateData(data) {
                        var dispOrder = jorteConfig.getEventDispOrder();
                        WORKER.postMessage({
                            cmd: 'ShowEvent',
                            date: dateP,
                            inc: inc,
                            id: elmID,
                            time: time,
                            start: startStr,
                            end: endStr,
                            visStart: visStart,
                            visEnd: visEnd,
                            calData: data,
                            type: viewType,
                            displayOrder: dispOrder
                        });
                    }
                }

                /**
                 * addNextMonth() will add new div at the end of cal_scroller before main calendar
                 * It will remove first div from cal_scroller
                 * it will update lastMonth,firstMonth,currentScreen
                 *
                 */
                function addNextMonth() {
                    //update current slide counter                    
                    currentMonth = new Date(lastMonth);
                    --currentScreen;
                    jorteUtils.addMonths(lastMonth, 1, true);
                    jorteUtils.addMonths(firstMonth, 1, true);

                    //Create new div and add in cal_scroller
                    ++monthsLoaded;
                    var caId = 'calendar' + monthsLoaded;
                    calScroller.append('<div id="' + caId + '" style="width:' + jorteConfig.SCREEN_WIDTH + 'px;" class="cal_month cal fc fc-ltr bg_color"></div>');

                    //Set Date in div
                    var elmId = '#' + caId;
                    $(elmId).data('date', new Date(lastMonth));
                    getSlide(elmId, lastMonth, 0, null, false);

                    var matrix = calScroller.css("transform");
                    var currXval = parseInt(matrix.split(",")[4]);

                    //Update scroll div position, and remove first
                    var $firstMonth = $('.cal_month').filter(':visible').first().hide();
                    calScroller.css("transition", "unset")
                            .css("transform", "translate3d(" + (currXval + jorteConfig.SCREEN_WIDTH) + "px,0px,0px)");
                    $timeout(function() {
                        $firstMonth.remove();
                    }, 900);
                }

                /**
                 * addPreviousMonth() will add new div at the Start of cal_scroller
                 * It will remove last scroll div from cal_scroller
                 * it will update lastMonth,firstMonth,currentScreen
                 *
                 */
                function addPreviousMonth() {
                    //update current slide counter
                    currentMonth = new Date(firstMonth);
                    ++currentScreen;
                    jorteUtils.addMonths(firstMonth, -1, true);
                    jorteUtils.addMonths(lastMonth, -1, true);

                    //Create new div and add in cal_scroller
                    ++monthsLoaded;
                    var caId = 'calendar' + monthsLoaded;
                    calScroller.prepend('<div id="' + caId + '" style="width:' + jorteConfig.SCREEN_WIDTH + 'px;" class="cal_month cal fc fc-ltr bg_color"></div>');

                    //Set Date in div
                    var elmId = '#' + caId;
                    $(elmId).data('date', new Date(firstMonth));
                    getSlide(elmId, firstMonth, 0, null, false);

                    var matrix = calScroller.css("transform");
                    var currXval = parseInt(matrix.split(",")[4]);

                    //Update scroll div position, and remove first
                    var $lastMonth = $('.cal_month').filter(':visible').last().hide();
                    calScroller.css("transition", "unset")
                            .css("transform", "translate3d(" + (currXval - jorteConfig.SCREEN_WIDTH) + "px,0px,0px)");
                    $timeout(function() {
                        $lastMonth.remove();
                    }, 900);
                }

                /**
                 * addNextWeek() will add new div at the end of cal_scroller before main calendar
                 * It will remove first div from cal_scroller
                 * it will update previousWeek,nextWeek,currentWeek and currentScreen
                 *
                 */
                function addNextWeek() {
                    //update current slide counter
                    --currentScreen;
                    jorteUtils.addDays(nxtWeek, 7, true);
                    jorteUtils.addDays(preWeek, 7, true);
                    jorteUtils.addDays(currentWeek, 7, true);

                    //Create new div and add in cal_scroller
                    ++monthsLoaded;
                    var caId = 'calendar' + monthsLoaded;
                    calScroller.append('<div id="' + caId + '" style="width:' + jorteConfig.SCREEN_WIDTH + 'px; " class="cal_month cal fc fc-ltr bg_color"></div>');

                    //Set Date in div
                    var elmId = '#' + caId;
                    $(elmId).data('date', new Date(nxtWeek));

                    //copy updated last month html to sliding div
                    getSlide('#' + caId, nxtWeek, 0, null, false);

                    var matrix = calScroller.css("transform");
                    var currXval = parseInt(matrix.split(",")[4]);

                    //Update scroll div position, and remove first
                    calScroller.css("transition-property", "none");
                    $('.cal_month').first().remove();
                    calScroller.css("transform", "translate3d(" + (currXval + jorteConfig.SCREEN_WIDTH) + "px,0px,0px)");
                }

                /**
                 * addPreviousWeek() will add new div at the end of cal_scroller before main calendar
                 * It will remove first div from cal_scroller
                 * it will update previousWeek,nextWeek,currentWeek and currentScreen
                 *
                 */
                function addPreviousWeek() {
                    ++currentScreen;
                    jorteUtils.addDays(nxtWeek, -7, true);
                    jorteUtils.addDays(preWeek, -7, true);
                    jorteUtils.addDays(currentWeek, -7, true);
                    ++monthsLoaded;
                    var caId = 'calendar' + monthsLoaded;
                    calScroller.prepend('<div id="' + caId + '" style="width:' + jorteConfig.SCREEN_WIDTH + 'px;" class="cal_month cal fc fc-ltr bg_color"></div>');

                    //Set Date in div
                    var elmId = '#' + caId;
                    $(elmId).data('date', new Date(preWeek));
                    getSlide(elmId, preWeek, 0, null, false);

                    var matrix = calScroller.css("transform");
                    var currXval = parseInt(matrix.split(",")[4]);
                    calScroller.css("transition-property", "none");
                    $('.cal_month').last().remove();
                    calScroller.css("transform", "translate3d(" + (currXval - jorteConfig.SCREEN_WIDTH) + "px,0px,0px)");
                }

                //Touch event Handler
                function swipeStatus(event, phase, direction) {
                    if (phase === "move" && (direction === "left" || direction === "right")) {
                        isRest = false;
                        isSwipeStart = false;
                        isSwipeEnd = false;
                    } else if (phase === "cancel") {
                        scrollCalendar((jorteConfig.SCREEN_WIDTH * currentScreen), speed);
                        isSwipeEnd = true;
                    } else if (phase === "end") {
                        if (direction === "left" || direction === "right") {
                            scrollCalendar((jorteConfig.SCREEN_WIDTH * currentScreen), 0);
                        }
                        //Check scroll moving
                        if (!isRest) {
                            if (direction === "right") {
                                switch (viewType) {
                                    case 1:
                                        addPreviousMonth();
                                        break;
                                    case 2:
                                        addPreviousWeek();
                                        break;
                                }
                            } else if (direction === "left") {
                                switch (viewType) {
                                    case 1:
                                        addNextMonth();
                                        break;
                                    case 2:
                                        addNextWeek();
                                        break;
                                }
                            }
                            //Scroll To rest position to left or right
                            if (direction === "right") {
                                previousMonth();
                            } else if (direction === "left") {
                                nextMonth();
                            } else {
                                scrollCalendar((jorteConfig.SCREEN_WIDTH * currentScreen), speed);
                            }
                            isSwipeEnd = true;
                            $scope.currentMonth = currentMonth;
                            $scope.$apply();
                            endTransition();
                        } else {
                            event.preventDefault();
                        }
                    } else if (phase === "start") {
                        isSwipeStart = true;
                    } else {
                        event.preventDefault();
                    }
                    event.preventDefault();
                }

                /**
                 * Move scroll div using transition
                 * @param distance
                 * @param duration
                 * @param callback
                 */
                function scrollCalendar(distance, duration, callback) {
                    calScroller.css("transition-property", "transform")
                            .css("transition-duration", (duration / 1000).toFixed(1) + "s");
                    //inverse the number we set in the css
                    var value = (distance < 0 ? "" : "-") + Math.abs(jorteConfig.SCREEN_WIDTH).toString();
                    calScroller.css("transform", "translate3d(" + value + "px,0px,0px)")
                            .one('transitionend', function() {
                                calScroller.css("transition-property", "none");
                                if (callback)
                                    callback();
                            });
                }

                function previousMonth() {
                    currentScreen = Math.max(currentScreen - 1, 0);

                    //removing selection
                    $('.fc-selected-custom').remove();
                }

                function nextMonth() {
                    currentScreen = Math.min(currentScreen + 1, maxImages - 1);

                    //removing selection
                    $('.fc-selected-custom').remove();
                }

                function showTodayBtn() {
                    var now = new Date();
                    if (currentMonth.getFullYear() !== now.getFullYear() || currentMonth.getMonth() !== now.getMonth()) {
                        $('#btn_display').fadeIn(100);
                    } else {
                        $('#btn_display').fadeOut(100);
                    }
                }

                function weekShowTodayBtn() {
                    var now = new Date();
                    var temp = jorteUtils.cloneDate(preWeek);
                    temp.setDate(temp.getDate() + 6);
                    if ((now <= nxtWeek && now >= temp)) {
                        $('#btn_display').fadeOut(100);
                    } else {
                        $('#btn_display').fadeIn(100);
                    }
                }

                //When Scroll finish hide scroll divs
                function endTransition() {
                    $timeout(function() {
                        scrollCalendar(jorteConfig.SCREEN_WIDTH * currentScreen, speed, function() {
                            if (isSwipeEnd) {
                                isRest = true;
                                isSwipeEnd = false;
                                if (viewType === 1) {
                                    showTodayBtn();
                                } else if (viewType === 2) {
                                    weekShowTodayBtn();
                                }
                            }
                        });
                    }, 0);
                    $('#dayEvents').hide();
                    $('#new_event').hide();
                    simSwipe();
                }

                function workerHndlr(e) {
                    var result = e.data.result;
                    if (e.data.cmd === 'ShowEvent') {
                        var $el = $(result.html);
                        $(result.id).html($el);
                        $compile($el)($scope);
                    }
                }

                function reloadCalendar(dt, data, is_refresh) {
                    simSwipe();
                    if (viewType === 1) {
                        if (!dt) {
                            dt = currentMonth;
                        }
                        currentMonth = dt;
                        $scope.currentMonth = currentMonth;
                        lastMonth = new Date(dt);
                        firstMonth = new Date(dt);
                        jorteUtils.addMonths(lastMonth, 1, true);
                        jorteUtils.addMonths(firstMonth, -1, true);
                    } else {
                        if (!dt) {
                            dt = currentWeek;
                        }
                        currentWeek = jorteUtils.cloneDate(dt);
                        var temp = parseInt(currentWeek.getDay()) + parseInt(jorteConfig.getFirstDayOfWeek());
                        jorteUtils.addDays(jorteUtils.cloneDate(currentWeek), -(temp), true);
                        nxtWeek = new Date(currentWeek);
                        preWeek = new Date(currentWeek);
                        jorteUtils.addDays(nxtWeek, 7, true);
                        jorteUtils.addDays(preWeek, -7, true);

                    }
                    if (!data) {
                        data = null;
                    }
                    var slides = $('#cal_scroller').children();
                    //Calling the calendar worker using the screen id
                    var clDate = new Date(dt);
                    getSlide('#' + slides[1].id, clDate, 0, data, true);
                    var clDate = new Date(dt);
                    getSlide('#' + slides[0].id, clDate, -1, data, true);
                    var clDate = new Date(dt);
                    getSlide('#' + slides[2].id, clDate, 1, data, true);
                    
                    if (!is_refresh) {
                        calData = [];
                        is_first = false;
                        cal_no = 0;
                        $scope.calendarLoaded = null;
                        if (!$rootScope.syncRunning) {
                            var clDate = new Date(dt);
                            getSlide('#' + slides[1].id, clDate, 0, null, false, function () {
                                var clDate = new Date(dt);
                                getSlide('#' + slides[0].id, clDate, -1, null, false, function () {
                                    var clDate = new Date(dt);
                                    getSlide('#' + slides[2].id, clDate, 1, null, false, function () {
                                        $scope.calendarLoaded = new Date().getTime();
                                    });
                                });
                            });
                        }
                    }
                    //Showing today button
                    if (viewType === 1) {
                        showTodayBtn();
                    } else if (viewType === 2) {
                        weekShowTodayBtn();
                    }

                    currentScreen = 1;
                    calScroller.css("transition-property", "none");
                    calScroller.css("transform", "translate3d(-" + jorteConfig.SCREEN_WIDTH + "px,0px,0px)");

                }
                function simSwipe() {
                    $('#scrolle_content').swipe("disable").swipe("enable");
                }

                var clickCount = 0;
                var prev_clickdate = null;

                function getDayEvents(dateObj) {
                    // Open the dialog
                    dialogService.open('eventTaskListPopup', 'eventTaskListPopup', {'dateObj': dateObj}, {fullScreen: true});
                }

                function dayClickHndlr(date_obj) {
                    $('.fc-selected-custom').remove();
                    $('#dayEvents').show();
                    $('#new_event').show();
                    var borderContainer = $("td[data-date='" + jorteUtils.formatDate(date_obj, 'yyyy-MM-dd') + "'] ");
                    switch (viewType) {
                        case 1: //Month View
                            borderContainer.prepend("<div class='fc-selected-custom sel_day' style='width:" + (SC.colWidth - 2) +
                                    "px;height:" + (SC.colHeight - 2) + "px' ></div>");
                            break;
                        case 2:
                            borderContainer.prepend("<div class='fc-selected-custom sel_day' style='width:99.5%;height:" + (SC.colHeight - 2) + "px' ></div>");
                            break;
                    }
                    //Broadcast values to dayEvents
                    $scope.params.clickedDate = date_obj;

                    if (jorteConfig.getSingleTapDisplay()) {
                        getDayEvents(date_obj);
                    } else {
                        var dt = jorteUtils.formatDate(date_obj, getMSG('IntegerDateFormat'));
                        if (prev_clickdate === dt) {
                            clickCount++;
                            if (clickCount === 2) {
                                clickCount = 0;
                                getDayEvents(date_obj);
                            }
                        } else {
                            clickCount = 1;
                        }
                        prev_clickdate = dt;
                    }
                }

                /*
                 *
                 * Initialize calendar and calendar variables on app start
                 */
                var WORKER;
                function initCalendar(currentView) {
                    if (currentView) {
                        viewType = currentView;
                    }
                    switch (viewType) {
                        case 1:
                            WORKER = new Worker('js/worker/month.js');
                            WORKER.addEventListener('message', workerHndlr, false);
                            break;
                        case 2:
                            WORKER = new Worker('js/worker/week.js');
                            WORKER.addEventListener('message', workerHndlr, false);
                            break
                    }
                    calScroller = $('#cal_scroller');

                    // set calendar width
                    calScroller.css('width', jorteConfig.SCREEN_WIDTH * 1000).css('transition-property', 'none');
                    $('.cal').css('width', jorteConfig.SCREEN_WIDTH);

                    var viewSettings = (viewType === 1) ? jorteConfig.getMonthSettings() : jorteConfig.getWeekSettings();
                    var ST = {
                        firstDay: jorteConfig.getFirstDayOfMonth(),
                        firstDayWeek: jorteConfig.getFirstDayOfWeek(),
                        dispCompletedEvents: jorteConfig.getDispCompletedEvent(),
                        reverseBand: viewSettings.reverseBar,
                        showWeekNumber: jorteConfig.getShowWeekNumber(),
                        COLORS: jorteConfig.COLORS,
                        themeTitleColor: jorteConfig.JORTE_THEME.title_color,
                        currentTheme: jorteConfig.getCurrentTheme()
                    };
                    SC = new (function() {
                        var fSize = viewSettings.fontSize / 100;
                        var weekScreenHt = $(window).height() - ($(window).height() * .35);
                        this.titleHeight = 26;
                        this.viewWidth = jorteConfig.SCREEN_WIDTH;
                        this.headHeight = 16;
                        this.viewHeight = this.viewWidth - this.titleHeight - this.headHeight;
                        this.viewHeightWeek = weekScreenHt - this.titleHeight - this.headHeight;
                        this.dayNoHeight = 13;
                        this.iconSize = parseInt(viewSettings.iconSize);
                        this.colWidth = Math.floor(this.viewWidth / 7) - 1;
                        this.colWidthNBdr = this.viewWidth / 7;
                        this.colHeight = Math.floor((this.viewHeight - 7) / 6);
                        var colEventHeight = this.colHeight - this.dayNoHeight;
                        this.lineHeight = Math.floor((colEventHeight / 3) * fSize);
                        this.fontSize = this.lineHeight - 2;
                        this.colHeightNBdr = this.viewHeight / 6;
                        /*Week view only start*/
                        this.rowHeightWeek = parseInt(this.viewHeightWeek / 7);
                        this.colWidthWeek = parseInt(this.viewWidth);
                        this.lineHeightWeek = Math.floor((this.rowHeightWeek / 2) * fSize);
                        this.fontSizeWeek = this.lineHeightWeek - 8;
                        this.maxLevelWeek = Math.floor(this.rowHeightWeek / this.lineHeightWeek);
                        /*Week view only end*/

                        this.eventAllHeight = this.colWidth / 2;
                        this.maxLevel = Math.floor(colEventHeight / this.lineHeight);
                        this.maxImgCount = Math.floor(this.colWidth / 20);
                        this.monthNames = cal_string.monthNames;
                        this.monthNamesShort = cal_string.monthNamesShort;
                        this.dayNames = cal_string.dayNames;
                        this.dayNamesShort = cal_string.dayNamesShort;
                        this.heightAdj = Math.floor((this.viewHeight / 6) % 6) - 2;
                        this.widthAdj = Math.floor((this.viewWidth / 7) % 7) - 2;
                        this.YearFormat1 = getMSG('YearFormat1');
                        this.YearMonthFormat1 = getMSG('YearMonthFormat1');
                        this.headDateFormat = getMSG('headDateFormat');
                        this.YearMonthOnlyFormat1 = getMSG('YearMonthOnlyFormat1');
                        this.NoSubjectHead = getMSG('NoSubjectHead');
                        this.NoSubjectHoliday = getMSG('NoSubjectHoliday');
                    })();

                    //Initialize calendar with default values
                    WORKER.postMessage({
                        cmd: 'Init',
                        screen: SC,
                        options: ST,
                        type: viewType
                    });

                    reloadCalendar(new Date());
                    currentScreen = 1;

                    switch (viewType) {
                        case 1: //Month View
                            var calHeight = $(window).width() - 4;
                            var bottomHeight = $(window).height() - calHeight - 44;
                            $('#cal_scroller').css('height', calHeight);
                            $('#bottom').css('height', bottomHeight);

                            $('#calendar1').data('date', firstMonth);
                            $('#calendar2').data('date', currentMonth);
                            $('#calendar3').data('date', lastMonth);
                            break;
                        case 2: //Week View
                            var calHeight = $(window).height() - ($(window).height() * .35);
                            var bottomHeight = $(window).height() - calHeight - 44;
                            $('#cal_scroller').css("height", calHeight);
                            $('#bottom').css("height", bottomHeight);

                            $('#calendar1').data('date', preWeek);
                            $('#calendar2').data('date', currentWeek);
                            $('#calendar3').data('date', nxtWeek);
                            break;
                    }
                }
                initCalendar();
                /**
                 * Scroll functions
                 */
                calScroller.css('transition-property', 'none');
                calScroller.css('transform', 'translate3d(-' + jorteConfig.SCREEN_WIDTH + 'px,0px,0px)');

                var swipeOptions;
                //Bind touch events using touchswipe.js
                swipeOptions = {
                    triggerOnTouchEnd: false,
                    swipeStatus: swipeStatus,
                    allowPageScroll: 'vertical',
                    threshold: 25
                };
                $('#scrolle_content').swipe(swipeOptions);
                //set css transform
                calScroller.css('transition-property', 'transform');

                //Jump back to current month
                $scope.currentScreen = function() {
                    $('#dayEvents, #new_event').hide();
                    reloadCalendar(new Date());
                };
                //Calendar day cell click
                $scope.dayClick = function(selectedDate) {
                    simSwipe();
                    dayClickHndlr(new Date(selectedDate));
                };
                //Create event form
                $scope.showCreateEvent = function() {
                    dialogService.open('createEventPopup', 'createEvent', {clickedDate: $scope.params.clickedDate}, {headerVisible: false});
                };
                //open notification popup
                $scope.$on('openNotification', function(evt, s) {
                    dialogService.open('notificationShowPopup', 'notificationShow', null, {title: '', width: $(window).width(), height: $(window).height()});
                });
                //Reset on create event
                $scope.$on('eventAdded', function(evt, data) {
                    var timeOutDelay = dialogService.dialogs['eventTaskListPopup'] ? 300 : 10;
                    var evtToShow = jorteConfig.getEventToShow();
                    var dispCompletedEvt = jorteConfig.getDispCompletedEvent();
                    var obj = currentSlide();
                    if (data.dataObj && data.dataObj.event.parent && data.dataObj.event.originalStartDate) {
                        var instance_id = '#'+data.dataObj.event.parent + '#' + data.dataObj.event.originalStartDate;
                        delete calData[instance_id];
                        $scope.$apply();
                    }
                    eventSvc.getSingleEventAndInstances(obj.cal_start, obj.cal_end, data.event_id, evtToShow, dispCompletedEvt, function(resultList) {
                        $rootScope.$broadcast('eventTaskItems', resultList);
                        setTimeout(function() {
                            reloadCalendar(data.createdDate,resultList,true);
                        }, timeOutDelay);
                    });
                });
                //Reset on create edit
                $scope.$on('eventUpdated', function(evt, data) {
                    var timeOutDelay = dialogService.dialogs['eventTaskListPopup'] ? 300 : 10;
                    var evtToShow = jorteConfig.getEventToShow();
                    var dispCompletedEvt = jorteConfig.getDispCompletedEvent();
                    for (var i in calData) {
                        var locItem = calData[i];
                        if (locItem.id === data.event_id && locItem.type === 0) {
                            delete calData[i];
                        }
                    }
                    $scope.$apply();
                    var obj = currentSlide();
                    eventSvc.getSingleEventAndInstances(obj.cal_start, obj.cal_end, data.event_id, evtToShow, dispCompletedEvt, function(resultList) {
                        $rootScope.$broadcast('eventTaskItems', resultList);
                        setTimeout(function() {
                            reloadCalendar(data.createdDate,resultList,true);
                        }, timeOutDelay);
                    });
                });
                //Reset on holiday import
                $scope.$on('holyDayAdded', function() {
                    reloadCalendar(new Date());
                });

                $scope.$on('eventTaskItemDeleted', function(evt, changedItem) {
                    var parent;
                    if(changedItem.details && !changedItem.details[0].parent){
                        parent = changedItem.itemId;
                    }
                    for (var i in calData) {
                        var locItem = calData[i];
                        if ((locItem.id === changedItem.itemId && locItem.type === changedItem.itemType)||(parent && locItem.parent && locItem.parent === parent && locItem.type === changedItem.itemType)) {
                            delete calData[i];
                        }
                    }
                    $scope.$apply();
                    reloadCalendar($scope.currentMonth, null, true);
                });
                
                $scope.$on('singleRepeatEventDeleted', function(evt, changedItem) {
                    if (changedItem.itemInstanceId) {
                        delete calData['#' + changedItem.itemInstanceId];
                    }
                    $scope.$apply();
                    reloadCalendar($scope.currentMonth, null, true);
                });
                
                $scope.$on('repeatEventsDeleted', function(evt, eventId) {
                    for (var i in calData) {
                        var locItem = calData[i];
                        if (locItem.id === eventId && locItem.type === 0 || locItem.parent && locItem.parent === eventId) {
                            delete calData[i];
                        }
                    }
                    $scope.$apply();
                    reloadCalendar($scope.currentMonth, null, true);
                }); 
                
                $scope.$on('eventTaskItemCompleted', function(evt, changedItem) {
                    var resultList = [];
                    for (var i in calData) {
                        var locItem = calData[i];
                        if (locItem.id === changedItem.itemId && locItem.type === changedItem.itemType) {
                            locItem.completed = 1;
                            if(locItem.details && locItem.details.length>0){
                                locItem.details[0].completed = 1;
                            }
                            resultList.push(locItem);
                        }
                    }
                    $scope.$apply();
                    $rootScope.$broadcast('eventTaskItems', resultList);
                    setTimeout(function () {
                        reloadCalendar($scope.currentMonth, resultList, true);
                    }, 10);
                });

                $scope.$on('taskUpdated', function(evt, data) {
                    var timeOutDelay = dialogService.dialogs['eventTaskListPopup'] ? 300 : 10;
                    if (jorteConfig.getDisplayTask()) {
                        taskSvc.getSingleTasksAndInstancesForCalendarView(data.task_id, !jorteConfig.getHideCompletedTask(), function(resultList) {
                            $rootScope.$broadcast('eventTaskItems', resultList);
                            setTimeout(function () {
                                reloadCalendar($scope.currentMonth, resultList, true);
                            }, timeOutDelay);
                        });
                    }
                });

                $scope.$on('taskAdded', function(evt, data) {
                    var timeOutDelay = dialogService.dialogs['eventTaskListPopup'] ? 300 : 10;
                    if (jorteConfig.getDisplayTask()) {
                        taskSvc.getSingleTasksAndInstancesForCalendarView(data.task_id, !jorteConfig.getHideCompletedTask(), function(resultList) {
                            $rootScope.$broadcast('eventTaskItems', resultList);
                            setTimeout(function() {
                                reloadCalendar($scope.currentMonth, resultList, true);
                            }, timeOutDelay);
                        });
                    }
                });
                $scope.onShowDateClick = function(date) {
                    if (!date) {
                        date = new Date();
                    } else {
                        date = new Date(date);
                    }
                    var modelData = {
                        currDate: date,
                        onSet: function(newDate) {
                            reloadCalendar(newDate);
                            dialogService.close("dateSelectPopup");
                        }
                    };
                    var titleDate = jorteUtils.formatDate(date, getMSG('LongDateFormat2'), cal_string);
                    dialogService.open("dateSelectPopup", "dateSelectPopup", modelData, {title : titleDate});
                };
                //Rest calendar from header
                $scope.setCalendarDate = function(dateStr) {
                    reloadCalendar(new Date(dateStr));
                };
                //Reset on sync completed
                $scope.$on('syncCompleted', function() {
                    if (!$rootScope.syncRunning) {
                        reloadCalendar();
                    }
                });
                //On theme change
                $scope.$on('themeChanged', function() {
                    initCalendar();
                });
                $scope.onTasksMenuClick = function() {
                    $rootScope.taskFetchRunning = false;
                    $location.path('/taskMemo');
                };
                //Search
                $scope.onSearchMenuClick = function() {
                    $scope.params.customize = false;
                    dialogService.open('searchFormPopup', 'searchFormPopup', null, {title: getMSG('SearchHead')});
                };
                //customize
                $scope.params.customize = false;
                $scope.onCustomizeMenuClick = function() {
                    $scope.params.customize = ($scope.params.customize) ? false : true;
                    if ($scope.params.customize) {
                        $("#bottom").css('overflow-y', 'hidden');
                    } else {
                        $("#bottom").css('overflow-y', 'auto');
                    }
                };
                //main settings
                $scope.onSettingsMenuClick = function() {
                    $scope.params.customize = false;
                    dialogService.open("mainSettingsFormPopUp", "mainSettingsForm", null, {title: getMSG('OptionsHead')});
                };
                //Refill
                $scope.refillMenu = function(status) {
                    $scope.params.customize = false;
                    $("#bottom").css('overflow-y', 'auto');
                    switch (status) {
                        case true:
                            $scope.params.refillMenu = status;
                            break;
                        case false:
                            $scope.params.refillMenu = status;
                            $scope.params.settings = false;
                            break;
                    }
                };
                //Toggle View
                $scope.toggleView = function(type) {
                    jorteConfig.setDefaultView(parseInt(type));
                    $scope.refillMenu(true);
                    $scope.params.viewType = parseInt(type);
                    initCalendar(parseInt(type));
                };
                //Calendar view settings
                $scope.viewSettings = function() {
                    $scope.params.settings = (!$scope.params.settings);
                };
                //View changed from settings popup
                $scope.$watch('params.viewType', function(newVal, oldVal) {
                    if (oldVal !== newVal) {
                        initCalendar(parseInt(newVal));
                    }
                });
                //Firstday changed from settings popup
                $scope.$on('firstDayChanged', function(evt, val) {
                    initCalendar(parseInt(val.viewType));
                });
                //Reverse band display change
                $scope.$on('reverseBandChanged', function(evt, val) {
                    initCalendar(parseInt(val.viewType));
                });
                //Display or hide task in calendar bottom
                $scope.$watch('params.dispTaskMemo', function(newVal, oldVal) {
                    if (oldVal !== newVal) {
                        reloadCalendar();
                    }
                });
                //Change the size of calendar event
                $scope.$watch('params.fontSize', function(newVal, oldVal) {
                    if (oldVal !== newVal) {
                        initCalendar();
                    }
                });
                //Change the icon size of calendar event
                $scope.$watch('params.iconSize', function(newVal, oldVal) {
                    if (oldVal !== newVal) {
                        initCalendar();
                    }
                });
            }]);