'use strict';

/**
 * Jorte main controllers
 * 
 */
angular.module('controllers.mainEvents', [])

        // important events controller
        .controller('mainEventsCtrl', ['$rootScope', '$scope','$location', 'mainSvc', 'dialogService',
            function($rootScope, $scope, $location, mainSvc, dialogService) {
                //Populate main events
                $scope.mainEvents = false;
                $scope.eventTaskItems = [];
                var localResult = [];
                var eventList = [];
                var taskList = [];
                var locStart, locEnd;
                var currentMonth;
                function getDayEvents(dateObj) {
                    // Open the dialog
                    dialogService.open('eventTaskListPopup', 'eventTaskListPopup', {'dateObj': dateObj}, {fullScreen: true});
                    try {
                        if (dialogService.dialogs['eventTaskListPopup']) {
                            $rootScope.$broadcast('eventTaskItemsPopup', $scope.eventTaskItems);
                        }

                    } catch (e) {
                        console.log('broadcast eventTaskItemsPopup ', e);
                    }

                }
                function importantEvents(result) {
                    jorteUtils.sortEventsByDate(result);
                    $scope.mainEvents = [];
                    $scope.mainEvents = processResults(result);
                    $scope.$apply();
                }
                function getImportantEvents(newVal) {
                    if(!newVal){
                        return ;
                    }
                    eventList = [];
                    taskList = [];
                    localResult = [];
                    var temp = new Date(newVal);
                    temp.setHours(0, 0, 0, 0);
                    temp.setDate(1);
                    var start = new Date(temp);
                    temp.setMonth(temp.getMonth() + 1);
                    var end = new Date(temp);
                    end.setHours(23, 59, 59, 0);
                    end = jorteUtils.addDays(end, -1, true);
                    locStart = start, locEnd = end;

                    var newList = $scope.eventTaskItems;
                    if (!newList) {
                        return;
                    }
                    for (var i in newList) {
                        var instance = newList[i];
                        
                        if ((start <= instance.begin && end >= instance.begin) ||
                                (start <= instance.end && end >= instance.end) ||
                                (instance.begin <= start && instance.end >= start)) {
                            if (instance.type === 0 && instance.importance===1 && instance.completed===0 && (eventList.indexOf(instance.id) === -1)) {
                                localResult.push(instance);
                                eventList.push(instance.id);
                            } else if (instance.type === 1 && instance.importance===1 && instance.completed===0 && (taskList.indexOf(instance.id) === -1)) {
                                localResult.push(instance);
                                taskList.push(instance.id);
                            }
                        }
                    }
                    setTimeout(function () {
                        importantEvents(localResult);
                    }, 10);
                }
                              
                $scope.$on('eventTaskItems', function(evt, newList) {
                    for (var i in newList) {
                        var locItem = newList[i];
                        if (locItem.isdeliverCalendar === 1) {
                            $scope.eventTaskItems['del_' + locItem.instance_id] = locItem;
                        } else {
                            $scope.eventTaskItems[locItem.instance_id] = locItem;
                            if(locItem.parent && locItem.originalStartDate){
                                var instance_id = locItem.parent+ '#' +locItem.originalStartDate;
                                delete $scope.eventTaskItems[instance_id];
                            }
                        }
                    }
                    $scope.$apply();
                    if (currentMonth) {
                        getImportantEvents(currentMonth);
                    }

                });
                
                $scope.$watch('currentMonth', function (newVal, oldVal) {
                    currentMonth = newVal;                                        
                });

                $scope.onItemClick = function(date) {
                    if (!date) {
                        return;
                    }
                    var dateObj = new Date(date);
                    dateObj.setHours(0, 0, 0, 0);
                    getDayEvents(new Date(dateObj));
                };
                
                $scope.$on('eventTaskItemDeleted', function(evt, changedItem) {
                    var parent;
                    if(changedItem.details && !changedItem.details[0].parent){
                        parent = changedItem.itemId;
                    }
                    for (var i = 0; i < localResult.length; i++) {
                        var locItem = localResult[i];
                        if (locItem.id === changedItem.itemId && locItem.type === changedItem.itemType
                                || (locItem.type === 2 && locItem.calendar_id === changedItem.calendarId)||(parent && locItem.parent && locItem.parent === parent && locItem.type === changedItem.itemType)) {
                            localResult.splice(i, 1);
                            i--;
                        }
                    }
                    for (var i in $scope.eventTaskItems) {
                        var locItem = $scope.eventTaskItems[i];
                        if ((locItem.id === changedItem.itemId && locItem.type === changedItem.itemType)||(parent && locItem.parent && locItem.parent === parent && locItem.type === changedItem.itemType)) {
                            delete $scope.eventTaskItems[i];
                        }
                    }
                    $scope.$apply();
                    importantEvents(localResult);

                });
                
                $scope.$on('singleRepeatEventDeleted', function(evt, changedItem) {
                    for (var i = 0; i < localResult.length; i++) {
                        var locItem = localResult[i];
                        if (locItem.instance_id === changedItem.itemInstanceId) {
                            localResult.splice(i, 1);
                            break;
                        }
                    }
                    if (changedItem.itemInstanceId) {
                        delete $scope.eventTaskItems[changedItem.itemInstanceId];
                    }
                    $scope.$apply();
                    importantEvents(localResult);

                });
                
                $scope.$on('repeatEventsDeleted', function(evt, eventId) {

                    for (var i = 0; i < localResult.length; i++) {
                        var locItem = localResult[i];
                        if (locItem.id === eventId && locItem.type === 0||(locItem.parent && locItem.parent === eventId)) {
                            localResult.splice(i, 1);
                            i--;
                        }
                    }
                    for (var i in $scope.eventTaskItems) {
                        var locItem = $scope.eventTaskItems[i];
                        if (locItem.id === eventId && locItem.type === 0||(locItem.parent && locItem.parent === eventId)) {
                            delete $scope.eventTaskItems[i];
                        }
                    }
                    $scope.$apply();
                    importantEvents(localResult);
                });
                
                $scope.$on('eventUpdated', function(evt, data) {
                    for (var i in $scope.eventTaskItems) {
                        var locItem = $scope.eventTaskItems[i];
                        if (locItem.id === data.event_id && locItem.type === 0) {
                            delete $scope.eventTaskItems[i];
                        }
                    }
                    $scope.$apply();

                });
                $scope.$on('holidayDeleted', function(evt) {
                    for (var i in $scope.eventTaskItems) {
                        var locItem = $scope.eventTaskItems[i];
                        if (locItem.provider === 200) {
                            delete $scope.eventTaskItems[i];
                        }
                    }
                    $scope.$apply();
                });
                               
                function processResults(result) {
                    var events = [];
                    var itemIndex = 0;
                    for (var i = 0; i < result.length; i++) {
                        var item = result[i];
                        var impEvent = {}, color = '';
                        impEvent.id = item.id;
                        impEvent.itemInstanceId = item.instance_id;
                        impEvent.name = (item.name) ? item.name : ((item.holiday) ? getMSG('NoSubjectHoliday') : getMSG('NoSubjectHead'));
                        impEvent.start_date = (item.begin) ? jorteUtils.formatDate(new Date(item.begin), getMSG('ShortDateFormat1'), cal_string) : '';
                        impEvent.due_date = (item.end) ? jorteUtils.formatDate(new Date(item.end), getMSG('ShortDateFormat1'), cal_string) : '';
                        impEvent.start_time = (item.start_time !== null) ? jorteUtils.TimeConvertOption(new Date(item.begin), 'HH:mm') : '';
                        var due_time = '';
                        if (item.end_time !== null) {
                            if (item.day_time === 7) {
                                var d = new Date(item.end);
                                var c = d.getMinutes() + 1;
                                d.setMinutes(c);
                                due_time = jorteUtils.TimeConvertOption(d, getMSG('ShortDateFormat3'));
                            } else if (item.day_time === 8) {
                                var d = new Date(item.end);
                                due_time = jorteUtils.TimeConvertOption(d, getMSG('ShortDateFormat3'));
                            }else{
                                due_time = jorteUtils.TimeConvertOption(new Date(item.end), getMSG('ShortDateFormat3'));
                            }
                        } else {
                            due_time = '';
                        }
                        impEvent.due_time = due_time;
                        impEvent.icon = (item.icon) ? item.icon : '';
                        impEvent.location = (item.location) ? jorteUtils.htmlEscape(item.location) : '';
                        /** For detail popup */
                        impEvent.itemId = item.id;
                        impEvent.itemType = item.type;
                        impEvent.itemIndex = ++itemIndex;
                        impEvent.startDate = item.begin;//for navigatio popup
                        if (item.importance && item.type === 1) {//for task
                            color = jorteConfig.COLORS.red;
                        } else if (item.color) {
                            color = item.color;
                        } else {
                            color = item.cal_color ? item.cal_color : jorteConfig.COLORS.eventDefault;
                        }

                        impEvent.color = color;
                        impEvent.is_public = item.is_public;
                        impEvent.is_share = item.is_share;
                        events.push(impEvent);
                    }
                    return events;
                }
            }]);
