'use strict';

/**
 * Deliver Calendar List controller
 * 
 */
angular.module('controllers.mainEvtCalendar', [])

        // deliver calendar list controller
        .controller('mainEvtCalendarCtrl', ['$scope', 'mainSvc', function($scope, mainSvc) {
                function deliverCalList(result) {

                    for (var i = 0; i < result.length; i++) {
                        for (var j = 0; j < result.length - i - 1; j++) {
                            if (result[j].id < result[j + 1].id) {
                                var tmp = result[j];
                                result[j] = result[j + 1];
                                result[j + 1] = tmp;
                            } else if (result[j].id === result[j + 1].id) {
                                if (result[j].de_id > result[j + 1].de_id) {
                                    var tmp2 = result[j];
                                    result[j] = result[j + 1];
                                    result[j + 1] = tmp2;
                                }
                            }
                        }
                    }
                    var calendarList = [];
                    var prvCID = null;
                    var temp;
                    for (var i = 0; i < result.length; i++) {
                        var item = result[i];
                        if (prvCID !== item.id) {
                            prvCID = item.id;
                            temp = {};
                            temp.calendarTitle = item.calendar_title;
                            temp.events = [];
                            calendarList.push(temp);
                        }
                        var tempEvt = {};
                        tempEvt.url = item.url;
                        tempEvt.textColor = item.color ? item.color : '';
                        tempEvt.textTime = '(' + jorteUtils.formatDate(new Date(item.begin), getMSG('MainViewFormat'), cal_string) + ')';
                        tempEvt.eventTitle = item.title;
                        tempEvt.imageSrc = item.icon_id;
                        temp.events.push(tempEvt);
                    }
                    $scope.evtCalList = calendarList;
                    $scope.$apply();
                }

                mainSvc.getEventCalendars(function(result) {
                    deliverCalList(result);
                });

                $scope.openUrl = function(url) {
                    url && window.open(url);
                };

            }]);