'use strict';

/**
 * Jorte main controllers
 * 
 */
angular.module('controllers.mainTasks', [])

        //Main task and memos controller
        .controller('mainTasksCtrl', ['$rootScope', '$scope','$location', 'mainSvc', 'dialogService',
            function($rootScope, $scope,$location, mainSvc, dialogService) {

                var localResult = [];
                function taskAndMemos(result) {
                    $scope.mainTasks = [];
                    $scope.mainTasks = processResult(result);
                    $scope.$apply();
                }

                function taskFetchPagination(resultList) {
                    function pagination(task_list_id, is_advance, taskCount, callBack) {
                        mainSvc.getTasksDetails(task_list_id, is_advance, taskCount, function (result) {
                            if (result && result.length > 0) {
                                for (var j = 0; j < result.length; j++) {
                                    localResult.push(result[j]);
                                }
                                taskCount += result.length;
                                jorteUtils.sortById(localResult);
                                taskAndMemos(localResult);
                            }
                            callBack && callBack(taskCount);
                        });
                    }

                    function nextTaskListData(i, taskCount, is_advance) {

                        if (i >= resultList.length) {
                            jorteUtils.sortById(localResult);
                            taskAndMemos(localResult);
                            return;
                        }
                        var obj = resultList[i];
                        var task_list_id = obj.id, task_count = obj.count;
                        if ($location.path() === "/" && !$rootScope.syncRunning) {
                            setTimeout(function () {
                                pagination(task_list_id, is_advance, taskCount, function (count) {
                                    if (count < task_count) {
                                        taskCount = count;
                                        nextTaskListData(i, taskCount, true);
                                    } else {
                                        taskCount = 0;
                                        nextTaskListData(++i, taskCount, false);
                                    }
                                });
                            }, 10);
                        }
                    }
                    localResult = [];
                    nextTaskListData(0, 0, false);
                }
                $scope.$watch('calendarLoaded', function (newVal, oldVal) {
                    if ($location.path() === "/" && newVal) {
                        mainSvc.getSelectedTasksCount(function (resultList) {
                            taskFetchPagination(resultList);
                        });
                    }
                });    
                $scope.onItemClick = function(itemIndex) {
                    var modelData = {itemIndex: itemIndex - 1, renderList: $scope.mainTasks};
                    dialogService.open("eventTaskDetailPopup_BottomTasks", "eventTaskDetailPopup", modelData, {title: 'Task & Memos', minHeight: 360, headerVisible: false});
                };
                //Broadcast received on item deletion
                $scope.$on('eventTaskItemDeleted', function(evt, changedItem) {
                    for (var i = 0; i < localResult.length; i++) {
                        var locItem = localResult[i];
                        if (locItem.id === changedItem.itemId && locItem.type===changedItem.itemType) {
                            localResult.splice(i, 1);
                            i--;
                        }
                    }
                    taskAndMemos(localResult);
                });
                //Broadcast received on item completion
                $scope.$on('eventTaskItemCompleted', function(evt, changedItem) {
                    for (var i = 0; i < localResult.length; i++) {
                        var locItem = localResult[i];
                        if (locItem.id === changedItem.itemId) {
                            locItem.completed = 1;
                        }
                    }
                    taskAndMemos(localResult);
                });
                //Broadcast received on task updation
                $scope.$on('taskUpdated', function(evt, taskData) {
                    var timeOutDelay = dialogService.dialogs['eventTaskListPopup'] ? 300 : 10;
                    setTimeout(function () {
                        mainSvc.getSingleTask(taskData.task_id, function (result) {
                            for (var i = 0; i < localResult.length; i++) {
                                if (localResult[i].id === result.id) {
                                    localResult[i] = result;
                                    break;
                                }
                            }
                            jorteUtils.sortById(localResult);
                            taskAndMemos(localResult);
                            try {
                                if (dialogService.dialogs['eventTaskDetailPopup_BottomTasks']) {
                                    $rootScope.$broadcast('navigItemsListChanged', $scope.mainTasks);
                                }
                            } catch (e) {
                                console.log('broadcast navigItemsListChanged ', e);
                            }
                        });
                    }, timeOutDelay);
                });
                //Broadcast received on task addition
                $scope.$on('taskAdded', function(evt, taskData) {
                    var timeOutDelay = dialogService.dialogs['eventTaskListPopup'] ? 300 : 10;
                    setTimeout(function () {
                        mainSvc.getSingleTask(taskData.task_id, function (result) {
                            localResult.push(result);
                            jorteUtils.sortById(localResult);
                            taskAndMemos(localResult);
                        });
                    }, timeOutDelay);
                });

                function processResult(result) {
                    var tasks = [];
                    var itemIndex = 0;
                    for (var i = 0; i < result.length; i++) {
                        var item = result[i];
                        if (item.completed === 0 || (item.completed === 1 && !jorteConfig.getHideCompletedTask())) {
                            var taskMemo = {}, color = '', getFormatSd = getMSG('ShortDateFormat4'), getFormatEd = getMSG('ShortDateFormat4');
                            if (jorteUtils.formatDate(new Date(), 'MM') === jorteUtils.formatDate(new Date(item.start_date), 'MM')) {
                                getFormatSd = getMSG('ShortDateFormat1');
                            }
                            if (jorteUtils.formatDate(new Date(), 'MM') === jorteUtils.formatDate(new Date(item.due_date), 'MM')) {
                                getFormatEd = getMSG('ShortDateFormat1');
                            }

                            taskMemo.id = item.id;
                            taskMemo.name = (item.name) ? item.name : getMSG('NoSubjectHead');
                            taskMemo.start_date = (item.start_date) ? jorteUtils.formatDate(new Date(item.start_date), getFormatSd, cal_string) : '';
                            taskMemo.start_time = (item.start_time !== null) ? jorteUtils.parseMinutes(item.start_time) : '';
                            taskMemo.due_date = (item.due_date) ? jorteUtils.formatDate(new Date(item.due_date), getFormatEd, cal_string) : '';
                            taskMemo.due_time = (item.due_time !== null) ? jorteUtils.parseMinutes(item.due_time) : '';
                            taskMemo.icon = (item.icon) ? item.icon : '';
                            taskMemo.location = (item.location) ? jorteUtils.htmlEscape(item.location) : '';
                            /** For details popup */
                            taskMemo.itemId = item.id;
                            taskMemo.itemType = 1;
                            taskMemo.itemIndex = ++itemIndex;
                            if (item.completed === 1) {
                                color = jorteConfig.COLORS.completed;
                            } else if (item.importance || item.holiday || item.provider === 200) {
                                color = jorteConfig.COLORS.red;
                            } else if (item.color) {
                                color = item.color;
                            } else {
                                color = item.cal_color ? item.cal_color : (item.type !== 1 ? jorteConfig.COLORS.eventDefault : jorteConfig.COLORS.taskDefault);
                            }

                            taskMemo.color = color;
                            tasks.push(taskMemo);
                        }
                    }
                    return tasks;
                }
            }]);