'use strict';

/**
 * Jorte controllers
 * 
 */
angular.module('controllers.notification.notification', [])

        // Notification controller

        .controller('notificationCtrl', ['$rootScope', '$scope', 'dialogService', 'reminderSvc', 'notificationSvc',
            function($rootScope, $scope, dialogService, reminderSvc, notificationSvc) {
                function processResults(data) {
                    var rs = [];
                    var itemIndex = 0;
                    var colorStyle;
                    for (var i = 0, item = null, time, desc, df, liClass = ''; i < data.length; i++) {
                        var remList = {};
                        item = data[i];
                        remList.id = item.id;
                        remList.name = item.name ? item.name : getMSG('NoSubjectHead');
                        liClass = (item.completed ? 'completed' : (item.importance ? 'important' : ''));
                        remList.liClass = liClass ? liClass : '';
                        colorStyle = item.color && !liClass ? item.color : '';
                        remList.colorStyle = colorStyle;
                        df = ((new Date(item.event_start_time)).toDateString() !== (new Date(item.event_end_time)).toDateString() ? 'MMM d, ' : '') + 'h:mm TT';
                        time = (item.event_start_time ? jorteUtils.formatDate(new Date(item.event_start_time), (item.event_end_time ? 'MMM d, h:mm TT' : 'h:mm TT, MMM d')) : '') + (item.event_end_time ? ' - ' + jorteUtils.formatDate(new Date(item.event_end_time), df) : '');
                        desc = item.location ? item.location : '';
                        remList.time = time;
                        remList.desc = desc;

                        /** For detail popup */
                        remList.itemId = item.event_id;
                        remList.itemInstanceId = item.id;
                        remList.itemType = 0;
                        remList.itemIndex = ++itemIndex;
                        remList.startDate = item.event_start_time;//for navigatio popup

                        rs.push(remList);
                    }
                    return rs;
                }

                function reminderList(data) {
                    $scope.reminderList = [];
                    $scope.reminderList = processResults(data);
                    $scope.$apply();
                }

                reminderSvc.getAllReminderItems(function(data) {
                    reminderList(data);
                });

                $scope.onItemClick = function(itemIndex) {
                    var dateObj = new Date($scope.reminderList[itemIndex - 1].startDate);
                    var itemId = $scope.reminderList[itemIndex - 1].itemId;
                    var itemType = $scope.reminderList[itemIndex - 1].itemType;
                    var modelData = {'itemId': itemId, 'itemType': itemType, 'dateObj': dateObj};
                    $rootScope.$broadcast('showDayEvents', modelData);
                };

                $scope.dismissAll = function() {
                    notificationSvc.dismissAll();
                    dialogService.close('notificationShowPopup');
                };

                $scope.snoozeAll = function() {
                    notificationSvc.snoozeAll();
                    dialogService.close('notificationShowPopup');
                };
            }]);