'use strict';

/**
 * Google login controllers
 * 
 */
angular.module('controllers.googleLogin', [])
        .controller('googleLoginCtrl', ['$scope', 'googleAuthSvc',
            function($scope, googleAuthSvc) {

                $scope.googleLogin = function() {
                    $scope.loginError = false;
                    $scope.loginStart = true;
                    googleAuthSvc.auth(function(status, res) {
                        if (status) {
                            $scope.loginError = false;
                            $scope.model.onSuccess(true, 'close');
                        } else {
                            $scope.model.onSuccess(false, res);
                            $scope.loginStart = false;
                            $scope.loginError = true;
                        }
                    });
                };

            }]);