'use strict';

/**
 * Jorte login controllers
 * 
 */
angular.module('controllers.jorteLogin', [])
        .controller('jorteLoginCtrl', ['$scope', 'jorteAuthSvc', 'dialogService',
            function($scope, jorteAuthSvc, dialogService) {
                $scope.hideCreateStatus = false;
                $scope.jorteUser = jorteAuthSvc.fetchUserProfile();
                if (!$scope.jorteUser) {
                    if (jorteAuthSvc.fetchJSyncStatus()) {
                        var jStatus = jorteAuthSvc.fetchJSyncStatus();
                        if (jStatus.status === 0) {
                            $scope.hideCreateStatus = true;
                            $scope.jorte_id = jStatus.jorteId;
                        }
                    }
                }

                $scope.jorteLogin = function() {
                    $scope.loginError = false;
                    if (!$scope.jorte_id || !$scope.jorte_pwd) {
                        alert(getMSG('JorteIdPasswordHead'));
                        return;
                    }
                    $scope.loginStart = true;
                    jorteAuthSvc.auth(function(status) {
                        if (status) {
                            $scope.loginError = false;
                            $scope.model.onSuccess(true);
                            dialogService.close("jorteLoginPopup", "jorteLoginPopup");
                        } else {
                            $scope.model.onSuccess(false);
                            $scope.loginStart = false;
                            $scope.loginError = true;
                        }
                    }, $scope.jorte_id, $scope.jorte_pwd);
                };

                $scope.closePopup = function() {
                    dialogService.close("jorteLoginPopup", "jorteLoginPopup");
                };

                $scope.openUrl = function(type) {
                    if (type === 1) {
                        window.open("https://jorte.net/certify/account/create/showDefault?applicationCode=jorte-droid", 'auth_windows', 'fullscreen=0,width=200,height=100,resizable=1');
                    } else {
                        window.open("https://jorte.net/certify/account/passwordReissueSend/", 'auth_windows', 'fullscreen=0,width=200,height=100,resizable=1');
                    }
                };
            }]);