'use strict';

angular.module('controllers.search', [])

        // search controller
        .controller('searchCtrl', ['$scope', '$location', 'dialogService',
            function($scope, $location, dialogService) {
                $scope.keyWord = '';
                $scope.onOkClick = function() {
                    $location.path('/search/' + encodeURIComponent($scope.keyWord));
                    dialogService.close('searchFormPopup');
                };
                $scope.onClearClick = function() {
                    $scope.keyWord = '';
                    $scope.$apply();
                };
                $scope.onCancelClick = function() {
                    dialogService.close('searchFormPopup');
                };

            }])
        .controller('searchResultCtrl', ['$scope', '$routeParams', 'searchSvc', 'eventSvc', 'taskSvc', 'dialogService',
            function($scope, $routeParams, searchSvc, eventSvc, taskSvc, dialogService) {
                $scope.keyWord = $routeParams.keyword ? decodeURIComponent($routeParams.keyword) : '';
                $scope.searchScreenHt = $(window).height() - $('#search_head').height();
                var period = 1;
                var localList = [];
                var startDate;
                var endDate;
                showSearchResult();
                function sortEventTasks(localList) {
                    for (var i = 0; i < localList.length; i++) {
                        for (var j = 0; j < localList.length - i - 1; j++) {
                            if (localList[j].begin > localList[j + 1].begin) {
                                var temp = localList[j];
                                localList[j] = localList[j + 1];
                                localList[j + 1] = temp;
                            }
                        }
                    }
                }
                function showSearchResult() {
                    var date = new Date()
                    date.setHours(23, 59, 59, 0);
                    startDate = jorteUtils.addDays(new Date(), -15, false).getTime();
                    endDate = jorteUtils.addDays(date, 15, true).getTime();
                    $scope.renderList = [];
                    $scope.startDate = jorteUtils.formatDate(new Date(startDate), getMSG('LongDateFormat5'), cal_string);
                    $scope.endDate = jorteUtils.formatDate(new Date(endDate), getMSG('LongDateFormat5'), cal_string);
                    loadSearchResult($scope.keyWord, startDate, endDate, true, function(list) {
                        localList = list;
                        $scope.renderList = processResult(list);
                        $scope.$apply();
                    });
                }

                function loadSearchResult(keyWord, startDate, endDate, isFirst, afterProcessCB) {
                    if (!startDate && !endDate) {
                        afterProcessCB([]);
                    }

                    var calendarType = [];
                    if (jorteConfig.getJorteCalendarEnabled()) {
                        calendarType.push(0);
                    }
                    if (jorteConfig.getNationalHolidaysEnabled()) {
                        calendarType.push(200);
                    }
                    if (jorteConfig.getGoogleCalendarEnabled()) {
                        calendarType.push(300);
                    }
                    searchSvc.getSearchList(startDate, endDate, startDate, endDate, calendarType, jorteConfig.getDisplayTask(), !jorteConfig.getHideCompletedTask(), isFirst, keyWord, function(viewList) {
                        for (var i = 0; i < viewList.length; i++) {
                            for (var j = 0; j < viewList.length - i - 1; j++) {
                                if (viewList[j].begin > viewList[j + 1].begin) {
                                    var temp = viewList[j];
                                    viewList[j] = viewList[j + 1];
                                    viewList[j + 1] = temp;
                                }
                            }
                        }
                        afterProcessCB(viewList);
                    });
                }
                $scope.onItemClick = function(index) {
                    index = index - 1;
                    var curItem = $scope.renderList[index];
                    var navigList = [];
                    var dateMillis = curItem.itemDate;

                    navigList.push(angular.copy(curItem));
                    var navigItemIndex = 0;

                    if (!curItem.dayChanged) {
                        for (var i = index - 1; i >= 0; i--) {
                            var aPrevItem = $scope.renderList[i];
                            navigList.unshift(angular.copy(aPrevItem));
                            navigItemIndex++;
                            if (aPrevItem.dayChanged) {
                                break;
                            }
                        }
                    }

                    for (var i = index + 1; i < $scope.renderList.length; i++) {
                        var aNextItem = $scope.renderList[i];
                        if (aNextItem.dayChanged) {
                            break;
                        }
                        navigList.push(angular.copy(aNextItem));
                    }
                    var dateObj = new Date(dateMillis);
                    var date_caption = jorteUtils.formatDate(dateObj, getMSG('LongDateFormat2'), cal_string);
                    var modelData = {itemIndex: navigItemIndex, renderList: navigList, 'dateObj': dateObj};
                    dialogService.open("eventTaskDetailPopup", "eventTaskDetailPopup", modelData, {title: date_caption, minHeight: 360, headerVisible: false});
                };

                $scope.$on('eventTaskItemDeleted', function(evt, changedItem) {
                    var parent;
                    if(changedItem.details && !changedItem.details[0].parent){
                        parent = changedItem.itemId;
                    }
                    for (var i = 0; i < localList.length; i++) {
                        var locItem = localList[i];
                        if ((locItem.id === changedItem.itemId && locItem.type === changedItem.itemType)||(parent && locItem.parent && locItem.parent === parent && locItem.type === changedItem.itemType)) {
                            localList.splice(i, 1);
                            i--;
                        }
                    }
                    $scope.renderList = processResult(localList);
                    $scope.$apply();
                });
                $scope.$on('singleRepeatEventDeleted', function(evt, changedItem) {
                    for (var i = 0; i < localList.length; i++) {
                        var locItem = localList[i];
                        if (changedItem.details && changedItem.details[0].start_date === locItem.begin && changedItem.itemId === locItem.id) {
                            localList.splice(i, 1);
                            break;
                        }
                    }
                    $scope.renderList = processResult(localList);
                    $scope.$apply();
                });
                
                $scope.$on('repeatEventsDeleted', function(evt, eventId) {
                    for (var i = 0; i < localList.length; i++) {
                        var locItem = localList[i];
                        if (locItem.id === eventId && locItem.type === 0 || locItem.parent && locItem.parent === eventId) {
                            localList.splice(i, 1);
                            i--;
                        }
                    }
                    $scope.renderList = processResult(localList);
                    $scope.$apply();
                }); 
                
                $scope.$on('eventTaskItemCompleted', function(evt, changedItem) {
                    for (var i = 0; i < localList.length; i++) {
                        var locItem = localList[i];
                        if (locItem.id === changedItem.itemId && locItem.type === changedItem.itemType) {
                            locItem.completed = 1;
                            if (locItem.details && locItem.details.length > 0) {
                                locItem.details[0].completed = 1;
                            }
                        }
                    }
                    $scope.renderList = processResult(localList);
                    $scope.$apply();
                });

                $scope.$on('taskUpdated', function(evt, data) {
                    taskSvc.getSingleTasksAndInstancesForSearch(data.task_id, !jorteConfig.getHideCompletedTask(), function(list) {
                        var newTask = list && list.length > 0 ? list[0] : null;
                        for (var i = 0; newTask && i < localList.length; i++) {
                            if (localList[i].id === newTask.id && localList[i].type === 1) {
                                localList[i] = newTask;
                                break;
                            }
                        }
                        sortEventTasks(localList);
                        $scope.renderList = processResult(localList);
                        $scope.$apply();

                        var index = -1;
                        for (var i = 0; i < localList.length; i++) {
                            if (localList[i].id === data.task_id) {
                                index = i;
                                break;
                            }
                        }
                        if (dialogService.dialogs['eventTaskDetailPopup']) {
                            dialogService.close('eventTaskDetailPopup');
                        }
                        if (index >= 0) {
                            $scope.onItemClick(index + 1);
                        }
                    });
                });

                $scope.$on('eventUpdated', function(evt, data) {
                    for (var i = 0; localList && i < localList.length; i++) {
                        var locItem = localList[i];
                        if (locItem && locItem.id === data.event_id && locItem.type === 0) {
                            localList.splice(i, 1);
                            i--;
                        }
                    }
                    var evtToShow = jorteConfig.getEventToShow();
                    var dispCompletedEvt = jorteConfig.getDispCompletedEvent();
                    eventSvc.getSingleEventAndInstances(startDate, endDate, data.event_id, evtToShow, dispCompletedEvt, function(list) {
                        setTimeout(function () {
                            for (var i = 0; i < list.length; i++) {
                                localList.push(list[i]);
                            }
                            sortEventTasks(localList);
                            $scope.renderList = processResult(localList);
                            $scope.$apply();

                            var index = -1;
                            for (var i = 0; i < localList.length; i++) {
                                if (localList[i].id === data.event_id && localList[i].type === 0) {
                                    index = i;
                                    break;
                                }
                            }
                            if (dialogService.dialogs['eventTaskDetailPopup']) {
                                dialogService.close('eventTaskDetailPopup');
                            }
                            if (index >= 0) {
                                $scope.onItemClick(index + 1);
                            }
                        },10);

                    });
                });
                
                $scope.$on('eventAdded', function(evt, data) {
                    if (data.dataObj && data.dataObj.event.parent && data.dataObj.event.originalStartDate) {
                        var instance_id = data.dataObj.event.parent + '#' + data.dataObj.event.originalStartDate;
                        for (var i = 0; localList && i < localList.length; i++) {
                            var locItem = localList[i];
                            if (locItem && locItem.instance_id === instance_id) {
                                localList.splice(i, 1);
                                break;
                            }
                        }
                    }
                    var evtToShow = jorteConfig.getEventToShow();
                    var dispCompletedEvt = jorteConfig.getDispCompletedEvent();
                    eventSvc.getSingleEventAndInstances(startDate, endDate, data.event_id, evtToShow, dispCompletedEvt, function(list) {
                        setTimeout(function () {
                            for (var i = 0; i < list.length; i++) {
                                localList.push(list[i]);
                            }
                            sortEventTasks(localList);
                            $scope.renderList = processResult(localList);
                            $scope.$apply();

                            var index = -1;
                            for (var i = 0; i < localList.length; i++) {
                                if (localList[i].id === data.event_id && localList[i].type === 0) {
                                    index = i;
                                    break;
                                }
                            }
                            if (dialogService.dialogs['eventTaskDetailPopup']) {
                                dialogService.close('eventTaskDetailPopup');
                            }
                            if (index >= 0) {
                                $scope.onItemClick(index + 1);
                            }

                        }, 10);

                    });
                });
                
                $scope.onSearchClick = function() {
                    showSearchResult();
                };

                $scope.onBackwardClick = function() {
                    var end = new Date(startDate);
                    end.setHours(23, 59, 59, 0);
                    var prev = jorteUtils.addDays(end, -1, true).getTime();
                    startDate = jorteUtils.addMonths(new Date(startDate), -period, false).getTime();
                    $scope.startDate = jorteUtils.formatDate(new Date(startDate), getMSG('LongDateFormat5'), cal_string);
                    loadSearchResult($scope.keyWord, startDate, prev, false, function(list) {
                        for (var i = list.length - 1; i >= 0; i--) {
                            localList.unshift(list[i]);
                        }
                        $scope.renderList = processResult(localList);
                        $scope.$apply();
                    });
                };

                $scope.onForwardClick = function() {
                    var next = jorteUtils.addDays(new Date(endDate), 1, false).getTime();
                    endDate = jorteUtils.addMonths(new Date(endDate), period, true).getTime();
                    $scope.endDate = jorteUtils.formatDate(new Date(endDate), getMSG('LongDateFormat5'), cal_string);
                    loadSearchResult($scope.keyWord, next, endDate, false, function(list) {
                        for (var i = 0; i < list.length; i++) {
                            localList.push(list[i]);
                        }
                        $scope.renderList = processResult(localList);
                        $scope.$apply();
                    });
                };

                function processResult(result) {
                    var renderList = [];
                    var lastDate = '';
                    var itemIndex = 0;
                    var startTime = startDate;
                    var endTime = endDate;
                    for (var i = 0; i < result.length; i++) {
                        var renderItem = {};
                        var rec = result[i];
                        if (VerEx().find($scope.keyWord).withAnyCase().test(rec.name) && (rec.begin || rec.end)) {
                            if ((startTime <= rec.begin && endTime >= rec.begin) ||
                                    (startTime <= rec.end && endTime >= rec.end) ||
                                    (rec.begin <= startTime && rec.end >= startTime)) {

                                var start = new Date(rec.begin);
//                                var end = new Date(rec.end);
                                var dt = jorteUtils.formatDate(start, getMSG('LongDateFormat1'), cal_string);
                                var btime = jorteUtils.formatDate(start, 'HH:mm');
                                
                                var etime = jorteUtils.formatDate(new Date(rec.end), 'HH:mm');
                                if (rec.day_time === 7) {
                                    var d = new Date(rec.end);
                                    d.setMinutes(d.getMinutes() + 1);
                                    etime = jorteUtils.TimeConvertOption(d.getTime(), getMSG('ShortDateFormat3'));
                                } else if (rec.day_time === 8) {
                                    var d = new Date(rec.end_inst);
                                    etime = jorteUtils.TimeConvertOption(d.getTime(), getMSG('ShortDateFormat3'));
                                }
                                
//                                var etime = (rec.day_time === 7) ? '24:00' : jorteUtils.formatDate(end, 'HH:mm');
                                var time = '';
                                if (rec.start_time || rec.start_time === 0) {
                                    time = btime;
                                } else {
                                    time += '--:--';
                                }
                                if (rec.end_time || rec.end_time === 0) {
                                    time += ' - ' + etime;
                                } else {
                                    time += ' - ' + '--:--';
                                }
                                if (lastDate !== dt) {
                                    renderItem.dayChanged = true;
                                    renderItem.startDay = start.getDay();
                                    renderItem.displayDate = dt;
                                    lastDate = dt;
                                }
                                renderItem.importance = rec.importance;
                                renderItem.itemColor = rec.color;
                                renderItem.color = jorteUtils.getColor(rec);
                                renderItem.name = rec.name;
                                renderItem.location = rec.location;
                                renderItem.time = time;
                                renderItem.itemId = rec.id;
                                renderItem.itemType = rec.type;
                                renderItem.itemDate = rec.begin;
                                renderItem.itemIndex = ++itemIndex;
                                renderItem.is_public = rec.is_public;
                                renderItem.is_share = rec.is_share;
                                renderItem.itemInstanceId = rec.instance_id;
                                if (rec.details) {
                                    renderItem.details = rec.details;
                                }
                                renderList.push(renderItem);
                            }
                        }
                    }
                    return renderList;
                }
            }]);