'use strict';

/**
 * Jorte main controllers
 * 
 */
angular.module('controllers.mainSettings', [])

        // settings controller
        .controller('mainSettingsCtrl', ['$rootScope', '$scope', '$routeParams', '$sce', 'jorteAuthSvc', 'googleAuthSvc', 'syncSvc', 'calendarSvc', 'mainSvc', 'dialogService',
            function($rootScope, $scope, $routeParams, $sce, jorteAuthSvc, googleAuthSvc, syncSvc, calendarSvc, mainSvc, dialogService) {

                $scope.screenHt = $(window).height();

                function deleteGoogleAccount() {
                    calendarSvc.clearGoogleData(function() {
                        googleAuthSvc.clearAccount();
                        syncSvc.removePreviousAlarm(jorteConfig.googleCalendar, function() {
                        });
                        syncSvc.removePreviousAlarm(jorteConfig.googleTaskList, function() {
                        });
                        $scope.initSettings();
                        $scope.$apply();
                    });
                }
                function syncCallbackFn() {
                    if ($routeParams.mode === 'taskList' || $routeParams.mode === 'taskListSync') {
                        $rootScope.$broadcast('syncTaskCompleted', null);
                    } else {
                        $rootScope.$broadcast('syncCompleted', null);
                    }
                }

                $scope.manageJorteAutoSync = function() {

                    if (!jorteConfig.getJorteAccount()) {
                        $scope.jorteAutoSyncEnabled = false;
                        return;
                    }

                    if ($scope.jorteAutoSyncEnabled) {
                        jorteConfig.removeJorteCalendarAutoSync();
                        $scope.jorteAutoSyncEnabled = false;
                        syncSvc.removePreviousAlarm(jorteConfig.jorteCalendar, function() {
                        });
                    } else {
                        jorteConfig.setJorteCalendarAutoSync(120);
                        $scope.jorteAutoSyncEnabled = true;
                        syncSvc.setAutoSync(jorteConfig.jorteCalendar, jorteConfig.getJorteCalendarAutoSync());
                    }
                };

                $scope.manageGoogleAutoSync = function() {

                    if (!jorteConfig.getGoogleAccount()) {
                        $scope.googleAutoSyncEnabled = false;
                        return;
                    }

                    if ($scope.googleAutoSyncEnabled) {
                        jorteConfig.removeGoogleCalendarAutoSync();
                        $scope.googleAutoSyncEnabled = false;
                        syncSvc.removePreviousAlarm(jorteConfig.googleCalendar, function() {
                        });
                    } else {
                        jorteConfig.setGoogleCalendarAutoSync(120);
                        $scope.googleAutoSyncEnabled = true;
                        syncSvc.setAutoSync(jorteConfig.googleCalendar, jorteConfig.getGoogleCalendarAutoSync());
                    }
                };

                $scope.setAutoSyncInterval = function(syncType) {
                    $scope.interval = null;
                    $scope.syncType = syncType;
                    $scope.syncItem = null;

                    if (syncType === 'jorte') {
                        $scope.interval = jorteConfig.getJorteCalendarAutoSync();
                    } else if (syncType === 'google') {
                        $scope.interval = jorteConfig.getGoogleCalendarAutoSync();
                    }
                    if ($scope.interval) {
                        var modelData = {
                            intervalId: $scope.interval,
                            syncType: $scope.syncType,
                            onSuccess: function(interval) {

                                if (interval && $scope.interval !== interval) {
                                    $scope.interval = interval;

                                    if (syncType === 'jorte') {
                                        jorteConfig.setJorteCalendarAutoSync(interval);
                                        $scope.syncItem = jorteConfig.jorteCalendar;
                                    } else if (syncType === 'google') {
                                        jorteConfig.setGoogleCalendarAutoSync(interval);
                                        $scope.syncItem = jorteConfig.googleCalendar;
                                    }
                                    if ($scope.syncItem) {
                                        syncSvc.setAutoSync($scope.syncItem, interval);
                                    }

                                }
                                dialogService.close("setAutoSyncIntervalPopup", "setAutoSyncInterval");
                            }};
                        dialogService.open("setAutoSyncIntervalPopup", "setAutoSyncInterval", modelData, {minHeight: 320, title: getMSG('choosesyncinterval')});
                    }
                };

                $scope.initSettings = function() {
                    jorteAuthSvc.init();
                    googleAuthSvc.init();
                    if ($routeParams.mode === 'taskList' || $routeParams.mode === 'taskListSync') {
                        if ($routeParams.mode === 'taskListSync') {
                            $scope.showSettingsArea = false;
                            $scope.showSettingsSync = false;
                            $scope.showSettingsTskSync = true;
                            $scope.showSettingsCal = false;
                        } else {
                            $scope.showSettingsArea = true;
                            $scope.showSettingsSync = false;
                            $scope.showSettingsTskSync = false;
                            $scope.showSettingsCal = false;
                        }

                        $scope.jorteAutoSyncEnabled = jorteConfig.getJorteCalendarAutoSync() ? true : false;
                        $scope.googleAutoSyncEnabled = jorteConfig.getGoogleCalendarAutoSync() ? true : false;
                        $scope.jorteSyncInterval = jorteConfig.getJorteCalendarAutoSync() ? jorteConfig.getJorteCalendarAutoSync() : null;
                        $scope.googleSyncInterval = jorteConfig.getJorteCalendarAutoSync() ? jorteConfig.getJorteCalendarAutoSync() : null;
                    } else if ($routeParams.mode === 'calendar' || $routeParams.mode === 'calendarSync') {
                        if ($routeParams.mode === 'calendarSync') {
                            $scope.showSettingsArea = false;
                            $scope.showSettingsSync = true;
                            $scope.showSettingsCal = false;
                            $scope.showSettingsTskSync = false;
                        } else {
                            $scope.showSettingsArea = false;
                            $scope.showSettingsSync = false;
                            $scope.showSettingsTskSync = false;
                            $scope.showSettingsCal = true;

                            mainSvc.getSelectedCalendars(function(data) {
                                if (data.length > 0) {
                                    var pos = 0;
                                    for (var j = 0; j < data.length; j++) {
                                        if (data[j].id === jorteConfig.getDefaultCalendar()) {
                                            pos = j;
                                            break;
                                        }
                                    }
                                    $scope.defaultCalendarName = data[pos].name;
                                }

                                $scope.$apply();
                            });

                        }

                        $scope.jorteAutoSyncEnabled = jorteConfig.getJorteCalendarAutoSync() ? true : false;
                        $scope.googleAutoSyncEnabled = jorteConfig.getGoogleCalendarAutoSync() ? true : false;
                        $scope.jorteSyncInterval = jorteConfig.getJorteCalendarAutoSync() ? jorteConfig.getJorteCalendarAutoSync() : null;
                        $scope.googleSyncInterval = jorteConfig.getJorteCalendarAutoSync() ? jorteConfig.getJorteCalendarAutoSync() : null;
                    }

                    $scope.displayTask = jorteConfig.getDisplayTask();
                    $scope.singleTapDisplay = jorteConfig.getSingleTapDisplay();
                    $scope.showWeekNum = jorteConfig.getShowWeekNumber();
                    $scope.hideCompletedTask = jorteConfig.getHideCompletedTask();
                    $scope.jorteLoginEnabled = jorteAuthSvc.fetchUserProfile() ? true : false;
                    $scope.googleLoginEnabled = googleAuthSvc.fetchUserProfile() ? true : false;
                    $scope.googleUser = googleAuthSvc.fetchUserProfile() ? googleAuthSvc.fetchUserProfile().email : '';
                    $scope.jorteUser = (jorteAuthSvc.fetchJSyncStatus() && jorteAuthSvc.fetchJSyncStatus().status) ? jorteAuthSvc.fetchJSyncStatus().jorteId : null;
                };

                $scope.defaultCalander = function() {
                    var modelData = {
                        onSuccess: function(val) {
                            $scope.defaultCalendarName = val;
                        }
                    };
                    dialogService.open("defaultCalanderPopup", "defaultCalanderPopupInfo", modelData, {title: getMSG('SetDefaultCalendarHead')});

                };

                $scope.completeTaskStatus = function() {
                    if ($scope.hideCompletedTask) {
                        jorteConfig.setHideCompletedTask(false);
                    } else {
                        jorteConfig.setHideCompletedTask(true);
                    }
                    $scope.initSettings();
                };

                $scope.dispWithSingleTap = function() {
                    if ($scope.singleTapDisplay) {
                        jorteConfig.setSingleTapDisplay(false);
                    } else {
                        jorteConfig.setSingleTapDisplay(true);
                    }
                    $scope.initSettings();
                };

                $scope.showWeekNumStatus = function() {
                    if ($scope.showWeekNum) {
                        jorteConfig.setShowWeekNumber(false);
                    } else {
                        jorteConfig.setShowWeekNumber(true);
                    }
                    $scope.initSettings();
                };

                $scope.displayTaskStatus = function() {
                    if ($scope.displayTask) {
                        jorteConfig.setDisplayTask(false);
                    } else {
                        jorteConfig.setDisplayTask(true);
                    }
                    $scope.initSettings();
                };

                $scope.deleteJorteAccount = function() {
                    jorteAuthSvc.clearAccount();
                    syncSvc.removePreviousAlarm(jorteConfig.jorteCalendar, function() {
                    });
                    syncSvc.removePreviousAlarm(jorteConfig.jorteTaskList, function() {
                    });
                    $scope.initSettings();
                };

                $scope.manageJorteAccount = function() {
                    if (jorteConfig.getJorteAccount()) {
                        $scope.deleteJorteAccount();
                    } else {
                        var modelData = {onSuccess: function(val) {
                                $scope.jorteLoginEnabled = val;
                                $scope.jorteUser = jorteAuthSvc.fetchUserProfile() ? jorteAuthSvc.fetchUserProfile().jorteId : '';
                                syncSvc.sync({jorteCalendar: true}, function() {
                                    syncSvc.sync({jorteTaskList: true}, syncCallbackFn);
                                });
                            }};
                        dialogService.open("jorteLoginPopup", "jorteLoginPopup", modelData, {title: getMSG('Jorte_ID_settings')});
                    }
                };

                $scope.manageGoogleAccount = function() {
                    if (jorteConfig.getGoogleAccount()) {
                        var confirmModel = {
                            msg: $sce.trustAsHtml(getMSG('GoogleRemoveAccountConfirmHead')),
                            resultCb: function(status) {
                                if (status) {
                                    deleteGoogleAccount();
                                }
                                dialogService.close("confirmBoxPopup");
                            }
                        };
                        dialogService.open("confirmBoxPopup", "confirmBox", confirmModel, {title: getMSG('Confirm')});
                    } else {
                        var modelData = {onSuccess: function(val, res) {
                                jorteConfig.setGoogleCalendarEnabled(true);
                                $scope.googleLoginEnabled = val;
                                $scope.googleUser = googleAuthSvc.fetchUserProfile() ? googleAuthSvc.fetchUserProfile().email : '';
                                $scope.$apply();
                                syncSvc.sync({googleCalendar: true}, function() {
                                    syncSvc.sync({googleTaskList: true}, syncCallbackFn);
                                });
                                if (res && (res === 'close' || res === 'access_denied')) {
                                    dialogService.close("googleLoginPopup", "googleLoginPopup");
                                }
                            }};
                        dialogService.open("googleLoginPopup", "googleLoginPopup", modelData, {title: getMSG('Google_Account_Settings')});
                    }
                };

                $scope.syncJorte = function() {
                    if (navigator.onLine) {
                        syncSvc.sync({jorteCalendar: true}, function() {
                            syncSvc.sync({jorteTaskList: true}, syncCallbackFn);
                        });
                    } else {
                        alert(getMSG('NetworkNotAvailable'));
                    }
                };

                $scope.syncGoogle = function() {
                    if (navigator.onLine) {
                        syncSvc.sync({googleCalendar: true}, function() {
                            syncSvc.sync({googleTaskList: true}, syncCallbackFn);
                        });
                    } else {
                        alert(getMSG('NetworkNotAvailable'));
                    }
                };

                $scope.initSettings();
            }])
        .controller('setAutoSyncIntervalCtrl', ['$scope', 'dialogService',
            function($scope) {

                $scope.intervalList = [
                    {id: 5, name: getMSG('FiveMinutesIntervalHead')},
                    {id: 30, name: getMSG('ThirtyMinutesIntervalHead')},
                    {id: 60, name: getMSG('OneHourIntervalHead')},
                    {id: 120, name: getMSG('TwoHourIntervalHead')},
                    {id: 180, name: getMSG('ThreeHourIntervalHead')},
                    {id: 400, name: getMSG('SixHourIntervalHead')},
                    {id: 800, name: getMSG('TwelveHourIntervalHead')}
                ];

                $scope.setInterval = function(id, name) {
                    $scope.model.onSuccess(id);
                };

            }])
        .controller('defaultCalanderCtrl', ['$scope', 'dialogService', 'mainSvc',
            function($scope, dialogService, mainSvc) {

                $scope.calanderList = [];
                $scope.isSelected = jorteConfig.getDefaultCalendar();
                $scope.defaultCalander = function() {
                    mainSvc.getSelectedCalendars(function(data) {
                        $scope.calanderList = processCalander(data);
                        $scope.$apply();
                    });
                };
                function processCalander(res) {
                    var calanderList = [];
                    var calanderItem;
                    for (var i = 0; i < res.length; i++) {
                        calanderItem = {};
                        calanderItem.calendarListId = res[i].id;
                        calanderItem.calendarListName = res[i].name;
                        calanderItem.calendarType = res[i].type;
                        calanderItem.index = i + 1;
                        calanderList.push(calanderItem);
                    }
                    return calanderList;
                }

                $scope.onCalanderItemClick = function(index, calendarName) {
                    jorteConfig.setDefaultCalendar(index);
                    $scope.model.onSuccess(calendarName);
                    dialogService.close("defaultCalanderPopup");
                };
                $scope.onCancelClick = function() {
                    dialogService.close("defaultCalanderPopup");
                };

                $scope.defaultCalander();
            }]);