'use strict';

/**
 * Jorte controllers
 * 
 */
angular.module('controllers.notificationSettings', [])
        .controller('notificationSettingsCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.notifySetScreenHt = $(window).height() - $('#default_reminder').height();
                $scope.closeNotificationSettings = function() {
                    dialogService.open("mainSettingsFormPopUp", "mainSettingsForm", null, {title: getMSG('OptionsHead')});
                };
                $scope.openNotificationSettings = function() {
                    dialogService.open("notificationsPopup", "notificationPopupInfo", {notificationCode: jorteConfig.getDefaultReminder()}, {title: getMSG('AlertSettingsHead')});
                };
                $scope.openAlertTypeSettings = function() {
                    dialogService.open("alertTypePopup", "alertTypePopupInfo", null, {title: getMSG('SelectHead')});
                };
            }])
        .controller('notificationSetCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.params = {
                    notificationOrderId: $scope.model.notificationCode
                };
                $scope.setnotificationSettingOrder = function(id) {
                    jorteConfig.setDefaultReminder(id);
                    dialogService.close("notificationsPopup");
                };
            }])
        .controller('alertTypeCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.selectAlertType = function() {
                    dialogService.close("alertTypePopup");
                };
            }]);



