'use strict';
/**
 * Jorte controllers
 * 
 */
angular.module("controllers.optionSettings", [])
        .controller('optionSettingsCtrl', ['$scope', '$location', 'dialogService',
            function($scope, $location, dialogService) {
                $scope.showMainSettings = function() {
                    var countryModel = {
                        countryCode: getMSG('CurrentActiveLanguage')
                    };
                    dialogService.open("holidayPopup", "holidayPopupInfo", countryModel, {title: getMSG('NationalHolidaysHead')});
                };
                $scope.viewEventSettings = function() {
                    $location.path('/viewEventSettings');
                    dialogService.close("mainSettingsFormPopUp");
                };
                $scope.notificationSettings = function() {
                    $location.path('/notificationSettings');
                    dialogService.close("mainSettingsFormPopUp");
                };
                $scope.aboutApp = function() {
                    var currentLang = getMSG('CurrentActiveLanguage');

                    if (currentLang === "ja") {
                        $location.path('/aboutJorteJa');
                    } else if(currentLang === "es"){
                        $location.path('/aboutJorteEs');
                    } else {
                        $location.path('/aboutJorteEn');
                    }                    
                    dialogService.close("mainSettingsFormPopUp");
                };
            }
        ])
        .controller('holyDaySettings', ['$rootScope', '$scope', 'holidayApiSvc', 'holidaySvc', 'dialogService',
            function($rootScope, $scope, holidayApiSvc, holidaySvc, dialogService) {

                function network_availability(callBack) {
                    if (navigator.onLine) {
                        callBack && callBack(true);
                    } else {
                        callBack && callBack(false);
                    }
                }
                var cntryCode = $scope.model.countryCode;
                var cntryName = getMSG('UsHead');
                switch (cntryCode) {
                    case 'ja':
                        cntryName = getMSG('JapaneseHead');
                        break;
                }
                $scope.params = {
                    countryCode: $scope.model.countryCode,
                    countryName: cntryName
                };
                //show all country codes
                $scope.showCountryNames = function() {
                    var countryModel = {
                        countryCode: ($scope.params.countryCode) ? $scope.params.countryCode : '',
                        selectedCountry: function(countryCode, countryName) {
                            $scope.params.countryCode = countryCode;
                            $scope.params.countryName = countryName;
                        }
                    };
                    dialogService.open("selectCountryPopup", "selectCountryInfo", countryModel, {title: getMSG('SelectHead')});
                };
                $scope.importHoliday = function() {
                    var countryCode = $scope.params.countryCode;
                    countryCode = (countryCode === 'ja') ? 'japanese' : countryCode;
                    var confirmMsg = getMSG('ContentOneHolidayHead');
                    if (countryCode === 'japanese') {
                        confirmMsg = getMSG('NationalHolidayImportJaExplanation');
                    }
                    if (!confirm(confirmMsg)) {
                        return false;
                    }
                    var CurrentActiveLanguage = getMSG('CurrentActiveLanguage');
                    var contryCode = (countryCode === 'en') ? 'usa' : countryCode;
                    var userId = CurrentActiveLanguage + '.' + contryCode + '#holiday@group.v.calendar.google.com';

                    var currentDate = new Date();
                    var minDate = new Date(currentDate.setFullYear(currentDate.getFullYear() - 2));
                    var currentDate = new Date();
                    var maxDate = new Date(currentDate.setFullYear(currentDate.getFullYear() + 2));
                    var maxResults = 100;

                    var urlDetails = {
                        startMin: minDate,
                        startMax: maxDate,
                        userId: encodeURIComponent(userId),
                        maxResults: maxResults
                    };

                    var match_jacalendar = "^[^.]+\.japanese.*$";
                    var patt = new RegExp(match_jacalendar);
                    var res = patt.test(userId);

                    if (res) {
                        /*
                         * For japanese national holiday, calculating in app
                         */
                        holidayApiSvc.jaHolidayRequest(urlDetails, function(status) {
                            $rootScope.$broadcast('holyDayAdded');
                            status ? alert(getMSG('HolidaysImportedHead')) : alert(getMSG('HolidaysNotImportedHead'));
                            dialogService.close("holidayPopup");
                        });
                    } else {

                        network_availability(function(status) {
                            if (status) {
                                /*
                                 * For other countries national holiday, from national holiday API
                                 */
                                holidayApiSvc.holidayRequest(urlDetails, function(status) {
                                    $rootScope.$broadcast('holyDayAdded');
                                    status ? alert(getMSG('HolidaysImportedHead')) : alert(getMSG('HolidaysNotImportedHead'));
                                    dialogService.close("holidayPopup");
                                });
                            }
                        });
                    }
                };
                $scope.deleteHoliday = function() {
                    if (confirm(getMSG('DeletAllHolidayDataHead'))) {
                        holidaySvc.deleteHolidayEvents(function() {
                            $rootScope.$broadcast('holidayDeleted');
                            $rootScope.$broadcast('holyDayAdded');
                            alert(getMSG('DeleteCompleteHead'));
                            dialogService.close("holidayPopup");
                        });
                    }
                };
                $scope.closeHoliday = function() {
                    dialogService.close("holidayPopup");
                };
                //set the country code for holiday import
                $scope.setCountryDetails = function(countryCode, countryName) {
                    $scope.model.selectedCountry(countryCode, getMSG(countryName));
                    dialogService.close("selectCountryPopup");
                };
            }
        ]);