'use strict';

/**
 * Jorte controllers
 * 
 */
angular.module('controllers.viewEventSettings', [])
        .controller('viewEventSettingsCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.viewSettingsScreenHt = $(window).height() - $('#event_view_settings_header').height();
                $scope.closeEventViewSettings = function() {
                    dialogService.open("mainSettingsFormPopUp", "mainSettingsForm", null, {title: getMSG('OptionsHead')});
                };

                $scope.orderOfDisplayEvents = function() {
                    var displayModel = {
                        displayCode: jorteConfig.getEventDispOrder(),
                        eventShowCode: jorteConfig.getEventToShow(),
                        displayCompleteCode: jorteConfig.getDispCompletedEvent()
                    };
                    dialogService.open("displayOrderPopup", "displayOrderPopupInfo", displayModel, {title: getMSG('SelectHead')});
                };

                $scope.whichEventShow = function() {
                    var eventShowModel = {
                        displayCode: jorteConfig.getEventDispOrder(),
                        eventShowCode: jorteConfig.getEventToShow(),
                        displayCompleteCode: jorteConfig.getDispCompletedEvent()
                    };
                    dialogService.open("eventShowPopup", "eventShowPopupInfo", eventShowModel, {title: getMSG('SelectHead')});
                };

                $scope.howToShowEvents = function() {
                    var eventShowModel = {
                        displayCode: jorteConfig.getEventDispOrder(),
                        eventShowCode: jorteConfig.getEventToShow(),
                        displayCompleteCode: jorteConfig.getDispCompletedEvent()
                    };
                    dialogService.open("eventDisplayCompletPopup", "eventDisplayCompletePopupInfo", eventShowModel, {title: getMSG('SelectHead')});
                };
            }])
        .controller('eventSettingsCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.params = {
                    displayOrderId: $scope.model.displayCode,
                    eventShowId: $scope.model.eventShowCode,
                    eventDisplayCompleteId: $scope.model.displayCompleteCode
                };

                $scope.setdisplayOrder = function(id) {
                    jorteConfig.setEventDispOrder(id);
                    dialogService.close("displayOrderPopup");
                };

                $scope.eventShowOrder = function(id) {
                    jorteConfig.setEventToShow(id);
                    dialogService.close("eventShowPopup");
                };

                $scope.dispCompletedOrder = function(id) {
                    jorteConfig.setDispCompletedEvent(id);
                    dialogService.close("eventDisplayCompletPopup");
                };
            }]);


