'use strict';

/**
 * Jorte calendar view settings controllers
 * 
 */
angular.module('controllers.viewSettings', [])

        .controller('calViewSettingsCtrl', ['$rootScope', '$scope', 'dialogService',
            function($rootScope, $scope, dialogService) {
                var viewType = jorteConfig.getDefaultView();
                var viewSettings = (viewType === 1) ? jorteConfig.getMonthSettings() : jorteConfig.getWeekSettings();
                $scope.settingsParam = {
                    showPage: false,
                    viewType: viewType,
                    viewLabel: (viewType === 1) ? getMSG('MonthHead') : getMSG('WeekHead'),
                    firstDayVal: (viewType === 1) ? jorteConfig.getFirstDayOfMonth() : jorteConfig.getFirstDayOfWeek(),
                    firstDayLabel: (viewType === 1) ? jorteUtils.getDayText(jorteConfig.getFirstDayOfMonth()) : jorteUtils.getDayText(jorteConfig.getFirstDayOfWeek()),
                    dispImpEvents: viewSettings.dispImpEvent,
                    dispTaskMemo: viewSettings.dispTaskMemo,
                    fontSize: viewSettings.fontSize,
                    iconSize: viewSettings.iconSize,
                    iconSizeLabel: jorteUtils.getIconSizeText(viewSettings.iconSize),
                    reverseBar: viewSettings.reverseBar
                };

                $scope.$watch('params.settings', function(newVal, oldVal) {
                    $scope.settingsParam.showPage = newVal;
                });
                //On view change
                $scope.$watch('params.viewType', function(newVal, oldVal) {
                    $scope.settingsParam.viewType = newVal;
                    $scope.settingsParam.viewLabel = (newVal === 1) ? getMSG('MonthHead') : getMSG('WeekHead');
                    $scope.settingsParam.firstDayVal = (newVal === 1) ? jorteConfig.getFirstDayOfMonth() : jorteConfig.getFirstDayOfWeek();
                    $scope.settingsParam.firstDayLabel = (viewType === 1) ? jorteUtils.getDayText(jorteConfig.getFirstDayOfMonth()) : jorteUtils.getDayText(jorteConfig.getFirstDayOfWeek()),
                            viewSettings = (newVal === 1) ? jorteConfig.getMonthSettings() : jorteConfig.getWeekSettings();
                    $scope.settingsParam.dispImpEvents = viewSettings.dispImpEvent;
                    $scope.settingsParam.dispTaskMemo = viewSettings.dispTaskMemo;
                    $scope.settingsParam.fontSize = viewSettings.fontSize;
                    $scope.settingsParam.iconSize = viewSettings.iconSize;
                    $scope.settingsParam.iconSizeLabel = jorteUtils.getIconSizeText(viewSettings.iconSize);
                });
                //close settings
                $scope.closeSettings = function() {
                    $scope.settingsParam.showPage = false;
                    //Reflect change in parent view
                    $scope.$parent.params.settings = false;
                };
                //Display task and memos
                $scope.dispTaskMemo = function() {
                    var currTaskVal = parseInt($scope.settingsParam.dispTaskMemo);
                    var currEvtVal = $scope.settingsParam.dispImpEvents;
                    var currRevVal = $scope.settingsParam.reverseBar;
                    var fontSize = $scope.settingsParam.fontSize;
                    var iconSize = $scope.settingsParam.iconSize;
                    $scope.settingsParam.dispTaskMemo = currTaskVal;
                    if ($scope.settingsParam.viewType === 1) {
                        jorteConfig.setMonthSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal, reverseBar: currRevVal, fontSize: fontSize, iconSize: iconSize});
                    } else {
                        jorteConfig.setWeekSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal, reverseBar: currRevVal, fontSize: fontSize, iconSize: iconSize});
                    }
                    jorteConfig.setDisplayTask(currTaskVal ? true : false);
                    //Reflect change in parent view
                    $scope.$parent.params.dispTaskMemo = currTaskVal ? true : false;
                };
                //Display important events
                $scope.dispImpEvents = function() {
                    var currTaskVal = $scope.settingsParam.dispTaskMemo;
                    var currEvtVal = parseInt($scope.settingsParam.dispImpEvents);
                    var currRevVal = $scope.settingsParam.reverseBar;
                    var fontSize = $scope.settingsParam.fontSize;
                    var iconSize = $scope.settingsParam.iconSize;                    
                    $scope.settingsParam.dispImpEvents = currEvtVal;
                    if ($scope.settingsParam.viewType === 1) {
                        jorteConfig.setMonthSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal, reverseBar: currRevVal, fontSize: fontSize, iconSize: iconSize});
                    } else {
                        jorteConfig.setWeekSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal, reverseBar: currRevVal, fontSize: fontSize, iconSize: iconSize});
                    }
                    //Reflect change in parent view
                    $scope.$parent.params.dispImpEvents = (currEvtVal) ? true : false;
                };
                //Reverse bar band display
                $scope.reverseBarFn = function() {
                    var currTaskVal = $scope.settingsParam.dispTaskMemo;
                    var currEvtVal = $scope.settingsParam.dispImpEvents;
                    var currRevVal = $scope.settingsParam.reverseBar;
                    var fontSize = $scope.settingsParam.fontSize;
                    var iconSize = $scope.settingsParam.iconSize;
                    $scope.settingsParam.iconSizeLabel = jorteUtils.getIconSizeText(iconSize);
                    if ($scope.settingsParam.viewType === 1) {
                        jorteConfig.setMonthSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal,
                            reverseBar: currRevVal, fontSize: fontSize, iconSize: iconSize});
                    } else {
                        jorteConfig.setWeekSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal,
                            reverseBar: currRevVal, fontSize: fontSize, iconSize: iconSize});
                    }
                    //Reflect change in parent view
                    $rootScope.$broadcast('reverseBandChanged', $scope.settingsParam.viewType);
                };
                //Select view
                $scope.selectView = function() {

                    var settingsViewModel = {
                        viewType: $scope.settingsParam.viewType,
                        viewTypeCb: function(val) {
                            var chViewType = parseInt(val);
                            var viewSettings = (chViewType === 1) ? jorteConfig.getMonthSettings() : jorteConfig.getWeekSettings();

                            jorteConfig.setDefaultView(chViewType);
                            $scope.settingsParam.viewType = chViewType;
                            $scope.settingsParam.viewLabel = (chViewType === 1) ? getMSG('MonthHead') : getMSG('WeekHead');
                            $scope.settingsParam.firstDayVal = (chViewType === 1) ? jorteConfig.getFirstDayOfMonth() : jorteConfig.getFirstDayOfWeek();
                            $scope.settingsParam.firstDayLabel = (chViewType === 1) ? jorteUtils.getDayText(jorteConfig.getFirstDayOfMonth()) : jorteUtils.getDayText(jorteConfig.getFirstDayOfWeek());
                            $scope.settingsParam.dispImpEvents = viewSettings.dispImpEvent;
                            $scope.settingsParam.dispTaskMemo = viewSettings.dispTaskMemo;
                            $scope.settingsParam.fontSize = viewSettings.fontSize;
                            $scope.settingsParam.iconSize = viewSettings.iconSize;
                            $scope.settingsParam.iconSizeLabel = jorteUtils.getIconSizeText(viewSettings.iconSize);
                            $scope.settingsParam.reverseBar = viewSettings.reverseBar;
                            //Reflect change in parent view
                            $scope.$parent.params.dispTaskMemo = viewSettings.dispTaskMemo ? true : false;
                            $scope.$parent.params.dispImpEvents = (viewSettings.dispImpEvent) ? true : false;
                            $scope.$parent.params.viewType = chViewType;
                        }
                    };
                    // Open the dialog
                    dialogService.open('selectViewPopup', 'selectView', settingsViewModel, {title: getMSG('SelectHead')});
                };

                //Set font size
                $scope.setFontSize = function() {
                    var settingsViewModel = {
                        fontSize: $scope.settingsParam.fontSize,
                        fontSizeCb: function(val) {
                            $scope.settingsParam.fontSize = val;
                            var currTaskVal = $scope.settingsParam.dispTaskMemo;
                            var currEvtVal = $scope.settingsParam.dispImpEvents;
                            var currRevVal = $scope.settingsParam.reverseBar;
                            var iconSize = $scope.settingsParam.iconSize;
                            $scope.settingsParam.dispImpEvents = currEvtVal;
                            if ($scope.settingsParam.viewType === 1) {
                                jorteConfig.setMonthSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal, reverseBar: currRevVal, fontSize: val, iconSize: iconSize});
                            } else {
                                jorteConfig.setWeekSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal, reverseBar: currRevVal, fontSize: val, iconSize: iconSize});
                            }
                            $scope.$parent.params.fontSize = val;
                        }
                    };
                    // Open the dialog
                    dialogService.open('fontSizePopup', 'fontSize', settingsViewModel, {title: getMSG('SelectHead')});
                };

                //Set event icon
                $scope.setEventIcon = function() {
                    var settingsViewModel = {
                        eventIcon: $scope.settingsParam.iconSize,
                        iconSizeCb: function(val) {
                            $scope.settingsParam.iconSize = val;
                            $scope.settingsParam.iconSizeLabel = jorteUtils.getIconSizeText(val);
                            var currTaskVal = $scope.settingsParam.dispTaskMemo;
                            var currEvtVal = $scope.settingsParam.dispImpEvents;
                            var currRevVal = $scope.settingsParam.reverseBar;
                            var fontSize = $scope.settingsParam.fontSize;
                            if ($scope.settingsParam.viewType === 1) {
                                jorteConfig.setMonthSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal, reverseBar: currRevVal, fontSize: fontSize, iconSize: val});
                            } else {
                                jorteConfig.setWeekSettings({dispTaskMemo: currTaskVal, dispImpEvent: currEvtVal, reverseBar: currRevVal, fontSize: fontSize, iconSize: val});
                            }
                            $scope.$parent.params.iconSize = val;
                        }
                    };
                    // Open the dialog
                    dialogService.open('eventIconPopup', 'eventIcon', settingsViewModel, {title: getMSG('SelectHead')});
                };

                //Select icon size
                $scope.selectFirstday = function() {
                    var settingsViewModel = {
                        firstDayVal: $scope.settingsParam.firstDayVal,
                        firstDayCb: function(val) {
                            var chfirstDay = parseInt(val);
                            ($scope.settingsParam.viewType === 1) ? jorteConfig.setFirstDayOfMonth(chfirstDay) :
                                    jorteConfig.setFirstDayOfWeek(chfirstDay);
                            $scope.settingsParam.firstDayVal = chfirstDay;
                            $scope.settingsParam.firstDayLabel = jorteUtils.getDayText(chfirstDay);
                            $rootScope.$broadcast('firstDayChanged', $scope.settingsParam.viewType);
                        }
                    };
                    // Open the dialog
                    dialogService.open('firstDayPopup', 'firstDay', settingsViewModel, {title: getMSG('SelectHead')});
                };
            }])
        //Change view controller
        .controller('selectViewCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                var viewType = $scope.model.viewType;
                $scope.viewParams = {
                    viewType: viewType
                };

                $scope.selectView = function(type) {
                    $scope.model.viewTypeCb(type);
                    dialogService.close('selectViewPopup');
                };
            }])
        //font size controller
        .controller('fontSizeCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.viewParams = {
                    fontSize: $scope.model.fontSize
                };
                $scope.setFontSize = function(fontSize) {
                    $scope.model.fontSizeCb(fontSize);
                    dialogService.close('fontSizePopup');
                };
            }])
        //event icon controller
        .controller('eventIconCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.viewParams = {
                    eventIcon: $scope.model.eventIcon
                };
                $scope.setEventIcon = function(iconSize) {
                    $scope.model.iconSizeCb(iconSize);
                    dialogService.close('eventIconPopup');
                };
            }])
        //Change first day controller
        .controller('firstdayCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.viewParams = {
                    firstDayVal: $scope.model.firstDayVal
                };
                $scope.setFirstDay = function(dayType) {
                    $scope.model.firstDayCb(dayType);
                    dialogService.close('firstDayPopup');
                };
            }]);