'use strict';
/**
 * Jorte task create controller
 * 
 */
angular.module('controllers.taskCreate', [])

        // create task controller
        .controller('taskCreateCtrl', ['$rootScope', '$scope', 'taskSvc', 'syncSvc', 'templateSvc', 'dialogService',
            function($rootScope, $scope, taskSvc, syncSvc, templateSvc, dialogService) {
                var remList = [];
                var defaultReminder = (jorteConfig.getDefaultReminder() === 'None') ? 10 : jorteConfig.getDefaultReminder();
                var name, startDate, endDate, startTime, endTime, content;
                if ($scope.model) {//From create event popup
                    name = $scope.model.name;
                    startDate = $scope.model.startDate;
                    endDate = $scope.model.endDate;
                    startTime = $scope.model.startTime;
                    endTime = $scope.model.endTime;
                    content = $scope.model.content;
                }
                //Show if there is only due date
                if (endDate && jorteConfig.getDefaultReminder() !== 'None') {
                    remList.push({id: new Date().getTime(), rem_id: null, type: defaultReminder, minutes: defaultReminder, label: jorteUtils.getReminderText(parseInt(defaultReminder))});
                }

                $scope.formInfo = {
                    name: (name) ? name : '',
                    start_date: (startDate) ? startDate : '----/--/--',
                    start_date_disp: (startDate) ? jorteUtils.formatDate(new Date(startDate), getMSG('TaskDate'), cal_string) : '----/--/--',
                    end_date: (endDate) ? endDate : '----/--/--',
                    end_date_disp: (endDate) ? jorteUtils.formatDate(new Date(endDate), getMSG('TaskDate'), cal_string) : '----/--/--',
                    start_time: (startTime) ? startTime : '--:--',
                    end_time: (endTime) ? endTime : '--:--',
                    showTaskList: false,
                    taskListId: 1,
                    taskListName: getMSG('MyTaskListHead'),
                    taskListType: 0,
                    remindershow: (endDate) ? true : false,
                    content: (content) ? content : null,
                    phContent: getMSG('ContentHead'),
                    reminder: {
                        list: remList
                    }
                };

                taskSvc.getAllSelectedTaskLists(function(data) {
                    if (data.length > 1) {
                        $scope.formInfo.showTaskList = true;
                    }
                    if (data.length > 0) {
                        $scope.formInfo.taskList = data;
                        $scope.formInfo.taskListId = data[0].id;
                        $scope.formInfo.taskListName = data[0].name;
                        $scope.formInfo.taskListType = data[0].type;
                        $scope.formInfo.sync_status = data[0].sync_status;
                        $scope.formInfo.tlist_global_id = data[0].global_id;
                    } else {
                        alert(getMSG('TaskListIsNotAvailableHead'));
                        dialogService.close('taskCreatePopup');
                    }
                    $scope.$apply();
                });

                function findTaskList(id) {
                    var task_list = $scope.formInfo.taskList;
                    var taskList;
                    for (var i = 0, item = null; i < task_list.length; i++) {
                        item = task_list[i];
                        if (item.id === id) {
                            taskList = item;
                            break;
                        }
                    }
                    return taskList;
                }

                $scope.showMyTaskList = function() {
                    var taskListModel = {
                        taskList: angular.copy($scope.formInfo.taskList),
                        taskListId: $scope.formInfo.taskListId,
                        taskListIdCb: function(taskListId, name) {
                            $scope.formInfo.taskListId = taskListId;
                            $scope.formInfo.taskListName = name;
                            var taskList = findTaskList(taskListId);
                            $scope.formInfo.taskListType = taskList.type;
                            $scope.formInfo.sync_status = taskList.sync_status;
                            $scope.formInfo.tlist_global_id = taskList.global_id;
                        }
                    };
                    dialogService.open('myTaskListPopup', 'myTaskList', taskListModel, {title: getMSG('SelectHead')});
                };
                //show event template
                $scope.eventTemplate = function() {
                    var templateModel = {
                        type: 1,
                        selectedTemplate: function(template) {
                            $scope.formInfo.name = template;
                        }
                    };
                    dialogService.open("eventTemplateFormPopUp", "eventTemplateForm", templateModel, {title: getMSG('Select_Title')});
                };
                //Store task
                $scope.saveTask = function() {
                    var task_list_id = $scope.formInfo.taskListId;
                    var type = $scope.formInfo.taskListType === 300 ? 300 : 1;
                    var create_date = new Date().getTime(), complete_date = null, update_date = null;
                    var calendar_id = $scope.formInfo.taskListType === 300 ? task_list_id : 1;
                    var timezone = jorteConfig.TIME_ZONE;
                    var name = $scope.formInfo.name;
                    var memo = ($scope.formInfo.content) ? $scope.formInfo.content : null;
                    var importance = ($scope.formInfo.important) ? 1 : 0;
                    var completed = ($scope.formInfo.completed) ? 1 : 0;
                    var start_date_obj = $scope.formInfo.start_date? $scope.formInfo.start_date : '----/--/--';
                    var due_date_obj = $scope.formInfo.end_date? $scope.formInfo.end_date : '----/--/--';
                    var start_time = $scope.formInfo.start_time;
                    var end_time = $scope.formInfo.end_time;
                    var hours = 0;
                    var minutes = 0;
                    var ehours = 23;
                    var eminutes = 59;
                    var start_date = null;
                    var sTime = null;
                    var due_date = null;
                    var eTime = null;
                    name = (name) ? name.replace(/^\s\s*/, '').replace(/\s\s*$/, '') : null;
                    if (start_time !== '--:--') {
                        hours = start_time.substring(0, 2);
                        minutes = start_time.substring(3, 5);
                        sTime = 60 * parseInt(hours) + parseInt(minutes);
                    }
                    if (start_date_obj !== '----/--/--') {
                        var sdate = new Date(start_date_obj.getFullYear(), start_date_obj.getMonth(), start_date_obj.getDate(), hours, minutes, 0);
                        start_date = sdate.getTime();
                    }

                    if (end_time !== '--:--') {
                        ehours = end_time.substring(0, 2);
                        eminutes = end_time.substring(3, 5);
                        eTime = 60 * parseInt(ehours) + parseInt(eminutes);
                    }

                    if (due_date_obj !== '----/--/--') {
                        var edate = new Date(due_date_obj.getFullYear(), due_date_obj.getMonth(), due_date_obj.getDate(), ehours, eminutes, 0);
                        due_date = edate.getTime();
                    }

                    if (completed === 1) {
                        complete_date = new Date().getTime();
                    }
                    var beginDates = [], reminderList = [];
                    if (due_date) {
                        if (!start_date) {
                            beginDates.push(due_date);
                        } else {
                            beginDates.push(start_date);
                        }
                        for (var i = 0; i < remList.length; i++) {
                            var rem = remList[i];
                            var reminder = {};
                            reminder.id = rem['id'];
                            reminder.minutes = parseInt(rem['minutes']), reminder.type = parseInt(rem['type']);
                            reminder.beginDates = beginDates;
                            reminderList.push(reminder);
                        }
                    }
                    var task = new TaskJorte();
                    task.calendar_id = parseInt(calendar_id), task.task_list_id = parseInt(task_list_id), task.name = name, task.memo = memo, task.start_date = start_date,
                            task.due_date = due_date, task.start_time = sTime, task.due_time = eTime, task.type = type, task.timezone = timezone,
                            task.status = 1, task.completed = completed, task.importance = importance, task.complete_date = complete_date,
                            task.create_date = create_date, task.update_date = update_date, task.reminders = reminderList;
                    var tm;
                    if (name) {
                        tm = new TemplateJorte();
                        tm.event_name = name, tm.flag = 1, tm.create_date = create_date, tm.update_date = update_date, tm.type = 1;
                    }
                    var data = {
                        task: task,
                        due_date_obj: due_date_obj,
                        start_date: start_date,
                        due_date: due_date
                    };
                    taskSvc.saveTaskDetails(data, function(taskId) {
                        if (tm) {
                            templateSvc.createUniqueHistory(tm, function() {
                            });
                        }
                        data.task_id = taskId;
                        $rootScope.$broadcast('taskAdded', data);
                        var params = {id: taskId, task_list_id: task_list_id, task_list_type: $scope.formInfo.taskListType};
                        if ($scope.formInfo.taskListType !== 300) {
                            params.jorteTaskList = true;
                        } else {
                            params.googleTaskList = true;
                        }

                        if ($scope.formInfo.tlist_global_id) {
                            syncSvc.syncSingleTask(params, function() {
                            });
                        }
                        dialogService.close('taskCreatePopup');
                    });
                };
                // Add new
                $scope.formInfo.reminder.add = function() {
                    if (remList.length < 5) {
                        remList.push({id: new Date().getTime(), rem_id: null, type: defaultReminder, minutes: defaultReminder, label: jorteUtils.getReminderText(parseInt(defaultReminder))});
                    }
                };
                // Remove
                $scope.formInfo.reminder.remove = function(pos) {
                    remList.splice(pos, 1);
                };
                $scope.showReminderPopup = function(val, pos) {
                    // The data for the dialog
                    var reminderModel = {
                        remPos: pos,
                        remVal: val,
                        reminderVal: function(val, pos) {
                            remList.splice(pos, 1, {id: new Date().getTime(), rem_id: null, type: val, minutes: val, label: jorteUtils.getReminderText(parseInt(val))});
                        }
                    };
                    dialogService.open('reminderPopup', 'reminder', reminderModel, {refreshPopup: true, title: getMSG('SelectHead')});
                };
                //Close popup
                $scope.closePopup = function() {
                    var r = confirm(getMSG('ExitSaveHead'));
                    if (r === true) {
                        dialogService.close('taskCreatePopup');
                    }
                };
                $scope.swapEvent = function() {
                    // The data for the dialog
                    var swapModel = {
                        val: 2,
                        name: $scope.formInfo.name,
                        startDate: $scope.formInfo.start_date,
                        endDate: $scope.formInfo.end_date,
                        startTime: $scope.formInfo.start_time,
                        endTime: $scope.formInfo.end_time,
                        content: $scope.formInfo.content
                    };
                    dialogService.open('swapEventPopup', 'swapEvent', swapModel, {title: getMSG('SelectHead')});
                };
                $scope.onShowTimeClick = function(type) {
                    var time = null;
                    if (type === 1) {
                        time = $scope.formInfo.start_time;
                    } else if (type === 2) {
                        time = $scope.formInfo.end_time;
                    }
                    if (!time) {
                        return;
                    }

                    time = time.replace(':', '');
                    var modelData = {
                        currTime: time,
                        onSet: function(newTime) {
                            dialogService.close("timeSelectPopup");
                            if (type === 1) {
                                $scope.formInfo.start_time = newTime;
                                if ($scope.formInfo.start_time === $scope.formInfo.end_date) {
                                    if ($scope.formInfo.end_time !== '--:--' && newTime > $scope.formInfo.end_time) {
                                        $scope.formInfo.end_time = newTime;
                                    }
                                }
                            } else if (type === 2) {
                                $scope.formInfo.end_time = newTime;
                                if ($scope.formInfo.start_date === $scope.formInfo.end_date) {
                                    if ($scope.formInfo.start_time !== '--:--' && newTime !== '--:--' && newTime < $scope.formInfo.start_time) {
                                        $scope.formInfo.start_time = newTime;
                                    }
                                }
                            }
                        }
                    };
                    dialogService.open("timeSelectPopup", "timeSelectPopup", modelData, {title: getMSG('SetTimeHead'), width: '70%'});
                };
                $scope.onShowDateClick = function(type) {
                    var date = null;
                    if (type === 1) {
                        date = ($scope.formInfo.start_date !== '----/--/--') ? $scope.formInfo.start_date : null;
                    } else if (type === 2) {
                        date = ($scope.formInfo.end_date !== '----/--/--') ? $scope.formInfo.end_date : null;
                    }
                    if (!date) {
                        date = new Date();
                    }
                    $scope.formInfo.remindershow = true;
                    if (remList.length === 0 && jorteConfig.getDefaultReminder() !== 'None') {
                        remList.push({id: new Date().getTime(), rem_id: null, type: defaultReminder, minutes: defaultReminder, label: jorteUtils.getReminderText(parseInt(defaultReminder))});
                    }
                    $scope.formInfo.reminder.list = remList;
                    var modelData = {
                        currDate: date,
                        clear: true,
                        onSet: function(newDate) {
                            dialogService.close("dateSelectPopup");
                            if (type === 1) {
                                $scope.formInfo.start_date = newDate;
                                $scope.formInfo.start_date_disp = (newDate) ? jorteUtils.formatDate(new Date(newDate), getMSG('TaskDate'), cal_string) : '----/--/--';
                                if (newDate > $scope.formInfo.end_date) {
                                    $scope.formInfo.end_date = newDate;
                                    $scope.formInfo.end_date_disp = (newDate) ? jorteUtils.formatDate(new Date(newDate), getMSG('TaskDate'), cal_string) : '----/--/--';
                                }
                                if ($scope.formInfo.start_date === $scope.formInfo.end_date) {
                                    if ($scope.formInfo.end_time !== '--:--' && $scope.formInfo.start_time > $scope.formInfo.end_time) {
                                        $scope.formInfo.end_time = $scope.formInfo.start_time;
                                    }
                                }
                            } else if (type === 2) {
                                $scope.formInfo.end_date = newDate;
                                $scope.formInfo.end_date_disp = (newDate) ? jorteUtils.formatDate(new Date(newDate), getMSG('TaskDate'), cal_string) : '----/--/--';
                                if ($scope.formInfo.start_date > newDate) {
                                    $scope.formInfo.start_date = newDate;
                                    $scope.formInfo.start_date_disp = (newDate) ? jorteUtils.formatDate(new Date(newDate), getMSG('TaskDate'), cal_string) : '----/--/--';
                                }
                                if ($scope.formInfo.start_date === $scope.formInfo.end_date) {
                                    if ($scope.formInfo.start_time !== '--:--' && $scope.formInfo.end_time < $scope.formInfo.start_time) {
                                        $scope.formInfo.start_time = $scope.formInfo.end_time;
                                    }
                                }
                            }
                        }
                    };
                    var titleDate = jorteUtils.formatDate(date, getMSG('TaskDate'), cal_string);
                    dialogService.open("dateSelectPopup", "dateSelectPopup", modelData, {title: titleDate});
                };
            }])

        //Task list controller
        .controller('myTaskListCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                // The data for the dialog
                $scope.taskList = $scope.model.taskList;
                $scope.taskListId = $scope.model.taskListId;
                $scope.selectTaskList = function(id, name) {
                    $scope.model.taskListIdCb(id, name);
                    dialogService.close('myTaskListPopup');
                };
            }]);