'use strict';

/**
 * Jorte task edit controller
 * 
 */
angular.module('controllers.taskEdit', [])

        //Update task controller
        .controller('taskEditCtrl', ['$rootScope', '$scope', 'taskSvc', 'syncSvc', 'dialogService',
            function($rootScope, $scope, taskSvc, syncSvc, dialogService) {
                var task = $scope.model.data.details[0];
                var remList = [];
                var defaultReminder = (jorteConfig.getDefaultReminder() === 'None') ? 10 : jorteConfig.getDefaultReminder();
                $scope.reminder = {};
                for (var i = 0; i < task.reminders.length; i++) {
                    var rem = task.reminders[i];
                    remList.push({id: new Date().getTime(), rem_id: null, type: rem.type, minutes: rem.minutes, label: jorteUtils.getReminderText(parseInt(rem.type))});
                }
                $scope.reminder.list = remList;

                if (task.start_time || task.start_time === 0) {
                    var reminder;
                    var start_time = null;
                    start_time = parseInt(task.start_time / 60);
                    if (start_time < 10) {
                        start_time = "0" + start_time;
                    }
                    reminder = parseInt((task.start_time % 60));
                    reminder < 10 ? start_time += ":0" + reminder : start_time += ":" + reminder;
                }

                if (task.due_time || task.due_time === 0) {
                    var reminder;
                    var end_time = null;
                    end_time = parseInt(task.due_time / 60);
                    if (end_time < 10) {
                        end_time = "0" + end_time;
                    }
                    reminder = parseInt((task.due_time % 60));
                    reminder < 10 ? end_time += ":0" + reminder : end_time += ":" + reminder;
                }

                $scope.formInfo = {
                    name: task.name,
                    important: task.importance,
                    completed: task.completed,
                    start_date: (task.start_date) ? new Date(task.start_date) : '----/--/--',
                    start_date_disp: (task.start_date) ? jorteUtils.formatDate(new Date(task.start_date), getMSG('TaskDate'), cal_string) : '----/--/--',
                    end_date: (task.due_date) ? new Date(task.due_date) : '----/--/--',
                    end_date_disp: (task.due_date) ? jorteUtils.formatDate(new Date(task.due_date), getMSG('TaskDate'), cal_string) : '----/--/--',
                    start_time: (start_time) ? start_time : '--:--',
                    end_time: (end_time) ? end_time : '--:--',
                    content: (task.memo) ? (task.memo) : null,
                    taskListId: task.task_list_id,
                    taskListName: (task.task_list_name) ? task.task_list_name : getMSG('MyTaskListHead'),
                    taskListType: task.task_list_type,
                    sync_status: task.sync_status,
                    tlist_global_id: task.global_id,
                    remindershow: (task.due_date) ? true : false,
                    phContent: getMSG('ContentHead')
                };

                taskSvc.getAllSelectedTaskLists(function(data) {
                    if (data.length > 1) {
                        $scope.formInfo.showTaskList = true;
                    }

                    if (data.length > 0) {
                        $scope.formInfo.taskList = data;
                    } else {
                        alert(getMSG('TaskListIsNotAvailableHead'));
                        dialogService.close("taskEditPopup");
                    }
                    $scope.formInfo.showTaskList = (data.length > 1) ? true : false,
                            $scope.$apply();
                });

                function findTaskList(id) {
                    var task_list = $scope.formInfo.taskList;
                    var taskList;
                    for (var i = 0, item = null; i < task_list.length; i++) {
                        item = task_list[i];
                        if (item.id === id) {
                            taskList = item;
                            break;
                        }
                    }
                    return taskList;
                }

                //show event template
                $scope.eventTemplate = function() {
                    var templateModel = {
                        type: 1,
                        selectedTemplate: function(template) {
                            $scope.formInfo.name = template;
                        }
                    };
                    dialogService.open("eventTemplateFormPopUp", "eventTemplateForm", templateModel, {title: getMSG('Select_Title')});
                };

                $scope.showMyTaskList = function() {
                    var taskListModel = {
                        taskList: angular.copy($scope.formInfo.taskList),
                        taskListId: $scope.formInfo.taskListId,
                        taskListIdCb: function(taskListId, name) {
                            $scope.formInfo.taskListId = taskListId;
                            $scope.formInfo.taskListName = name;
                            var taskList = findTaskList(taskListId);
                            $scope.formInfo.taskListType = taskList.type;
                            $scope.formInfo.sync_status = taskList.sync_status;
                            $scope.formInfo.tlist_global_id = taskList.global_id;
                        }
                    };
                    dialogService.open("myTaskListPopup", "myTaskList", taskListModel, {title: getMSG('SelectHead')});
                };
                //Close popup
                $scope.closePopup = function() {
                    var r = confirm(getMSG('ExitSaveHead'));
                    if (r === true) {
                        dialogService.close('taskEditPopup');
                    }
                };
                //Update tasks
                $scope.updateTask = function() {
                    var task_list_id = $scope.formInfo.taskListId;
                    var type = $scope.formInfo.taskListType === 300 ? 300 : 1;
                    var complete_date = null, update_date = null;
                    var calendar_id = $scope.formInfo.taskListType === 300 ? task_list_id : 1;
                    var timezone = jorteConfig.TIME_ZONE;
                    var name = $scope.formInfo.name;
                    var memo = ($scope.formInfo.content) ? $scope.formInfo.content : null;
                    var importance = ($scope.formInfo.important) ? 1 : 0;
                    var completed = ($scope.formInfo.completed) ? 1 : 0;
                    var start_date_obj = $scope.formInfo.start_date? $scope.formInfo.start_date : '----/--/--';
                    var due_date_obj = $scope.formInfo.end_date? $scope.formInfo.end_date : '----/--/--';
                    var start_time = $scope.formInfo.start_time;
                    var end_time = $scope.formInfo.end_time;

                    var hours = 0;
                    var minutes = 0;
                    var ehours = 23;
                    var eminutes = 59;
                    var start_date = null;
                    var sTime = null;
                    var due_date = null;
                    var eTime = null;

                    name = (name) ? name.replace(/^\s\s*/, '').replace(/\s\s*$/, '') : null;

                    if (start_time !== '--:--') {
                        hours = start_time.substring(0, 2);
                        minutes = start_time.substring(3, 5);
                        sTime = 60 * parseInt(hours) + parseInt(minutes);
                    }

                    if (start_date_obj !== '----/--/--') {
                        var sdate = new Date(start_date_obj.getFullYear(), start_date_obj.getMonth(), start_date_obj.getDate(), hours, minutes, 0);
                        start_date = sdate.getTime();
                    }

                    if (end_time !== '--:--') {
                        ehours = end_time.substring(0, 2);
                        eminutes = end_time.substring(3, 5);
                        eTime = 60 * parseInt(ehours) + parseInt(eminutes);
                    }

                    if (due_date_obj !== '----/--/--') {
                        var edate = new Date(due_date_obj.getFullYear(), due_date_obj.getMonth(), due_date_obj.getDate(), ehours, eminutes, 0);
                        due_date = edate.getTime();
                    }

                    if (completed === 1) {
                        complete_date = new Date().getTime();
                    }
                    var beginDates = [], reminderList = [];

                    if (due_date) {
                        if (!start_date) {
                            beginDates.push(due_date);
                        } else {
                            beginDates.push(start_date);
                        }

                        for (var i = 0; i < remList.length; i++) {
                            var rem = remList[i];
                            var reminder = {};
                            reminder.id = rem['id'];
                            reminder.minutes = parseInt(rem['minutes']), reminder.type = parseInt(rem['type']);
                            reminder.beginDates = beginDates;
                            reminderList.push(reminder);
                        }
                    }
                    var data = {
                        task_id: task.id,
                        calendar_id: calendar_id,
                        task_list_id: task_list_id,
                        name: name,
                        memo: memo,
                        start_date: start_date,
                        due_date: due_date,
                        startTime: sTime,
                        dueTime: eTime,
                        type: type,
                        timezone: timezone,
                        status: 1,
                        completed: completed,
                        importance: importance,
                        complete_date: complete_date,
                        update_date: update_date,
                        due_date_obj: due_date_obj,
                        reminders: reminderList
                    };
                    taskSvc.updateTaskDetails(data, function() {
                        $rootScope.$broadcast('taskUpdated', data);
                        dialogService.close("taskEditPopup");
                        var params = {id: task.id, task_list_id: task_list_id, task_list_type: $scope.formInfo.taskListType};

                        if ($scope.formInfo.taskListType !== 300) {
                            params.jorteTaskList = true;
                        } else {
                            params.googleTaskList = true;
                        }
                        if ($scope.formInfo.tlist_global_id) {
                            syncSvc.syncSingleTask(params, function() {
                            });
                        }
                    });
                };

                // Add new
                $scope.reminder.add = function() {
                    if (remList.length < 5) {
                        remList.push({id: new Date().getTime(), rem_id: null, type: defaultReminder, minutes: defaultReminder, label: jorteUtils.getReminderText(parseInt(defaultReminder))});
                    }
                };

                // Remove
                $scope.reminder.remove = function(pos) {
                    remList.splice(pos, 1);
                };

                $scope.showReminderPopup = function(val, pos) {
                    // The data for the dialog
                    var reminderModel = {
                        remPos: pos,
                        remVal: val,
                        reminderVal: function(val, pos) {
                            remList.splice(pos, 1, {id: new Date().getTime(), rem_id: null, type: val, minutes: val, label: jorteUtils.getReminderText(parseInt(val))});
                        }
                    };
                    dialogService.open("reminderPopup", "reminder", reminderModel, {refreshPopup: true, title: getMSG('SelectHead')});
                };
                
                $scope.onShowTimeClick = function(type) {
                    var time = null;
                    if (type === 1) {
                        time = $scope.formInfo.start_time;
                    } else if (type === 2) {
                        time = $scope.formInfo.end_time;
                    }
                    if (!time) {
                        return;
                    }

                    time = time.replace(':', '');
                    var modelData = {
                        currTime: time,
                        onSet: function(newTime) {
                            dialogService.close("timeSelectPopup");
                            if (type === 1) {
                                $scope.formInfo.start_time = newTime;
                                if ($scope.formInfo.start_date === $scope.formInfo.end_date) {
                                    if ($scope.formInfo.end_time !== '--:--' && newTime > $scope.formInfo.end_time) {
                                        $scope.formInfo.end_time = newTime;
                                    }
                                }
                            } else if (type === 2) {
                                $scope.formInfo.end_time = newTime;
                                if ($scope.formInfo.start_date === $scope.formInfo.end_date) {
                                    if ($scope.formInfo.start_time !== '--:--' && newTime !== '--:--' && newTime < $scope.formInfo.start_time) {
                                        $scope.formInfo.start_time = newTime;
                                    }
                                }
                            }
                        }
                    };
                    dialogService.open("timeSelectPopup", "timeSelectPopup", modelData, {title: getMSG('SetTimeHead'), width:'70%'});
                };
                $scope.onShowDateClick = function(type) {
                    var date = null;
                    if (type === 1) {
                        date = ($scope.formInfo.start_date !== '----/--/--') ? $scope.formInfo.start_date : null;
                    } else if (type === 2) {
                        date = ($scope.formInfo.end_date !== '----/--/--') ? $scope.formInfo.end_date : null;
                    }
                    if (!date) {
                        date = new Date();
                    }
                    $scope.formInfo.remindershow = true;
                    //Show if there is only due date
                    if (remList.length === 0 && jorteConfig.getDefaultReminder() !== 'None') {
                        // Init rem button
                        remList.push({id: new Date().getTime(), rem_id: null, type: defaultReminder, minutes: defaultReminder, label: jorteUtils.getReminderText(parseInt(defaultReminder))});
                        $scope.reminder.list = remList;
                    }

                    var modelData = {
                        currDate: date,
                        clear: true,
                        onSet: function(newDate) {
                            dialogService.close("dateSelectPopup");
                            if (type === 1) {
                                $scope.formInfo.start_date = newDate;
                                $scope.formInfo.start_date_disp = (newDate) ? jorteUtils.formatDate(new Date(newDate), getMSG('TaskDate'), cal_string) : '----/--/--';
                                if (newDate > $scope.formInfo.end_date) {
                                    $scope.formInfo.end_date = newDate;
                                    $scope.formInfo.end_date_disp = (newDate) ? jorteUtils.formatDate(new Date(newDate), getMSG('TaskDate'), cal_string) : '----/--/--';
                                }
                                if ($scope.formInfo.start_date === $scope.formInfo.end_date) {
                                    if ($scope.formInfo.end_time !== '--:--' && $scope.formInfo.start_time > $scope.formInfo.end_time) {
                                        $scope.formInfo.end_time = $scope.formInfo.start_time;
                                    }
                                }
                            } else if (type === 2) {
                                $scope.formInfo.end_date = newDate;
                                $scope.formInfo.end_date_disp = (newDate) ? jorteUtils.formatDate(new Date(newDate), getMSG('TaskDate'), cal_string) : '----/--/--';
                                if ($scope.formInfo.start_date > newDate) {
                                    $scope.formInfo.start_date = newDate;
                                    $scope.formInfo.start_date_disp = (newDate) ? jorteUtils.formatDate(new Date(newDate), getMSG('TaskDate'), cal_string) : '----/--/--';
                                }
                                if ($scope.formInfo.start_date === $scope.formInfo.end_date) {
                                    if ($scope.formInfo.start_time !== '--:--' && $scope.formInfo.end_time < $scope.formInfo.start_time) {
                                        $scope.formInfo.start_time = $scope.formInfo.end_time;
                                    }
                                }
                            }

                        }
                    };
                    var titleDate = jorteUtils.formatDate(date, getMSG('TaskDate'), cal_string);
                    dialogService.open("dateSelectPopup", "dateSelectPopup", modelData, {title: titleDate});
                };

                $scope.onItemDelete = function() {
                    if ($scope.model.deleteClickCb && $scope.model.deleteClickCb()) {
                        dialogService.close('taskEditPopup');
                    }
                };
            }]);