'use strict';

/**
 * Jorte taskList controller
 * 
 */
angular.module('controllers.taskList', [])

        // taskList controller
        .controller('taskListCtrl', ['$scope', 'taskSvc', 'dialogService', function($scope, taskSvc, dialogService) {

                var localResult = [];
                $scope.taskList = [];
                $scope.jorteTasklistCount = 0;

                $scope.showTaskList = function() {
                    taskSvc.getAllTaskLists(function(list) {
                        localResult = list;
                        var jorteTasklistCount = 0;
                        for (var i = 0; i < localResult.length; i++) {
                            var locTl = localResult[i];
                            if (locTl.type === 1) {
                                jorteTasklistCount++;
                            }
                        }
                        $scope.jorteTasklistCount = jorteTasklistCount;
                        $scope.chk = true;
                        $scope.taskList = processTaskListResult(list);
                        $scope.$apply();
                        dialogService.refresh('taskListPopup');
                    });
                };
                function processTaskListResult(lists) {
                    var taskLists = [];
                    for (var i = 0; i < lists.length; i++) {
                        var tlItem = {};
                        var t = lists[i];
                        tlItem.id = t.id;
                        tlItem.name = t.name;
                        tlItem.selected = t.selected === 1;
                        tlItem.color = jorteUtils.htmlEscape(t.color);
                        taskLists.push(tlItem);
                    }
                    return taskLists;
                }

                $scope.onItemColorClick = function(id) {
                    var curItem = {};
                    for (var i = 0; i < localResult.length; i++) {
                        if (localResult[i].id === id) {
                            curItem = localResult[i];
                            break;
                        }
                    }
                    var colorModel = {
                        colorCode: curItem.color ? curItem.color : '',
                        selectedColor: function(color) {
                            taskSvc.updateTaskListColor(id, color, function() {
                                curItem.color = color;
                                $scope.taskList = processTaskListResult(localResult);
                                $scope.$apply();
                            });
                        }
                    };
                    dialogService.open('colorPickerPopup', 'colorPicker', colorModel, {title: getMSG('SelectColorHead')});
                };

                $scope.swapSelection = function(id, status) {
                    status = status ? 1 : 0;
                    taskSvc.swapTaskListSelection(id, status, function() {
                        for (var i = 0; i < localResult.length; i++) {
                            var locTl = localResult[i];
                            if (locTl.id === id) {
                                locTl.selected = status;
                            }
                        }
                        $scope.taskList = processTaskListResult(localResult);
                        $scope.$apply();
                    });
                };

                $scope.showCreateTaskListPopup = function() {
                    var modelData = {
                        totalTaskLists: $scope.jorteTasklistCount
                    };
                    dialogService.open("taskListCreatePopup", "taskListCreatePopup", modelData, {title: getMSG('CreateANewTaskListHead'), refreshPopup: true});
                };

                $scope.closeTaskListPopup = function() {
                    dialogService.close("taskListPopup", "taskListPopup");
                };

                $scope.taskListDetailPopup = function(id) {
                    dialogService.open("taskListDetailPopup", "taskListDetailPopup", {taskListId: id}, {title: getMSG('TaskListDetailsHead')});
                };

                $scope.$on('taskListCreated', function(evt, changedItem) {
                    $scope.showTaskList();
                });

                $scope.$on('taskListUpdated', function(evt, updatedItem) {
                    $scope.showTaskList();
                });

                $scope.$on('syncTaskCompleted', function(evt, changedItem) {
                    $scope.showTaskList();
                });
                $scope.$on('taskListDeleted', function(evt, deletedId) {
                    $scope.showTaskList();
                });

                $scope.showTaskList();
            }])
        .controller('taskListCreateCtrl', ['$rootScope', '$scope', 'taskSvc', 'syncSvc', 'dialogService',
            function($rootScope, $scope, taskSvc, syncSvc, dialogService) {
                var taskListModel = $scope.model;
                var jorteAccount = jorteConfig.getJorteSync();
                $scope.jorte_id = (jorteAccount) ? jorteAccount.jorteId : null;
                $scope.taskListModel = {
                    name: '',
                    content: '',
                    syncCloud: false
                };
                $scope.onEdit = false;
                $scope.deletable = true;
                
                var taskEditDetail = $scope.model.taskEditDetail;
                if (taskEditDetail) {
                    $scope.taskListModel = taskEditDetail;
                    $scope.onEdit = true;
                    if (taskEditDetail.id === 1 || taskEditDetail.type === 300) {
                        $scope.deletable = false;
                    }
                }

                $scope.initData = function() {
                    if ($scope.onEdit) {
                        $scope.$apply();
                    }
                };
                $scope.synced = function() {
                    setTimeout(function() {
                        dialogService.refresh('taskListCreatePopup');
                    }, 0);
                };
                $scope.selectAccount = function() {
                    if (!jorteAccount) {
                        alert(getMSG('ErrorJorteAccountNothing'));
                        return;
                    }
                    dialogService.open("selectAccountPopup", "selectAccountPopup", {jorteId: jorteAccount.jorteId}, {title: getMSG('CreateANewTaskListHead')});
                };
                $scope.saveTaskList = function() {
                    if (!$scope.taskListModel.name) {
                        alert(getMSG('ContentOneTaskListHead'));
                        return;
                    }
                    if (taskListModel.totalTaskLists > 3) {
                        dialogService.close('taskListCreatePopup');
                        return;
                    }
                    if ($scope.taskListModel.syncCloud && !jorteAccount) {
                        alert(getMSG('ErrorNoJorteAccount'));
                        return;
                    }
                    var taskList = new TaskListJorte();
                    var date = jorteUtils.getSqlDateUTC();
                    taskList.name = $scope.taskListModel.name,
                            taskList.content = $scope.taskListModel.content,
                            taskList.selected = 0, taskList.status = 1,
                            taskList.sync_status = $scope.taskListModel.syncCloud ? 1 : 0,
                            taskList.create_date = date,
                            taskList.update_date = date, taskList.color = '#5080e8';
                    taskSvc.saveTaskList(taskList, function(tlId) {
                        taskList.id = tlId;
                        $rootScope.$broadcast('taskListCreated', taskList);
                        dialogService.close('taskListCreatePopup');
                        if (taskList.sync_status) {
                            var params = {id: taskList.id, task_list_type: 1, jorteTaskList: true};
                            syncSvc.syncSingleTaskList(params, function() {
                    });
                        }
                    });
                };
                $scope.updateTaskList = function() {
                    if (!$scope.taskListModel.name) {
                        alert(getMSG('ContentOneTaskListHead'));
                        return;
                    }
                    if ($scope.taskListModel.syncCloud && !jorteAccount) {
                        alert(getMSG('ErrorNoJorteAccount'));
                        return;
                    }
                    var data = {};
                    var date = jorteUtils.getSqlDateUTC();
                    var id = $scope.taskListModel.id;
                    var global_id = $scope.taskListModel.global_id;
                    var type = $scope.taskListModel.type;
                    data.name = $scope.taskListModel.name,
                            data.content = $scope.taskListModel.content,
                            data.syncStatus = $scope.taskListModel.syncCloud ? 1 : 0,
                            data.dirty = 1, data.date = date;
                    taskSvc.updateTaskListData(id, data, function() {
                        data.id = id;
                        $rootScope.$broadcast('taskListUpdated', data);
                        dialogService.close('taskListCreatePopup');
                        if (type !== 300 && data.syncStatus) {
                            var params = {id: id, task_list_type: 1, jorteTaskList: true};
                            syncSvc.syncSingleTaskList(params, function() {
                    });
                        }
                    });
                };
                $scope.deleteTaskList = function() {
                    if (!confirm(getMSG('ContentTwoTaskListHead'))) {
                        return;
                    }
                    var id = $scope.taskListModel.id;
                    var global_id = $scope.taskListModel.global_id;
                    var type = $scope.taskListModel.type;
                    taskSvc.deleteTaskList(id, function() {
                        $rootScope.$broadcast('taskListDeleted', id);
                        dialogService.close('taskListCreatePopup');
                        dialogService.close('taskListDetailPopup');
                        if (type !== 300 && global_id) {
                            var params = {del_global_id: global_id, task_list_type: 1, jorteTaskList: true};
                            syncSvc.syncSingleTaskList(params, function() {
                    });
                        }
                    });
                };

            }])
        .controller('taskListDetailPopupCtrl', ['$scope', 'taskSvc', 'dialogService',
            function($scope, taskSvc, dialogService) {

                var taskListId = $scope.model.taskListId;
                $scope.showDetail = function() {
                    taskSvc.getTaskList(taskListId, function(item) {
                        $scope.taskDetail = processDetail(item);
                        $scope.$apply();
                    });
                };
                function processDetail(item) {
                    var renderDetail = {};
                    renderDetail.itemName = item.name;
                    renderDetail.localOnlyHeadLabel = (item.sync_status && jorteConfig.getJorteSync() && item.type !== 300) ? getMSG('TaskJorteCloud') : (item.sync_status && item.type === 300) ? getMSG('GoogleTask') : getMSG('LocalOnlyHead');
                    renderDetail.itemContent = item.content || '';
                    renderDetail.timezone = '';
                    renderDetail.syncStatus = (item.sync_status && jorteConfig.getJorteSync() && item.type !== 300)||(item.sync_status && item.type === 300) ? getMSG('SynchronizedHead') : getMSG('NotSynchronizedHead');
                    renderDetail.itemId = item.id;
                    renderDetail.itemType = item.type;
                    return renderDetail;
                }

                $scope.editTaskListPopup = function() {
                    var jorte_id = (jorteConfig.getJorteSync()) ? jorteConfig.getJorteSync().jorteId : null;
                    taskSvc.getTaskList($scope.taskDetail.itemId, function(taskList) {
                        var modelData = {
                            taskEditDetail: {
                                id: taskList.id,
                                name: taskList.name,
                                content: taskList.content,
                                syncCloud: (taskList.sync_status && jorte_id) ? true : false,
                                global_id: taskList.global_id,
                                type: taskList.type
                            }
                        };
                        dialogService.open("taskListCreatePopup", "taskListCreatePopup", modelData, {title: getMSG('CreateANewTaskListHead'), refreshPopup: true});
                    });
                };

                $scope.$on('taskListUpdated', function(evt, updatedItem) {
                    $scope.showDetail();
                });

                $scope.taskDetail = {};
                $scope.closeDetailPopup = function() {
                    dialogService.close('taskListDetailPopup');
                };

                $scope.showDetail();
            }])
        .controller('selectAccountCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.jorte_id = $scope.model.jorteId;
                $scope.selectAccount = function() {
                    dialogService.close('selectAccountPopup');
                };
            }]);