'use strict';

/**
 * Jorte controllers
 * 
 */
angular.module('controllers.taskAndMemo', [])

        // task and memo page
        .controller('taskAndMemoCtrl', ['$rootScope', '$scope', 'mainSvc', 'taskSvc', 'syncSvc', '$location', '$route', 'dialogService',
            function ($rootScope, $scope, mainSvc, taskSvc, syncSvc, $location, $route, dialogService) {
                var dbResult = {tasks: [], tlCount: 1, tlName: ''};
                function taskAndMemos(dbResult) {
                    var v = processTasksData(dbResult);
                    $scope.renderList = v.renderList;
                    $scope.taskListTitle = v.title;
                    $scope.$apply();
                }
                function taskFetchPagination(resultList, afterShowCB) {
                    dbResult = {tasks: [], tlCount: 1, tlName: ''};
                    dbResult.tlCount = resultList.length;
                    function pagination(task_list_id, is_advance, taskCount, callBack) {
                        mainSvc.getTaskListDetails(task_list_id, is_advance, taskCount, function (result) {
                            if (result && result.length > 0) {
                                for (var j = 0; j < result.length; j++) {
                                    dbResult.tasks.push(result[j]);
                                }
                                taskCount += result.length;
                                jorteUtils.sortById(dbResult.tasks);
                                taskAndMemos(dbResult);
                            }
                            callBack && callBack(taskCount);
                        });
                    }

                    function nextTaskListData(i, taskCount, is_advance) {
                        if (i >= resultList.length) {
                            jorteUtils.sortById(dbResult.tasks);
                            taskAndMemos(dbResult);
                            afterShowCB && afterShowCB();
                            return;
                        }
                        var obj = resultList[i];
                        var task_list_id = obj.id, task_count = obj.count;
                        if (resultList.length === 1) {
                            dbResult.tlName = obj.tlName;
                        }
                        if (!$rootScope.sortRunning && $rootScope.taskFetchRunning  && !$rootScope.syncRunning && $location.path()==="/taskMemo") {
                            setTimeout(function () {
                                pagination(task_list_id, is_advance, taskCount, function (count) {
                                    if (count < task_count) {
                                        taskCount = count;
                                        nextTaskListData(i, taskCount, true);
                                    } else {
                                        taskCount = 0;
                                        nextTaskListData(++i, taskCount, false);
                                    }
                                });
                            }, 10);
                        }else{
                            $rootScope.taskFetchRunning = false;
                            return;
                        }
                    }
                    nextTaskListData(0, 0, false);
                }
                function processTasksData(dbResult) {
                    var tasks = dbResult.tasks, taskListcount = dbResult.tlCount, tlName = dbResult.tlName;
                    var renderList = [];
                    var taskListTitle = getMSG('TasksandMemosHead');
                    if (taskListcount === 1) {
                        taskListTitle = tlName ? tlName : '';
                    }
                    var taskCls = '', taskComplCls = '', taskName = '', itemIndex = 0;

                    for (var i = 0, item = null; i < tasks.length; i++) {
                        var startDate, endDate = '', start_time = '', end_time = '', taskListName = '';
                        item = tasks[i];
                        if (item.completed === 0 || (item.completed === 1 && !jorteConfig.getHideCompletedTask())) {
                            startDate = (item.start_date) ? jorteUtils.formatDate(new Date(item.start_date), getMSG('TaskPageDateFormat'), cal_string) : '';
                            if (item.start_time !== null) {
                                start_time = jorteUtils.parseMinutes(item.start_time);
                            }
                            endDate = (item.due_date) ? jorteUtils.formatDate(new Date(item.due_date), getMSG('TaskPageDateFormat'), cal_string) : '';
                            if (item.due_time !== null) {
                                end_time = jorteUtils.parseMinutes(item.due_time);
                            }

                            var color = item.task_color ? item.task_color : jorteConfig.COLORS.taskDefault;
                            color = item.importance ? jorteConfig.COLORS.red : color;
                            color = item.completed ? jorteConfig.COLORS.completed : color;

                            taskName = item.name ? item.name : getMSG('NoSubjectHead');
                            taskListName = item.task_list_name ? item.task_list_name : '';
                            taskCls = item.importance ? 'task_red' : 'task_norm';
                            taskComplCls = item.completed ? 'task_compl' : '';

                            var renderItem = {};
                            renderItem.itemId = item.id;
                            renderItem.taskClass = taskCls;
                            renderItem.taskCompletedCls = taskComplCls;
                            renderItem.itemStartDate = item.start_date;
                            renderItem.completed = item.completed ? 1 : 0;
                            renderItem.color = color;
                            renderItem.taskName = taskName;
                            renderItem.taskListCount = taskListcount;
                            renderItem.taskListName = taskListName;
                            renderItem.startDate = startDate;
                            renderItem.startTime = start_time;
                            renderItem.endDate = endDate;
                            renderItem.endTime = end_time;
                            renderItem.itemType = 1;
                            renderItem.itemIndex = ++itemIndex;
                            renderList.push(renderItem);
                        }
                    }
                    return {'title': taskListTitle, 'renderList': renderList};
                }
                $scope.screenHt = $(window).height() - $('#task_inner').height() - $('#icon_set').height();

                $scope.syncAllTypesOfTasks = function() {
                    if (!jorteConfig.getJorteAccount() && !jorteConfig.getGoogleAccount()) {
                        $location.path('/settings/taskListSync/');
                        return;
                    }
                    syncSvc.sync({jorteCalendar: true}, function () {
                        syncSvc.sync({jorteTaskList: true}, function () {
                            syncSvc.sync({googleCalendar: true}, function () {
                                syncSvc.sync({googleTaskList: true}, function () {
                                    $rootScope.$broadcast('syncCompleted', null);
                                });
                            });
                        });
                    });
                };

                $scope.displayList = function (afterShowCB) {
                    if ($rootScope.taskFetchRunning===false) {
                        $rootScope.taskFetchRunning = true;
                        mainSvc.getSelectedTasksCount(function (resultList) {
                            taskFetchPagination(resultList, function () {
                                $rootScope.taskFetchRunning = false;
                                afterShowCB && afterShowCB();
                            });
                        });
                    }
                };

                taskSvc.getSelectedTaskLists(function(result) {
                    if (result.length === 1) {
                        $scope.taskTitle = result[0].name;
                        $scope.$apply();
                    } else {
                        $scope.taskTitle = getMSG('TasksandMemosHead');
                    }
                });

                $scope.noTaskMemoMessage = getMSG('NoTaskMemoHead');

                $scope.$on('eventTaskItemDeleted', function(evt, changedItem) {
                    for (var i = 0; i < dbResult.tasks.length; i++) {
                        var locItem = dbResult.tasks[i];
                        if (locItem.id === changedItem.itemId) {
                            dbResult.tasks.splice(i, 1);
                            i--;
                        }
                    }
                    $scope.renderList = processTasksData(dbResult).renderList;
                    $scope.$apply();
                });

                $scope.$on('eventTaskItemCompleted', function(evt, changedItem) {
                    for (var i = 0; i < dbResult.tasks.length; i++) {
                        var locItem = dbResult.tasks[i];
                        if (locItem.id === changedItem.itemId) {
                            locItem.completed = 1;
                        }
                    }
                    $scope.renderList = processTasksData(dbResult).renderList;
                    $scope.$apply();
                });

                function swapCompletedStatus(id, status) {
                    id = parseInt(id), status = parseInt(status);
                    var updateData;
                    var date = jorteUtils.getSqlDateUTC();
                    updateData = (status === 1) ? [0, null] : [1, date];
                    taskSvc.swapCompletedStatus(id, updateData, function() {
                        for (var i = 0; i < dbResult.tasks.length; i++) {
                            var locItem = dbResult.tasks[i];
                            if (locItem.id === id) {
                                locItem.completed = updateData[0];

                                var params = {id: id, task_list_id: locItem.task_list_id, task_list_type: locItem.task_list_type};
                                if (locItem.task_list_type !== 300) {
                                    params.jorteTaskList = true;
                                } else {
                                    params.googleTaskList = true;
                                }

                                if (locItem.global_id) {
                                    syncSvc.syncSingleTask(params, function() {
                                    });
                                }
                            }
                        }
                        $scope.renderList = processTasksData(dbResult).renderList;
                        $scope.$apply();
                    });
                }

                $scope.onStatusCheckClick = function(id, status) {
                    swapCompletedStatus(id, status);
                    return false;
                };

                $scope.displayList(); //start with display the list of task.

                $scope.showTaskDetails = function(itemIndex) {
                    var modelData = {itemIndex: itemIndex - 1, renderList: $scope.renderList};
                    dialogService.open('eventTaskDetailPopup', 'eventTaskDetailPopup', modelData, {title: 'Task & Memos', minHeight: 360, headerVisible: false});
                };

                $scope.showTaskListPopup = function() {
                    $rootScope.taskFetchRunning = false;
                    var options = {
                        title: getMSG('SelectListHead'),
                        refreshPopup: true,
                        close: function() {
                            $route.reload();
                        }
                    };
                    dialogService.open('taskListPopup', 'taskListPopup', null , options);
                };

                $scope.createTaskPopup = function() {
                    dialogService.open('taskCreatePopup', 'taskCreate', null, {title: getMSG('EditTasksAndMemosHead'), headerVisible: false});
                };

                $scope.taskSortPopup = function() {
                    dialogService.open('taskSortPopup', 'taskSortPopup', null, {title: getMSG('SortHead')});
                };

                $scope.closeTaskCreate = function() {
                    dialogService.close('taskCreatePopup');
                };

                $scope.$on('taskUpdated', function (evt, taskData) {
                    var timeOutDelay = dialogService.dialogs['eventTaskListPopup'] ? 300 : 10;
                    setTimeout(function () {
                        mainSvc.getSingleTaskDisplayList(taskData.task_id, function (result) {
                            for (var i = 0; i < dbResult.tasks.length; i++) {
                                if (dbResult.tasks[i].id === result.id) {
                                    dbResult.tasks[i] = result;
                                    taskAndMemos(dbResult);
                                    break;
                                }
                            }
                            try {
                                $rootScope.$broadcast('navigItemsListChanged', $scope.renderList);
                            } catch (e) {
                                console.log('broadcast navigItemsListChanged ', e);
                            }
                        });
                    }, timeOutDelay);
                });

                $scope.$on('taskSorted', function (evt, taskData) {
                    $scope.displayList();
                });

                $scope.$on('taskAdded', function (evt, taskData) {
                    var timeOutDelay = dialogService.dialogs['eventTaskListPopup'] ? 300 : 10;
                    setTimeout(function () {
                        mainSvc.getSingleTaskDisplayList(taskData.task_id, function (result) {
                            dbResult.tasks.unshift(result);
                            taskAndMemos(dbResult);
                            try {
                                $rootScope.$broadcast('navigItemsListChanged', $scope.renderList);
                            } catch (e) {
                                console.log('broadcast navigItemsListChanged ', e);
                            }
                        });
                    }, timeOutDelay);
                });
            }])
        .controller('taskSortPopupCtrl', ['$rootScope', '$scope', 'mainSvc', 'taskSvc', 'syncSvc', '$location', '$route', 'dialogService',
            function ($rootScope, $scope, mainSvc, taskSvc, syncSvc, $location, $route, dialogService) {
                function taskFetchPagination(totalCount) {
                    var localResult = [];
                    function pagination(is_advance, taskCount, callBack) {
                        mainSvc.getTasksForSort(is_advance, taskCount, function (result) {
                            if (result && result.length > 0) {
                                for (var j = 0; j < result.length; j++) {
                                    localResult.unshift(result[j]);
                                }
                                taskCount += result.length;
                            }
                            callBack && callBack(taskCount);
                        });
                    }

                    function updateSortedTasks(items, callback) {
                        var splitList = jorteUtils.splitArray(items, 500);
                        function loopSplit(i) {
                            if (i >= splitList.length) {
                                callback && callback();
                                return;
                            }
                            taskSvc.sortedTasksUpdation(splitList[i], function () {
                                setTimeout(function () {
                                    loopSplit(++i);
                                }, 10);
                            });
                        }
                        loopSplit(0);
                    }
                    function fetchAllTaskListData(i, taskCount, is_advance) {
                        var task_count = totalCount;
                        setTimeout(function () {
                            pagination(is_advance, taskCount, function (count) {
                                if (count < task_count) {
                                    taskCount = count;
                                    fetchAllTaskListData(i, taskCount, true);
                                } else {
                                    if (localResult.length > 0) {
                                        jorteUtils.sortTasks(localResult);
                                        var seqno = 0;
                                        for (var j = 0; j < localResult.length; j++) {
                                            localResult[j].seq = seqno;
                                            seqno++;
                                        }
                                        updateSortedTasks(localResult, function () {
                                            $rootScope.sortRunning = false;
                                            setTimeout(function () {
                                                $rootScope.$broadcast('taskSorted');
                                            }, 10);
                                        });
                                    }
                                }
                            });
                        }, 10);
                    }
                    fetchAllTaskListData(0, 0, false);
                }
                $scope.cancelSort = function () {
                    dialogService.close('taskSortPopup');
                };
                $scope.onSortClick = function () {
                    $rootScope.sortRunning = true;
                    mainSvc.getTasksCount(function (count) {
                        taskFetchPagination(count);
                        dialogService.close('taskSortPopup');
                    });

                };
            }]);
