'use strict';

/**
 * l10 directive
 * 
 */
angular.module('directives.l10n', [])

        /**
         * Directive to translate string according to lang
         */
        .directive('ngL10nId', function() {
            return function(scope, element, attr) {
                if (!attr.ngL10nId) {
                    return;
                }
                var transString = getMSG(attr.ngL10nId);
                if (element.is("input")) {
                    element.val(transString);
                } else {
                    element.text(transString);
                }
            };
        });
