'use strict';

/**
 * scroll end directive
 * 
 */
angular.module('directives.whenScrolled', [])

        /**
         * Directive to invoke a method on scroll end
         */

        .directive('whenScrolled', function() {

            return function(scope, elm, attr) {
                var raw = elm[0];
                elm.bind('scroll', function() {
                    if (raw.scrollTop + raw.offsetHeight >= raw.scrollHeight) {
                        scope.$apply(attr.whenScrolled);
                    }
                });
            };
        });

