'use strict';
(function ($) {
    $.widget("jorte.dialog", $.ui.dialog, {
        options: {
            width: '98%',
            margin: 15,
            fullScreen: false,
            headerVisible: true,
            animationClass: ''//jpop-animation
        },
        _create: function () {
            this._super("_create");
            var o = this.options;

            if (this._ui)
                return;
            // decide if header is visible
            if (o.headerVisible === false)
                this.uiDialogTitlebar.hide();

            // Initializing UI
            var ui = {
                container: $("<div class='jpop-popup-container'></div>")
            }, self = this;

            // Define instance variables
            $.extend(this, {
                _scrollTop: 0,
                _ui: ui,
                _fallbackTransition: "",
                _currentTransition: false,
                _prereqs: null,
                _isOpen: false,
                _tolerance: null,
                _resizeData: null,
                _ignoreResizeTo: 0,
                _orientationchangeInProgress: false
            });

            $.each(o, function (key, value) {
                // Cause initial options to be applied by their handler by
                // temporarily setting the option to undefined
                // - the handler then sets it to the initial value
                self.options[key] = undefined;
                self._setOption(key, value, true);
            });

            if (!o.refreshPopup) {
                this.repos();
            }
        },
        repos: function () {
            this._autoFixContent();
        },
        _setOption: function (key, value) {
            this._super(key, value); // for 1.8 would be $.Widget.prototype._setOption.apply( this, arguments );

            if (key === "headerVisible") {
                if (value === false)
                    this.uiDialogTitlebar.hide();
                else
                    this.uiDialogTitlebar.show();
                return;
            }
        },
        _getPosition: function () {
            var wWidth = $(window).width();
            var wHeight = window.innerHeight || $(window).height();
            var pWidth = this.uiDialog.outerWidth();
            var pHeight = this.uiDialog.outerHeight();
            var wHeightFull = $(window).height() - 120;
            var cLeft = 0, cTop = 0;
            if (!this.options.fullScreen) {
                cLeft = (wWidth - pWidth) / 2;
                cLeft = cLeft >= 0 ? cLeft : this.options.margin;
                cTop = (wHeight - pHeight) / 2;
                cTop = cTop >= this.options.margin ? cTop : this.options.margin;
            }
            return {
                wWidth: wWidth,
                wHeight: wHeight,
                pWidth: pWidth,
                pHeight: pHeight,
                wHeightFull: wHeightFull,
                top: cTop,
                left: cLeft
            };
        },
        _autoFixContent: function () {
            var self = this, o = this.options;
            var sElem = self.element.find('[data-auto-height]');
            var elemCount = sElem.length, bufferHeight = 9;
            if (elemCount === 0)
                return;

            /* Resetting height */
            sElem.height('auto').addClass('jpop-auto-height');
            var pos = self._getPosition();

            if (o.fullScreen) {
                sElem.height(pos.wHeightFull).css('overflow', 'auto');
            } else {
                var pHeight = pos.pHeight;
                var wHeightFull = pos.wHeightFull;
                var sElemTotalHeight = 0;
                
                sElem.each(function (i) {                    
                    var tElem = $(this);
                    /* Getting height of all scroll elements */
                    sElemTotalHeight += tElem.height();
                });

                if (sElemTotalHeight < wHeightFull && sElemTotalHeight !== 0) {
                    sElem.height(sElemTotalHeight + bufferHeight).css('overflow', 'auto');
                } else if (pHeight > wHeightFull) {
                    sElem.height(wHeightFull).css('overflow', 'auto');
                } else {
                    sElem.height(pHeight).css('overflow', 'auto');
                }                
                this.uiDialog.css('top', pos.top);
            }
        }
    });
})(jQuery);