'use strict';

/**
 * Init Jorte App and including dependencies
 * 
 */
angular.module('jorteApp', [
    /**
     * Angular Plugins
     * 
     */
    'ngRoute',
    /**
     * Angular MVC
     * 
     */
    'jorte.config',
    'jorteApp.routes',
    'jorteApp.run',
    'jorteApp.controllers',
    'jorteApp.services',
    'jorteApp.directives'
]);

/**
 * Including controllers
 * 
 */
angular.module('jorteApp.controllers', [
    /*
     * Home page controllers
     */
    'controllers.main',
    'controllers.dayEvents',
    'controllers.mainEvents',
    'controllers.mainTasks',
    'controllers.theme',
    'controllers.mainEvtCalendar',
    'controllers.calendarSettings',
    'controllers.mainSettings',
    'controllers.viewSettings',
    'controllers.optionSettings',
    'controllers.viewEventSettings',
    'controllers.notificationSettings',
    'controllers.aboutJorte',
    /*
     * Task controllers
     */
    'controllers.taskList',
    'controllers.taskAndMemo',
    'controllers.taskCreate',
    'controllers.taskEdit',
    /*
     * Event controllers
     */
    'controllers.createEvent',
    'controllers.editEvent',
    'controllers.repeatSelect',
    'controllers.repeatForm',
    'controllers.eventSession',
    'controllers.iconList',
    'controllers.eventSwap',
    'controllers.googleTimezone',
    'controllers.eventTemplate',
    /*
     * Search
     */
    'controllers.search',
    /*
     * Event Calendar
     */
    'controllers.eventCalendar',
    /*
     * Popup customize
     */
    'controllers.customize',
    /*
     * Popup controllers
     */
    'controllers.dayEventsPopup',
    'controllers.eventTaskDetails',
    /*
     * Common controllers
     */
    'controllers.colorPicker',
    'controllers.reminder',
    'controllers.notification.notification',
    'controllers.timePicker',
    'controllers.datePicker',
    'controllers.confirmBox',
    /*
     * Provider controllers
     */
    'controllers.jorteLogin',
    'controllers.googleLogin'

]);

/**
 * Including services
 * 
 */
angular.module('jorteApp.services', [
    'dialogService',
    'services.models.jortedb',
    'services.models.main',
    'services.models.event',
    'services.models.task',
    'services.models.theme',
    'services.models.evtCalendar',
    'services.models.search',
    'services.models.reminder',
    'services.oauth.jorteAuth',
    'services.oauth.googleAuth',
    'services.models.template',
    'services.sync.sync',
    'services.sync.jorteSync',
    'services.sync.googleSync',
    'services.sync.localdbSync',
    'services.api.calendarApi',
    'services.api.holidayApi',
    'services.holiday',
    'services.models.font',
    'services.models.calendar',
    'services.rrule',
    'services.notification.notification',
    'services.notification.helper'
]);

/**
 * Including directives
 * 
 */
angular.module('jorteApp.directives', [
    'directives.l10n',
    'directives.whenScrolled'
]);

angular.element(document).ready(function() {
    jorteDB.init(function() {
        angular.bootstrap(document, ['jorteApp']);
    });
});
