/**
 * Routes
 * 
 */
angular.module('jorteApp.routes', [])

        .config(['$routeProvider', function($routeProvider) {

                $routeProvider
                        .when('/', {
                            controller: 'mainCtrl',
                            templateUrl: 'partials/main.html'
                        }).
                        when('/taskMemo', {
                            templateUrl: 'partials/task/main-task-memo.html',
                            controller: 'taskAndMemoCtrl'
                        }).
                        when('/calendar', {
                            templateUrl: 'partials/calendar-settings/calendar-settings.html',
                            controller: 'calendarSettingsCtrl'
                        }).
                        when('/settings/:mode', {
                            templateUrl: 'partials/settings/main-settings.html',
                            controller: 'mainSettingsCtrl'
                        }).
                        when('/search/:keyword?', {
                            templateUrl: 'partials/search/search-result.html',
                            controller: 'searchResultCtrl'
                        }).
                        when('/eventCalendar', {
                            templateUrl: 'partials/event-calendar/event-calendar-main.html',
                            controller: 'eventCalendarCtrl'
                        }).
                        when('/eventCalendarSearch', {
                            templateUrl: 'partials/event-calendar/event-calendar-search.html',
                            controller: 'eventCalendarSearchCtrl'
                        }).
                        when('/themeColorList', {
                            templateUrl: 'partials/customize/color-list.html',
                            controller: 'themeColorListCtrl'
                        })
                        .when('/viewEventSettings', {
                            templateUrl: 'partials/settings/view-event-settings.html',
                            controller: 'viewEventSettingsCtrl'
                        })
                        .when('/notificationSettings', {
                            templateUrl: 'partials/settings/notification-settings.html',
                            controller: 'notificationSettingsCtrl'
                        })
                        .when('/aboutJorteEn', {
                            templateUrl: 'partials/about/about_en.html',
                            controller: 'aboutCtrl'
                        })
                        .when('/aboutJorteEs', {
                            templateUrl: 'partials/about/about_es.html',
                            controller: 'aboutCtrl'
                        })
                        .when('/aboutJorteJa', {
                            templateUrl: 'partials/about/about_ja.html',
                            controller: 'aboutCtrl'
                        })
                        .otherwise({
                            controller: 'mainCtrl',
                            templateUrl: 'partials/main.html'
                        });
            }]);
