'use strict';

var jorteDB = (function () {
    var DB_NAME = 'jortedb';
    var DB_VER = 7;
    var db = null;
    var storeCreateIndex = function (objectStore, name, nameArray, options) {
        if (!objectStore.indexNames.contains(name)) {
            objectStore.createIndex(name, nameArray, options);
        }
    };
    function createIndexes(calStore, templatesStore, eventStore, taskListStore, taskStore, instanceStore, themeStore, themeContentStore, deliverCalendarsStore, deliverEventsStore, deletedCalendarsStore, deletedEventsStore, deletedTasksStore, deletedTaskListsStore, fontStore, callBack) {

        storeCreateIndex(calStore, "selected", "selected", {unique: false});
        storeCreateIndex(calStore, "type", "type", {unique: false});
        storeCreateIndex(calStore, "dirty", "dirty", {unique: false});
        storeCreateIndex(calStore, "global_id", "global_id", {unique: false});
        storeCreateIndex(calStore, "sync_events", "sync_events", {unique: false});

        storeCreateIndex(templatesStore, "flag", "flag", {unique: false});
        storeCreateIndex(templatesStore, "flag+type", ["flag", "type"], {unique: false});
        storeCreateIndex(templatesStore, "flag+type+event_name", ["flag", "type", "event_name"], {unique: false});

        storeCreateIndex(eventStore, 'calendar_id', 'calendar_id', {unique: false});
        storeCreateIndex(eventStore, "calendar_id+status", ["calendar_id", "status"], {unique: false});
        storeCreateIndex(eventStore, "global_id", "global_id", {unique: false});
        storeCreateIndex(eventStore, "calendar_id+holiday", ["calendar_id", "holiday"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+start_date+end_date+rep_flag", ["calendar_id", "start_date", "end_date", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+holiday+start_date+end_date+rep_flag", ["calendar_id", "holiday", "start_date", "end_date", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+start_date+completed+rep_flag", ["calendar_id", "start_date", "completed", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+start_date+rep_flag", ["calendar_id", "start_date", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+holiday+start_date+completed+rep_flag", ["calendar_id", "holiday", "start_date", "completed", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+holiday+start_date+rep_flag", ["calendar_id", "holiday", "start_date", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+importance+completed", ["calendar_id", "importance", "completed"], {unique: false});
        storeCreateIndex(eventStore, 'calendar_id+rep_flag', ['calendar_id', 'rep_flag'], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+holiday+completed+rep_flag", ["calendar_id", "holiday", "completed", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+holiday+rep_flag", ["calendar_id", "holiday", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+completed+rep_flag", ["calendar_id", "completed", "rep_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+long_flag", ["calendar_id", "long_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+holiday+long_flag", ["calendar_id", "holiday", "long_flag"], {unique: false});
        storeCreateIndex(eventStore, "calendar_id+deleted", ["calendar_id", "deleted"], {unique: false});
        storeCreateIndex(eventStore, "parent_global", "parent_global", {unique: false});
        storeCreateIndex(eventStore, "parent", "parent", {unique: false});
        storeCreateIndex(eventStore, "parent+originalStartDate", ["parent", "originalStartDate"], {unique: false});

        storeCreateIndex(taskListStore, "selected", "selected", {unique: false});
        storeCreateIndex(taskListStore, "sync_status+dirty", ["sync_status", "dirty"], {unique: false});
        storeCreateIndex(taskListStore, "sync_status", "sync_status", {unique: false});
        storeCreateIndex(taskListStore, "global_id", "global_id", {unique: false});
        storeCreateIndex(taskListStore, "type", "type", {unique: false});

        storeCreateIndex(taskStore, 'task_list_id', 'task_list_id', {unique: false});
        storeCreateIndex(taskStore, 'start_date', 'start_date', {unique: false});
        storeCreateIndex(taskStore, 'start_time', 'start_time', {unique: false});
        storeCreateIndex(taskStore, 'due_date', 'due_date', {unique: false});
        storeCreateIndex(taskStore, 'due_time', 'due_time', {unique: false});
        storeCreateIndex(taskStore, 'task_list_id+start_date', ['task_list_id', 'start_date'], {unique: false});
        storeCreateIndex(taskStore, 'task_list_id+due_date', ['task_list_id', 'due_date'], {unique: false});
        storeCreateIndex(taskStore, "global_id", "global_id", {unique: false});
        storeCreateIndex(taskStore, 'task_list_id+start_date+deleted+status+completed', ['task_list_id', 'start_date', 'deleted', 'status', 'completed'], {unique: false});
        storeCreateIndex(taskStore, 'task_list_id+start_date+due_date', ['task_list_id', 'start_date', 'due_date'], {unique: false});
        storeCreateIndex(taskStore, 'task_list_id+deleted', ['task_list_id', 'deleted'], {unique: false});
        storeCreateIndex(taskStore, 'deleted', ['deleted'], {unique: false});

        storeCreateIndex(instanceStore, "event_id", "event_id", {unique: false});
        storeCreateIndex(instanceStore, 'event_id+begin', ['event_id', 'begin'], {unique: false});
        storeCreateIndex(instanceStore, 'begin', 'begin', {unique: false});
        storeCreateIndex(instanceStore, 'end', 'end', {unique: false});
        storeCreateIndex(instanceStore, 'task_id', 'task_id', {unique: false});
        storeCreateIndex(instanceStore, 'event_id+begin+end', ['event_id', 'begin', 'end'], {unique: false});
        storeCreateIndex(instanceStore, 'reminder_status', 'reminder_status', {unique: false});
        storeCreateIndex(instanceStore, 'begin+end', ['begin', 'end'], {unique: false});

        storeCreateIndex(themeStore, 'parent', 'parent', {unique: false});


        storeCreateIndex(deliverCalendarsStore, "selected", "selected", {unique: false});
        storeCreateIndex(deliverCalendarsStore, "global_id", "global_id", {unique: false});

        storeCreateIndex(deliverEventsStore, "calendar_id", "calendar_id", {unique: false});
        storeCreateIndex(deliverEventsStore, "global_id", "global_id", {unique: false});
        storeCreateIndex(deliverEventsStore, "calendar_id+begin", ["calendar_id", "begin"], {unique: false});

        storeCreateIndex(deletedCalendarsStore, "global_id", "global_id", {unique: false});

        storeCreateIndex(deletedEventsStore, "global_id", "global_id", {unique: false});
        storeCreateIndex(deletedEventsStore, "parent_global", "parent_global", {unique: false});
        storeCreateIndex(deletedEventsStore, "type", "type", {unique: false});

        storeCreateIndex(deletedTasksStore, 'task_list_id', 'task_list_id', {unique: false});
        storeCreateIndex(deletedTasksStore, "global_id", "global_id", {unique: false});

        storeCreateIndex(deletedTaskListsStore, "global_id", "global_id", {unique: false});

        storeCreateIndex(fontStore, "is_selected", "is_selected", {unique: false});
        storeCreateIndex(fontStore, "font_family", "font_family", {unique: false});
        storeCreateIndex(fontStore, "global_id", "global_id", {unique: false});

        callBack && callBack();
    }
    function upgradeDB(event) {
        console.log('DB upgrade needed');

        db = event.target.result;
        var txn = event.target.transaction;
        txn.oncomplete = function (evt) {
            console.log('Upgrade complete');
        };
        txn.onerror = function (evt) {
            console.log('Upgrade failed', evt);
        };

        var calStore, templatesStore, eventStore, taskListStore, taskStore, instanceStore, themeStore, themeContentStore, deliverCalendarsStore, deliverEventsStore, deletedCalendarsStore, deletedEventsStore, deletedTasksStore, deletedTaskListsStore, fontStore;
        if (event.newVersion > event.oldVersion && event.oldVersion !== 0) {
            // Get exiting objectStore
            calStore = txn.objectStore('calendar');
            templatesStore = txn.objectStore('templates');
            eventStore = txn.objectStore('event');
            taskListStore = txn.objectStore('task_list');
            taskStore = txn.objectStore('task');
            instanceStore = txn.objectStore('event_instance');
            themeStore = txn.objectStore('theme');
            themeContentStore = txn.objectStore('theme_content');
            deliverCalendarsStore = txn.objectStore('deliver_calendars');
            deliverEventsStore = txn.objectStore('deliver_events');
            deletedCalendarsStore = txn.objectStore('deleted_calendars');
            deletedEventsStore = txn.objectStore('deleted_events');
            deletedTasksStore = txn.objectStore('deleted_tasks');
            deletedTaskListsStore = txn.objectStore('deleted_task_lists');
            fontStore = txn.objectStore('fonts');
            createIndexes(calStore, templatesStore, eventStore, taskListStore, taskStore, instanceStore, themeStore, themeContentStore, deliverCalendarsStore, deliverEventsStore, deletedCalendarsStore, deletedEventsStore, deletedTasksStore, deletedTaskListsStore, fontStore, function () {
            });
            jorteConfig.updateInit();
        } else {
            // Fist creation of database objectStore
            calStore = db.createObjectStore("calendar", {keyPath: 'id', autoIncrement: true});
            templatesStore = db.createObjectStore("templates", {keyPath: 'id', autoIncrement: true});
            eventStore = db.createObjectStore("event", {keyPath: 'id', autoIncrement: true});
            taskListStore = db.createObjectStore("task_list", {keyPath: 'id', autoIncrement: true});
            taskStore = db.createObjectStore("task", {keyPath: 'id', autoIncrement: true});
            instanceStore = db.createObjectStore("event_instance", {keyPath: 'id', autoIncrement: true});
            themeStore = db.createObjectStore("theme", {keyPath: 'id', autoIncrement: true});
            themeContentStore = db.createObjectStore("theme_content", {keyPath: 'theme_id', autoIncrement: false});

            deliverCalendarsStore = db.createObjectStore("deliver_calendars", {keyPath: 'id', autoIncrement: true});
            deliverEventsStore = db.createObjectStore("deliver_events", {keyPath: 'id', autoIncrement: true});
            deletedCalendarsStore = db.createObjectStore("deleted_calendars", {keyPath: 'id', autoIncrement: true});
            deletedEventsStore = db.createObjectStore("deleted_events", {keyPath: 'id', autoIncrement: true});
            deletedTasksStore = db.createObjectStore("deleted_tasks", {keyPath: 'id', autoIncrement: true});
            deletedTaskListsStore = db.createObjectStore("deleted_task_lists", {keyPath: 'id', autoIncrement: true});
            fontStore = db.createObjectStore("fonts", {keyPath: 'id', autoIncrement: true});
            createIndexes(calStore, templatesStore, eventStore, taskListStore, taskStore, instanceStore, themeStore, themeContentStore, deliverCalendarsStore, deliverEventsStore, deletedCalendarsStore, deletedEventsStore, deletedTasksStore, deletedTaskListsStore, fontStore, function () {

                console.log('Creating tables');

                var dt = new Date();
                var strtDate1 = new Date(dt.getFullYear(), dt.getMonth(), dt.getDate(), 10, 0, 0).getTime();
                var startTime1 = 600;
                var strtDate2 = new Date(dt.getFullYear(), dt.getMonth(), dt.getDate(), 11, 0, 0).getTime();
                var startTime2 = 660;
                var strtDate3 = new Date(dt.getFullYear(), dt.getMonth(), dt.getDate(), 12, 0, 0).getTime();
                var startTime3 = 720;
                var memo = '';

                console.log('Creating calendar store');


                var calendars = [];
                var calendar = new Calendar();
                calendar.calendar_rule = 2, calendar.type = 0, calendar.name = getMSG('MyCalenderHead'), calendar.timezone = jorteConfig.TIME_ZONE,
                        calendar.description = getMSG('CalendarSyncHead'), calendar.is_share = 0, calendar.is_public = 0, calendar.is_visible = 1,
                        calendar.seqno = 0;
                calendars.push(calendar);

                calendar = new Calendar();
                calendar.calendar_rule = 2, calendar.type = 100, calendar.name = getMSG('HolCalendarHead'), calendar.timezone = jorteConfig.TIME_ZONE,
                        calendar.description = '', calendar.is_share = 0, calendar.is_public = 0, calendar.is_visible = 1,
                        calendar.seqno = 0;
                calendars.push(calendar);

                calendar = new Calendar();
                calendar.calendar_rule = 2, calendar.type = 200, calendar.name = getMSG('NationalHolCalendarHead'), calendar.timezone = jorteConfig.TIME_ZONE,
                        calendar.description = '', calendar.is_share = 0, calendar.is_public = 0, calendar.is_visible = 1,
                        calendar.seqno = 0;
                calendars.push(calendar);

                console.log('Inserting calendars');
                for (var i = 0; i < calendars.length; i++) {
                    calStore.add(calendars[i]);
                }



                var events = [];
                var event = new EventJorte();
                event.calendar_id = 1, event.name = getMSG('ExampleExHead'), event.content = memo, event.icon = null, event.start_date = strtDate1, event.end_date = strtDate1,
                        event.start_time = startTime1, event.timezone = jorteConfig.TIME_ZONE, event.importance = 0, event.completed = 0,
                        event.create_date = dt.getTime(), event.update_date = dt.getTime();
                events.push(event);

                event = new EventJorte();
                event.calendar_id = 1, event.name = getMSG('ImportantExHead'), event.content = memo, event.icon = 'style/icons/events/30_1_star.png',
                        event.start_date = strtDate2, event.end_date = strtDate2,
                        event.start_time = startTime2, event.timezone = jorteConfig.TIME_ZONE, event.importance = 1, event.completed = 0,
                        event.create_date = dt.getTime(), event.update_date = dt.getTime();
                events.push(event);

                event = new EventJorte();
                event.calendar_id = 1, event.name = getMSG('CompletedExHead'), event.content = memo, event.icon = null, event.start_date = strtDate3, event.end_date = strtDate3,
                        event.start_time = startTime3, event.timezone = jorteConfig.TIME_ZONE, event.importance = 1, event.completed = 1,
                        event.create_date = dt.getTime(), event.update_date = dt.getTime();
                events.push(event);

                for (var i = 0; i < events.length; i++) {
                    eventStore.add(events[i]);
                }

                var taskList = new TaskListJorte();
                taskList.name = getMSG('MyTaskListHead'), taskList.selected = 1, taskList.create_date = dt.getTime(),
                        taskList.update_date = dt.getTime(), taskList.sync_status = 1;

                taskListStore.add(taskList);

                var tasks = [];
                var task = new TaskJorte();
                task.calendar_id = 1, task.task_list_id = 1, task.name = getMSG('Task1ExHead'), task.memo = memo, task.type = 1, task.start_date = null, task.due_date = null, task.start_time = null,
                        task.due_time = null, task.timezone = jorteConfig.TIME_ZONE, task.importance = 1, task.completed = 0, task.create_date = dt.getTime(), task.update_date = dt.getTime();
                tasks.push(task);

                task = new TaskJorte();
                task.calendar_id = 1, task.task_list_id = 1, task.name = getMSG('Task2ExHead'), task.memo = memo, task.type = 1, task.start_date = null, task.due_date = null, task.start_time = null,
                        task.due_time = null, task.timezone = jorteConfig.TIME_ZONE, task.importance = 0, task.completed = 0, task.create_date = dt.getTime(), task.update_date = dt.getTime();
                tasks.push(task);

                task = new TaskJorte();
                task.calendar_id = 1, task.task_list_id = 1, task.name = getMSG('Task3ExHead'), task.memo = memo, task.type = 1, task.start_date = null, task.due_date = null, task.start_time = null,
                        task.due_time = null, task.timezone = jorteConfig.TIME_ZONE, task.importance = 0, task.completed = 1, task.create_date = dt.getTime(), task.update_date = dt.getTime();
                tasks.push(task);

                for (var i = tasks.length - 1; i >= 0; i--) {
                    taskStore.add(tasks[i]);
                }

                var instances = [];
                //Event Instance
                var instance = new EventInstance();
                instance.event_id = 1, instance.begin = strtDate1, instance.end = strtDate1;
                instances.push(instance);

                instance = new EventInstance();
                instance.event_id = 2, instance.begin = strtDate2, instance.end = strtDate2;
                instances.push(instance);

                instance = new EventInstance();
                instance.event_id = 3, instance.begin = strtDate3, instance.end = strtDate3;
                instances.push(instance);

                //Task Instance
                instance = new EventInstance();
                instance.task_id = 1, instance.begin = null, instance.end = null;
                instances.push(instance);

                instance = new EventInstance();
                instance.task_id = 2, instance.begin = null, instance.end = null;
                instances.push(instance);

                instance = new EventInstance();
                instance.task_id = 3, instance.begin = null, instance.end = null;
                instances.push(instance);

                for (var i = 0; i < instances.length; i++) {
                    instanceStore.add(instances[i]);
                }


                var themes = [];
                var theme = new ThemeJorte();
                theme.name = 'Jorte White', theme.details = 'Jorte White', theme.author = 'jorte', theme.path = 'style/theme/jorte_white.css',
                        theme.color = '#7B797B', theme.parent = 0, theme.is_static = 1, theme.file_name = 'jorte_white.css';
                themes.push(theme);

                theme = new ThemeJorte();
                theme.name = 'Black', theme.details = 'Black', theme.author = 'jorte', theme.path = 'style/theme/black.css',
                        theme.color = '#313031', theme.parent = 0, theme.is_static = 1, theme.file_name = 'black.css';
                themes.push(theme);

                theme = new ThemeJorte();
                theme.name = 'Peach Orange', theme.details = 'Peach Orange', theme.author = 'jorte', theme.path = 'style/theme/peach_orange.css',
                        theme.color = '#FFCBB5', theme.parent = 0, theme.is_static = 1, theme.file_name = 'peach_orange.css';
                themes.push(theme);

                theme = new ThemeJorte();
                theme.name = 'Ocean Blue', theme.details = 'Ocean Blue', theme.author = 'jorte', theme.path = 'style/theme/ocean_blue.css',
                        theme.color = '#B5CBFF', theme.parent = 0, theme.is_static = 1, theme.file_name = 'ocean_blue.css';
                themes.push(theme);

                theme = new ThemeJorte();
                theme.name = 'Strawberry Milk', theme.details = 'Strawberry Milk', theme.author = 'jorte', theme.path = 'style/theme/strawberry_milk.css',
                        theme.color = '#FF416B', theme.parent = 0, theme.is_static = 1, theme.file_name = 'strawberry_milk.css';
                themes.push(theme);

                theme = new ThemeJorte();
                theme.name = 'Lime Green', theme.details = 'Lime Green', theme.author = 'jorte', theme.path = 'style/theme/lime_green.css',
                        theme.color = '#52C394', theme.parent = 0, theme.is_static = 1, theme.file_name = 'lime_green.css';
                themes.push(theme);

                theme = new ThemeJorte();
                theme.name = 'Lemon Choffon', theme.details = 'Lemon Choffon', theme.author = 'jorte', theme.path = 'style/theme/lemon_chiffon.css',
                        theme.color = '#FFF394', theme.parent = 0, theme.is_static = 1, theme.file_name = 'lemon_chiffon.css';
                themes.push(theme);

                for (var i = 0; i < themes.length; i++) {
                    themeStore.add(themes[i]);
                }

                var themeContents = [];
                var themeContent = new ThemeContent();
                themeContent.theme_id = 1, themeContent.content = THEME_JORTEWHTE + THEME_JORTEWHTE_EXTRA;
                themeContents.push(themeContent);

                themeContent = new ThemeContent();
                themeContent.theme_id = 2, themeContent.content = THEME_BLACK + THEME_BLACK_EXTRA;
                themeContents.push(themeContent);

                themeContent = new ThemeContent();
                themeContent.theme_id = 3, themeContent.content = THEME_PEACHORANGE + THEME_PEACHORANGE_EXTRA;
                themeContents.push(themeContent);

                themeContent = new ThemeContent();
                themeContent.theme_id = 4, themeContent.content = THEME_OCEANBLUE + THEME_OCEANBLUE_EXTRA;
                themeContents.push(themeContent);

                themeContent = new ThemeContent();
                themeContent.theme_id = 5, themeContent.content = THEME_STRAWBERRY + THEME_STRAWBERRY_EXTRA;
                themeContents.push(themeContent);

                themeContent = new ThemeContent();
                themeContent.theme_id = 6, themeContent.content = THEME_LIMEGREEN + THEME_LIMEGREEN_EXTRA;
                themeContents.push(themeContent);

                themeContent = new ThemeContent();
                themeContent.theme_id = 7, themeContent.content = THEME_LEMON + THEME_LEMON_EXTRA;
                themeContents.push(themeContent);

                for (var i = 0; i < themeContents.length; i++) {
                    themeContentStore.add(themeContents[i]);
                }

                var fonts = [];
                var font = new FontsJorte();
                font.name = 'cmunst.otf', font.details = 'Default Jorte font select', font.path = '/style/fonts/cmunst.otf',
                        font.is_selected = 0, font.font_family = 'cmunst';
                fonts.push(font);

                font = new FontsJorte();
                font.name = 'cmuntb.otf', font.details = 'Default Jorte font select', font.path = '/style/fonts/cmuntb.otf',
                        font.is_selected = 0, font.font_family = 'cmuntb';
                fonts.push(font);


                for (var i = 0; i < fonts.length; i++) {
                    fontStore.add(fonts[i]);
                }

                console.log('Create tables completed');
            });
            jorteConfig.init();
        }        
    }
    return {
        getTransaction: function (datastores, mode, completeCB, errorCB) {

            var trans = db.transaction(datastores, mode);
            if ($.type(completeCB) === 'function') {
                trans.oncomplete = completeCB;
            }
            if ($.type(errorCB) === 'function') {
                trans.onerror = errorCB;
            } else {
                trans.onerror = function (event) {
                    console.log(event);
                };
            }
            return trans;
        },
        init: function (callback) {
            var request = indexedDB.open(DB_NAME, DB_VER);
            request.onsuccess = function (evt) {
                db = request.result;
                console.log('Jorte DB opened');
                callback();
            };
            request.onerror = function (evt) {
                console.log('DB open failed', evt);
            };
            request.onupgradeneeded = upgradeDB;
        }
    };
}());
