'use strict';

var currentLang = navigator.language;
var cal_string, ja_holiday;
if (currentLang === "ja") {
    cal_string = {
        monthNames: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
        monthNamesShort: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
        dayNames: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'],
        dayNamesShort: ['日', '月', '火', '水', '木', '金', '土']
    };
    ja_holiday = {
        details: [
            "1949,    ,1/1,     元日", "1949,1999,1/15,    成人の日",
            "2000,    ,1/2;MON, 成人の日", "1967,    ,2/11,    建国記念の日",
            "1949,    ,VERNAL,  春分の日", "1949,1988,4/29,    天皇誕生日",
            "1989,2006,4/29,    みどりの日", "2007,    ,4/29,    昭和の日",
            "1949,    ,5/3,     憲法記念日", "2007,    ,5/4,     みどりの日",
            "1949,    ,5/5,     こどもの日", "1996,2003,7/20,    海の日",
            "2004,    ,7/3;MON, 海の日", "1966,2003,9/15,    敬老の日",
            "2004,    ,9/3;MON, 敬老の日", "1948,    ,AUTUMNAL,秋分の日",
            "1966,1999,10/10,   体育の日", "2000,    ,10/2;MON,体育の日",
            "1948,    ,11/3,    文化の日", "1948,    ,11/23,   勤労感謝の日",
            "1989,    ,12/23,   天皇誕生日"
        ]
    };
} else if (currentLang === "es") {
    cal_string = {
        monthNames: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
        monthNamesShort: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep', 'oct', 'nov', 'dic'],
        dayNames: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes', 'sábado'],
        dayNamesShort: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb']
    };
    ja_holiday = {
        details: [
            "1949,    ,1/1,     New Year's Day", "1949,1999,1/15,    Coming of Age Day",
            "2000,    ,1/2;MON, Coming of Age Day", "1967,    ,2/11,    Foundation Day",
            "1949,    ,VERNAL,  Vernal Equinox Day", "1949,1988,4/29,    Emperor's Birthday",
            "1989,2006,4/29,    Green Day", "2007,    ,4/29,    Showa Day",
            "1949,    ,5/3,     Foundation Day", "2007,    ,5/4,     Green Day",
            "1949,    ,5/5,     Children's Day", "1996,2003,7/20,    Marine Day",
            "2004,    ,7/3;MON, Marine Day", "1966,2003,9/15,    Senior Citizens' Day",
            "2004,    ,9/3;MON, Senior Citizens' Day", "1948,    ,AUTUMNAL,Autumnal Equinox Day",
            "1966,1999,10/10,   Health Sports Day", "2000,    ,10/2;MON,Health Sports Day",
            "1948,    ,11/3,    Culture Day", "1948,    ,11/23,   Labor Thanksgiving Day",
            "1989,    ,12/23,   Emperor's Birthday"
        ]
    };
} else {
    cal_string = {
        monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
        monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
        dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']
    };
    ja_holiday = {
        details: [
            "1949,    ,1/1,     New Year's Day", "1949,1999,1/15,    Coming of Age Day",
            "2000,    ,1/2;MON, Coming of Age Day", "1967,    ,2/11,    Foundation Day",
            "1949,    ,VERNAL,  Vernal Equinox Day", "1949,1988,4/29,    Emperor's Birthday",
            "1989,2006,4/29,    Green Day", "2007,    ,4/29,    Showa Day",
            "1949,    ,5/3,     Foundation Day", "2007,    ,5/4,     Green Day",
            "1949,    ,5/5,     Children's Day", "1996,2003,7/20,    Marine Day",
            "2004,    ,7/3;MON, Marine Day", "1966,2003,9/15,    Senior Citizens' Day",
            "2004,    ,9/3;MON, Senior Citizens' Day", "1948,    ,AUTUMNAL,Autumnal Equinox Day",
            "1966,1999,10/10,   Health Sports Day", "2000,    ,10/2;MON,Health Sports Day",
            "1948,    ,11/3,    Culture Day", "1948,    ,11/23,   Labor Thanksgiving Day",
            "1989,    ,12/23,   Emperor's Birthday"
        ]
    };
}

//To get localized string according to the language
window.getMSG = function(key, args) {
    return navigator.mozL10n.get(key, args);
};