'use strict';
/**
 * Jorte app run
 * 
 */
angular.module('jorteApp.run', [])

        .run(['$rootScope', 'themeSvc', 'syncSvc', 'notificationSvc', function($rootScope, themeSvc, syncSvc, notificationSvc) {
                FastClick.attach(document.body);
                //Set current theme
                themeSvc.getAllThemes(function(theme_list) {
                    var themeId = jorteConfig.getCurrentTheme();
                    themeId = !themeId ? '1' : themeId;
                    for (var i = 0; i < theme_list.length; i++) {
                        if (theme_list[i].id + '' === themeId) {
                            $rootScope.themeStyle = theme_list[i].theme_content;
                            return;
                        }
                    }
                });

                // This will handle an alarm set by this application
                if (navigator.mozSetMessageHandler) {
                    navigator.mozSetMessageHandler('alarm', function(mozAlarm) {
                        // only launch a notification if the Alarm is of the right type for this app 
                        try {
                            notificationSvc.init(mozAlarm);
                            syncSvc.getAutoSync(mozAlarm);
                        } catch (e) {
                            console.log("Unable to trigger alarm...", e);
                        }
                    });
                }
                $rootScope.currentLocale = currentLang;
                $rootScope.syncRunning = false;
            }]);
