'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.api.calendarApi', [])

        // Main service
        .factory('calendarApiSvc', ['$http', function($http) {

                var SERVER_URL = 'http://evt.jorte.net';
                function getConfigData() {
                    return {
                        deviceId: 'c63cd26a705e7ccb',
                        appVersion: '0.0.1',
                        platform: 'firefoxOs',
                        apktype: '50'
                    };
                }
                function send(apiURL, data, successCB, errorCB, noDefaultParam, method) {
                    data = data ? data : {};
                    if (!noDefaultParam) {
                        $.extend(data, data, getConfigData());
                    }
                    method = !method ? 'POST' : method;
                    var url = SERVER_URL + apiURL;
                    $http({'method': method, 'url': url, 'data': data})
                            .success(function(data) {
                                successCB(data);
                            }).
                            error(function(data, status) {
                                console.log('Error ', data, status);
                                errorCB && errorCB();
                            });
                }

                return {
                    getRecommendedCalendars: function(options, resultCB) {
                        send('/client/recommend/', options, resultCB);
                    },
                    getRankingCalendars: function(options, resultCB) {
                        send('/client/ranking/', options, resultCB);
                    },
                    searchCalendars: function(options, resultCB) {
                        send('/client/search/', options, resultCB);
                    },
                    getCalendar: function(options, resultCB) {
                        send('/client/getcal/', options, resultCB);
                    },
                    getCalendarItems: function(options, resultCB) {
                        send('/client/get/', options, resultCB);
                    },
                    start: function(completeCB) {

                        $http({'method': 'POST', 'url': SERVER_URL + '/client/start/', 'data': null})
                                .success(function(data) {
                                    jorteConfig.setPublicDeviceId(data.response.deviceId);
                                    completeCB && completeCB(1);
                                }).
                                error(function(data) {
                                    console.log(' Error ', data);
                                    completeCB && completeCB(0);
                                });

                    },
                    //using to call subscribe and unsubscribe APIs
                    subscribe: function(calendarId, flag, successCB, errorCB) {
                        var apiURL;
                        if (flag === 1) {
                            apiURL = '/client/subscribe/';
                        } else {
                            apiURL = '/client/unsubscribe/';
                        }
                        var data = {
                            calendarId: calendarId
                        };
                        $.extend(data, getConfigData());
                        data.deviceId = jorteConfig.getPublicDeviceId();

                        $http({'method': 'POST', 'url': SERVER_URL + apiURL, 'data': JSON.stringify(data)})
                                .success(function(data) {
                                    successCB && successCB(data);
                                }).
                                error(function(data, status) {
                                    console.log('Error ', data, status);
                                    errorCB && errorCB();
                                });

                    }
                };
            }]);