'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.api.holidayApi', [])

        // jorteAuth service
        .factory('holidayApiSvc', ['$http', 'holidaySvc','$rootScope', function($http, holidaySvc,$rootScope) {                
                var holiday_begin_year = 1948;
                var yearList = [];
                function init(cb) {
                    var holiday_defs = ja_holiday.details;
                    var holiday_metadata = [];
                    for (var i = 0, sz = holiday_defs.length; i < sz; i++) {
                        var metaString = holiday_defs[i];

                        var parts = metaString.split(",");
                        var metaData = {};
                        metaData.beginYear = parts[0];
                        metaData.endYear = parts[1].trim() ? parseInt(parts[1]) : 9999;
                        var dayPart = parts[2];
                        if (dayPart === "VERNAL") {
                            metaData.isVernal = true;
                        } else if (dayPart === "AUTUMNAL") {
                            metaData.isAutumnal = true;
                        } else {
                            var dayParts = dayPart.split("/");
                            if (dayParts.length !== 2)
                                throw "holiday_defs syntax error: ", metaString;

                            metaData.month = parseInt(dayParts[0]);
                            var day = dayParts[1];
                            var pos = day.indexOf(";");
                            if (pos < 0) {
                                metaData.day = parseInt(day);
                            } else {
                                metaData.day = 0;
                                metaData.weekNumOfMonth = parseInt(day.substring(0, pos));
                                metaData.week = getWeekString2HolidayWeek(day.substring(pos + 1));
                            }
                        }

                        metaData.displayName = parts[3].trim();
                        holiday_metadata.push(metaData);
                        if (i === holiday_defs.length - 1) {
                            cb(holiday_metadata);
                        }
                    }
                }
                function nationalHolidayLogic(year) {
                    if (year < 1986) {
                        return null;
                    } else {
                        return 'Y1986';
                    }
                }
                function makeNationalHoliday(list, year) {
                    var display_name = getMSG('NationalHolidayNationalPeople');
                    for (var i = 1; i < list.length; i++) {

                        var h1 = list[i - 1];
                        var h2 = list[i];
                        var d = new Date(h1.date);
                        d.setDate(d.getDate() + 2);
                        d.setFullYear(year);
                        if (d.getTime() !== h2.date)
                            continue;

                        d.setDate(d.getDate() - 1);

                        if (d.getDay() === 0) //Sunday
                            continue;

                        var nationalHoliday = {};
                        nationalHoliday.date = d.getTime();
                        nationalHoliday.displayName = display_name;

                        yearList.push(i, nationalHoliday);
                    }
                }
                function transferLogic(year) {
                    if (year < 1973)
                        return null;
                    else if (year < 2007)
                        return 'Y1973';
                    else
                        return 'Y2007';
                }
                function makeTransHoliday(list, logic, year) {
                    var diplay_name = getMSG('NationalHolidayCompensatory');
                    switch (logic) {
                        case 'Y2007':
                            var idx = 0;
                            for (var i = 0; i < list.length && idx < list.length; i++) {
                                var holidaySun = list[idx++];

                                var d = new Date(holidaySun.date);

                                if (d.getDay() !== 0 || d.getFullYear() !== year) //Sunday
                                    continue;

                                d.setDate(d.getDate() + 1);
                                d.setFullYear(year);

                                var normalDay = d.getTime();

                                for (var j = idx; j < list.length; j++) {

                                    idx = j;
                                    var holidayNext = list[j];
                                    if (holidayNext.date === normalDay) {
                                        d.setDate(d.getDate() + 1);
                                        d.setFullYear(year);
                                        normalDay = d.getTime();
                                        continue;
                                    }
                                    break;
                                }
                                var holidaytrans = {};
                                holidaytrans.date = normalDay;
                                holidaytrans.displayName = diplay_name;

                                yearList.push(idx, holidaytrans);
                            }
                            break;
                        case 'Y1973':
                            var idx = 1;
                            for (var i = 1, sz = list.length; i < sz; i++) {
                                var holidaySun = list[idx - 1];
                                var holidayMon = list[idx++];

                                var d = new Date(holidaySun.date);
                                if (d.getDay() !== 0 || d.getFullYear() !== year)
                                    continue;

                                d.setDate(d.getDate() + 1);

                                var monday = d.getTime();

                                var dMon = new Date(holidayMon.date);

                                if (dMon.getDay() === 1 || dMon.getFullYear() !== year)
                                    continue;

                                var holidaytrans = {};
                                holidaytrans.date = monday;
                                holidaytrans.displayName = diplay_name;

                                yearList.push(idx, holidaytrans);
                            }
                            break;
                    }
                }
                function calculate(beginYear, endYear, cb) {
                    init(function(data) {
                        var d = new Date();
                        for (var year = beginYear; year <= endYear; year++) {
                            if (year < holiday_begin_year)
                                continue;

                            d.setFullYear(year);
                            for (var i = 0; i < data.length; i++) {
                                var meta = data[i];
                                if (year < meta.beginYear || year > meta.endYear)
                                    continue;

                                if (meta.isVernal || meta.isAutumnal) {
                                    if (meta.isVernal) {
                                        calcVernal(d);
                                    } else {
                                        calcAutumnal(d);
                                    }
                                } else if (meta.day > 0) {
                                    d.setMonth(meta.month - 1);
                                    d.setDate(meta.day);
                                } else if (meta.weekNumOfMonth > 0 && meta.week > 0) {
                                    d.setMonth(meta.month - 1);
                                    d.setDate(meta.day);

                                    d.setDate(d.getDate() + (7 * meta.weekNumOfMonth));
                                    d.setDate(d.getDate() + meta.week - (d.getDay() || 7));
                                }
                                var holiday = {};
                                holiday.date = d.getTime();
                                holiday.displayName = meta.displayName;

                                yearList.push(holiday);
                            }

                            var nhLogic = nationalHolidayLogic(year);
                            if (nhLogic) {
                                makeNationalHoliday(yearList, year); //National holiday for people
                            }

                            var logic = transferLogic(year);
                            if (logic) {
                                makeTransHoliday(yearList, logic, year); //Compensatory holiday
                            }
                        }
                        cb && cb(yearList);
                    });
                }
                function calcAutumnal(d) {
                    d.setMonth(8); //September

                    var year = d.getFullYear();

                    var i;
                    if (year >= 1851 && year <= 1899)
                        i = parseInt(22.2588 + 0.242194 * (year - 1980) - parseInt((year - 1983) / 4));
                    else if (year >= 1900 && year <= 1979)
                        i = parseInt(23.2588 + 0.242194 * (year - 1980) - parseInt((year - 1983) / 4));
                    else if (year >= 1980 && year <= 2099)
                        i = parseInt(23.2488 + 0.242194 * (year - 1980) - parseInt((year - 1980) / 4));
                    else if (year >= 2100 && year <= 2150)
                        i = parseInt(24.2488 + 0.242194 * (year - 1980) - parseInt((year - 1980) / 4));
                    else
                        return;

                    d.setDate(i);
                }
                function calcVernal(d) {
                    d.setMonth(2); //March
                    var year = d.getFullYear();

                    var i;
                    if (year >= 1851 && year <= 1899)
                        i = parseInt(19.2811 + 0.242194 * (year - 1980) - parseInt((year - 1983) / 4));
                    else if (year >= 1900 && year <= 1979)
                        i = parseInt(20.8357 + 0.242194 * (year - 1980) - parseInt((year - 1983) / 4));
                    else if (year >= 1980 && year <= 2099)
                        i = parseInt(20.8431 + 0.242194 * (year - 1980) - parseInt((year - 1980) / 4));
                    else if (year >= 2100 && year <= 2150)
                        i = parseInt(21.8510 + 0.242194 * (year - 1980) - parseInt((year - 1980) / 4));
                    else
                        return;

                    d.setDate(i);
                }
                function getWeekString2HolidayWeek(s) {
                    if (s === 'SUN') {
                        return 0;
                    } else if (s === 'MON') {
                        return 1;
                    } else if (s === 'TUE') {
                        return 2;
                    } else if (s === 'WED') {
                        return 3;
                    } else if (s === 'THU') {
                        return 4;
                    } else if (s === 'FRI') {
                        return 5;
                    } else if (s === 'SAT') {
                        return 6;
                    } else {
                        throw "Week not found : ", s;
                    }
                }
                function prepareHoliday(list, cb) {
                    var yearListTemp = [];
                    if (list.length > 0) {
                        for (var i = 0; i < list.length; i++) {
                            var holidayDet = list[i];
                            var holidayDate = (new Date(holidayDet.date)).getTime();
                            yearListTemp.push([holidayDet.displayName, holidayDate, holidayDate, holidayDate, holidayDate]);
                        }
                        cb && cb(yearListTemp);
                    }
                }
                return {
                    holidayRequest: function(urlDetails, apiResponse) {
                        var hoiday = [];
                        var startMin = jorteUtils.formatDate(urlDetails.startMin, 'yyyyMMdd');
                        var startMax = jorteUtils.formatDate(urlDetails.startMax, 'yyyyMMdd');
                        var nationalHolidayurl = jorteConfig.NATIONAL_HOLIDAY.API_URL +
                                '?startMin=' + startMin +
                                '&startMax=' + startMax +
                                '&userId=' + urlDetails.userId +
                                '&maxResults=' + urlDetails.maxResults;
                        $http({method: 'GET', url: nationalHolidayurl}).success(function(data, status) {
                            if (status === 200) {
                                var courseDef = x2js.xml_str2json(data);
                                var xmlObject = courseDef.feed.entry;
                                for (var i = 0; i < xmlObject.length; i++) {
                                    var titile = xmlObject[i].title.__text;
                                    var endTime = xmlObject[i].when._endTime;
                                    var startTime = xmlObject[i].when._startTime;
                                    var std = jorteUtils.parseISO8601(startTime);
                                    var edd = jorteUtils.parseISO8601(endTime);
                                    if (startTime !== endTime) {
                                        edd.setDate(edd.getDate() - 1);
                                    }
                                    var stday = std.getTime();
                                    var endday = edd.getTime();
                                    hoiday.push([titile, stday, stday, endday, endday]);
                                }
                                $rootScope.$broadcast('holidayDeleted');
                                holidaySvc.insertHolidayEvents(hoiday, function(status) {
                                    apiResponse && apiResponse(status);
                                });
                            } else {
                                apiResponse && apiResponse(false);
                            }
                        }).error(function(data) {
                            apiResponse && apiResponse(false);
                        });
                    },
                    /*
                     * For Japanese national holiday
                     */
                    jaHolidayRequest: function(urlDetails, apiResponse) {
                        var start = (urlDetails.startMin).getFullYear();
                        var end = (urlDetails.startMax).getFullYear();
                        calculate(start, end, function(holidayList) {//Calculating japanese holiday
                            prepareHoliday(holidayList, function(holidayPrepared) { //Preparing holiday to insert
                                yearList.length = 0; //Emptying yearlist global array
                                $rootScope.$broadcast('holidayDeleted');
                                holidaySvc.insertHolidayEvents(holidayPrepared, function(status) { //Inserting to objectstore
                                    apiResponse && apiResponse(status);
                                });
                            });
                        });
                    }
                };
            }]);