'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.holiday', [])

        // Main service
        .factory('holidaySvc', function() {

            return {
                deleteHolidayEvents: function(completeCB, trans) {
                    if (!trans) {
                        trans = jorteDB.getTransaction(["event", "event_instance"], "readwrite");
                    }
                    var eventStore = trans.objectStore("event");
                    var instStore = trans.objectStore("event_instance");
                    var req = eventStore.index("calendar_id").openCursor(IDBKeyRange.only(3));
                    var evt_ids = [];
                    req.onsuccess = function(evt) {
                        var cursEvt = evt.target.result;
                        if (cursEvt) {
                            evt_ids.push(cursEvt.value.id);
                            var req = instStore.index("event_id").openCursor(IDBKeyRange.only(cursEvt.value.id));
                            req.onsuccess = function(evt) {
                                var cursInst = evt.target.result;
                                if (cursInst) {
                                    var req = cursInst.delete(cursInst.value);
                                    req.onsuccess = function() {
                                        cursInst.continue();
                                    };
                                } else {
                                    var req = cursEvt.delete(cursEvt.value);
                                    req.onsuccess = function() {
                                        cursEvt.continue();
                                    };
                                }
                            };
                        } else {
                            completeCB && completeCB();
                        }
                    };
                },
                insertHolidayEvents: function(holidays, txCompleteCB) {
                    var trans = jorteDB.getTransaction(["event", "event_instance"], "readwrite",
                            function() {
                                txCompleteCB && txCompleteCB(true);
                            }, function() {
                        txCompleteCB && txCompleteCB(false);
                    }
                    );
                    var eventStore = trans.objectStore("event");
                    var instStore = trans.objectStore("event_instance");

                    this.deleteHolidayEvents(function() {
                        $.each(holidays, function(key, e) {
                            var event = new EventJorte();
                            event.calendar_id = 3, event.name = e[0], event.start_date = e[1], event.start_time = e[2],
                                    event.end_date = e[3], event.end_time = e[4], event.holiday = 1;
                            var req = eventStore.add(event);
                            req.onsuccess = function(evt) {
                                var eventId = evt.target.result;
                                var inst = new EventInstance();
                                inst.event_id = eventId, inst.begin = e[1], inst.end = e[3];
                                instStore.add(inst);
                            };
                        });
                    }, trans);
                }
            };
        });


