'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.calendar', [])

        // Main service
        .factory('calendarSvc', function() {
            function getCalendar(calendarId, resultCB, trans) {
                var calStore = trans.objectStore("calendar");
                var req = calStore.get(parseInt(calendarId));
                req.onsuccess = function(evt) {
                    resultCB(evt.target.result);
                };
            }

            function updateCalendar(calendar, successCB, trans) {
                var calStore = trans.objectStore("calendar");
                var req = calStore.put(calendar);
                req.onsuccess = function(evt) {
                    successCB && successCB(evt.target.result);
                };
            }
            
            function getCalendarWithEventInstancesPagination(calendar, is_advance, eventCount, resultCB, trans) {
                var eventInstances = [];
                var count = 0;
                var evtStore = trans.objectStore("event");
                var instanceStore = trans.objectStore("event_instance");
                if (calendar) {
                    var req = evtStore.index("calendar_id+status").openCursor(IDBKeyRange.only([calendar.id, 1]));
                    req.onsuccess = function (evt) {
                        var evtCurs = evt.target.result;
                        if (is_advance === true) {
                            if (eventCount !== 0) {
                                evtCurs.advance(eventCount);
                                is_advance = false;
                            }
                        }else {
                            if (evtCurs) {
                                var event = evtCurs.value;
                                var is_exist = false;
                                var req = instanceStore.index("event_id").openCursor(IDBKeyRange.only(event.id));
                                req.onsuccess = function (evt) {
                                    var instCurs = evt.target.result;
                                    if (instCurs) {
                                        var instance = instCurs.value;
                                        if (!is_exist) {
                                            var view = {};
                                            var instance_id = event.id + '#' + instance.begin;
                                            view.id = event.id, view.instance_id = instance_id, view.name = event.name, view.start_date = event.start_date,
                                                    view.start_time = event.start_time, view.end_time = event.end_time,
                                                    view.all_day = event.all_day, view.holiday = event.holiday, view.day_time = event.day_time, view.icon = event.icon,
                                                    view.completed = event.completed, view.importance = event.importance, view.color = event.color,
                                                    view.cal_color = calendar.color, view.begin = instance.begin, view.end = instance.end,
                                                    view.type = calendar.type;
                                            var curDetail = makeCurDetails(calendar, event, instance);
                                            view.details = [];
                                            view.details.push(curDetail);
                                            eventInstances.push(view);
                                            is_exist = true;
                                        }
                                        instCurs.continue();
                                    }else {
                                        count++;
                                        if (count % 100 === 0) {
                                            resultCB && resultCB(eventInstances);
                                            return;
                                        } else {
                                            evtCurs.continue();
                                        }
                                    }
                                };

                            } else {
                                resultCB && resultCB(eventInstances);
                            }
                        }
                    };
                }
            }
            function makeCurDetails(calendar, event, instance) {
                var view = new EventTaskView();
                view.id = event.id, view.instance_id = instance.id, view.icon = event.icon, view.name = event.name, view.color = event.color, view.location = event.location,
                        view.day_time = event.day_time, view.holiday = event.holiday, view.repeat = event.repeat,
                        view.content = event.content, view.start_date = instance.begin, view.event_start = event.start_date,
                        view.end_date = instance.end, view.event_end = event.end_date, view.start_time = event.start_time,
                        view.end_time = event.end_time, view.status = event.status, view.importance = event.importance,
                        view.completed = event.completed, view.timezone = event.timezone, view.calendar = calendar.name,
                        view.calendar_id = calendar.id, view.calendar_type = calendar.type, view.cal_color = calendar.color,
                        view.all_day = event.all_day, view.reminders = event.reminders, view.global_id = event.global_id,
                        view.cal_global_id = calendar.global_id, view.sync_events = calendar.sync_events, view.is_public = calendar.is_public,
                        view.is_share = calendar.is_share, view.parent = event.parent || null, view.originalStartDate = event.originalStartDate || null,
                        view.owner_account = calendar.owner_account, view.cancelled = event.cancelled, view.last_date = event.last_date,
                        view.sync_version = event.sync_version || null;
                return view;

            }
            return {
                updateCalendarSelectionFlag: function(calendarId, resultCB) {
                    var trans = jorteDB.getTransaction(["calendar"], "readwrite");
                    getCalendar(calendarId, function(calendar) {
                        calendar.selected = calendar.selected === 0 ? 1 : 0;
                        updateCalendar(calendar, resultCB, trans);
                    }, trans);
                },
                updateCalendarColor: function(calendarId, color, resultCB) {
                    var trans = jorteDB.getTransaction(["calendar"], "readwrite");
                    getCalendar(calendarId, function(calendar) {
                        calendar.color = color;
                        updateCalendar(calendar, resultCB, trans);
                    }, trans);
                },
                getSingleCalendar: function (calendarId, resultCB) {
                    var trans = jorteDB.getTransaction(["calendar"], "readonly");
                    getCalendar(calendarId, function (calendar) {
                        resultCB && resultCB(calendar);
                    }, trans);
                },
                getCalendarWithEventInstances: function(calendar, is_advance, eventCount, resultCB) {
                    var eventViews=[];
                    var trans = jorteDB.getTransaction(["event", "event_instance"], "readonly",
                            function() {
                                resultCB(eventViews);
                            }
                    );
                    getCalendarWithEventInstancesPagination(calendar, is_advance, eventCount, function (resRows) {
                        eventViews = resRows;
                    }, trans);
                },
                getEventsCount: function (calendar_id,resultCB) {
                    var trans = jorteDB.getTransaction(
                            ['event'],
                            'readonly',
                            function () {
                                resultCB && resultCB(count);
                            }
                    );
                    var count = 0;
                    var eventStore = trans.objectStore("event");
                    var req = eventStore.index("calendar_id+deleted").count([calendar_id,0]);
                    req.onsuccess = function () {
                        count = req.result;
                    };
                },
                clearGoogleData: function(resultCB) {
                    /* Clear calendars */

                    var trans = jorteDB.getTransaction(["calendar", "task_list", "event", "task", "event_instance"], "readwrite",
                            function() {
                                resultCB();
                            }
                    );
                    var calStore = trans.objectStore("calendar");
                    var taskListStore = trans.objectStore("task_list");
                    var eventStore = trans.objectStore("event");
                    var taskStore = trans.objectStore("task");
                    var instStore = trans.objectStore("event_instance");

                    var req1 = calStore.index("type").openCursor(IDBKeyRange.only(300));
                    var data = [];
                    req1.onsuccess = function(e1) {
                        var c1 = e1.target.result;
                        if (c1) {
                            var calendar = c1.value;
                            data.push({"calendarId": calendar.id, "taskListId": -1});
                            c1.continue();
                        } else {
                            var req2 = taskListStore.index("type").openCursor(IDBKeyRange.only(300));
                            req2.onsuccess = function(e2) {
                                var c2 = e2.target.result;
                                if (c2) {
                                    var taskList = c2.value;
                                    data.push({"calendarId": -1, "taskListId": taskList.id});
                                    c2.continue();
                                } else {
                                    (function(res) {
                                        var cals = res;
                                        var calendarIds = [];
                                        var taskListIds = [];
                                        var j = 0, k = 0;
                                        for (var i = 0; i < cals.length; i++) {
                                            if (cals[i].calendarId === -1) {
                                                // tasklist id
                                                taskListIds[j] = cals[i].taskListId;
                                                j++;
                                            } else if (cals[i].taskListId === -1) {
                                                // calendar id
                                                calendarIds[k] = cals[i].calendarId;
                                                k++;
                                            }
                                        }
                                        var ci = 0, tli = 0;
                                        var res2 = [];
                                        fetchEvents();
                                        function fetchEvents() {
                                            if (ci >= calendarIds.length) { //got all events for these calendar ids
                                                fetchTasks();
                                                return;
                                            }
                                            var req3 = eventStore.index("calendar_id").openCursor(IDBKeyRange.only(calendarIds[ci]));
                                            req3.onsuccess = function(e3) {
                                                var c3 = e3.target.result;
                                                if (c3) {
                                                    var anEvent = c3.value;
                                                    res2.push({"eventId": anEvent.id, "taskId": -1});
                                                    c3.continue();
                                                } else {
                                                    ci++;
                                                    fetchEvents();
                                                }
                                            };
                                        }

                                        function fetchTasks() {
                                            if (tli >= taskListIds.length) { //got all tasks for these task list ids
                                                processIds(res2);
                                                return;
                                            }
                                            var req4 = taskStore.index("task_list_id").openCursor(IDBKeyRange.only(taskListIds[tli]));
                                            req4.onsuccess = function(e4) {
                                                var c4 = e4.target.result;
                                                if (c4) {
                                                    var aTask = c4.value;
                                                    res2.push({"eventId": -1, "taskId": aTask.id});
                                                    c4.continue();
                                                } else {
                                                    tli++;
                                                    fetchTasks();
                                                }
                                            };
                                        }

                                        function processIds(res) {
                                            (function(res) {
                                                var events = res;
                                                for (var i = 0; i < events.length; i++) {
                                                    (function(events, i) {
                                                        if (events[i].eventId === -1) {
                                                            // tasklist id
                                                            var req5 = taskStore.delete(events[i].taskId);
                                                            req5.onsuccess = function(e5) {

                                                            };
                                                            req5.onerror = function(e5) {
                                                                console.log('Task deletion error ', e5);
                                                            };
                                                            var req6 = instStore.index("task_id").openCursor(IDBKeyRange.only(parseInt(events[i].taskId)));
                                                            req6.onsuccess = function(e6) {
                                                                var curs6 = e6.target.result;
                                                                if (curs6) {
                                                                    curs6.delete(curs6.value);
                                                                    curs6.continue();
                                                                }
                                                            };
                                                            req6.onerror = function(e6) {
                                                                console.log('Task instance deletion error ', e6);
                                                            };

                                                        } else if (events[i].taskId === -1) {
                                                            var req5 = eventStore.delete(events[i].eventId);
                                                            req5.onsuccess = function(e5) {

                                                            };
                                                            req5.onerror = function(e5) {
                                                                console.log('Event deletion error ', e5);
                                                            };
                                                            var req6 = instStore.index("event_id").openCursor(IDBKeyRange.only(parseInt(events[i].eventId)));
                                                            req6.onsuccess = function(e6) {
                                                                var curs6 = e6.target.result;
                                                                if (curs6) {
                                                                    curs6.delete(curs6.value);
                                                                    curs6.continue();
                                                                }
                                                            };
                                                            req6.onerror = function(e6) {
                                                                console.log('Event instance deletion error ', e6);
                                                            };

                                                        }
                                                    })(events, i);
                                                }
                                            })(res);
                                            var req8 = calStore.index("type").openCursor(IDBKeyRange.only(300));
                                            req8.onsuccess = function(e8) {
                                                var curs8 = e8.target.result;
                                                if (curs8) {
                                                    curs8.delete(curs8.value);
                                                    curs8.continue();
                                                }
                                            };
                                            req8.onerror = function(e8) {
                                                console.log('Google calendar deletion error ', e8);
                                            };
                                            var req9 = taskListStore.index("type").openCursor(IDBKeyRange.only(300));
                                            req9.onsuccess = function(e9) {
                                                var curs9 = e9.target.result;
                                                if (curs9) {
                                                    curs9.delete(curs9.value);
                                                    curs9.continue();
                                                }
                                            };
                                            req9.onerror = function(e9) {
                                                console.log('Google taskList deletion error ', e9);
                                            };
                                        }
                                    })(data);
                                }
                            };
                            req2.onerror = function(e2) {
                                console.log('select tasklist error ', e2);
                            };
                        }
                    };
                }
            };
        });