'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.event', [])

        // Event service
        .factory('eventSvc', ['reminderSvc', function(reminderSvc) {
                function initTransForEventUpdate(completeCB, errorCB) {
                    return jorteDB.getTransaction(["event", "event_instance", "deleted_events"], "readwrite", completeCB, errorCB);
                }
                function makeCurDetails(calendar, event, instance) {
                    var view = new EventTaskView();
                    view.id = event.id,view.instance_id = instance.id, view.icon = event.icon, view.name = event.name, view.color = event.color, view.location = event.location,
                            view.day_time = event.day_time, view.holiday = event.holiday, view.repeat = event.repeat,
                            view.content = event.content, view.start_date = instance.begin, view.event_start = event.start_date,
                            view.end_date = instance.end, view.event_end = event.end_date, view.start_time = event.start_time,
                            view.end_time = event.end_time, view.status = event.status, view.importance = event.importance,
                            view.completed = event.completed, view.timezone = event.timezone, view.calendar = calendar.name,
                            view.calendar_id = calendar.id, view.calendar_type = calendar.type, view.cal_color = calendar.color,
                            view.all_day = event.all_day, view.reminders = event.reminders, view.global_id = event.global_id,
                            view.cal_global_id = calendar.global_id, view.sync_events = calendar.sync_events,view.is_public = calendar.is_public,
                            view.is_share = calendar.is_share, view.parent = event.parent || null, view.originalStartDate = event.originalStartDate || null,
                            view.owner_account = calendar.owner_account, view.cancelled = event.cancelled, view.last_date = event.last_date,
                            view.sync_version = event.sync_version||null;
                    return view;

                }
                function makeEventTaskViews(calendar, event, instance) {
                    var view = new EventTaskView();
                    view.id = event.id,
                            view.instance_id = instance.id,
                            view.calendar_id = event.calendar_id,
                            view.name = event.name,
                            view.icon = event.icon,
                            view.all_day = event.all_day,
                            view.day_time = event.day_time,
                            view.color = event.color,
                            view.location = event.location,
                            view.memo = event.content,
                            view.begin = instance.begin,
                            view.end = instance.end,
                            view.start_date = event.start_date,
                            view.end_date = event.end_date,
                            view.completed = event.completed,
                            view.importance = event.importance,
                            view.holiday = event.holiday,
                            view.type = 0,
                            view.repeat = event.repeat,
                            view.last_date = event.last_date,
                            view.provider = calendar.type,
                            view.cal_color = calendar.color,
                            view.timezone = event.timezone,
                            view.icon_only = null,
                            view.icon_map = null,
                            view.icon_id = null,
                            view.disp_type = null,
                            view.isdeliverCalendar = 2,
                            view.start_time = event.start_time,
                            view.end_time = event.end_time;
                    view.is_public = calendar.is_public;
                    view.is_share = calendar.is_share;
                    view.parent = event.parent || null;
                    view.originalStartDate = event.originalStartDate||null;
                    view.sync_version = event.sync_version||null;
                    view.end_inst = instance.end;
                    return view;
                }
                function processInstanceView(calendar,event,eventTaskViews,begin,end){
                    var instance = new EventInstance();
                    instance.id = event.id + '#' + begin;
                    instance.event_id = event.id;
                    instance.begin = begin;
                    instance.end = end;
                    var view = makeEventTaskViews(calendar, event, instance);
                    var curDetail = makeCurDetails(calendar, event, instance);
                    view.details = [];
                    view.details.push(curDetail);
                    eventTaskViews.push(view);
                }
                function createGlobalId(item){
                    var global_id;
                    if (item.all_day === 1) {
                        global_id = item.global_id+'_'+jorteUtils.toDateGlobal(item.start_date);
                    } else {
                        global_id = item.global_id+'_'+jorteUtils.toRFP3339Global(item.start_date);
                    }
                    return global_id;
                }
                function processExdate(exdate,instance_dates){
                    if (exdate) {
                        var str_list = exdate.split('EXDATE;');
                        var dateList = [];
                        if (str_list.length > 1) {
                            if (str_list[1].indexOf('TZID') > -1) {
                                var new_list = str_list[1].split(':');
                                var exdate_list = new_list[1];
                                var tzid = new_list[0].split('=')[1];

                                exdate_list = exdate_list.split(',');
                                for (var j = 0; exdate_list && j < exdate_list.length; j++) {
                                    var dateStr = exdate_list[j];
                                    var yyyyMMdd = null, HHmmss = null, year = null, month = null, day = null, hour = 0, minute = 0, second = 0, date = null;

                                    if (exdate_list[j].indexOf('T') > -1) {
                                        var s_list = exdate_list[j].split('T');
                                        if (s_list.length > 1) {
                                            yyyyMMdd = s_list[0].toString();
                                            HHmmss = s_list[1].toString();
                                        }
                                    } else {
                                        yyyyMMdd = exdate_list[j].toString();
                                    }
                                    if (yyyyMMdd && yyyyMMdd.length === 8) {
                                        year = parseInt(dateStr.substring(0, 4));
                                        month = parseInt(dateStr.substring(4, 6));
                                        day = parseInt(dateStr.substring(6, 8));
                                    }
                                    if (HHmmss && HHmmss.length === 6) {
                                        hour = parseInt(HHmmss.substring(0, 2));
                                        minute = parseInt(HHmmss.substring(2, 4));
                                        second = parseInt(HHmmss.substring(4, 6));
                                    }
                                    if (year && month && day) {
                                        date = new Date(year, month - 1, day, hour, minute, second);
                                        var new_date = jorteUtils.calcTime(tzid, date.getTime());
                                        dateList.push(new_date.getTime());
                                    }
                                }
                                if (instance_dates) {
                                    for (var k = 0; k < instance_dates.length; k++) {
                                        if (dateList.indexOf(new Date(instance_dates[k]).getTime()) > -1) {
                                            instance_dates.splice(k, 1);
                                            k--;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                function getEventById(eventId, resultCB, trans) {
                    var reqest = trans.objectStore("event").get(parseInt(eventId));
                    reqest.onerror = function(e) {
                        console.log('Event get Failed ', e);
                    };
                    reqest.onsuccess = function(e) {
                        resultCB(e.target.result);
                    };
                }

                function updateEvent(anEvent, trans, successCB) {
                    var req = trans.objectStore("event").put(anEvent);
                    req.onerror = function(e) {
                        console.log('Event update Failed ', e);
                    };
                    req.onsuccess = function(e) {
                        successCB && successCB(e.target.result);
                    };
                }
                function updateChildEventForGoogle(data,completeCB,trans){
                    var eventStore = trans.objectStore("event");
                    var parent_event_id = data.event_id;
                    var changeEvent = data.changeEvent;
                    var req = eventStore.index("parent").openCursor(IDBKeyRange.only(parseInt(parent_event_id)));
                    req.onerror = function(e) {
                        console.log(e);
                    };
                    req.onsuccess = function (e) {
                        var eventCurs = e.target.result;
                        if (eventCurs) {
                            var event = eventCurs.value;
                            if (changeEvent.name) {
                                event.name = changeEvent.name;
                            }
                            if (changeEvent.content) {
                                event.content = changeEvent.content;
                            }
                            if (changeEvent.importance) {
                                event.importance = changeEvent.importance;
                            }
                            if (changeEvent.completed) {
                                event.completed = changeEvent.completed;
                            }
                            if (changeEvent.location) {
                                event.location = changeEvent.location;
                            }
                            eventCurs.update(event);
                            eventCurs.continue();
                        } else {
                            completeCB && completeCB();
                        }
                    };
                }
                function deleteRepeatEventChildren(params, completeCB, trans) {
                    var parent_event_id = params.event_id;
                    var calendar_type = params.calendar_type;
                    var all_dayOld = params.all_dayOld;
                    var all_day = params.all_day;
                    
                    var eventStore = trans.objectStore("event");
                    var instanceStore = trans.objectStore("event_instance");
                    var deletedEventStore = trans.objectStore("deleted_events");
                    var req = eventStore.index("parent").openCursor(IDBKeyRange.only(parseInt(parent_event_id)));
                    req.onerror = function(e) {
                        console.log(e);
                    };
                    req.onsuccess = function (e) {
                        var eventCurs = e.target.result;
                        if (eventCurs) {
                            var event = eventCurs.value;
                            if (event.global_id && event.type !== 300) {
                                var parent = event.parent ? event.parent : event.id;
                                var obj = {
                                    global_id: event.global_id,
                                    sync_version: event.sync_version,
                                    type: calendar_type,
                                    parent: parent
                                };
                                if (event.parent) {
                                    var originalStartDate = event.start_date;
                                    obj.parent_global = event.parent_global;
                                    obj.originalStartDate = originalStartDate || null;
                                    obj.originalTimezone = event.originalTimezone ? event.originalTimezone : event.timezone;
                                    obj.sync_version = event.sync_version ? event.sync_version : null;
                                    obj.all_day = all_dayOld ? true : false;
                                }
                                var req = deletedEventStore.add(obj);
                                req.onsuccess = function (e) {
                                };
                                req.onerror = function (e) {
                                    console.log('Insert Event to deletedEvent Failed ', e);
                                };
                            }
                            var req1 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(parseInt(event.id)));
                            req1.onsuccess = function (e1) {
                                var instCurs = e1.target.result;
                                if (instCurs) {
                                    instCurs.delete(instCurs.value);
                                    instCurs.continue();
                                }else{
                                    eventCurs.delete(event);
                                    eventCurs.continue();
                                }
                            };


                        } else {
                            completeCB && completeCB();
                        }
                    };
                }
                function deleteSingleEventInstance(parent_eventId, start_date, completeCB, trans) {
                    var instanceStore = trans.objectStore("event_instance");
                    parent_eventId = parseInt(parent_eventId);
                    var req1 = instanceStore.index("event_id+begin").openCursor([parent_eventId, start_date]);
                    req1.onsuccess = function (e1) {
                        var instCurs = e1.target.result;
                        if (instCurs) {
                            instCurs.delete(instCurs.value);
                            instCurs.continue();
                        }else {
                            completeCB && completeCB();
                        }
                    };
                }
                function deleteEventInstances(eventId, completeCB, trans) {
                    var instanceStore = trans.objectStore("event_instance");
                    var req = instanceStore.index("event_id").openCursor(IDBKeyRange.only(parseInt(eventId)));
                    req.onerror = function(e) {
                        console.log(e);
                    };
                    req.onsuccess = function(e) {
                        var instanceCurs = e.target.result;
                        if (instanceCurs) {
                            instanceCurs.delete(instanceCurs.value);
                            instanceCurs.continue();
                        } else {
                            completeCB && completeCB();
                        }
                    };
                }
                function addEventInstance(instance, trans) {
                    var instanceStore = trans.objectStore("event_instance");
                    var reqest = instanceStore.add(instance);
                    reqest.onerror = function(e) {
                        console.log('Event Instance Add Failed ', e);
                    };
                }
                function syncEventInsertion(insertList, callback) {
                    var trans = jorteDB.getTransaction(
                            ["event", "event_instance"],
                            "readwrite",
                            callback,
                            function(e) {
                                console.log(e);
                            }
                    );
                    var evtStore = trans.objectStore("event");
                    function insertEvent(i) {
                        if (i >= insertList.length) {
                            return;
                        }
                        var newEvt = insertList[i];
                        var evtObj = {};
                        $.extend(evtObj, newEvt);
                        delete evtObj.instances;
                        if (newEvt.reminders && newEvt.reminders.length > 0) {
                            reminderSvc.addReminders(newEvt.reminders);
                        }
                        var processInsertEvent = function () {

                            var req = evtStore.add(evtObj);
                            req.onsuccess = function (evt) {
                                var eventId = evt.target.result;
                                for (var j = 0; j < newEvt.instances.length; j++) {
                                    var anInstance = newEvt.instances[j];
                                    anInstance.event_id = eventId;
                                    addEventInstance(anInstance, trans);
                                }
                                if(evtObj.parent && evtObj.originalStartDate){
                                    deleteSingleEventInstance(evtObj.parent, evtObj.originalStartDate,function (){

                                    },trans);
                                }
                                insertEvent(++i);
                            };
                        };
                        if (evtObj.parent_global) {
                            var req1 = evtStore.index('global_id').openCursor(evtObj.parent_global.toString());
                            req1.onsuccess = function (e1) {
                                var eventCur = e1.target.result;
                                if (eventCur) {
                                    var parent_event = eventCur.value;
                                    evtObj.parent = parent_event.id;
                                    processInsertEvent();
                                }else{
                                    processInsertEvent();
                                }
                            };
                        } else {
                            processInsertEvent();
                        }
                    }
                    insertEvent(0);
                }
                function syncEventUpdation(updatedEvent, callback) {
                    var trans = jorteDB.getTransaction(
                            ["event", "event_instance"],
                            "readwrite",
                            callback,
                            function(e) {
                                console.log(e);
                            }
                    );

                    var updateEvents = function(i) {
                        if (i >= updatedEvent.length) {
                            return;
                        }
                        var locEvent = updatedEvent[i];
                        var evtObj = {};
                        var req;
                        $.extend(evtObj, locEvent);
                        delete evtObj.instances;
                        var processUpdateEvent = function () {
                            updateEvent(evtObj, trans, function () {
                                deleteEventInstances(locEvent.id, function () {
                                    var instances = locEvent.instances;
                                    for (var k = 0; k < instances.length; k++) {
                                        var anInstance = instances[k];
                                        anInstance.event_id = locEvent.id;
                                        addEventInstance(anInstance, trans);
                                    }
                                }, trans);
                                if(evtObj.parent && evtObj.originalStartDate){
                                    deleteSingleEventInstance(evtObj.parent, evtObj.originalStartDate,function (){

                                    },trans);
                                }
                                updateEvents(++i);
                            });
                        };
                        if (evtObj.parent_global) {
                            var req1 = trans.objectStore("event").index('global_id').openCursor(evtObj.parent_global.toString());
                            req1.onsuccess = function (e1) {
                                var eventCur = e1.target.result;
                                if (eventCur) {
                                    var parent_event = eventCur.value;
                                    evtObj.parent = parent_event.id;
                                    processUpdateEvent();
                                }else{
                                    processUpdateEvent();
                                }
                            };
                        }else {
                            processUpdateEvent();
                        }

                        if (locEvent.reminders && locEvent.reminders.length > 0) {
                            reminderSvc.addReminders(locEvent.reminders);
                        }
                    };
                    updateEvents(0);
                }
                function syncEventDeletion(deleteList, callback) {
                    var trans = jorteDB.getTransaction(
                            ["event", "event_instance"],
                            "readwrite",
                            callback,
                            function(e) {
                                console.log(e);
                            }
                    );
                    var eventStore = trans.objectStore("event");
                    var deleteEvents = function(i) {
                        if (i >= deleteList.length) {
                            return;
                        }
                        var eventId = parseInt(deleteList[i].id);
                        var req1 = eventStore.delete(eventId);
                        req1.onsuccess = function(e1) {
                            deleteEventInstances(eventId, null, trans);
                            deleteEvents(++i);
                        };
                    };
                    deleteEvents(0);
                }

                return {
                    getLongEventAndInstancesLimit: function(startTime, endTime, calStart, calEnd, calendar_type, evtToShow, dispCompletedEvt, resultCB, trans) {
                        var eventTaskViews = [];
                        var singleEventViews = [];
                        startTime = calStart;
                        endTime = calEnd;
                        var calStore = trans.objectStore("calendar");
                        var eventStore = trans.objectStore("event");
                        var instanceStore = trans.objectStore("event_instance");

                        var req1 = calStore.index("selected").openCursor(IDBKeyRange.only(1));
                        req1.onsuccess = function(e1) {
                            var calCurs = e1.target.result;
                            if (calCurs) {
                                var calendar = calCurs.value;
                                var calendarType = $.inArray(calendar.type, calendar_type);
                                if (calendarType > -1) {
                                    var req2;
                                    if (evtToShow === 2) {
                                        req2 = eventStore.index("calendar_id+long_flag").openCursor(IDBKeyRange.only([calendar.id, 1]));
                                    } else {
                                        var range = IDBKeyRange.bound([calendar.id, evtToShow, 1], [calendar.id, evtToShow, 1], false, false);
                                        req2 = eventStore.index("calendar_id+holiday+long_flag").openCursor(range);
                                    }

                                    req2.onsuccess = function(evt) {
                                        var eventCurs = evt.target.result;
                                        if (eventCurs) {
                                            var event = eventCurs.value;
                                            if (event.parent) {
                                                singleEventViews.push(event);
                                            }
                                            if (event.rep_flag) {
                                                eventCurs.continue();
                                                return;
                                            }
                                            if (!event.completed || (event.completed && dispCompletedEvt !== 0)) {
                                                var req3 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(event.id));
                                                req3.onsuccess = function(evt) {
                                                    var instanceCurs = evt.target.result;
                                                    if (instanceCurs) {
                                                        var instance = instanceCurs.value;
                                                        var view = makeEventTaskViews(calendar, event, instance);
                                                        if (eventTaskViews['#' + instance.id] === undefined) {
                                                            eventTaskViews['#' + instance.id] = view;
                                                        }
                                                        instanceCurs.continue();
                                                    } else {
                                                        eventCurs.continue();
                                                    }
                                                };
                                            } else {
                                                eventCurs.continue();
                                            }
                                        } else {
                                            calCurs.continue();
                                        }
                                    };
                                } else {
                                    calCurs.continue();
                                }
                            } else {
                                resultCB && resultCB(eventTaskViews);
                            }
                        };
                    },
                    getRepeatEventAndInstancesLimit: function(startTime, endTime, calStart, calEnd, calendar_type, evtToShow, dispCompletedEvt, resultCB, trans) {
                        var eventTaskViews = [];
                        startTime = calStart;
                        endTime = calEnd;
                        var calStore = trans.objectStore("calendar");
                        var eventStore = trans.objectStore("event");
                        var req1 = calStore.index("selected").openCursor(IDBKeyRange.only(1));
                        req1.onsuccess = function(e1) {
                            var calCurs = e1.target.result;
                            if (calCurs) {
                                var calendar = calCurs.value;
                                var calendarType = $.inArray(calendar.type, calendar_type);
                                if (calendarType > -1) {
                                    var req2;
                                    if (evtToShow === 2) {
                                        req2 = eventStore.index("calendar_id+rep_flag").openCursor(IDBKeyRange.only([calendar.id, 1]));
                                    } else {
                                        var range = IDBKeyRange.bound([calendar.id, evtToShow, 1], [calendar.id, evtToShow, 1], false, false);
                                        req2 = eventStore.index("calendar_id+holiday+rep_flag").openCursor(range);
                                    }

                                    req2.onsuccess = function(evt) {
                                        var eventCurs = evt.target.result;
                                        if (eventCurs) {
                                            var event = eventCurs.value;
                                            if (event.deleted) {
                                                eventCurs.continue();
                                                return;
                                            }
                                            if (!event.completed || (event.completed && dispCompletedEvt !== 0)) {
                                                var sdate = new Date(event.start_date);
                                                var repeatSelectObj = null;
                                                var rule = null;
                                                var repeat = event.repeat;
                                                if (repeat) {
                                                    repeat = repeat.toString();
                                                    repeatSelectObj = RRule.parseString(repeat);
                                                    if (!repeatSelectObj.count && !repeatSelectObj.until) {
                                                        repeatSelectObj.until = new Date(endTime);
                                                    }

                                                    repeatSelectObj.dtstart = sdate;
                                                    rule = new RRule(repeatSelectObj);
                                                    var date_diff = event.end_date - event.start_date;
                                                    var instance_dates = [sdate.toString()];

                                                    if (rule) {
                                                        var c_date = new Date(startTime);
                                                        var d_date = new Date(endTime);
                                                        instance_dates = rule.between(new Date(c_date.getFullYear(), c_date.getMonth(), c_date.getDate() - 1), new Date(d_date.getFullYear(), d_date.getMonth(), d_date.getDate() + 1));
                                                        instance_dates = instance_dates.toString().split(',');
                                                        if(!instance_dates || instance_dates.length===1 && instance_dates[0]===""){
                                                            instance_dates = [sdate.toString()];
                                                        }
                                                        if (event.exdate) {
                                                            processExdate(event.exdate, instance_dates);
                                                        }

                                                    }
                                                    if (event.cancelled) {
                                                        var cancelled = event.cancelled;
                                                        if (instance_dates) {
                                                            for (var k = 0; k < instance_dates.length; k++) {
                                                                if (event.all_day === 0 && cancelled.indexOf(new Date(instance_dates[k]).getTime()) > -1) {
                                                                    instance_dates.splice(k, 1);
                                                                    k--;
                                                                }else{
                                                                    var d = new Date(instance_dates[k]);
                                                                    d.setTime(d.getTime() - d.getTimezoneOffset() * 60 * 1000);
                                                                    if (cancelled.indexOf(d.getTime())> -1) {
                                                                        instance_dates.splice(k, 1);
                                                                        k--;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }

                                                    var begin, end;
                                                    for (var j = 0; j < instance_dates.length; j++) {
                                                        begin = new Date(instance_dates[j]).getTime();
                                                        end = begin + date_diff;
                                                        var instance = new EventInstance();
                                                        instance.id = event.id + '#' + begin;
                                                        instance.event_id = event.id;
                                                        instance.begin = begin;
                                                        instance.end = end;
                                                        if ((startTime <= instance.begin && endTime >= instance.begin) ||
                                                                (startTime <= instance.end && endTime >= instance.end) ||
                                                                (instance.begin <= startTime && instance.end >= startTime)) {
                                                            var view = makeEventTaskViews(calendar, event, instance);
                                                            var curDetail = makeCurDetails(calendar, event, instance);
                                                            view.details = [];
                                                            view.details.push(curDetail);
                                                            eventTaskViews['#' + instance.id] = view;
                                                        }
                                                    }
                                                }

                                                eventCurs.continue();

                                            } else {
                                                eventCurs.continue();
                                            }
                                        } else {
                                            calCurs.continue();
                                        }
                                    };
                                } else {
                                    calCurs.continue();
                                }
                            } else {
                                resultCB && resultCB(eventTaskViews);
                            }
                        };
                    },
                    getEventAndInstancesLimit: function(startTime, endTime, calStart, calEnd, calendar_type, evtToShow, dispCompletedEvt, resultCB, trans) {
                        var instanceStart = startTime;
                        var instanceEnd = endTime;
                        var eventTaskViews = [];
                        var singleEventViews = [];
                        var calStore = trans.objectStore("calendar");
                        var eventStore = trans.objectStore("event");
                        var instanceStore = trans.objectStore("event_instance");

                        var req1 = calStore.index("selected").openCursor(IDBKeyRange.only(1));
                        req1.onsuccess = function(e1) {
                            var calCurs = e1.target.result;
                            if (calCurs) {
                                var calendar = calCurs.value;
                                var calendarType = $.inArray(calendar.type, calendar_type);
                                if (calendarType > -1) {
                                    var req2;
                                    if (evtToShow === 2) {
                                        var range = IDBKeyRange.bound([calendar.id, startTime, startTime, 0], [calendar.id, endTime, endTime, 0], false, false);
                                        req2 = eventStore.index("calendar_id+start_date+end_date+rep_flag").openCursor(range);
                                    } else {
                                        var range = IDBKeyRange.bound([calendar.id, evtToShow, startTime, startTime, 0], [calendar.id, evtToShow, endTime, endTime, 0], false, false);
                                        req2 = eventStore.index("calendar_id+holiday+start_date+end_date+rep_flag").openCursor(range);
                                    }
                                    req2.onsuccess = function(e2) {
                                        var eventCurs = e2.target.result;
                                        if (eventCurs) {
                                            var event = eventCurs.value;
                                            if (event.parent) {
                                                singleEventViews.push(event);
                                            }
                                            if (event.rep_flag || event.deleted) {
                                                eventCurs.continue();
                                                return;
                                            }
                                            if (!event.completed || (event.completed && dispCompletedEvt !== 0)) {
                                                var req3;
                                                if ((event.end_date - event.start_date) > (1000 * 60 * 60 * 24)) { //suppose its a long event
                                                    req3 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(event.id));
                                                } else {
                                                    var range = IDBKeyRange.bound([event.id, instanceStart, instanceStart], [event.id, instanceEnd, instanceEnd], false, false);
                                                    req3 = instanceStore.index("event_id+begin+end").openCursor(range);
                                                }
                                                req3.onsuccess = function(e3) {
                                                    var instanceCurs = e3.target.result;
                                                    if (instanceCurs) {
                                                        var instance = instanceCurs.value;
                                                        if ((startTime >= instance.begin && startTime <= instance.end) ||
                                                                (endTime >= instance.begin && endTime <= instance.end) ||
                                                                (instance.begin >= startTime && instance.begin <= endTime) ||
                                                                (instance.end >= startTime && instance.end <= endTime)) {
                                                            var view = makeEventTaskViews(calendar, event, instance);
                                                            if (eventTaskViews['#' + instance.id] === undefined) {
                                                                eventTaskViews['#' + instance.id] = view;
                                                            }
                                                        }
                                                        instanceCurs.continue();
                                                    } else {
                                                        eventCurs.continue();
                                                    }
                                                };
                                            } else {
                                                eventCurs.continue();
                                            }

                                        } else {
                                            calCurs.continue();
                                        }
                                    };
                                } else {
                                    calCurs.continue();
                                }
                            } else {
                                resultCB && resultCB(eventTaskViews,singleEventViews);
                            }
                        };
                    },
                    getEventsCount: function(startTime, endTime, evtToShow, dispCompletedEvt, resultCB, trans) {
                        var events_count = 0;
                        var calStore = trans.objectStore("calendar");
                        var eventStore = trans.objectStore("event");
                        var req1 = calStore.index("selected").openCursor(IDBKeyRange.only(1));
                        req1.onsuccess = function(e1) {
                            var calCurs = e1.target.result;
                            if (calCurs) {
                                var calendar = calCurs.value;
                                var displayCompleted = 0;
                                if (dispCompletedEvt !== 0) {
                                    displayCompleted = 1;
                                }

                                var req2, range;
                                if (evtToShow === 2) {
                                    if (dispCompletedEvt === 0) {
                                        range = IDBKeyRange.bound([calendar.id, startTime, displayCompleted, 0], [calendar.id, endTime, displayCompleted, 0], false, false);
                                        req2 = eventStore.index("calendar_id+start_date+completed+rep_flag").count(range);
                                    } else {
                                        range = IDBKeyRange.bound([calendar.id, startTime, 0], [calendar.id, endTime, 0], false, false);
                                        req2 = eventStore.index("calendar_id+start_date+rep_flag").count(range);
                                    }
                                } else {
                                    if (dispCompletedEvt === 0) {
                                        range = IDBKeyRange.bound([calendar.id, evtToShow, startTime, displayCompleted, 0], [calendar.id, evtToShow, endTime, displayCompleted, 0], false, false);
                                        req2 = eventStore.index("calendar_id+holiday+start_date+completed+rep_flag").count(range);
                                    } else {
                                        range = IDBKeyRange.bound([calendar.id, evtToShow, startTime, 0], [calendar.id, evtToShow, endTime, 0], false, false);
                                        req2 = eventStore.index("calendar_id+holiday+start_date+rep_flag").count(range);
                                    }
                                }

                                req2.onsuccess = function() {
                                    events_count += req2.result;
                                    calCurs.continue();
                                };

                            } else {
                                resultCB && resultCB(events_count);
                            }
                        };
                    },
                    getEventAndInstancesForEdit: function(dateStartTime, dateEndTime, event_id, instance_id, txCompletedCB) {
                        var eventViews = [];
                        var trans = jorteDB.getTransaction(
                                ["calendar", "event", "event_instance"],
                                "readonly",
                                function() {
                                    txCompletedCB(eventViews);
                                }
                        );
                        var calStore = trans.objectStore("calendar");
                        var eventStore = trans.objectStore("event");
                        var instanceStore = trans.objectStore("event_instance");
                        var req1 = eventStore.get(parseInt(event_id));

                        req1.onerror = function(e1) {
                            console.log('getEventAndInstancesForEdit', e1);
                        };
                        req1.onsuccess = function(e1) {
                            var event = e1.target.result;
                            var req2 = calStore.get(parseInt(event.calendar_id));
                            req2.onerror = function(e2) {
                                console.log('getEventAndInstancesForEdit', e2);
                            };
                            req2.onsuccess = function(e2) {
                                var calendar = e2.target.result;
                                if (instance_id) {
                                    var req3 = instanceStore.get(parseInt(instance_id));
                                    req3.onerror = function(e3) {
                                        console.log('getEventAndInstancesForEdit', e3);
                                    };
                                    req3.onsuccess = function (e3) {
                                        var instance = e3.target.result;
                                        if (instance) {
                                            var view = {};
                                            view.id = event.id, view.instance_id = instance.id, view.icon = event.icon, view.name = event.name, view.color = event.color, view.location = event.location,
                                                    view.day_time = event.day_time, view.holiday = event.holiday, view.repeat = event.repeat,
                                                    view.content = event.content, view.start_date = instance.begin, view.event_start = event.start_date,
                                                    view.end_date = instance.end, view.event_end = event.end_date, view.start_time = event.start_time,
                                                    view.end_time = event.end_time, view.status = event.status, view.importance = event.importance,
                                                    view.completed = event.completed, view.timezone = event.timezone, view.calendar = calendar.name,
                                                    view.calendar_id = calendar.id, view.calendar_type = calendar.type, view.cal_color = calendar.color,
                                                    view.all_day = event.all_day, view.reminders = event.reminders, view.global_id = event.global_id,
                                                    view.cal_global_id = calendar.global_id, view.sync_events = calendar.sync_events, view.is_public = calendar.is_public,
                                                    view.is_share = calendar.is_share, view.parent = event.parent || null, view.originalStartDate = event.originalStartDate || null,
                                                    view.owner_account = calendar.owner_account, view.cancelled = event.cancelled, view.last_date = event.last_date,
                                                    view.sync_version = event.sync_version||null;

                                            eventViews.push(view);
                                        }
                                    };
                                } else {
                                    var req3 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(event.id));
                                    req3.onerror = function(e3) {
                                        console.log('getEventAndInstancesForEdit', e3);
                                    };
                                    req3.onsuccess = function(e3) {
                                        var instanceCurs = e3.target.result;
                                        if (instanceCurs) {
                                            var instance = instanceCurs.value;
                                            if ((dateStartTime <= instance.begin && dateEndTime >= instance.begin) ||
                                                    (dateStartTime <= instance.end && dateEndTime >= instance.end) ||
                                                    (instance.begin <= dateStartTime && instance.end >= dateStartTime)) {
                                                var view = {};
                                                view.id = event.id, view.instance_id = instance.id, view.icon = event.icon, view.name = event.name, view.color = event.color, view.location = event.location,
                                                        view.day_time = event.day_time, view.holiday = event.holiday, view.repeat = event.repeat,
                                                        view.content = event.content, view.start_date = instance.begin, view.event_start = event.start_date,
                                                        view.end_date = instance.end, view.event_end = event.end_date, view.start_time = event.start_time,
                                                        view.end_time = event.end_time, view.status = event.status, view.importance = event.importance,
                                                        view.completed = event.completed, view.timezone = event.timezone, view.calendar = calendar.name,
                                                        view.calendar_id = calendar.id, view.calendar_type = calendar.type, view.cal_color = calendar.color,
                                                        view.all_day = event.all_day, view.reminders = event.reminders, view.global_id = event.global_id,
                                                        view.cal_global_id = calendar.global_id, view.sync_events = calendar.sync_events, view.is_public = calendar.is_public,
                                                        view.is_share = calendar.is_share, view.parent = event.parent || null, view.originalStartDate = event.originalStartDate || null,
                                                        view.owner_account = calendar.owner_account, view.cancelled = event.cancelled, view.last_date = event.last_date,
                                                        view.sync_version = event.sync_version||null;
                                                eventViews.push(view);
                                            }
                                            instanceCurs.continue();
                                        }
                                    };
                                }
                            };
                        };
                    },
                    deleteOnlyThisEvent:function (event, txCompletedCB){
                        var del_event_id;
                        var global_id = event.calendar_type === 300 ? createGlobalId(event) : null;
                        var trans = jorteDB.getTransaction(
                                ["deleted_events","event","event_instance"],
                                "readwrite",
                                function() {
                                    txCompletedCB(global_id, event.global_id, del_event_id);
                                }
                        );
                        var deletedEventStore = trans.objectStore("deleted_events");
                        var eventStore = trans.objectStore("event");
                        var originalStartDate = event.start_date;
                        var obj = {
                            global_id: global_id,
                            type: event.calendar_type
                        };
                        if (event.calendar_type !== 300) {
                            obj.parent = event.parent ? event.parent : event.id;
                            obj.parent_global = event.global_id;
                            obj.originalStartDate = originalStartDate || null;
                            obj.originalTimezone = event.originalTimezone ? event.originalTimezone : event.timezone;
                            obj.sync_version = event.sync_version ? event.sync_version : null;
                            obj.all_day = event.all_day || event.day_time === 1 ? true : false ;
                        } else {
                            obj.cal_global_id = event.cal_global_id;
                        }
                        var req = deletedEventStore.add(obj);
                        req.onsuccess = function (e) {
                            del_event_id = e.target.result;
                        };
                        req.onerror = function (e) {
                            console.log('Insert Event to deletedEvent Failed ', e);
                        };
                        var req = eventStore.get(parseInt(event.id));
                        req.onerror = function (e1) {
                            console.log('getting event error ', e1);
                        };
                        req.onsuccess = function (e1) {
                            var event = e1.target.result;
                            if (!event.cancelled) {
                                event.cancelled = [];
                            }
                            var cancelled = event.cancelled;
                            cancelled.push(originalStartDate);
                            event.cancelled = cancelled;
                            var req1 = eventStore.put(event);
                            req1.onerror = function (e1) {
                                console.log('Event update Failed ', e1);
                            };
                            req1.onsuccess = function (e) {
                                if (originalStartDate) {
                                    deleteSingleEventInstance(event.id, originalStartDate, function () {
                                    
                                    }, trans);
                            }
                            };
                        };
                    },
                    deleteEvent: function(eventId, txCompletedCB, itemNotFoundCB) {

                        var trans = jorteDB.getTransaction(
                                ["calendar", "event", "event_instance", "deleted_events"],
                                "readwrite",
                                txCompletedCB
                        );
                        var calStore = trans.objectStore("calendar");
                        var eventStore = trans.objectStore("event");
                        var instanceStore = trans.objectStore("event_instance");
                        var deletedEventStore = trans.objectStore("deleted_events");

                        var req = eventStore.get(parseInt(eventId));
                        var eventList = [];
                        req.onerror = function(e1) {
                            console.log('getting event error ', e1);
                        };
                        req.onsuccess = function(e1) {
                            var event = e1.target.result;
                            var req = calStore.get(parseInt(event.calendar_id));
                            req.onerror = function(e2) {
                                console.log('getting event calendar err ', e2);
                            };
                            req.onsuccess = function(e2) {
                                var calendar = e2.target.result;
                                if (calendar) {
                                    eventList.push({
                                        global_id: event.global_id,
                                        sync_version: event.sync_version,
                                        type: calendar.type});
                                }
                                if (eventList.length > 0) {
                                    var item = eventList[0];
                                    if ((item.global_id ||event.parent) && item.type === 0) {
                                        var parent = event.parent ? event.parent : event.id;
                                        var obj = {
                                            global_id: item.global_id||null,
                                            sync_version: item.sync_version||null,
                                            type: item.type,
                                            parent : parent
                                        };
                                        if (event.parent) {
                                            var req = eventStore.get(parseInt(event.parent));
                                            req.onerror = function (e1) {
                                                console.log('getting event error ', e1);
                                            };
                                            req.onsuccess = function (e1) {
                                                var parent_event = e1.target.result;
                                                if (parent_event) {
                                                    obj.all_day = parent_event.all_day || parent_event.day_time === 1 ? true : false;
                                                }else{
                                                    obj.all_day = false;
                                                }
                                                var originalStartDate = event.start_date;
                                                obj.parent_global = event.parent_global;
                                                obj.originalStartDate = originalStartDate || null;
                                                obj.originalTimezone = event.originalTimezone ? event.originalTimezone : event.timezone;
                                                obj.sync_version = event.sync_version ? event.sync_version : null;
                                                var req = deletedEventStore.add(obj);
                                                req.onsuccess = function (e) {
                                                };
                                                req.onerror = function (e) {
                                                    console.log('Insert Event to deletedEvent Failed ', e);
                                                };
                                            };
                                            
                                        } else {
                                            var req = deletedEventStore.add(obj);
                                            req.onsuccess = function (e) {
                                            };
                                            req.onerror = function (e) {
                                                console.log('Insert Event to deletedEvent Failed ', e);
                                            };
                                        }


                                    }
                                    if(item.global_id && item.type === 0 && event.parent){
                                        event.deleted = 1, event.dirty = 0, event.status = 0, event.update_date = (new Date()).getTime();
                                        var req4 = eventStore.put(event);
                                        req4.onerror = function(e) {
                                            console.log('Event update Failed ', e);
                                        };
                                        req4.onsuccess = function(e) {
                                            var req5 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(parseInt(eventId)));
                                            req5.onsuccess = function(e5) {
                                                var instCurs = e5.target.result;
                                                if (instCurs) {
                                                    instCurs.delete(instCurs.value);
                                                    instCurs.continue();
                                                }
                                            };
                                        };
                                        var params = {};
                                        params.event_id = eventId;
                                        params.calendar_type = calendar.type;
                                        deleteRepeatEventChildren(params, function () {
                                        }, trans);
                                    } else if (item.global_id && item.type === 300) {
                                        event.deleted = 1, event.dirty = 1, event.status = 0, event.update_date = (new Date()).getTime();
                                        var req4 = eventStore.put(event);
                                        req4.onerror = function(e) {
                                            console.log('Event update Failed ', e);
                                        };
                                        req4.onsuccess = function(e) {
                                            var req5 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(parseInt(eventId)));
                                            req5.onsuccess = function(e5) {
                                                var instCurs = e5.target.result;
                                                if (instCurs) {
                                                    instCurs.delete(instCurs.value);
                                                    instCurs.continue();
                                                }
                                            };
                                        };
                                        var params = {};
                                        params.event_id = eventId;
                                        params.calendar_type = calendar.type;
                                        deleteRepeatEventChildren(params, function () {
                                        }, trans);
                                    } else {
                                        var req4 = eventStore.delete(eventId);
                                        req4.onsuccess = function(e4) {
                                            var req5 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(parseInt(eventId)));
                                            req5.onsuccess = function(e5) {
                                                var instCurs = e5.target.result;
                                                if (instCurs) {
                                                    instCurs.delete(instCurs.value);
                                                    instCurs.continue();
                                                }
                                            };
                                        };
                                        var params = {};
                                        params.event_id = eventId;
                                        params.calendar_type = calendar.type;
                                        deleteRepeatEventChildren(params, function () {
                                        }, trans);
                                    }
                                } else {
                                    itemNotFoundCB();
                                }
                            };
                        };
                    },
                    makeEventCompleted: function(id, txCompletedCB) {
                        var date = new Date().getTime();
                        var trans = jorteDB.getTransaction(["event"], "readwrite", txCompletedCB);
                        var eventStore = trans.objectStore("event");
                        var req = eventStore.get(parseInt(id));
                        req.onerror = function(e) {
                            console.log('Event get Failed ', e);
                        };
                        req.onsuccess = function(e) {
                            var event = e.target.result;
                            event.completed = 1, event.dirty = 1, event.complete_date = date, event.update_date = date;
                            eventStore.put(event);
                        };
                    },
                    createEvent: function(data, txCompleteCB) {
                        var event_id;
                        var trans = initTransForEventUpdate(function() {
                            txCompleteCB(event_id);
                        });

                        var eventStore = trans.objectStore("event");
                        var req = eventStore.add(data.event);
                        req.onerror = function(evt) {
                            console.log('Event Add Failed ', evt);
                        };
                        req.onsuccess = function(evt) {
                            event_id = evt.target.result;
                            var begin, end;
                            var instance_dates = data.instance_dates;
                            var length = instance_dates.length;
                            for (var i = 0; i < length; i++) {
                                begin = new Date(instance_dates[i]).getTime();
                                end = begin + data.date_diff;
                                var instance = new EventInstance();
                                instance.event_id = event_id;
                                instance.begin = begin;
                                instance.end = end;
                                addEventInstance(instance, trans);
                            }
                            if (data.event.reminders && data.event.reminders.length > 0) {
                                reminderSvc.addReminders(data.event.reminders);
                            }
                            if(data.event.parent && data.event.originalStartDate){
                                deleteSingleEventInstance(data.event.parent, data.event.originalStartDate,function (){
                                    
                                },trans);
                            }
                        };
                    },
                    updateEventDetails: function(data, txCompleteCB) {
                        var trans = initTransForEventUpdate(txCompleteCB);

                        getEventById(data.event_id, function(event) {
                            var all_dayOld = event.all_day;
                                event.calendar_id = parseInt(data.calendar_id), event.name = data.name, event.content = data.content,
                                        event.icon = data.icon, event.color = data.color, event.start_date = data.start_date, event.end_date = data.end_date,
                                        event.start_time = data.startTime, event.end_time = data.endTime, event.type = data.type, event.timezone = data.timezone,
                                        event.repeat = data.repeat, event.importance = data.importance, event.all_day = data.all_day,
                                        event.holiday = data.holiday, event.day_time = data.day_time, event.location = data.location,
                                        event.completed = data.completed, event.complete_date = data.complete_date, event.update_date = data.update_date,
                                        event.dirty = 1, event.last_date = data.last_date, event.reminders = data.reminders, event.rep_flag = data.rep_flag,
                                    event.long_flag = data.long_flag,event.exdate = data.exdate;
                                    
                            if (data.editRepeatType && data.editRepeatType === 2 && data.deleteChild) {
                                event.cancelled = [];
                                event.exdate = null;
                                var params = {};
                                params.event_id = data.event_id;
                                params.calendar_type = data.calendarType;
                                params.all_dayOld = all_dayOld;
                                params.all_day = data.all_day;

                                deleteRepeatEventChildren(params, function () {

                                },trans);
                            }
                            updateEvent(event, trans, function(event_id) {
                                deleteEventInstances(event_id, function () {
                                    var begin, end;
                                    var length = data.instance_dates.length;
                                    for (var i = 0; i < length; i++) {
                                        begin = new Date(data.instance_dates[i]).getTime();
                                        end = begin + data.date_diff;
                                        var instance = new EventInstance();
                                        instance.event_id = event_id;
                                        instance.begin = begin;
                                        instance.end = end;
                                        addEventInstance(instance, trans);
                                    }
                                    if (data.reminders && data.reminders.length > 0) {
                                        reminderSvc.addReminders(data.reminders);
                                    }
                                    if (data.type === 300 && !data.deleteChild && data.changeEvent) {
                                        updateChildEventForGoogle(data,function (){
                                            
                                        },trans);
                                    }
                                }, trans);
                            });
                            }, trans);
                    },
                    updateFutureEventDetails: function (data, txCompleteCB) {
                        var trans = initTransForEventUpdate(txCompleteCB);
                        var eventStore = trans.objectStore("event");
                        var instanceStore = trans.objectStore("event_instance");
                        var repeat_end = data.repeat_end;
                        getEventById(data.event_id, function (event) {
                            event.repeat = data.repeat, event.update_date = data.update_date, event.dirty = 1;
                            updateEvent(event, trans, function (event_id) {
                                var req = eventStore.index("parent").openCursor(IDBKeyRange.only(parseInt(event_id)));
                                req.onerror = function (e) {
                                    console.log(e);
                                };
                                req.onsuccess = function (e) {
                                    var eventCurs = e.target.result;
                                    if (eventCurs) {
                                        var child_event = eventCurs.value;
                                        if (child_event.originalStartDate > repeat_end) {
                                            var req1 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(parseInt(child_event.id)));
                                            req1.onsuccess = function (e1) {
                                                var instCurs = e1.target.result;
                                                if (instCurs) {
                                                    instCurs.delete(instCurs.value);
                                                    instCurs.continue();
                                                }
                                            };
                                            eventCurs.delete(child_event);
                                        }
                                        eventCurs.continue();
                                    } else {
                                        var req1 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(parseInt(data.event_id)));
                                        req1.onsuccess = function (e1) {
                                            var instCurs = e1.target.result;
                                            if (instCurs) {
                                                var instance = instCurs.value;
                                                if (instance.begin > repeat_end) {
                                                    instCurs.delete(instCurs.value);
                                                }
                                                instCurs.continue();
                                            }
                                        };
                                    }
                                };
                            });
                        }, trans);
                    },
                    /*
                     * get deleted events and events with dirty flag set , for sync.
                     */
                    getAllEventsForSync: function(typeArr, resultCB) {
                        var delListLocal = [];
                        var insertListLocal = [];
                        var insertListChildrenLocal = [];
                        var updateListLocal = [];
                        var remainingList = [];
                        var trans = jorteDB.getTransaction(
                                ["deleted_events", "calendar", "event"],
                                "readonly",
                                function() {
                                    var params = {delListLocal: delListLocal, insertListLocal: insertListLocal, updateListLocal: updateListLocal,insertListChildrenLocal:insertListChildrenLocal, remainingList: remainingList};
                                    resultCB(params);
                                },
                                function(e) {
                                    console.log(e);
                                }
                        );
                        var calStore = trans.objectStore("calendar");
                        var delEvtStore = trans.objectStore("deleted_events");
                        var evtStore = trans.objectStore("event");
                        var req = delEvtStore.openCursor();
                        req.onsuccess = function(evt) {
                            var delEvtCurs = evt.target.result;
                            if (delEvtCurs) {
                                var delEvt = delEvtCurs.value;
                                if ($.inArray(delEvt.type, typeArr) >= 0) {
                                    delEvt.deleted_status = 1;
                                    delListLocal.push(delEvt);
                                }
                                delEvtCurs.continue();
                            } else {
                                var req1 = calStore.index("sync_events").openCursor(IDBKeyRange.only(1));
                                req1.onsuccess = function(evt) {
                                    var calCurs = evt.target.result;
                                    if (calCurs) {
                                        var calendar = calCurs.value;
                                        if ($.inArray(calendar.type, typeArr) >= 0) {
                                            var req2 = evtStore.index("calendar_id").openCursor(IDBKeyRange.only(parseInt(calendar.id)));
                                            req2.onsuccess = function(evt) {
                                                var evtCurs = evt.target.result;
                                                if (evtCurs) {
                                                    var event = evtCurs.value;
                                                    if (event.dirty === 1) {
                                                        var evtObj = {};
                                                        $.extend(evtObj, event);
                                                        evtObj.cal_global_id = calendar.global_id;
                                                        evtObj.calendar_rule = calendar.calendar_rule;
                                                        if (event.global_id) {
                                                            updateListLocal['#' + event.global_id] = evtObj;
                                                        } else {
                                                            if (evtObj.parent) {
                                                                var req1 = evtStore.get(parseInt(evtObj.parent));
                                                                req1.onsuccess = function (evt) {
                                                                    var parent_event = evt.target.result;
                                                                    if (parent_event) {
                                                                        evtObj.parent_event = parent_event;
                                                                        if (!parent_event.global_id) {
                                                                            insertListChildrenLocal.push(evtObj);
                                                                        }else{
                                                                            insertListLocal.push(evtObj);
                                                                        }
                                                                    }
                                                                };
                                                            }else{
                                                                insertListLocal.push(evtObj);
                                                            }
                                                        }
                                                    } else {
                                                        if (event.global_id) {
                                                            remainingList['#' + event.global_id] = event;
                                                        }
                                                    }
                                                    evtCurs.continue();
                                                } else {
                                                    calCurs.continue();
                                                }
                                            };
                                        } else {
                                            calCurs.continue();
                                        }
                                    }
                                };
                            }
                        };
                    },
                    syncEvents: function(op, items, callback) {
                        switch (op) {
                            case 1:
                                syncEventInsertion(items, callback);
                                break;
                            case 2:
                                syncEventUpdation(items, callback);
                                break;
                            case 3:
                                syncEventDeletion(items, callback);
                                break;
                        }
                    },
                    clearLocallyDeletedEvents: function(type,callback) {
                        var trans = jorteDB.getTransaction(
                                ["deleted_events"],
                                "readwrite",
                                callback,
                                function(e) {
                                    console.log(e);
                                }
                        );
                        var delEvtStore = trans.objectStore("deleted_events");
                        var reqDelEvt = delEvtStore.index('type').openCursor(IDBKeyRange.only(type));
                        reqDelEvt.onsuccess = function(evt) {
                            var cursDelEvt = evt.target.result;
                            if (cursDelEvt) {
                                cursDelEvt.delete(cursDelEvt.value);
                                cursDelEvt.continue();
                            }
                        };
                    },
                    /*
                     * get deleted events and events with dirty flag set , for sync.
                     */
                    getSingleEventForSync: function(params, resultCB) {
                        var delListLocal = [];
                        var insertListLocal = [];
                        var updateListLocal = [];
                        var remainingList = [];
                        var id = params.id , del_event_id = params.del_event_id;
                        var calendar_id = params.calendar_id, calendar_type = params.calendar_type, del_global_id = params.del_global_id, parent_global = params.parent_global;
                        var trans = jorteDB.getTransaction(
                                ["deleted_events", "calendar", "event"],
                                "readonly",
                                function() {
                                    var params = {delListLocal: delListLocal, insertListLocal: insertListLocal, updateListLocal: updateListLocal, remainingList: remainingList};
                                    resultCB(params);
                                }
                        );
                        var calStore = trans.objectStore("calendar");
                        var delEvtStore = trans.objectStore("deleted_events");
                        var evtStore = trans.objectStore("event");
                        if (del_global_id) {
                            var req = delEvtStore.index("global_id").openCursor(IDBKeyRange.only(del_global_id));
                            req.onsuccess = function (evt) {
                                var delEvtCurs = evt.target.result;
                                if (delEvtCurs) {
                                    var delEvts = delEvtCurs.value;
                                    delEvts.deleted_status = 1;
                                    delListLocal.push(delEvts);
                                    delEvtCurs.continue();
                                } else {
                                    if (calendar_type !== 300) {
                                        var req2 = delEvtStore.index("parent_global").openCursor(IDBKeyRange.only(del_global_id));
                                        req2.onsuccess = function (evt) {
                                            var delEvtCur = evt.target.result;
                                            if (delEvtCur) {
                                                var delEvt = delEvtCur.value;
                                                delEvt.deleted_status = 1;
                                                delListLocal.push(delEvt);
                                                delEvtCur.continue();
                                            }
                                        };
                                    }
                                }
                            };
                        }else if(calendar_type!==300 && del_event_id){
                            var req = delEvtStore.get(parseInt(del_event_id));
                            req.onsuccess = function(evt) {
                                var delEvt = evt.target.result;
                                if (delEvt) {
                                    delEvt.deleted_status = 1;
                                    delListLocal.push(delEvt);
                                }
                            };
                        }else {
                            var req = calStore.get(calendar_id);
                            req.onsuccess = function(evt) {
                                var calendar = evt.target.result;
                                if (calendar && calendar.sync_events) {
                                    var req = evtStore.get(id);
                                    req.onsuccess = function(evt) {
                                        var event = evt.target.result;
                                        if (event) {
                                            var evtObj = {};
                                            $.extend(evtObj, event);
                                            evtObj.cal_global_id = calendar.global_id;
                                            evtObj.calendar_rule = calendar.calendar_rule;
                                            if (evtObj.parent) {
                                                var req1 = evtStore.get(parseInt(evtObj.parent));
                                                req1.onsuccess = function (evt) {
                                                    var parent_event = evt.target.result;
                                                    if (parent_event) {
                                                        evtObj.parent_event = parent_event;
                                                    }
                                                };
                                            }else if (calendar_type !== 300 && event.global_id) {
                                                var req2 = delEvtStore.index("parent_global").openCursor(IDBKeyRange.only(event.global_id));
                                                req2.onsuccess = function (evt) {
                                                    var delEvtCur = evt.target.result;
                                                    if (delEvtCur) {
                                                        var delEvt = delEvtCur.value;
                                                        delEvt.deleted_status = 1;
                                                        delListLocal.push(delEvt);
                                                        delEvtCur.continue();
                                                    }
                                                };
                                            }
                                            if (evtObj.global_id) {
                                                updateListLocal['#' + evtObj.global_id] = evtObj;
                                            } else {
                                                insertListLocal.push(evtObj);
                                            }
                                        }
                                    };
                                }
                            };
                        }
                    },
                    syncSingleEvent: function(type, list, local_list, callback) {
                        var trans = jorteDB.getTransaction(
                                ["event"],
                                "readwrite",
                                function() {
                                    callback();
                                }, function(e) {
                            console.log(e);
                        }
                        );
                        var result;
                        var evtStore = trans.objectStore("event");
                        if (list) {
                            result = list;
                        }else if (local_list) {
                            for (var k in local_list) {
                                result = local_list[k];
                                break;
                            }
                        }
                        if (result && result.id) {
                            var req = evtStore.get(parseInt(result.id));
                            req.onsuccess = function (evt) {
                                var event = evt.target.result;
                                if (event) {
                                    event.global_id = result.global_id;
                                    event.dirty = 0;
                                    event.seqno = result.seqno ? result.seqno : event.seqno;
                                    event.sync_version = result.sync_version;
                                    event.update_date = result.update_date;
                                    updateEvent(event, trans, function () {
                                    });
                                }
                            };
                        }
                    },
                    getSingleEventAndInstances: function(cal_start, cal_end, event_id, evtToShow, dispCompletedEvt, resultCB) {
                        var trans = jorteDB.getTransaction(
                                ['calendar', 'event', 'event_instance'],
                                'readonly',
                                //Success callback
                                function () {
                                    resultCB(eventTaskViews);
                                },
                                //Error callback
                                function (evt) {
                                    console.log(evt);
                                }
                            );
                            var eventTaskViews = [];
                            var eFlag = false;
                            var calStore = trans.objectStore("calendar");
                            var eventStore = trans.objectStore("event");
                            var instanceStore = trans.objectStore("event_instance");
                            var req1 = eventStore.get(parseInt(event_id));
                            req1.onerror = function (e1) {
                                console.log('getSingleEventAndInstances', e1);
                            };
                            req1.onsuccess = function (e1) {
                                var event = e1.target.result;
                                if (evtToShow !== 2) {
                                    if (event.holiday === evtToShow) {
                                        eFlag = true;
                                    } else {
                                        eFlag = false;
                                        return;
                                    }
                                } else {
                                    eFlag = true;
                                }
                                if (event.deleted) {
                                    return;
                                }
                                if (eFlag && (!event.completed || (event.completed && dispCompletedEvt !== 0))) {
                                    var req2 = calStore.get(parseInt(event.calendar_id));
                                    req2.onsuccess = function (e2) {
                                        var calendar = e2.target.result;
                                        if (calendar && calendar.selected === 1) {
                                            var sdate = new Date(event.start_date);
                                            var repeatSelectObj = null;
                                            var rule = null;
                                            var repeat = event.repeat;
                                            if (repeat) {
                                                repeat = repeat.toString();
                                                repeatSelectObj = RRule.parseString(repeat);
                                                if (!repeatSelectObj.count && !repeatSelectObj.until) {
                                                    repeatSelectObj.until = cal_end;
                                                }

                                                repeatSelectObj.dtstart = sdate;
                                                rule = new RRule(repeatSelectObj);
                                                var date_diff = event.end_date - event.start_date;
                                                var instance_dates = [sdate.toString()];

                                                if (rule) {
                                                    var c_date = new Date(cal_start);
                                                    var d_date = new Date(cal_end);
                                                    instance_dates = rule.between(new Date(c_date.getFullYear(), c_date.getMonth(), c_date.getDate() - 1), new Date(d_date.getFullYear(), d_date.getMonth(), d_date.getDate() + 1));
                                                    instance_dates = instance_dates.toString().split(',');
                                                    
                                                    if(!instance_dates || instance_dates.length===1 && instance_dates[0]===""){
                                                        instance_dates = [sdate.toString()];
                                                    }
                                                    
                                                    if (event.exdate) {
                                                        processExdate(event.exdate, instance_dates);
                                                    }
                                                }
                                                for (var k = 0; k < instance_dates.length; k++) {
                                                    instance_dates[k] = new Date(instance_dates[k]).getTime();
                                                }
                                                if (event.cancelled) {
                                                    var cancelled = event.cancelled;
                                                    if (instance_dates) {
                                                        for (var k = 0; k < instance_dates.length; k++) {
                                                            if (cancelled.indexOf(instance_dates[k]) > -1) {
                                                                instance_dates.splice(k, 1);
                                                                k--;
                                                            }
                                                        }
                                                    }
                                                }
                                                var req3 = eventStore.index("parent").openCursor(IDBKeyRange.only(parseInt(event.id)));
                                                req3.onerror = function (e1) {
                                                    console.log('getSingleEventAndInstances', e1);
                                                };
                                                req3.onsuccess = function (e1) {
                                                    var eventCurs = e1.target.result;
                                                    if (eventCurs) {
                                                        var child_event = eventCurs.value;
                                                        if (instance_dates) {
                                                            var index = instance_dates.indexOf(child_event.originalStartDate);
                                                                if (index > -1) {
                                                                    instance_dates.splice(index, 1);
                                                                        var req3 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(child_event.id));
                                                                        req3.onsuccess = function (e3) {
                                                                            var instanceCurs = e3.target.result;
                                                                            if (instanceCurs) {
                                                                                var instance = instanceCurs.value;
                                                                                var view = makeEventTaskViews(calendar, child_event, instance);
                                                                                eventTaskViews.push(view);
                                                                                instanceCurs.continue();
                                                                            }
                                                                        };
                                                                }
                                                        }
                                                        eventCurs.continue();
                                                    }else{
                                                            var begin, end;
                                                            for (var j = 0; j < instance_dates.length; j++) {
                                                                begin = new Date(instance_dates[j]).getTime();
                                                                end = begin + date_diff;
                                                                processInstanceView(calendar, event, eventTaskViews, begin, end);
                                                            }
                                                    }
                                                };

                                            } else {
                                                var req3 = instanceStore.index("event_id").openCursor(IDBKeyRange.only(event.id));

                                                req3.onsuccess = function (e3) {
                                                    var instanceCurs = e3.target.result;
                                                    if (instanceCurs) {
                                                        var instance = instanceCurs.value;
                                                        var view = makeEventTaskViews(calendar, event, instance);
                                                        eventTaskViews.push(view);
                                                        instanceCurs.continue();
                                                    }
                                                };
                                            }
                                        }
                                    };

                                }
                            };
                        },
                        getChildEventCountForADay: function(parent_event,start_date,resultCB) {
                            var events_count = 0;
                            var trans = jorteDB.getTransaction(
                                    ["event"],
                                    "readonly",
                                    function() {
                                        resultCB(events_count);
                                    }, function(e) {
                                console.log(e);
                            }
                            );
                            var eventStore = trans.objectStore("event");
                            var req1 = eventStore.index("parent+originalStartDate").count([parent_event, start_date]);
                            req1.onsuccess = function () {
                                events_count += req1.result;
                            };
                        },
                        getSingleEvent: function(eventId, resultCB) {
                            var trans = jorteDB.getTransaction(
                                    ["event"],
                                    "readonly",
                                    resultCB, function(e) {
                                console.log(e);
                            }
                            );
                            var reqest = trans.objectStore("event").get(parseInt(eventId));
                            reqest.onerror = function(e) {
                                console.log('Event get Failed ', e);
                            };
                            reqest.onsuccess = function(e) {
                                resultCB(e.target.result);
                            };
                        }
                    };
            }]);
