'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.evtCalendar', [])

        // Main service
        .factory('evtCalendarSvc', function() {
            function updateDeliverCalendar(delCalendar, successCB, trans) {
                var delCalStore = trans.objectStore("deliver_calendars");
                var req = delCalStore.put(delCalendar);
                req.onsuccess = function(evt) {
                    successCB && successCB(evt.target.result);
                };
            }
            return {
                getDeliverCalendarList: function(txCompleteCb) {
                    var data = [];
                    var trans = jorteDB.getTransaction(["deliver_calendars", "deliver_events"], "readonly",
                            function() {
                                txCompleteCb(data);
                            },
                            function(evt) {
                                console.log(evt);
                            }
                    );
                    var delEventStore = trans.objectStore("deliver_events");
                    var delCalStore = trans.objectStore("deliver_calendars");
                    var req = delCalStore.index("selected").openCursor(IDBKeyRange.only(1));
                    req.onsuccess = function(evt) {
                        var cur1 = evt.target.result;
                        if (cur1) {
                            var delCal = cur1.value;
                            if (new RegExp("^.*list.*$", "i").test(delCal.disp_type)) {
                                var req = delEventStore.index("calendar_id").openCursor(delCal.id);
                                req.onsuccess = function(evt) {
                                    var cur2 = evt.target.result;
                                    if (cur2) {
                                        var delEvt = cur2.value;
                                        var rec = {};
                                        rec.id = delCal.id, rec.calendar_title = delCal.title, rec.color = delCal.color,
                                                rec.begin = delEvt.begin, rec.end = delEvt.end, rec.title = delEvt.title,
                                                rec.icon_id = delEvt.icon_id, rec.url = delEvt.url, rec.de_id = delEvt.id;
                                        data.push(rec);
                                        cur2.continue();
                                    } else {
                                        cur1.continue();
                                    }
                                };
                            } else {
                                cur1.continue();
                            }
                        }
                    };
                },
                getDeliverEventsForCalendarView: function(startTime, endTime, resultCB, trans) {

                    var deliverEventViews = [];
                    var deliverEventStore = trans.objectStore("deliver_events");
                    var deliverCalStore = trans.objectStore("deliver_calendars");

                    var reqDelCal = deliverCalStore.index("selected").openCursor(IDBKeyRange.only(1));
                    reqDelCal.onsuccess = function(evtDelCal) {
                        var delCalCurs = evtDelCal.target.result;
                        if (delCalCurs) {
                            var delCal = delCalCurs.value;
                            if (new RegExp("^.*calendar.*$", "i").test(delCal.disp_type)) {
                                var range = IDBKeyRange.bound([delCal.id, startTime], [delCal.id, endTime], false, false);
                                var reqDelEvt = deliverEventStore.index("calendar_id+begin").openCursor(range);
                                reqDelEvt.onsuccess = function(evtDelEvt) {
                                    var delEvtCurs = evtDelEvt.target.result;
                                    if (delEvtCurs) {
                                        var delEvt = delEvtCurs.value;
                                        if ((startTime >= delEvt.begin && startTime <= delEvt.end) ||
                                                (endTime >= delEvt.begin && endTime <= delEvt.end) ||
                                                (delEvt.begin >= startTime && delEvt.begin <= endTime) ||
                                                (delEvt.end >= startTime && delEvt.end <= endTime)) {
                                            var view = new EventTaskView();
                                            view.id = delEvt.id,
                                                    view.instance_id = delEvt.id,
                                                    view.name = delEvt.title,
                                                    view.icon = delCal.icon_data,
                                                    view.all_day = delEvt.all_day,
                                                    view.color = null,
                                                    view.location = delEvt.location,
                                                    view.memo = delEvt.content,
                                                    view.begin = delEvt.begin,
                                                    view.end = delEvt.end,
                                                    view.start_date = delEvt.begin,
                                                    view.end_date = delEvt.end,
                                                    view.completed = null,
                                                    view.importance = null,
                                                    view.holiday = null,
                                                    view.type = 2,
                                                    view.repeat = null,
                                                    view.last_date = null,
                                                    view.provider = null,
                                                    view.cal_color = delCal.color,
                                                    view.timezone = delEvt.timezone,
                                                    view.icon_only = delEvt.icon_only,
                                                    view.icon_map = delCal.icon_map,
                                                    view.icon_id = delEvt.icon_id,
                                                    view.disp_type = delCal.disp_type,
                                                    view.isdeliverCalendar = 1,
                                                    view.start_time = null,
                                                    view.end_time = null;
                                            deliverEventViews.push(view);
                                        }
                                        delEvtCurs.continue();
                                    } else {
                                        delCalCurs.continue();
                                    }
                                };
                            } else {
                                delCalCurs.continue();
                            }
                        } else {
                            resultCB && resultCB(deliverEventViews);
                        }
                    };
                },
                getDeliverEventDetails: function(id, txCompleteCb) {
                    var delEvtViews = [];
                    var trans = jorteDB.getTransaction(["deliver_calendars", "deliver_events"], "readonly",
                            function() {
                                txCompleteCb(delEvtViews);
                            },
                            function(evt) {
                                console.log(evt);
                            }
                    );
                    var delEventStore = trans.objectStore("deliver_events");
                    var delCalStore = trans.objectStore("deliver_calendars");
                    var req = delEventStore.get(parseInt(id));
                    req.onsuccess = function(evt) {
                        var delEvt = evt.target.result;
                        var req = delCalStore.get(parseInt(delEvt.calendar_id));
                        req.onsuccess = function(e2) {
                            var delCal = e2.target.result;
                            var view = {};
                            view.all_day = delEvt.all_day, view.id = delEvt.id, view.name = delEvt.title, view.location = delEvt.location,
                                    view.icon = delEvt.icon_id, view.importance = null, view.completed = null, view.start_date = delEvt.begin,
                                    view.end_date = delEvt.end, view.type = 2, view.icon_data = delCal.icon_data, view.icon_map = delCal.icon_map,
                                    view.calendar_id = delEvt.calendar_id, view.color = delCal.color, view.content = delEvt.content, view.value = delEvt.value,
                                    view.url = delEvt.url, view.cal_title = delCal.title, view.provider = delCal.provider, view.global_id = delCal.global_id;
                            delEvtViews.push(view);
                        };
                    };
                },
                getDeliverCalendarByGlobalId: function(globalId, resultCB) {
                    var trans = jorteDB.getTransaction(["deliver_calendars"], "readonly");
                    var delCalStore = trans.objectStore("deliver_calendars");
                    var req = delCalStore.index("global_id").openCursor(IDBKeyRange.only(globalId));
                    var data = [];
                    req.onsuccess = function(evt) {
                        var curs1 = evt.target.result;
                        if (curs1) {
                            data.push(curs1.value);
                            curs1.continue();
                        } else {
                            resultCB(data);
                        }
                    };
                },
                deleteDeliverCalendarByGlobalId: function(globalId, txCompleteCB) {
                    var trans = jorteDB.getTransaction(["deliver_calendars", "deliver_events"], "readwrite", txCompleteCB,
                            function(e) {
                                console.log('deleteDeliverCalendarByGlobalId error', e);
                            }
                    );
                    var delCalStore = trans.objectStore("deliver_calendars");
                    var delEvtStore = trans.objectStore("deliver_events");
                    var req = delCalStore.index("global_id").openCursor(IDBKeyRange.only(globalId));
                    req.onsuccess = function(evt) {
                        var cursCal = evt.target.result;
                        if (cursCal) {
                            var delCal = cursCal.value;
                            var req = delEvtStore.index("calendar_id").openCursor(IDBKeyRange.only(delCal.id));
                            req.onsuccess = function(evt) {
                                var cursEvts = evt.target.result;
                                if (cursEvts) {
                                    cursEvts.delete(cursEvts.value);
                                    cursEvts.continue();
                                } else {
                                    cursCal.delete(delCal);
                                    cursCal.continue();
                                }
                            };

                        }
                    };
                },
                getAllDeliverCalendars: function(resultCB, trans) {
                    if (!trans) {
                        trans = jorteDB.getTransaction(["deliver_calendars"], "readonly");
                    }
                    var delCalStore = trans.objectStore("deliver_calendars");
                    var req = delCalStore.openCursor();
                    var delCals = [];
                    req.onsuccess = function(evt) {
                        var delCalCurs = evt.target.result;
                        if (delCalCurs) {
                            delCals.push(delCalCurs.value);
                            delCalCurs.continue();
                        } else {
                            resultCB(delCals);
                        }
                    };
                },
                getCalendarsWithEventCount: function(resultCB, trans) {
                    if (!trans) {
                        trans = jorteDB.getTransaction(["calendar", "event"], "readonly");
                    }
                    var eventStore = trans.objectStore("event");
                    var calStore = trans.objectStore("calendar");
                    var req = calStore.openCursor();
                    var results = [];
                    req.onsuccess = function(evt) {
                        var calCurs = evt.target.result;
                        if (calCurs) {
                            var calendar = calCurs.value;
                            results.push(calendar);
                            var count = eventStore.index("calendar_id+status").count([calendar.id, 1]);
                            count.onsuccess = function() {
                                calendar.cnt = count.result;
                                calCurs.continue();
                            };

                        } else {
                            resultCB(results);
                        }
                    };
                },
                addDeliverCalendar: function(dc) {
                    var trans = jorteDB.getTransaction(["deliver_calendars"], "readwrite");
                    var delCalStore = trans.objectStore("deliver_calendars");
                    delCalStore.add(dc);
                },
                addDeliverEvent: function(de) {
                    var trans = jorteDB.getTransaction(["deliver_events"], "readwrite");
                    var delEvtStore = trans.objectStore("deliver_events");
                    delEvtStore.add(de);
                },
                deleteDeliverCalendarAndEvents: function(calendarId, txCompleteCB) {
                    var trans = jorteDB.getTransaction(["deliver_calendars", "deliver_events"], "readwrite", txCompleteCB,
                            function(e) {
                                console.log('deleteDeliverCalendarAndEvents error', e);
                            }
                    );
                    var delEvtStore = trans.objectStore("deliver_events");
                    var delCalStore = trans.objectStore("deliver_calendars");
                    var req = delEvtStore.index("calendar_id").openCursor(IDBKeyRange.only(parseInt(calendarId)));
                    req.onsuccess = function(evt) {
                        var evtCurs = evt.target.result;
                        if (evtCurs) {
                            var reqDel = evtCurs.delete(evtCurs.value);
                            reqDel.onsuccess = function() {
                                evtCurs.continue();
                            };
                        } else {
                            delCalStore.delete(parseInt(calendarId));
                        }
                    };
                },
                getDeliverEventsList: function(txCompleteCb) {
                    var data = [];
                    var trans = jorteDB.getTransaction(["deliver_calendars", "deliver_events"], "readonly",
                            function() {
                                txCompleteCb(data);
                            },
                            function(evt) {
                                console.log(evt);
                            }
                    );
                    var delEventStore = trans.objectStore("deliver_events");
                    var delCalStore = trans.objectStore("deliver_calendars");
                    var req = delCalStore.index("selected").openCursor(IDBKeyRange.only(1));
                    req.onsuccess = function(evt) {
                        var cur1 = evt.target.result;
                        if (cur1) {
                            var delCal = cur1.value;
                            if (new RegExp("^.*list.*$", "i").test(delCal.disp_type)) {
                                var req = delEventStore.index("calendar_id").openCursor(delCal.id);
                                req.onsuccess = function(evt) {
                                    var cur2 = evt.target.result;
                                    if (cur2) {
                                        var delEvt = cur2.value;
                                        var rec = {};
                                        rec.id = delCal.id, rec.calendar_title = delCal.title, rec.color = delCal.color,
                                                rec.begin = delEvt.begin, rec.end = delEvt.end, rec.title = delEvt.title,
                                                rec.icon_id = delEvt.icon_id, rec.url = delEvt.url, rec.de_id = delEvt.id;
                                        data.push(rec);
                                        cur2.continue();
                                    } else {
                                        cur1.continue();
                                    }
                                };
                            } else {
                                cur1.continue();
                            }
                        }
                    };
                },
                getDeliverCalendar: function(delCalendarId, resultCB, trans) {
                    if (!trans) {
                        trans = jorteDB.getTransaction(["deliver_calendars"], "readonly");
                    }
                    var delCalStore = trans.objectStore("deliver_calendars");
                    var req = delCalStore.get(parseInt(delCalendarId));
                    req.onsuccess = function(evt) {
                        resultCB(evt.target.result);
                    };
                },
                updateDeliverCalendarSelectionFlag: function(calendarId, resultCB) {
                    var trans = jorteDB.getTransaction(["deliver_calendars"], "readwrite");
                    this.getDeliverCalendar(calendarId, function(delCal) {
                        delCal.selected = delCal.selected === 0 ? 1 : 0;
                        updateDeliverCalendar(delCal, resultCB, trans);
                    }, trans);
                },
                updateDeliverCalendarColor: function(calendarId, color, resultCB) {
                    var trans = jorteDB.getTransaction(["deliver_calendars"], "readwrite");
                    this.getDeliverCalendar(calendarId, function(delCal) {
                        delCal.color = color;
                        updateDeliverCalendar(delCal, resultCB, trans);
                    }, trans);
                },
                getDeliverEventsCount: function(startTime, endTime, resultCB, trans) {
                    var events_count = 0;
                    var deliverEventStore = trans.objectStore("deliver_events");
                    var deliverCalStore = trans.objectStore("deliver_calendars");

                    var reqDelCal = deliverCalStore.index("selected").openCursor(IDBKeyRange.only(1));
                    reqDelCal.onsuccess = function(evtDelCal) {
                        var delCalCurs = evtDelCal.target.result;
                        if (delCalCurs) {
                            var delCal = delCalCurs.value;
                            if (new RegExp("^.*calendar.*$", "i").test(delCal.disp_type)) {
                                var range = IDBKeyRange.bound([delCal.id, startTime], [delCal.id, endTime], false, false);
                                var reqDelEvt = deliverEventStore.index("calendar_id+begin").count(range);
                                reqDelEvt.onsuccess = function() {
                                    events_count += reqDelEvt.result;
                                    delCalCurs.continue();
                                };
                            } else {
                                delCalCurs.continue();
                            }
                        } else {
                            resultCB && resultCB(events_count);
                        }
                    };
                }
            };
        });
