'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.font', [])

        // Main service
        .factory('fontSvc', function() {

            return{
                getAllFontValues: function(resultCb) {
                    var fonts = [];
                    var trans = jorteDB.getTransaction(
                            ["fonts"],
                            "readonly",
                            function() {
                                resultCb(fonts);
                            }
                    );
                    var fontStore = trans.objectStore("fonts");
                    var reqFonts = fontStore.openCursor();
                    reqFonts.onsuccess = function(e1) {
                        var cursFonts = e1.target.result;
                        if (cursFonts) {
                            fonts.push(cursFonts.value);
                            cursFonts.continue();
                        }
                    };
                },
                updateFontSelection: function(currentFont, newFont, resultCB) {
                    var trans = jorteDB.getTransaction(
                            ["fonts"],
                            "readwrite",
                            function() {
                                resultCB(newFont);
                            }
                    );

                    var fontStore = trans.objectStore("fonts");

                    var reqFamilyFonts = fontStore.index("font_family").openCursor(IDBKeyRange.only(currentFont));
                    reqFamilyFonts.onsuccess = function(evt) {
                        var cursFamilyFonts = evt.target.result;
                        if (cursFamilyFonts) {
                            cursFamilyFonts.value.is_selected = 0;
                            cursFamilyFonts.update(cursFamilyFonts.value);
                            cursFamilyFonts.continue();
                        } else {
                            if (newFont !== "Roboto") {
                                var reqFamilyFonts2 = fontStore.index("font_family").openCursor(IDBKeyRange.only(newFont));
                                reqFamilyFonts2.onsuccess = function(evt) {
                                    var cursFamilyFonts2 = evt.target.result;
                                    if (cursFamilyFonts2) {
                                        cursFamilyFonts2.value.is_selected = 1;
                                        cursFamilyFonts2.update(cursFamilyFonts2.value);
                                        cursFamilyFonts2.continue();
                                    }
                                };
                            }
                        }
                    };
                },
                deSelectAllFonts: function(resultCB) {
                    var trans = jorteDB.getTransaction(
                            ["fonts"],
                            "readwrite",
                            function() {
                                resultCB();
                            }
                    );
                    var fontStore = trans.objectStore("fonts");
                    var reqSelFonts = fontStore.index("is_selected").openCursor(IDBKeyRange.only(1));
                    reqSelFonts.onsuccess = function(e1) {
                        var cursSelFonts = e1.target.result;
                        if (cursSelFonts) {
                            cursSelFonts.value.is_selected = 0;
                            cursSelFonts.update(cursSelFonts.value);
                            cursSelFonts.continue();
                        }
                    };
                },
                saveFont: function(font, resultCB) {
                    var trans = jorteDB.getTransaction(
                            ["fonts"],
                            "readwrite",
                            function() {
                                resultCB();
                            }
                    );

                    var fontStore = trans.objectStore("fonts");
                    var req = fontStore.index("global_id").openCursor(IDBKeyRange.only(parseInt(font.global_id)));
                    req.onsuccess = function(evt) {
                        var curs = evt.target.result;
                        if (curs) {
                            curs.value.path = font.path;
                            curs.value.font_family = font.font_family;
                            curs.value.is_selected = font.is_selected;
                            curs.value.details = font.details;
                            curs.update(curs.value);

                        } else {
                            var req = fontStore.add(font);
                            req.onerror = function(e) {
                                console.log('insertFont error ', e);
                            };
                            req.onsuccess = function(e) {
                            };
                        }
                    };
                }
            };
        });


