'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.main', [])

        // Main service
        .factory('mainSvc', ['eventSvc', 'taskSvc', 'evtCalendarSvc', 'jortedbSvc', function (eventSvc, taskSvc, evtCalendarSvc, jortedbSvc) {
                var transaction = null;
                function getCalendarData(startTime, endTime, calStart, calEnd, calTypes, fetchTasks, includeCompleted,eventTaskViews, transaction) {
                    var evtToShow = jorteConfig.getEventToShow();
                    var dispCompletedEvt = jorteConfig.getDispCompletedEvent();
                    var repeatEvents = [];
                    eventSvc.getRepeatEventAndInstancesLimit(startTime, endTime, calStart, calEnd, calTypes, evtToShow, dispCompletedEvt, function (resultList) {
                        if (resultList) {
                            repeatEvents = resultList;
                        }
                        eventSvc.getLongEventAndInstancesLimit(startTime, endTime, calStart, calEnd, calTypes, evtToShow, dispCompletedEvt, function (resultList, singleEventList) {
                            for (var i = 0; singleEventList && i < singleEventList.length; i++) {
                                var event = singleEventList[i];
                                if (event.parent && event.originalStartDate) {
                                    var id = '#' + event.parent + '#' + event.originalStartDate;
                                    if (repeatEvents[id] !== undefined) {
                                        delete repeatEvents[id];
                                    }
                                }
                            }
                            if (resultList) {
                                for (var i in resultList) {
                                    eventTaskViews.push(resultList[i]);
                                }
                            }
                        }, transaction);
                        eventSvc.getEventAndInstancesLimit(startTime, endTime, calStart, calEnd, calTypes, evtToShow, dispCompletedEvt, function (resultList, singleEventList) {

                            for (var i = 0; singleEventList && i < singleEventList.length; i++) {
                                var event = singleEventList[i];
                                if (event.parent && event.originalStartDate) {
                                    var id = '#' + event.parent + '#' + event.originalStartDate;
                                    if (repeatEvents[id] !== undefined) {
                                        delete repeatEvents[id];
                                    }
                                }
                            }
                            for (var i in repeatEvents) {
                                eventTaskViews.push(repeatEvents[i]);
                            }
                            for (var i in resultList) {
                                eventTaskViews.push(resultList[i]);
                            }
                        }, transaction);
                    }, transaction);
                    
                    if (fetchTasks) {
                        taskSvc.getTasksAndInstancesForCalendarView(startTime, endTime, includeCompleted, function (resultList) {
                            for (var i in resultList) {
                                eventTaskViews.push(resultList[i]);
                            }
                        }, transaction);
                    }

                    evtCalendarSvc.getDeliverEventsForCalendarView(calStart, calEnd, function (resultList) {
                        for (var i = 0; i < resultList.length; i++) {
                            eventTaskViews.push(resultList[i]);
                        }
                    }, transaction);
                }
                return {
                    loadEventsLimit: function (startTime, endTime, calStart, calEnd, calTypes, fetchTasks, includeCompleted, repeatFlag, resultCB, errorCB) {
                        var eventTaskViews = [];
                        if (transaction) {
                            transaction.abort();
                        } else {
                            transaction = jorteDB.getTransaction(
                                ['calendar', 'event', 'event_instance', 'task', 'task_list', 'deliver_events', 'deliver_calendars'],
                                'readonly',
                                //Success callback
                                function () {
                                    resultCB(eventTaskViews);
                                    transaction = null;
                                },
                                //Error callback
                                function (evt) {
                                    errorCB && errorCB();
                                    transaction = null;
                                }
                            );
                            getCalendarData(startTime, endTime, calStart, calEnd, calTypes, fetchTasks, includeCompleted, eventTaskViews, transaction);
                        }

                        transaction.onabort = function () {
                            // Report when the transaction was successfully aborted
                            transaction = null;
                            transaction = jorteDB.getTransaction(
                                    ['calendar', 'event', 'event_instance', 'task', 'task_list', 'deliver_events', 'deliver_calendars'],
                                    'readonly',
                                    //Success callback
                                    function () {
                                        resultCB(eventTaskViews,true);
                                        transaction = null;
                                    },
                                    //Error callback
                                    function (evt) {
                                        errorCB && errorCB();
                                        transaction = null;
                                    }
                            );
                                getCalendarData(startTime, endTime, calStart, calEnd, calTypes, fetchTasks, includeCompleted, eventTaskViews, transaction);
                        };
                    },
                    getTasksForSort: function (is_advance, taskCount, resultCB) {
                        var taskViews = [];

                        var trans = jortedbSvc.getTransaction(
                                ['task'],
                                'readonly',
                                function () {
                                    resultCB(taskViews);
                                }
                        );

                        taskSvc.getTaskForSortPagination(is_advance, taskCount, function (resRows) {
                            taskViews = resRows;
                        }, trans);
                    },
                    getTaskListDetails: function (task_list_id, is_advance, taskCount, resultCB) {
                        var taskViews = [];

                        var trans = jortedbSvc.getTransaction(
                                ['task_list', 'task'],
                                'readonly',
                                function () {
                                    resultCB(taskViews);
                                }
                        );

                        taskSvc.getTaskForDisplayListPagination(task_list_id, is_advance, taskCount, function (resRows) {
                            taskViews = resRows;
                        }, trans);
                    },
                    getTasksDetails: function (task_list_id, is_advance, taskCount, resultCB) {
                        var taskViews = [];

                        var trans = jortedbSvc.getTransaction(
                                ['task_list', 'task'],
                                'readonly',
                                function () {
                                    resultCB(taskViews);
                                }
                        );

                        taskSvc.getTaskWithTaskListColorPagination(task_list_id, is_advance, taskCount, function (resRows) {
                            taskViews = resRows;
                        }, trans);
                    },
                    getSingleTask: function (task_id, resultCB) {
                        var taskViews = [];

                        var trans = jortedbSvc.getTransaction(
                                ['task_list', 'task'],
                                'readonly',
                                function () {
                                    resultCB(taskViews);
                                }
                        );

                        taskSvc.getSingleTaskWithTaskListColor(task_id, function (resRows) {
                            taskViews = resRows;
                        }, trans);
                    },
                    getSingleTaskDisplayList: function (task_id, resultCB) {
                        var taskViews = [];

                        var trans = jortedbSvc.getTransaction(
                                ['task_list', 'task'],
                                'readonly',
                                function () {
                                    resultCB(taskViews);
                                }
                        );

                        taskSvc.getSingleTaskForDisplayList(task_id, function (resRows) {
                            taskViews = resRows;
                        }, trans);
                    },
                    getSelectedTasksCount: function (resultCB) {
                        var trans = jortedbSvc.getTransaction(
                                ['task_list', 'task'],
                                'readonly',
                                function () {
                                    resultCB && resultCB(list);
                                }
                        );
                        var list = [];
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        var req = taskListStore.index("selected").openCursor(IDBKeyRange.only(1));
                        req.onsuccess = function (evt) {
                            var tlCurs = evt.target.result;
                            if (tlCurs) {
                                var taskList = tlCurs.value;
                                var range = IDBKeyRange.bound([taskList.id, 0], [taskList.id, 0], false, false);

                                var req2 = taskStore.index("task_list_id+deleted").count(range);
                                req2.onsuccess = function () {
                                    var obj = {id: taskList.id, count: req2.result, tlName: taskList.name};
                                    list.push(obj);
                                    tlCurs.continue();
                                };
                            }
                        };
                    },
                    getTasksCount: function (resultCB) {
                        var trans = jortedbSvc.getTransaction(
                                ['task'],
                                'readonly',
                                function () {
                                    resultCB && resultCB(count);
                                }
                        );
                        var count = 0;
                        var taskStore = trans.objectStore("task");
                        var req = taskStore.index("deleted").count([0]);
                        req.onsuccess = function () {
                            count = req.result;
                        };
                    },
                    getEventCalendars: function (resultCB) {
                        evtCalendarSvc.getDeliverCalendarList(resultCB);
                    },
                    /*
                     * get deleted calendars and calendars with dirty flag set With given types, for sync.
                     */
                    getAllCalendarsForSync: function (typeArray, dirtyCheck, resultCB) {
                        var results = [];
                        var trans = jorteDB.getTransaction(["calendar", "deleted_calendars"], "readonly",
                                function () {
                                    resultCB(results);
                                },
                                function (evt) {
                                    console.log(evt);
                                }
                        );
                        var delCalStore = trans.objectStore("deleted_calendars");
                        var calStore = trans.objectStore("calendar");
                        var req = delCalStore.openCursor();
                        req.onsuccess = function (evt) {
                            var delCalCurs = evt.target.result;
                            if (delCalCurs) {
                                var delCal = delCalCurs.value;
                                if ($.inArray(300, typeArray) === -1) {
                                    delCal.deleted_status = 1;
                                    results.push(delCal);
                                }
                                delCalCurs.continue();
                            } else {
                                var req = dirtyCheck ? calStore.index("dirty").openCursor(IDBKeyRange.only(1)) : calStore.openCursor();
                                req.onsuccess = function (evt) {
                                    var calCurs = evt.target.result;
                                    if (calCurs) {
                                        var calendar = calCurs.value;
                                        if ($.inArray(calendar.type, typeArray) >= 0) {
                                            results.push(calendar);
                                        }
                                        calCurs.continue();
                                    }
                                };
                            }
                        };

                    },
                    syncCalendars: function (typeArray, list, callback) {
                        var trans = jorteDB.getTransaction(["calendar", "deleted_calendars"], "readwrite",
                                function () {
                                    callback();
                                },
                                function (evt) {
                                    console.log(evt);
                                }
                        );
                        var delCalStore = trans.objectStore("deleted_calendars");
                        var calStore = trans.objectStore("calendar");
                        var req = calStore.openCursor();
                        req.onsuccess = function (evt) {
                            var calCurs = evt.target.result;
                            if (calCurs) {
                                var calendar = calCurs.value;
                                if ($.inArray(calendar.type, typeArray) >= 0) {
                                    var found = false;
                                    for (var i = 0; i < list.length; i++) {
                                        var aCalendar = list[i];
                                        if (aCalendar.id || calendar.global_id) {
                                            if (calendar.id === aCalendar.id || calendar.global_id === aCalendar.global_id) {
                                                found = true;
                                                calendar.global_id = aCalendar.global_id;
                                                calendar.sync_version = aCalendar.sync_version, calendar.calendar_rule = aCalendar.calendar_rule,
                                                        calendar.type = aCalendar.type, calendar.name = aCalendar.name,
                                                        calendar.description = aCalendar.description, calendar.timezone = aCalendar.timezone,
                                                        calendar.owner_account = aCalendar.owner_account, calendar.sync_account = aCalendar.sync_account,
                                                        calendar.seqno = aCalendar.seqno, calendar.create_date = aCalendar.create_date,
                                                        calendar.update_date = aCalendar.update_date, calendar.sync_events = aCalendar.sync_events,
                                                        calendar.dirty = aCalendar.dirty,
                                                        calendar.is_public = aCalendar.is_public, calendar.is_share = aCalendar.is_share;
                                                calCurs.update(calendar);
                                                list.splice(i, 1); //processed or moved
                                                break;
                                            }
                                        }
                                    }
                                    if (!found) { //item only in local db, not in Jorte
                                        calCurs.delete(calendar);
                                    }
                                }
                                calCurs.continue();
                            } else {
                                for (var i = 0; i < list.length; i++) {
                                    calStore.add(list[i]);
                                }
                            }
                        };
                        var reqDelCal = delCalStore.openCursor();
                        reqDelCal.onsuccess = function (evt) {
                            var delCalCurs = evt.target.result;
                            if (delCalCurs) {
                                var delCal = delCalCurs.value;
                                if ($.inArray(300, typeArray) === -1) {
                                    delCalCurs.delete(delCal);
                                }
                                delCalCurs.continue();
                            }
                        };
                    },
                    getSelectedCalendars: function (resultCB) {
                        var calendars = [];
                        var trans = jorteDB.getTransaction('calendar', 'readonly', function () {
                            resultCB(calendars);
                        });
                        var jorteAccount = jorteConfig.getJorteSync() || null;
                        var jorteId = null;
                        if (jorteAccount) {
                            jorteId = jorteAccount.jorteId;
                        }
                        trans.objectStore('calendar').index('selected')
                                .openCursor(IDBKeyRange.only(1))
                                .onsuccess = function (event) {
                                    var res = event.target.result;
                                    if (res) {
                                        var cal = res.value;
                                        if (cal.type === 0 && cal.owner_account === jorteId && jorteConfig.getJorteCalendarEnabled()) {
                                            calendars.push(cal);
                                        } else if (cal.type === 300 && cal.is_public && jorteConfig.getGoogleCalendarEnabled()) {
                                            calendars.push(cal);
                                        }
                                        res.continue();
                                    }
                                };
                    },
                    getSingleCalendarForSync: function (params, resultCB) {
                        var results = [];
                        var id = params.calendar_id;
                        var calendar_type = params.calendar_type, del_global_id = params.del_global_id;
                        var trans = jorteDB.getTransaction(["deleted_calendars", "calendar"], "readonly",
                                function () {
                                    resultCB(results);
                                },
                                function (evt) {
                                    console.log('task txn ', evt);
                                }
                        );
                        var delCalStore = trans.objectStore("deleted_calendars");
                        var CalStore = trans.objectStore("calendar");
                        if (del_global_id) {
                            var req = delCalStore.index("global_id").openCursor(IDBKeyRange.only(del_global_id));
                            req.onsuccess = function (evt) {
                                var delCalCurs = evt.target.result;
                                if (delCalCurs) {
                                    var delTask = delCalCurs.value;
                                    if ($.inArray(300, calendar_type) === -1) {
                                        delTask.deleted_status = 1;
                                        results.push(delTask);
                                    }
                                }
                            };
                        } else {
                            var req = CalStore.get(id);
                            req.onsuccess = function (evt) {
                                var req = CalStore.get(id);
                                req.onsuccess = function (evt) {
                                    var cal = evt.target.result;
                                    if (cal) {
                                        results.push(cal);
                                    }
                                };
                            };
                        }
                    },
                    loadEventsTaskCount: function (startTime, endTime, fetchTasks, includeCompleted, resultCB, errorCB) {
                        var totalCount = 0;
                        var trans = jorteDB.getTransaction(
                                ['calendar', 'event', 'event_instance', 'task', 'task_list', 'deliver_calendars', 'deliver_events'],
                                'readonly',
                                function () {
                                    resultCB(totalCount);
                                },
                                function (evt) {
                                    console.log(evt);
                                    errorCB && errorCB();
                                }
                        );

                        var evtToShow = jorteConfig.getEventToShow();
                        var dispCompletedEvt = jorteConfig.getDispCompletedEvent();

                        eventSvc.getEventsCount(startTime, endTime, evtToShow, dispCompletedEvt, function (result) {
                            totalCount += result;
                        }, trans);

                        if (fetchTasks) {
                            taskSvc.getTasksCount(startTime, endTime, includeCompleted, function (result) {
                                totalCount += result;
                            }, trans);
                        }

                        evtCalendarSvc.getDeliverEventsCount(startTime, endTime, function (result) {
                            totalCount += result;
                        }, trans);
                    }
                };
            }]);