'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.reminder', [])

        // Main service
        .factory('reminderSvc', ['notificationHelperSvc', function(notificationHelperSvc) {
                return {
                    addReminders: function(newReminders) {
                        if (navigator.mozAlarms) {
                            var now = new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDate(), new Date().getHours(), new Date().getMinutes()-1, 0);
                            for (var j = 0; j < newReminders.length; j++) {
                                var newReminder = newReminders[j];
                                if (newReminder.beginDates) {
                                    var beginDates = newReminder.beginDates;
                                    for (var i = 0; i < beginDates.length; i++) {
                                        var notifyTime = beginDates[i] - (newReminder.minutes * 60000);
                                        var alarmTime = jorteUtils.formatDate(new Date(notifyTime), 'MMM dd, yyyy HH:mm:00');
                                        if (new Date(notifyTime).getTime() >= now.getTime()) {
                                            notificationHelperSvc.setAlarm(alarmTime, 'reminder_notification');
                                        }
                                    }
                                }
                            }
                        } else {
                            console.log("Browser does not support alarm");
                        }
                    },
                    //for showItems()
                    getAllReminderItems: function(txCompleteCB) {
                        var data = [];
                        var trans = jorteDB.getTransaction(["event", "event_instance", "task"], "readonly",
                                function() {
                                    txCompleteCB(data);
                                },
                                function(e) {
                                    console.log("getAllReminderItems tx error", e);
                                }
                        );

                        var instStore = trans.objectStore("event_instance");
                        var eventStore = trans.objectStore("event");
                        var taskStore = trans.objectStore("task");

                        var req = instStore.index("reminder_status").openCursor(IDBKeyRange.only(1));
                        var tempEvents = []; //temp events and task for caching events/task once loaded, avoid db fetching
                        var tempTasks = [];
                        function fetchEvent(event, inst, c1, data) {
                            if (event.status === 1) {
                                var rec = {};
                                rec.id = inst.id, rec.name = event.name, rec.event_id = event.id, rec.task_id = null,
                                        rec.location = event.location, rec.color = event.color, rec.importance = event.importance,
                                        rec.completed = event.completed, rec.event_start_time = inst.begin,
                                        rec.event_end_time = inst.end;
                                data.push(rec);
                            }
                            c1.continue();
                        }
                        function fetchTask(task, inst, c1, data) {
                            if (task.status === 1) {
                                var rec = {};
                                rec.id = inst.id, rec.name = task.name, rec.event_id = null, rec.task_id = task.id,
                                        rec.location = task.location, rec.color = task.color, rec.importance = task.importance,
                                        rec.completed = task.completed, rec.event_start_time = inst.begin,
                                        rec.event_end_time = inst.end;
                                data.push(rec);
                            }
                            c1.continue();
                        }
                        req.onsuccess = function(e1) {
                            var c1 = e1.target.result;
                            if (c1) {
                                var inst = c1.value;
                                if (inst.event_id && inst.event_id !== null) {
                                    var oldEvt = tempEvents[inst.event_id];
                                    if (oldEvt) {
                                        fetchEvent(oldEvt, inst, c1, data);
                                    } else {
                                        var evtStoreReq = eventStore.get(inst.event_id);
                                        evtStoreReq.onsuccess = function(e2) {
                                            var event = e2.target.result;
                                            if (event) {
                                                tempEvents[event.id] = event;
                                                fetchEvent(event, inst, c1, data);
                                            } else {
                                                c1.continue();
                                            }
                                        };
                                    }
                                } else if (inst.task_id && inst.task_id !== null) {
                                    var oldTask = tempTasks[inst.task_id];
                                    if (oldTask) {
                                        fetchTask(oldTask, inst, c1, data);
                                    } else {
                                        var taskStoreReq = taskStore.get(inst.task_id);
                                        taskStoreReq.onsuccess = function(e2) {
                                            var task = e2.target.result;
                                            if (task) {
                                                tempTasks[task.id] = task;
                                                fetchTask(task, inst, c1, data);
                                            } else {
                                                c1.continue();
                                            }
                                        };
                                    }
                                } else {
                                    //no event or task with the instance.
                                    c1.continue();
                                }
                            } else {

                                for (var i = 0; i < data.length; i++) {
                                    for (var j = 0; j < data.length - 1 - i; j++) {
                                        if (data[j].event_start_time > data[j + 1].event_start_time) {
                                            var tmp = data[j];
                                            data[j] = data[j + 1];
                                            data[j + 1] = tmp;
                                        }
                                    }
                                }
                            }
                        };
                    },
                    //for clearAll()
                    clearAllReminders: function(txCompleteCB) {
                        var trans = jorteDB.getTransaction(["event_instance"], "readwrite",
                                function() {
                                    txCompleteCB();
                                },
                                function(e) {
                                    console.log("clearAllReminders tx error ", e);
                                }
                        );

                        var instStore = trans.objectStore("event_instance");
                        var instReq = instStore.index("reminder_status").openCursor(IDBKeyRange.only(1));
                        instReq.onsuccess = function(e1) {
                            var c1 = e1.target.result;
                            if (c1) {
                                var inst = c1.value;
                                inst.reminder_status = 2;
                                c1.update(inst);
                                c1.continue();
                            }
                        };
                    },
                    //for reminder - snoozAll()
                    getInstancesHavingReminder: function(txCompleteCB) {
                        var data = [];
                        var trans = jorteDB.getTransaction(["event_instance"], "readonly",
                                function() {
                                    txCompleteCB(data);
                                },
                                function(e) {
                                    console.log("getInstancesHavingReminder tx error ", e);
                                }
                        );

                        var instStore = trans.objectStore("event_instance");
                        var instReq = instStore.index("reminder_status").openCursor(IDBKeyRange.only(1));
                        instReq.onsuccess = function(e1) {
                            var c1 = e1.target.result;
                            if (c1) {
                                var inst = c1.value;
                                data.push(inst.id);
                                c1.continue();
                            }
                        };
                    },
                    //for reminder-helper checkReminder();
                    getAllItemsWithReminder: function(cDate, txCompleteCB) {

                        var trans = jorteDB.getTransaction(["event", "event_instance", "task"], "readonly",
                                function() {
                                    txCompleteCB(data);
                                },
                                function(e) {
                                    console.log("getInstancesHavingReminder tx error ", e);
                                }
                        );

                        var instStore = trans.objectStore("event_instance");
                        var eventStore = trans.objectStore("event");
                        var taskStore = trans.objectStore("task");

                        var req1 = instStore.openCursor();
                        var data = [];
                        var tempEvents = [];
                        var tempTasks = [];

                        function fetchEvtRems(rems, event, inst, c1, data) {
                            for (var i = 0; i < rems.length; i++) {
                                var rem = rems[i];
                                var reminder_time = inst.begin - (rem.minutes * 60000);
                                if (cDate.getTime() === reminder_time) {
                                    var rec = {};
                                    rec.name = event.name, rec.location = event.location, rec.event_id = event.id,
                                            rec.task_id = null, rec.id = inst.id, rec.event_time = inst.begin, rec.minutes = rem.minutes,
                                            rec.reminder_time = reminder_time;
                                    data.push(rec);
                                }
                            }
                            c1.continue();
                        }
                        function fetchEvent(event, inst, c1, data) {
                            if (event.status === 1) {
                                if (event.reminders && event.reminders !== null) {
                                    fetchEvtRems(event.reminders, event, inst, c1, data);
                                }
                            } else {
                                c1.continue();
                            }
                        }
                        function fetchTskRems(rems, task, inst, c1, data) {
                            for (var i = 0; i < rems.length; i++) {
                                var rem = rems[i];
                                var reminder_time = inst.begin - (rem.minutes * 60000);
                                if (cDate.getTime() === reminder_time) {
                                    var rec = {};
                                    rec.name = task.name, rec.location = task.location, rec.event_id = null,
                                            rec.task_id = task.id, rec.id = inst.id, rec.event_time = inst.begin, rec.minutes = rem.minutes,
                                            rec.reminder_time = reminder_time;
                                    data.push(rec);
                                }
                            }
                            c1.continue();
                        }

                        function fetchTask(task, inst, c1, data) {
                            if (task.status === 1) {
                                if (task.reminders && task.reminders !== null) {
                                    fetchTskRems(task.reminders, task, inst, c1, data);
                                }
                            } else {
                                c1.continue();
                            }
                        }
                        req1.onsuccess = function(e1) {
                            var c1 = e1.target.result;
                            if (c1) {
                                var inst = c1.value;

                                if (inst.event_id && inst.event_id !== null) {
                                    var oldEvt = tempEvents[inst.event_id];
                                    if (oldEvt) {
                                        fetchEvent(oldEvt, inst, c1, data);
                                    } else {
                                        var req2 = eventStore.get(inst.event_id);
                                        req2.onsuccess = function(e2) {
                                            var event = e2.target.result;
                                            if (event) {
                                                tempEvents[event.id] = event;
                                                fetchEvent(event, inst, c1, data);
                                            } else {
                                                c1.continue();
                                            }
                                        };
                                    }
                                } else if (inst.task_id && inst.task_id !== null) {
                                    var oldTask = tempTasks[inst.task_id];
                                    if (oldTask) {
                                        fetchTask(oldTask, inst, c1, data);
                                    } else {
                                        var taskStoreReq = taskStore.get(inst.task_id);
                                        taskStoreReq.onsuccess = function(e2) {
                                            var task = e2.target.result;
                                            if (task) {
                                                tempTasks[task.id] = task;
                                                fetchTask(task, inst, c1, data);
                                            } else {
                                                c1.continue();
                                            }
                                        };
                                    }
                                } else {
                                    //no event or task with the instance.
                                    c1.continue();
                                }
                            }
                        };
                    },
                    // for reminder helper snoozeAlert()
                    getEventsAndTaskByInstanceId: function(ids, txCompleteCB) {
                        var data = [];

                        var trans = jorteDB.getTransaction(["event", "event_instance", "task"], "readonly",
                                function() {
                                    txCompleteCB(data);
                                },
                                function(e) {
                                    console.log("getEventsAndTaskByInstanceId tx error ", e);
                                }
                        );

                        var instStore = trans.objectStore("event_instance");
                        var eventStore = trans.objectStore("event");
                        var taskStore = trans.objectStore("task");

                        var checkIds = ids;
                        var tempEvents = [];
                        var tempTasks = [];

                        var ii = 0; //instance index
                        instFetch();
                        function instFetch() {
                            if (ii >= checkIds.length) {
                                for (var i = 0; i < data.length; i++) {
                                    for (var j = 0; j < data.length - 1 - i; j++) {
                                        if (data[j].begin > data[j + 1].begin) {
                                            var tmp = data[j];
                                            data[j] = data[j + 1];
                                            data[j + 1] = tmp;
                                        }
                                    }
                                }
                                return;
                            }
                            var req1 = instStore.get(parseInt(checkIds[ii]));
                            ii++;
                            req1.onsuccess = function(e1) {
                                var inst = e1.target.result;
                                if (inst) {
                                    var rec = {};
                                    if (inst.event_id) {
                                        var oldEvt = tempEvents[inst.event_id];

                                        if (oldEvt) {

                                            rec.id = inst.id, rec.name = oldEvt.name, rec.event_id = oldEvt.id, rec.task_id = null,
                                                    rec.location = oldEvt.location, rec.color = oldEvt.color, rec.importance = oldEvt.importance,
                                                    rec.completed = oldEvt.completed, rec.event_start_time = inst.begin,
                                                    rec.event_end_time = inst.end;
                                            data.push(rec);
                                            instFetch();
                                        } else {
                                            var req2 = eventStore.get(inst.event_id);
                                            req2.onsuccess = function(e2) {
                                                var event = e2.target.result;
                                                if (event) {
                                                    tempEvents[event.id] = event;

                                                    rec.id = inst.id, rec.name = event.name, rec.event_id = event.id, rec.task_id = null,
                                                            rec.location = event.location, rec.color = event.color, rec.importance = event.importance,
                                                            rec.completed = event.completed, rec.event_start_time = inst.begin,
                                                            rec.event_end_time = inst.end;
                                                    //data.push({name: event.name, begin: inst.begin});
                                                    data.push(rec);
                                                    instFetch();
                                                } else {
                                                    instFetch();
                                                }
                                            };
                                        }
                                    } else if (inst.task_id) {
                                        var oldTask = tempTasks[inst.task_id];
                                        if (oldTask) {
                                            rec.id = inst.id, rec.name = oldTask.name, rec.event_id = null, rec.task_id = oldTask.id,
                                                    rec.location = oldTask.location, rec.color = oldTask.color, rec.importance = oldTask.importance,
                                                    rec.completed = oldTask.completed, rec.event_start_time = inst.begin,
                                                    rec.event_end_time = inst.end;
                                            data.push(rec);
                                            instFetch();
                                        } else {
                                            var taskStoreReq = taskStore.get(inst.task_id);
                                            taskStoreReq.onsuccess = function(e2) {
                                                var task = e2.target.result;
                                                if (task) {
                                                    tempTasks[task.id] = task;
                                                    rec.id = inst.id, rec.name = task.name, rec.event_id = null, rec.task_id = task.id,
                                                            rec.location = task.location, rec.color = task.color, rec.importance = task.importance,
                                                            rec.completed = task.completed, rec.event_start_time = inst.begin,
                                                            rec.event_end_time = inst.end;
                                                    data.push(rec);
                                                    instFetch();
                                                } else {
                                                    instFetch();
                                                }
                                            };
                                        }
                                    } else { //no event or task
                                        instFetch();
                                    }
                                } else { //no instance for id
                                    instFetch();
                                }
                            };
                        }
                    },
                    inspectItemInstances: function(itemId, isEvent, dateA, dateB, txCompleteCB) {
                        var data = [];

                        var trans = jorteDB.getTransaction(["event", "task", "event_instance"], "readonly",
                                function() {
                                    txCompleteCB(data);
                                },
                                function(e) {
                                    console.log("getEventsAndTaskByInstanceId tx error ", e);
                                }
                        );

                        var instStore = trans.objectStore("event_instance");
                        var eventStore = trans.objectStore("event");
                        var taskStore = trans.objectStore("task");

                        var req1 = isEvent ? eventStore.get(parseInt(itemId)) : taskStore.get(parseInt(itemId));
                        req1.onsuccess = function(e1) {
                            var item = e1.target.result;
                            if (item.status === 1 &&
                                    (isEvent ? (item.end_date === null || item.end_date > dateA || item.end_date <= item.start_date)
                                            : (item.due_date === null || item.due_date > dateA || item.due_date <= item.start_date))) {

                                var reminders = item.reminders;
                                var req2 = instStore.index(isEvent ? "event_id" : "task_id").openCursor(IDBKeyRange.only(item.id));
                                var instances = [];
                                req2.onsuccess = function(e2) {
                                    var c2 = e2.target.result;
                                    if (c2) {
                                        var inst = c2.value;
                                        instances.push(inst);
                                        c2.continue();
                                    } else {
                                        for (var i = 0; i < instances.length; i++) {
                                            var inst = instances[i];
                                            for (var j = 0; j < reminders.length; j++) {
                                                var rem = reminders[j];
                                                var reminder_time = inst.begin - (rem.minutes * 60000);
                                                if (reminder_time >= dateB && reminder_time <= dateA) {
                                                    var rec = {};
                                                    rec.id = inst.id, rec.event_time = inst.begin, rec.reminder_time = reminder_time;
                                                    data.push(rec);
                                                }
                                            }
                                        }

                                        for (var i = 0; i < data.length; i++) {
                                            for (var j = 0; j < data.length - 1 - i; j++) {
                                                if (data[j].reminder_time < data[j + 1].reminder_time) {
                                                    var tmp = data[j];
                                                    data[j] = data[j + 1];
                                                    data[j + 1] = tmp;
                                                }
                                            }
                                        }

                                    }
                                };
                            }
                        };
                    },
                    activateReminders: function(checkIds, date, item, notifyCB) {

                        var updateOnly = !date ? true : false;
                        var trans = jorteDB.getTransaction(["event", "task", "event_instance"], "readwrite",
                                function() {
                                },
                                function(e) {
                                    console.log("getEventsAndTaskByInstanceId tx error ", e);
                                }
                        );

                        var instStore = trans.objectStore("event_instance");
                        var eventStore = trans.objectStore("event");
                        var taskStore = trans.objectStore("task");

                        var ii = 0;
                        updateStatus();
                        function updateStatus() {
                            if (ii >= checkIds.length) {
                                updateComplete();
                                return;
                            }
                            var req1 = instStore.get(parseInt(checkIds[ii]));
                            req1.onsuccess = function(e1) {
                                var inst = e1.target.result;
                                if (inst) {
                                    inst.reminder_status = !date ? 2 : 1;
                                    var req2 = instStore.put(inst);
                                    req2.onsuccess = function() {
                                        ii++;
                                        updateStatus();
                                    };
                                }
                            };
                        }
                        function updateComplete() {
                            var count = 0;
                            date = date || new Date();
                            var req3 = instStore.index("reminder_status").count(1);
                            req3.onsuccess = function() {
                                count += req3.result;
                                doCount(count);
                            };
                        }
                        var data = [];
                        var tempEvents = [];
                        var tempTasks = [];
                        function fetchEvent(event, inst, c1, data) {
                            if (event.status === 1) {
                                var rec = {};
                                rec.id = inst.id, rec.name = event.name, rec.event_id = event.id, rec.task_id = null,
                                        rec.location = event.location, rec.color = event.color, rec.importance = event.importance,
                                        rec.completed = event.completed, rec.event_start_time = inst.begin,
                                        rec.event_end_time = inst.end;
                                data.push(rec);
                            }
                            c1.continue();
                        }
                        function fetchTask(task, inst, c1, data) {
                            if (task.status === 1) {
                                var rec = {};
                                rec.id = inst.id, rec.name = task.name, rec.event_id = null, rec.task_id = task.id,
                                        rec.location = task.location, rec.color = task.color, rec.importance = task.importance,
                                        rec.completed = task.completed, rec.event_start_time = inst.begin,
                                        rec.event_end_time = inst.end;
                                data.push(rec);
                            }
                            c1.continue();
                        }
                        function doCount(count) {
                            if (count > 0) {
                                if (item) {
                                    processNotification(item, count, date, updateOnly);
                                } else {
                                    var req1 = instStore.index("reminder_status").openCursor(IDBKeyRange.only(1));
                                    req1.onsuccess = function(e1) {
                                        var c1 = e1.target.result;
                                        if (c1) {
                                            var inst = c1.value;
                                            if (inst.event_id && inst.event_id !== null) {
                                                var oldEvt = tempEvents[inst.event_id];
                                                if (oldEvt) {
                                                    fetchEvent(oldEvt, inst, c1, data);
                                                } else {
                                                    var req2 = eventStore.get(inst.event_id);
                                                    req2.onsuccess = function(e2) {
                                                        var event = e2.target.result;
                                                        if (event) {
                                                            tempEvents[event.id] = event;
                                                            fetchEvent(event, inst, c1, data);
                                                        } else {
                                                            c1.continue();
                                                        }
                                                    };
                                                }
                                            } else if (inst.task_id && inst.task_id !== null) {
                                                var oldTask = tempTasks[inst.task_id];
                                                if (oldTask) {
                                                    fetchTask(oldTask, inst, c1, data);
                                                } else {
                                                    var taskStoreReq = taskStore.get(inst.task_id);
                                                    taskStoreReq.onsuccess = function(e2) {
                                                        var task = e2.target.result;
                                                        if (task) {
                                                            tempTasks[task.id] = task;
                                                            fetchTask(task, inst, c1, data);
                                                        } else {
                                                            c1.continue();
                                                        }
                                                    };
                                                }
                                            } else {
                                                //no event or task with the instance.
                                                c1.continue();
                                            }
                                        } else {
                                            for (var i = 0; i < data.length; i++) {
                                                for (var j = 0; j < data.length - 1 - i; j++) {
                                                    if (data[j].event_start_time > data[j + 1].event_start_time) {
                                                        var tmp = data[j];
                                                        data[j] = data[j + 1];
                                                        data[j + 1] = tmp;
                                                    }
                                                }
                                            }
                                            if (data.length > 0) {
                                                processNotification(data[0], count, date, updateOnly);
                                            }
                                        }
                                    };
                                }
                            } else {
                                notifyCB(0);
                            }
                        }

                        function processNotification(item, count, date, updateOnly) {
                            var options = {
                                item: item,
                                count: count,
                                date: date,
                                updateOnly: updateOnly
                            };
                            notifyCB(options);
                        }
                    }
                };
            }]);