'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.search', [])

        // Search service
        .factory('searchSvc', ['eventSvc', 'taskSvc', function (eventSvc, taskSvc) {
                return {
                    getSearchList: function (startTime, endTime, calStart, calEnd, calTypes, fetchTasks, includeCompleted, repeatFlag, keyWord, resultCB, errorCB) {
                        var eventTaskViews = [];

                        var trans = jorteDB.getTransaction(
                            ['calendar', 'event', 'event_instance', 'task', 'task_list'],
                            'readonly',
                            //Success callback
                            function () {
                                resultCB(eventTaskViews);
                            },
                            //Error callback
                            function (evt) {
                                console.log(evt);
                                errorCB && errorCB();
                            }
                        );
                    var evtToShow = jorteConfig.getEventToShow();
                    var dispCompletedEvt = jorteConfig.getDispCompletedEvent();
                    var repeatEvents = [];
                    eventSvc.getRepeatEventAndInstancesLimit(startTime, endTime, calStart, calEnd, calTypes, evtToShow, dispCompletedEvt, function (resultList) {
                        if (resultList) {
                            repeatEvents = resultList;
                        }
                        eventSvc.getLongEventAndInstancesLimit(startTime, endTime, calStart, calEnd, calTypes, evtToShow, dispCompletedEvt, function (resultList, singleEventList) {
                            for (var i = 0; singleEventList && i < singleEventList.length; i++) {
                                var event = singleEventList[i];
                                if (event.parent && event.originalStartDate) {
                                    var id = '#' + event.parent + '#' + event.originalStartDate;
                                    if (repeatEvents[id] !== undefined) {
                                        delete repeatEvents[id];
                                    }
                                }
                            }
                            if (resultList) {
                                for (var i in resultList) {
                                    eventTaskViews.push(resultList[i]);
                                }
                            }
                        }, trans);
                        eventSvc.getEventAndInstancesLimit(startTime, endTime, calStart, calEnd, calTypes, evtToShow, dispCompletedEvt, function (resultList, singleEventList) {
                            for (var i = 0; singleEventList && i < singleEventList.length; i++) {
                                var event = singleEventList[i];
                                if (event.parent && event.originalStartDate) {
                                    var id = '#' + event.parent + '#' + event.originalStartDate;
                                    if (repeatEvents[id] !== undefined) {
                                        delete repeatEvents[id];
                                    }
                                }
                            }
                            for (var i in repeatEvents) {
                                eventTaskViews.push(repeatEvents[i]);
                            }
                            for (var i in resultList) {
                                eventTaskViews.push(resultList[i]);
                            }
                        }, trans);
                    }, trans);
                    
                    if (fetchTasks) {
                        taskSvc.getTasksAndInstancesForCalendarView(startTime, endTime, includeCompleted, function (resultList) {
                            for (var i in resultList) {
                                eventTaskViews.push(resultList[i]);
                            }
                        }, trans);
                    }
                    }
                };
            }]);