'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.task', [])

        // Task service
        .factory('taskSvc', ['reminderSvc', function(reminderSvc) {
                function initTransForTaskUpdate(completeCB, errorCB) {
                    return jorteDB.getTransaction(["event_instance", "task"], "readwrite", completeCB, errorCB);
                }
                function makeTaskViews(taskList, task, instance) {
                    var view = new EventTaskView();
                    view.id = task.id,
                            view.instance_id = instance.id,
                            view.name = task.name,
                            view.icon = null,
                            view.all_day = null,
                            view.color = null,
                            view.location = null,
                            view.memo = task.memo,
                            view.begin = instance.begin,
                            view.end = instance.end,
                            view.start_date = task.start_date,
                            view.end_date = task.due_date,
                            view.completed = task.completed,
                            view.importance = task.importance,
                            view.holiday = null,
                            view.type = 1,
                            view.repeat = null,
                            view.last_date = null,
                            view.provider = null,
                            view.cal_color = taskList.color,
                            view.timezone = task.timezone,
                            view.icon_only = null,
                            view.icon_map = null,
                            view.icon_id = null,
                            view.disp_type = null,
                            view.isdeliverCalendar = 2,
                            view.start_time = task.start_time,
                            view.end_time = task.due_time;
                    return view;
                }
                function makeSearchTaskViews(task, instance) {
                    var view = {};
                    view.color = task.color, view.id = task.id, view.type = 1, view.calendar_id = task.calendar_id,
                            view.name = task.name, view.location = task.location, view.start_time = task.start_time,
                            view.end_time = task.due_time, view.begin = instance.begin, view.end = instance.end,
                            view.importance = task.importance, view.completed = task.completed,
                            view.cal_color = null;
                    return view;
                }
                function updateTask(aTask, successCB, trans) {
                    var taskStore = trans.objectStore("task");
                    var req = taskStore.put(aTask);
                    req.onerror = function(evt) {
                        console.log('updateTask error ', evt);
                    };
                    req.onsuccess = function() {
                        successCB && successCB();
                    };
                }
                function getTaskForUpdate(taskId, resultCB, trans) {
                    var taskStore = trans.objectStore("task");
                    var req = taskStore.get(parseInt(taskId));
                    req.onerror = function(e) {
                        console.log('getTaskForUpdate error ', e);
                    };
                    req.onsuccess = function(e) {
                        resultCB(e.target.result);
                    };
                }
                function updateTaskList(taskList, successCB, trans) {
                    var taskListStore = trans.objectStore("task_list");
                    var req = taskListStore.put(taskList);
                    req.onsuccess = function() {
                        successCB && successCB();
                    };
                }
                function updateTaskInstances(aTask, updateCompletedCB, trans) {
                    var instanceStore = trans.objectStore("event_instance");
                    var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(aTask.id));
                    req.onerror = function(evt) {
                        console.log('updateTaskInstances error ', evt);
                    };
                    req.onsuccess = function (evt) {
                        var instanceCurs = evt.target.result;
                        if (instanceCurs) {
                            instanceCurs.value.begin = aTask.start_date;
                            instanceCurs.value.end = aTask.due_date;
                            var req = instanceCurs.update(instanceCurs.value);
                            req.onerror = function(evt) {
                                console.log('Instance update error ', evt);
                            };
                            instanceCurs.continue();
                        } else {
                            updateCompletedCB && updateCompletedCB();
                        }
                    };
                }
                function saveTaskInstances(instance, successCB, trans) {
                    var instanceStore = trans.objectStore("event_instance");
                    var req = instanceStore.add(instance);
                    req.onerror = function(evt) {
                        console.log('saveTaskInstances ', evt);
                    };
                    req.onsuccess = function(evt) {
                        successCB && successCB(evt.target.result);
                    };
                }
                function addTask(aTask, successCB, trans) {
                    var taskStore = trans.objectStore("task");
                    var req = taskStore.add(aTask);
                    req.onerror = function(evt) {
                        console.log('addTask error ', evt);
                    };
                    req.onsuccess = function(e) {
                        successCB && successCB(e.target.result);
                    };
                }

                function addTaskList(taskList, successCB, trans) {
                    var taskListStore = trans.objectStore("task_list");
                    var req = taskListStore.add(taskList);
                    req.onsuccess = function(evt) {
                        successCB && successCB(evt.target.result);
                    };
                }

                function deleteTaskInstances(taskId, successCB, trans) {
                    var instanceStore = trans.objectStore("event_instance");
                    var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(parseInt(taskId)));
                    req.onsuccess = function(evt) {
                        var instCurs = evt.target.result;
                        if (instCurs) {
                            instCurs.delete(instCurs.value);
                            instCurs.continue();
                        } else {
                            successCB && successCB();
                        }
                    };
                }

                function syncTaskInsertion(insertList, callback) {
                    var trans = jorteDB.getTransaction(
                            ["task", "event_instance"],
                            "readwrite",
                            callback,
                            function(e) {
                                console.log(e);
                            }
                    );
                    var taskStore = trans.objectStore("task");
                    var insertTask = function(i) {
                        if (i >= insertList.length) {
                            return;
                        }
                        var newTsk = insertList[i];
                        var tskObj = {};
                        $.extend(tskObj, newTsk);
                        delete tskObj.instances;
                        if (newTsk.reminders && newTsk.reminders.length > 0) {
                            reminderSvc.addReminders(newTsk.reminders);
                        }
                        var req = taskStore.add(tskObj);
                        req.onsuccess = function(evt) {
                            var taskId = evt.target.result;
                            for (var k = 0; k < newTsk.instances.length; k++) {
                                var anInstance = newTsk.instances[k];
                                anInstance.task_id = taskId;
                                saveTaskInstances(anInstance, null, trans);
                            }

                            insertTask(++i);
                        };
                    };

                    insertTask(0);
                }

                function syncTaskUpdation(updatedList, callback) {
                    var trans = jorteDB.getTransaction(
                            ["task", "event_instance"],
                            "readwrite",
                            callback,
                            function(e) {
                                console.log(e);
                            }
                    );

                    var updateTasks = function(i) {
                        if (i >= updatedList.length) {
                            return;
                        }
                        var locTask = updatedList[i];
                        var tskObj = {};
                        $.extend(tskObj, locTask);
                        delete tskObj.instances;
                        if (locTask.reminders && locTask.reminders.length > 0) {
                            reminderSvc.addReminders(locTask.reminders);
                        }
                        updateTask(tskObj, function() {
                            deleteTaskInstances(locTask.id, function() {
                                var instances = locTask.instances;
                                for (var k = 0; k < instances.length; k++) {
                                    var anInstance = instances[k];
                                    anInstance.task_id = locTask.id;
                                    saveTaskInstances(anInstance, null, trans);
                                }
                            }, trans);
                            updateTasks(++i);
                        }, trans);

                    };

                    updateTasks(0);
                }

                function syncTaskDeletion(deleteList, callback) {
                    var trans = jorteDB.getTransaction(
                            ["task", "event_instance"],
                            "readwrite",
                            callback,
                            function(e) {
                                console.log(e);
                            }
                    );
                    var taskStore = trans.objectStore("task");
                    var deleteTasks = function(i) {
                        if (i >= deleteList.length) {
                            callback();
                            return;
                        }
                        var taskId = parseInt(deleteList[i].id);
                        var req1 = taskStore.delete(taskId);
                        req1.onsuccess = function(e1) {
                            deleteTaskInstances(taskId, null, trans);
                            deleteTasks(++i);
                        };
                    };
                    deleteTasks(0);
                }
                return {
                    getTaskWithTaskListColorPagination: function (task_list_id, is_advance, taskCount, resultCB, trans) {
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        var eventTaskViews = [];
                        var req = taskListStore.get(parseInt(task_list_id));
                        req.onsuccess = function (evt) {
                            var taskList = evt.target.result;
                            if (taskList) {
                                var range = IDBKeyRange.bound([taskList.id, 0], [taskList.id, 0], false, false);
                                var req = taskStore.index("task_list_id+deleted").openCursor(range);
                                req.onsuccess = function (evt) {
                                    var taskCurs = evt.target.result;
                                    if (is_advance === true) {
                                        taskCurs.advance(taskCount);
                                        is_advance = false;
                                    }
                                    else {
                                        if (taskCurs) {
                                            var task = taskCurs.value;
                                            if (!task.deleted) {
                                                var view = {};
                                                view.id = task.id, view.name = task.name, view.color = null, view.start_date = task.start_date,
                                                        view.due_date = task.due_date, view.start_time = task.start_time, view.due_time = task.due_time,
                                                        view.completed = task.completed, view.importance = task.importance, view.location = null,
                                                        view.icon = null, view.type = 1, view.cal_color = taskList.color, view.seq = task.seq || 0;
                                                eventTaskViews.push(view);
                                            }
                                            if (eventTaskViews.length % 100 === 0) {
                                                resultCB && resultCB(eventTaskViews);
                                                return;
                                            } else {
                                                taskCurs.continue();
                                            }
                                        } else {
                                            resultCB && resultCB(eventTaskViews);
                                        }
                                    }
                                };
                            }
                        };
                    },
                    getSingleTaskWithTaskListColor: function (task_id, resultCB, trans) {
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        var req = taskStore.get(parseInt(task_id));
                        req.onsuccess = function (evt) {
                            var task = evt.target.result;
                            if (task && !task.deleted) {
                                var req2 = taskListStore.get(task.task_list_id);
                                req2.onsuccess = function (evt) {
                                    var taskList = evt.target.result;
                                    var view = {};
                                    view.id = task.id, view.name = task.name, view.color = null, view.start_date = task.start_date,
                                            view.due_date = task.due_date, view.start_time = task.start_time, view.due_time = task.due_time,
                                            view.completed = task.completed, view.importance = task.importance, view.location = null,
                                            view.icon = null, view.type = 1, view.cal_color = taskList.color;
                                    resultCB && resultCB(view);
                                };

                            }
                        };
                    },
                    getSingleTaskForDisplayList: function (task_id, resultCB, trans) {
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        var req = taskStore.get(parseInt(task_id));
                        req.onsuccess = function (evt) {
                            var task = evt.target.result;
                            if (task && !task.deleted) {
                                var req2 = taskListStore.get(task.task_list_id);
                                req2.onsuccess = function (evt) {
                                    var taskList = evt.target.result;
                                    var aTask = task;
                                    aTask.task_list_type = taskList.type;
                                    aTask.task_list_name = taskList.name;
                                    aTask.task_color = taskList.color;
                                    aTask.st_date = aTask.start_date ? aTask.start_date : '2082758400000';
                                    resultCB && resultCB(aTask);
                                };

                            }
                        };
                    },
                    getTaskForDisplayListPagination: function (task_list_id, is_advance, taskCount, resultCB, trans) {
                        var tasks = [];
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        var req = taskListStore.get(parseInt(task_list_id));
                        req.onsuccess = function (evt) {
                            var taskList = evt.target.result;
                            if (taskList) {
                                var range = IDBKeyRange.bound([taskList.id, 0], [taskList.id, 0], false, false);
                                var req = taskStore.index("task_list_id+deleted").openCursor(range);
                                req.onsuccess = function (evt) {
                                    var taskCurs = evt.target.result;
                                    if (is_advance === true) {
                                        taskCurs.advance(taskCount);
                                        is_advance = false;
                                    }
                                    else {
                                        if (taskCurs) {
                                            var task = taskCurs.value;
                                            if (!task.deleted) {
                                                var aTask = task;
                                                aTask.task_list_type = taskList.type;
                                                aTask.task_list_name = taskList.name;
                                                aTask.task_color = taskList.color;
                                                aTask.st_date = aTask.start_date ? aTask.start_date : '2082758400000';
                                                tasks.push(aTask);
                                            }
                                            if (tasks.length % 100 === 0) {
                                                resultCB && resultCB(tasks);
                                                return;
                                            } else {
                                                taskCurs.continue();
                                            }
                                        } else {
                                            resultCB && resultCB(tasks);
                                        }
                                    }
                                };
                            }
                        };
                    },
                    getTaskForSortPagination: function (is_advance, taskCount, resultCB, trans) {
                        var tasks = [];
                        var date = null;
                        var taskStore = trans.objectStore("task");
                        var req = taskStore.openCursor();
                        req.onsuccess = function (evt) {
                            var taskCurs = evt.target.result;
                            if (is_advance === true) {
                                taskCurs.advance(taskCount);
                                is_advance = false;
                            }
                            else {
                                if (taskCurs) {
                                    var task = taskCurs.value;
                                    if (!task.deleted) {
                                        date = new Date();
                                        task.start = new Date(3000, date.getMonth(), date.getDate(), 0, 0, 0).getTime();
                                        task.end = task.start;
                                        if (task.start_date) {
                                            date = new Date(task.start_date);
                                            task.start = new Date(date.getFullYear(), date.getMonth(), date.getDate(), 0, 0, 0).getTime();
                                        }
                                        if (task.due_date) {
                                            date = new Date(task.due_date);
                                            task.end = new Date(date.getFullYear(), date.getMonth(), date.getDate(), 0, 0, 0).getTime();
                                        }
                                        tasks.push(task);
                                    }
                                    if (tasks.length % 100 === 0) {
                                        resultCB && resultCB(tasks);
                                        return;
                                    } else {
                                        taskCurs.continue();
                                    }
                                } else {
                                    resultCB && resultCB(tasks);
                                }
                            }
                        };
                    },
                    getTasksAndInstancesForCalendarView: function(startTime, endTime, includeCompleted, resultCB, trans) {
                        var instanceStore = trans.objectStore("event_instance");
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        var eventTaskViews = [];
                        var req = taskListStore.index("selected").openCursor(IDBKeyRange.only(1));
                        req.onsuccess = function(evt) {
                            var tlCurs = evt.target.result;
                            if (tlCurs) {
                                var taskList = tlCurs.value;
                                var range = IDBKeyRange.bound([taskList.id, startTime], [taskList.id, endTime], false, false);
                                var req = taskStore.index("task_list_id+start_date").openCursor(range);
                                req.onsuccess = function(evt) {
                                    var taskCurs = evt.target.result;
                                    if (taskCurs) {
                                        var task = taskCurs.value;
                                        if (!task.deleted && task.status === 1 && (task.completed === 0 || includeCompleted && task.completed === 1)) {
                                            var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(task.id));
                                            req.onsuccess = function(evt) {
                                                var instCurs = evt.target.result;
                                                if (instCurs) {
                                                    var instance = instCurs.value;
                                                    if ((startTime >= instance.begin && startTime <= instance.end) ||
                                                            (endTime >= instance.begin && endTime <= instance.end) ||
                                                            (instance.begin >= startTime && instance.begin <= endTime) ||
                                                            (instance.end >= startTime && instance.end <= endTime)) {
                                                        var view = makeTaskViews(taskList, task, instance);
                                                        if (eventTaskViews['#' + instance.id] === undefined) {
                                                            eventTaskViews['#' + instance.id] = view;
                                                        }
                                                    }
                                                    instCurs.continue();
                                                } else {
                                                    taskCurs.continue();
                                                }
                                            };
                                        } else {
                                            taskCurs.continue();
                                        }
                                    } else {
                                        
                                        var req = taskStore.index("task_list_id+due_date").openCursor(range);
                                        req.onsuccess = function (evt) {
                                            var taskCurs = evt.target.result;
                                            if (taskCurs) {
                                                var task = taskCurs.value;
                                                if (!task.deleted && task.status === 1 && (task.completed === 0 || includeCompleted && task.completed === 1)) {
                                                    var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(task.id));
                                                    req.onsuccess = function (evt) {
                                                        var instCurs = evt.target.result;
                                                        if (instCurs) {
                                                            var instance = instCurs.value;
                                                            if ((startTime >= instance.begin && startTime <= instance.end) ||
                                                                    (endTime >= instance.begin && endTime <= instance.end) ||
                                                                    (instance.begin >= startTime && instance.begin <= endTime) ||
                                                                    (instance.end >= startTime && instance.end <= endTime)) {
                                                                var view = makeTaskViews(taskList, task, instance);
                                                                if (eventTaskViews['#' + instance.id] === undefined) {
                                                                    eventTaskViews['#' + instance.id] = view;
                                                                }
                                                            }
                                                            instCurs.continue();
                                                        } else {
                                                            taskCurs.continue();
                                                        }
                                                    };
                                                } else {
                                                    taskCurs.continue();
                                                }
                                            } else {
                                                tlCurs.continue();
                                            }
                                        };
                                        
                                    }
                                };
                            } else {
                                resultCB && resultCB(eventTaskViews);
                            }
                        };
                    },
                    getAllSelectedTaskLists: function(resultCB, trans) {
                        if (!trans) {
                            trans = jorteDB.getTransaction(["task_list"], "readonly");
                        }
                        var taskListStore = trans.objectStore("task_list");
                        var req = taskListStore.index("selected").openCursor(IDBKeyRange.only(1));
                        var taskLists = [];
                        req.onsuccess = function(evt) {
                            var tlCurs = evt.target.result;
                            if (tlCurs) {
                                taskLists.push(tlCurs.value);
                                tlCurs.continue();
                            } else {
                                resultCB(taskLists);
                            }
                        };
                    },
                    swapCompletedStatus: function(id, updateData, txCompleteCB) {
                        var trans = jorteDB.getTransaction(["event_instance", "task"], "readwrite", txCompleteCB,
                                function(evt) {
                                    console.log('swapCompletedStatus txn', evt);
                                }
                        );
                        getTaskForUpdate(id, function(task) {
                            task.completed = updateData[0];
                            task.complete_date = updateData[1];
                            updateTask(task, null, trans);
                        }, trans);
                    },
                    getTaskForEdit: function(id, txCompleteCB) {
                        var taskViews = [];
                        var trans = jorteDB.getTransaction(
                                ["task_list", "task"],
                                "readonly",
                                function() {
                                    txCompleteCB(taskViews);
                                },
                                function(evt) {
                                    console.log('getTaskForEdit txn ', evt);
                                }
                        );
                        var self = this;
                        var taskStore = trans.objectStore("task");
                        var taskListStore = trans.objectStore("task_list");
                        var req = taskStore.get(parseInt(id));
                        req.onsuccess = function(evt) {
                            var task = evt.target.result;

                            task.task_list_id = parseInt(task.task_list_id);
                            var req = taskListStore.get(task.task_list_id);
                            req.onsuccess = function(evt) {
                                self.getAllSelectedTaskLists(function(tls) {
                                    var taskList = evt.target.result;
                                    var view = {};
                                    view.id = task.id, view.name = task.name, view.memo = task.memo, view.start_date = task.start_date,
                                            view.due_date = task.due_date, view.start_time = task.start_time, view.due_time = task.due_time,
                                            view.status = task.status, view.importance = task.importance,
                                            view.completed = task.completed, view.task_list_name = taskList.name, view.task_list_id = task.task_list_id,
                                            view.task_color = taskList.color, view.task_type = task.type, view.global_id = task.global_id,
                                            view.task_list_type = taskList.type, view.tlist_global_id = taskList.global_id,
                                            view.sync_status = taskList.sync_status;
                                    view.reminders = task.reminders;
                                    view.taskListCount = tls.length;
                                    taskViews.push(view);
                                }, trans);
                            };
                        };
                    },
                    deleteTask: function(id, txCompletedCB) {
                        var trans = jorteDB.getTransaction(
                                ["task", "deleted_tasks", "event_instance"],
                                "readwrite",
                                function() {
                                    txCompletedCB(old_instances);
                                },
                                function(evt) {
                                    console.log(evt);
                                }
                        );
                        var taskStore = trans.objectStore("task");
                        var instanceStore = trans.objectStore("event_instance");
                        var deletedTaskStore = trans.objectStore("deleted_tasks");
                        var old_instances = [];

                        var req = taskStore.get(parseInt(id));
                        req.onerror = function(evt) {
                            console.log('deleteTask error ', evt);
                        };
                        req.onsuccess = function(evt) {
                            var task = evt.target.result;
                            if (task) {
                                if (task.global_id && task.type !== 300) {
                                    var obj = {
                                        global_id: task.global_id,
                                        sync_version: task.sync_version,
                                        task_list_id: task.task_list_id,
                                        type: task.type
                                    };
                                    deletedTaskStore.add(obj);
                                }
                                if (task.global_id && task.type === 300) {
                                    task.deleted = 1, task.dirty = 1, task.status = 0, task.update_date = (new Date()).getTime();
                                    var req = taskStore.put(task);
                                    req.onerror = function(e) {
                                        console.log('task update Failed ', e);
                                    };
                                    req.onsuccess = function(e) {
                                        var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(parseInt(id)));
                                        req.onsuccess = function(e) {
                                            var instCurs = e.target.result;
                                            if (instCurs) {
                                                old_instances.push(instCurs.value.id);
                                                instCurs.delete(instCurs.value);
                                                instCurs.continue();
                                            }
                                        };

                                    };

                                } else {

                                    var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(parseInt(id)));
                                    req.onsuccess = function(evt) {
                                        var instCurs = evt.target.result;
                                        if (instCurs) {
                                            old_instances.push(instCurs.value.id);
                                            instCurs.delete(instCurs.value);
                                            instCurs.continue();
                                        } else {
                                            var req = taskStore.delete(id);
                                            req.onsuccess = function() {
                                            };
                                        }
                                    };
                                }
                            }
                        };
                    },
                    makeTaskCompleted: function(id, txCompletedCB) {
                        var date = new Date().getTime();
                        var trans = jorteDB.getTransaction(["task"], "readwrite", txCompletedCB, function(evt) {
                            console.log(evt);
                        });
                        var taskStore = trans.objectStore("task");
                        var req = taskStore.get(parseInt(id));
                        req.onsuccess = function(evt) {
                            var task = evt.target.result;
                            task.completed = 1, task.dirty = 1, task.complete_date = date, task.update_date = date;
                            taskStore.put(task);
                        };
                    },
                    getAllTaskLists: function (resultCB, trans) {
                        if (!trans) {
                            trans = jorteDB.getTransaction(["task_list"], "readonly");
                        }
                        var taskListStore = trans.objectStore("task_list");
                        var req = taskListStore.openCursor();
                        var taskLists = [];
                        req.onsuccess = function(evt) {
                            var tlCurs = evt.target.result;
                            if (tlCurs) {
                                taskLists.push(tlCurs.value);
                                tlCurs.continue();
                            } else {
                                resultCB(taskLists);
                            }
                        };
                    },
                    getSelectedTaskLists: function(resultCB, trans) {
                        if (!trans) {
                            trans = jorteDB.getTransaction(["task_list"], "readonly");
                        }
                        var taskListStore = trans.objectStore("task_list");
                        var req = taskListStore.index("selected").openCursor(IDBKeyRange.only(1));
                        var taskLists = [];
                        req.onsuccess = function(evt) {
                            var tlCurs = evt.target.result;
                            if (tlCurs) {
                                taskLists.push(tlCurs.value);
                                tlCurs.continue();
                            } else {
                                resultCB(taskLists);
                            }
                        };
                    },
                    getTaskList: function(taskListId, resultCB, trans) {
                        if (!trans) {
                            trans = jorteDB.getTransaction(["task_list"], "readonly");
                        }
                        var taskListStore = trans.objectStore("task_list");
                        taskListId = parseInt(taskListId);
                        var req = taskListStore.get(taskListId);
                        req.onsuccess = function(evt) {
                            var taskList = evt.target.result;
                            resultCB(taskList);
                        };
                    },
                    swapTaskListSelection: function(id, status, txCompleteCB) {
                        var trans = jorteDB.getTransaction(["task_list"], "readwrite", txCompleteCB, function(evt) {
                            console.log('swapTaskListSelection txn', evt);
                        });
                        this.getTaskList(id, function(taskList) {
                            taskList.selected = status;
                            updateTaskList(taskList, null, trans);
                        }, trans);
                    },
                    saveTaskDetails: function(data, txCompleteCB) {
                        var taskId = null;
                        var trans = initTransForTaskUpdate(function() {
                            txCompleteCB(taskId);
                        }, function(e) {
                            console.log('saveTaskDetails txn ', e);
                        });
                        var task = data.task;
                        addTask(task, function(task_id) {
                            taskId = task_id;
                            if (!data.start_date) {
                                data.start_date = data.due_date;
                            }

                            var instance = new EventInstance();
                            instance.task_id = task_id, instance.begin = data.start_date, instance.end = data.due_date;
                            saveTaskInstances(instance, null, trans);
                            if (data.due_date && task.reminders && task.reminders.length > 0) {// insert reminder only if there is end date
                                reminderSvc.addReminders(task.reminders);
                            }
                        }, trans);
                    },
                    updateTaskListColor: function(id, color, txCompleteCB) {
                        var trans = jorteDB.getTransaction(["task_list"], "readwrite", txCompleteCB,
                                function(evt) {
                                    console.log('updateTaskListColor txn', evt);
                                }
                        );
                        this.getTaskList(id, function(taskList) {
                            taskList.color = color;
                            taskList.dirty = 1;
                            updateTaskList(taskList, null, trans);
                        }, trans);
                    },
                    saveTaskList: function(taskList, txCompleteCB) {
                        var taskListId = null;
                        var trans = jorteDB.getTransaction(["task_list"], "readwrite", function() {
                            txCompleteCB(taskListId);
                        }, function(e) {
                            console.log('saveTaskList txn', e);
                        });
                        addTaskList(taskList, function(tlId) {
                            taskListId = tlId;
                        }, trans);
                    },
                    updateTaskListData: function(id, data, txCompleteCB) {
                        var trans = jorteDB.getTransaction(["task_list"], "readwrite", txCompleteCB,
                                function(e) {
                                    console.log('updateTaskListData txn', e);
                                }
                        );
                        this.getTaskList(id, function(taskList) {
                            taskList.name = data.name, taskList.content = data.content, taskList.sync_status = data.syncStatus,
                                    taskList.dirty = data.dirty, taskList.update_date = data.date;
                            updateTaskList(taskList, null, trans);
                        }, trans);
                    },
                    updateTaskDetails: function(data, txCompleteCB) {
                        var trans = initTransForTaskUpdate(txCompleteCB, function(e) {
                            console.log('updateTaskDetails txn ', e);
                        });
                        getTaskForUpdate(data.task_id, function(task) {
                            task.calendar_id = parseInt(data.calendar_id), task.task_list_id = parseInt(data.task_list_id), task.name = data.name,
                                    task.memo = data.memo, task.start_date = data.start_date, task.due_date = data.due_date, task.start_time = data.startTime,
                                    task.due_time = data.dueTime, task.type = data.type, task.timezone = data.timezone, task.status = data.status,
                                    task.completed = data.completed, task.importance = data.importance, task.complete_date = data.complete_date,
                                    task.update_date = data.update_date, task.dirty = 1, task.reminders = data.reminders;

                            updateTask(task, function() {
                                if (!data.start_date) {
                                    task.start_date = task.due_date;
                                }
                                updateTaskInstances(task, null, trans);
                                if (data.due_date && data.reminders && data.reminders.length > 0) {
                                    reminderSvc.addReminders(data.reminders);
                                }
                            }, trans);
                        }, trans);
                    },
                    deleteTaskList: function(taskListId, deleteCompleteCB) {
                        var trans = jorteDB.getTransaction(["task_list", "deleted_task_lists"], "readwrite", deleteCompleteCB,
                                function(e) {
                                    console.log('deleteTaskList txn', e);
                                }
                        );
                        var taskListStore = trans.objectStore("task_list");
                        var deletedTaskListStore = trans.objectStore("deleted_task_lists");
                        var req = taskListStore.get(parseInt(taskListId));
                        req.onsuccess = function(evt) {
                            var item = evt.target.result;
                            if (item) {
                                if (item.global_id) {
                                    var deletedTl = {
                                        global_id: item.global_id,
                                        sync_version: item.sync_version,
                                        type: item.type
                                    };
                                    deletedTaskListStore.add(deletedTl);
                                }
                                taskListStore.delete(parseInt(taskListId));
                            }
                        };
                    },
                    getAllTasksForSync: function(typeArr, resultCB) {
                        var results = [];
                        var delListLocal = [];
                        var insertListLocal = [];
                        var updateListLocal = [];
                        var remainingList = [];
                        var trans = jorteDB.getTransaction(["deleted_tasks", "task_list", "task"], "readonly",
                                function() {
                                    resultCB({delListLocal: delListLocal, insertListLocal: insertListLocal, updateListLocal: updateListLocal, remainingList: remainingList});
                                },
                                function(evt) {
                                    console.log('sortTasks txn ', evt);
                                }
                        );
                        var delTaskStore = trans.objectStore("deleted_tasks");
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        var req = delTaskStore.openCursor();
                        req.onsuccess = function(evt) {
                            var delTksCurs = evt.target.result;
                            if (delTksCurs) {
                                var delTask = delTksCurs.value;
                                if ($.inArray(300, typeArr) === -1) {
                                    delTask.deleted_status = 1;
                                    delListLocal.push(delTask);
                                }
                                delTksCurs.continue();
                            } else {
                                var req = taskListStore.index("sync_status").openCursor(IDBKeyRange.only(1));
                                req.onsuccess = function(evt) {
                                    var tlCurs = evt.target.result;
                                    if (tlCurs) {
                                        var taskList = tlCurs.value;
                                        if ($.inArray(taskList.type, typeArr) >= 0) {
                                            var req = taskStore.index("task_list_id").openCursor(IDBKeyRange.only(taskList.id));
                                            req.onsuccess = function(evt) {
                                                var tCurs = evt.target.result;
                                                if (tCurs) {
                                                    var task = tCurs.value;
                                                    if (task && task.dirty === 1) {
                                                        var tsk = {};
                                                        $.extend(tsk, task);
                                                        tsk.listid = taskList.global_id;
                                                        results.push(tsk);
                                                        if (tsk.global_id) {
                                                            updateListLocal['#' + tsk.global_id] = tsk;
                                                        } else {
                                                            insertListLocal.push(tsk);
                                                        }
                                                    } else {
                                                        if (task.global_id) {
                                                            remainingList['#' + task.global_id] = task;
                                                        }
                                                    }
                                                    tCurs.continue();
                                                } else {
                                                    tlCurs.continue();
                                                }
                                            };
                                        } else {
                                            tlCurs.continue();
                                        }
                                    }
                                };
                            }
                        };

                    },
                    getAllTaskListForSync: function(typeArr, dirtyCheck, resultCB) {

                        var results = [];
                        var trans = jorteDB.getTransaction(["deleted_task_lists", "task_list"], "readonly",
                                function() {
                                    resultCB(results);
                                },
                                function(evt) {
                                    console.log('getAllTaskListForSynch txn ', evt);
                                }
                        );
                        var delTaskListStore = trans.objectStore("deleted_task_lists");
                        var taskListStore = trans.objectStore("task_list");

                        var req = delTaskListStore.openCursor();
                        req.onsuccess = function(evt) {
                            var delTskCurs = evt.target.result;
                            if (delTskCurs) {
                                var delTaskLst = delTskCurs.value;
                                if ($.inArray(300, typeArr) === -1) {
                                    delTaskLst.deleted_status = 1;
                                    results.push(delTaskLst);
                                }
                                delTskCurs.continue();
                            } else {
                                var req = taskListStore.openCursor();
                                req.onsuccess = function(evt) {
                                    var taskLstCurs = evt.target.result;
                                    if (taskLstCurs) {
                                        var taskList = taskLstCurs.value;
                                        if ($.inArray(taskList.type, typeArr) >= 0) {
                                            if(dirtyCheck){
                                                if (taskList.dirty) {
                                                    results.push(taskList);
                                                }
                                            } else {
                                                results.push(taskList);
                                            }
                                        }
                                        taskLstCurs.continue();
                                    }
                                };
                            }
                        };
                    },
                    syncTaskLists: function(typeArray, list, callback) {

                        var trans = jorteDB.getTransaction(["deleted_task_lists", "task_list"], "readwrite",
                                function() {
                                    callback();
                                },
                                function(evt) {
                                    console.log(evt);
                                }
                        );
                        var delTaskListStore = trans.objectStore("deleted_task_lists");
                        var taskListStore = trans.objectStore("task_list");
                        var req = taskListStore.index("sync_status").openCursor(IDBKeyRange.only(1));
                        req.onsuccess = function(evt) {
                            var tlCurs = evt.target.result;
                            if (tlCurs) {
                                var localTaskList = tlCurs.value;
                                if ($.inArray(localTaskList.type, typeArray) >= 0) {
                                    var found = false;
                                    for (var i = 0; i < list.length; i++) {
                                        var jorteTaskList = list[i];
                                        if (jorteTaskList.id || localTaskList.global_id) {
                                            if (localTaskList.id === jorteTaskList.id || localTaskList.global_id === jorteTaskList.global_id) {
                                                found = true;
                                                if (localTaskList.sync_version !== jorteTaskList.sync_version) { //update needed

                                                    localTaskList.global_id = jorteTaskList.global_id, localTaskList.name = jorteTaskList.name,
                                                            localTaskList.content = jorteTaskList.content, localTaskList.icon = jorteTaskList.icon,
                                                            localTaskList.color = jorteTaskList.color, localTaskList.notes = jorteTaskList.notes,
                                                            localTaskList.sync_status = jorteTaskList.sync_status, localTaskList.create_date = jorteTaskList.create_date,
                                                            localTaskList.update_date = jorteTaskList.update_date, localTaskList.sync_version = jorteTaskList.sync_version,
                                                            localTaskList.dirty = jorteTaskList.dirty;

                                                    tlCurs.update(localTaskList);
                                                }
                                                list.splice(i, 1); //processed or moved
                                                break;
                                            }
                                        }
                                    }
                                    if (!found) { //item only in local db, not in Jorte
                                        tlCurs.delete(localTaskList);
                                    }
                                }
                                tlCurs.continue();
                            } else {
                                for (var i = 0; i < list.length; i++) {
                                    taskListStore.add(list[i]);
                                }
                            }
                        };
                        var reqDelTaskList = delTaskListStore.openCursor();
                        reqDelTaskList.onsuccess = function(evt) {
                            var delTaskListCurs = evt.target.result;
                            if (delTaskListCurs) {
                                var delTaskList = delTaskListCurs.value;
                                if ($.inArray(delTaskList.type, typeArray) >= 0) {
                                    delTaskListCurs.delete(delTaskList);
                                }
                                delTaskListCurs.continue();
                            }
                        };
                    },
                    syncTasks: function(op, items, callback) {
                        switch (op) {
                            case 1:
                                syncTaskInsertion(items, callback);
                                break;
                            case 2:
                                syncTaskUpdation(items, callback);
                                break;
                            case 3:
                                syncTaskDeletion(items, callback);
                                break;
                        }
                    },
                    clearLocallyDeletedTasks: function(callback) {
                        var trans = jorteDB.getTransaction(
                                ["deleted_tasks"],
                                "readwrite",
                                callback,
                                function(e) {
                                    console.log(e);
                                }
                        );
                        var delTaskStore = trans.objectStore("deleted_tasks");
                        var reqDelEvt = delTaskStore.openCursor();
                        reqDelEvt.onsuccess = function(evt) {
                            var cursDelTask = evt.target.result;
                            if (cursDelTask) {
                                cursDelTask.delete(cursDelTask.value);
                                cursDelTask.continue();
                            }
                        };
                    },
                    sortedTasksUpdation: function (taskList, txCompleteCB) {
                        var trans = jorteDB.getTransaction(["task"], "readwrite", txCompleteCB,
                                function (evt) {
                                    console.log('sortTasks txn ', evt);
                                }
                        );
                        var updateSortedTasks = function (i) {
                            if (i >= taskList.length) {
                                return;
                            }
                            var task = taskList[i];
                            delete task.start;
                            delete task.end;
                            updateTask(task, function () {
                                updateSortedTasks(++i);
                            }, trans);
                        };
                        updateSortedTasks(0);
                    },
                    getSingleTaskForSync: function(params, resultCB) {
                        var delListLocal = [];
                        var insertListLocal = [];
                        var updateListLocal = [];
                        var remainingList = [];
                        var id = params.id;
                        var task_list_id = params.task_list_id, task_list_type = params.task_list_type, del_global_id = params.del_global_id;
                        var trans = jorteDB.getTransaction(["deleted_tasks", "task_list", "task"], "readonly",
                                function() {
                                    var params = {delListLocal: delListLocal, insertListLocal: insertListLocal, updateListLocal: updateListLocal, remainingList: remainingList};
                                    resultCB(params);
                                },
                                function(evt) {
                                    console.log('task txn ', evt);
                                }
                        );
                        var delTaskStore = trans.objectStore("deleted_tasks");
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        if (del_global_id) {
                            var req = delTaskStore.index("global_id").openCursor(IDBKeyRange.only(del_global_id));
                            req.onsuccess = function(evt) {
                                var delTksCurs = evt.target.result;
                                if (delTksCurs) {
                                    var delTask = delTksCurs.value;
                                    if ($.inArray(300, task_list_type) === -1) {
                                        delTask.deleted_status = 1;
                                        delListLocal.push(delTask);
                                    }
                                }
                            };
                        } else {
                            var req = taskListStore.get(task_list_id);
                            req.onsuccess = function(evt) {
                                var taskList = evt.target.result;
                                if (taskList && taskList.sync_status) {
                                    var req = taskStore.get(id);
                                    req.onsuccess = function(evt) {
                                        var task = evt.target.result;
                                        if (task) {
                                            var tsk = {};
                                            $.extend(tsk, task);
                                            tsk.listid = taskList.global_id;
                                            if (tsk.global_id) {
                                                updateListLocal['#' + tsk.global_id] = tsk;
                                            } else {
                                                insertListLocal.push(tsk);
                                            }
                                        }
                                    };

                                }
                            };
                        }
                    },
                    syncSingleTask: function(type, list, callback) {
                        var trans = jorteDB.getTransaction(
                                ["deleted_tasks", "task_list", "task", "event_instance"],
                                "readwrite",
                                function() {
                                    callback();
                                }, function(e) {
                            console.log(e);
                        }
                        );
                        var taskStore = trans.objectStore("task");
                        if (list) {
                            var req = taskStore.get(list.id);
                            req.onsuccess = function(evt) {
                                var task = evt.target.result;
                                if (task) {
                                    task.global_id = list.global_id;
                                    updateTask(task, null, trans);
                                }
                            };
                        }
                    },
                    getSingleTaskListForSync: function(params, resultCB) {
                        var results = [];
                        var id = params.id;
                        var task_list_type = params.task_list_type, del_global_id = params.del_global_id;
                        var trans = jorteDB.getTransaction(["deleted_task_lists", "task_list"], "readonly",
                                function() {
                                    resultCB(results);
                                },
                                function(evt) {
                                    console.log('task txn ', evt);
                                }
                        );
                        var delTaskListStore = trans.objectStore("deleted_task_lists");
                        var taskListStore = trans.objectStore("task_list");
                        if (del_global_id) {
                            var req = delTaskListStore.index("global_id").openCursor(IDBKeyRange.only(del_global_id));
                            req.onsuccess = function(evt) {
                                var delTksCurs = evt.target.result;
                                if (delTksCurs) {
                                    var delTask = delTksCurs.value;
                                    if ($.inArray(300, task_list_type) === -1) {
                                        delTask.deleted_status = 1;
                                        results.push(delTask);
                                    }
                                }
                            };
                        } else {
                            var req = taskListStore.get(id);
                            req.onsuccess = function(evt) {
                                var taskList = evt.target.result;
                                if (taskList && taskList.sync_status) {
                                    results.push(taskList);
                                }
                            };
                        }
                    },
                    syncSingleTaskList: function(type, list, callback) {
                        var trans = jorteDB.getTransaction(
                                ["deleted_task_lists", "task_list"],
                                "readwrite",
                                function() {
                                    callback();
                                }, function(e) {
                            console.log(e);
                        }
                        );
                        var taskListStore = trans.objectStore("task_list");
                        if (list) {
                            var req = taskListStore.get(list.id);
                            req.onsuccess = function(evt) {
                                var task_list = evt.target.result;
                                if (task_list) {
                                    task_list.global_id = list.global_id;
                                    updateTaskList(task_list, null, trans);
                                }
                            };
                        }
                    },
                    getTasksCount: function(startTime, endTime, includeCompleted, resultCB, trans) {
                        var tasks_count = 0;
                        var taskListStore = trans.objectStore("task_list");
                        var taskStore = trans.objectStore("task");
                        var req = taskListStore.index("selected").openCursor(IDBKeyRange.only(1));
                        req.onsuccess = function(evt) {
                            var tlCurs = evt.target.result;
                            if (tlCurs) {
                                var taskList = tlCurs.value;
                                var range;
                                if (includeCompleted) {
                                    range = IDBKeyRange.bound([taskList.id, startTime, 0, 1, 1], [taskList.id, endTime, 0, 1, 1], false, false);
                                } else {
                                    range = IDBKeyRange.bound([taskList.id, startTime, 0, 1, 0], [taskList.id, endTime, 0, 1, 0], false, false);
                                }
                                var req2 = taskStore.index("task_list_id+start_date+deleted+status+completed").count(range);
                                req2.onsuccess = function() {
                                    tasks_count += req2.result;
                                    tlCurs.continue();
                                };
                            } else {
                                resultCB && resultCB(tasks_count);
                            }
                        };
                    },
                    getSingleTasksAndInstancesForCalendarView: function(task_id, includeCompleted, resultCB) {
                        var trans = jorteDB.getTransaction(
                                ['task_list', 'task', 'event_instance'],
                                'readonly',
                                //Success callback
                                        function() {
                                            resultCB(eventTaskViews);
                                        },
                                        //Error callback
                                                function(evt) {
                                                    console.log(evt);
                                                }
                                        );

                                        var taskListStore = trans.objectStore("task_list");
                                        var taskStore = trans.objectStore("task");
                                        var instanceStore = trans.objectStore("event_instance");
                                        var eventTaskViews = [];
                                        var req = taskStore.get(parseInt(task_id));
                                        req.onsuccess = function(evt) {
                                            var task = evt.target.result;
                                            if (task && !task.deleted && task.status === 1 && (task.completed === 0 || includeCompleted && task.completed === 1)) {
                                                var req2 = taskListStore.get(parseInt(task.task_list_id));
                                                req2.onsuccess = function(e2) {
                                                    var taskList = e2.target.result;
                                                    if (taskList && taskList.selected === 1) {
                                                        var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(task.id));
                                                        req.onsuccess = function(evt) {
                                                            var instCurs = evt.target.result;
                                                            if (instCurs) {
                                                                var instance = instCurs.value;
                                                                var view = new EventTaskView();
                                                                view.id = task.id,
                                                                        view.instance_id = instance.id,
                                                                        view.name = task.name,
                                                                        view.icon = null,
                                                                        view.all_day = null,
                                                                        view.color = null,
                                                                        view.location = null,
                                                                        view.memo = task.memo,
                                                                        view.begin = instance.begin,
                                                                        view.end = instance.end,
                                                                        view.start_date = task.start_date,
                                                                        view.end_date = task.due_date,
                                                                        view.completed = task.completed,
                                                                        view.importance = task.importance,
                                                                        view.holiday = null,
                                                                        view.type = 1,
                                                                        view.repeat = null,
                                                                        view.last_date = null,
                                                                        view.provider = null,
                                                                        view.cal_color = taskList.color,
                                                                        view.timezone = task.timezone,
                                                                        view.icon_only = null,
                                                                        view.icon_map = null,
                                                                        view.icon_id = null,
                                                                        view.disp_type = null,
                                                                        view.isdeliverCalendar = 2,
                                                                        view.start_time = null,
                                                                        view.end_time = null;

                                                                eventTaskViews.push(view);
                                                                instCurs.continue();
                                                            }
                                                        };
                                                    }
                                                };
                                            }

                                        };

                                    },
                            getTasksAndInstanceForSearch: function (startTime, endTime, includeCompleted, resultCB, trans) {
                                var instanceStore = trans.objectStore("event_instance");
                                var taskListStore = trans.objectStore("task_list");
                                var taskStore = trans.objectStore("task");
                                var eventTaskViews = [];
                                var req = taskListStore.index("selected").openCursor(IDBKeyRange.only(1));
                                req.onsuccess = function (evt) {
                                    var tlCurs = evt.target.result;
                                    if (tlCurs) {
                                        var taskList = tlCurs.value;
                                        var range = IDBKeyRange.bound([taskList.id, startTime], [taskList.id, endTime], false, false);
                                        var req = taskStore.index("task_list_id+start_date").openCursor(range);
                                        req.onsuccess = function (evt) {
                                            var taskCurs = evt.target.result;
                                            if (taskCurs) {
                                                var task = taskCurs.value;
                                                if (!task.deleted && task.status === 1 && 
                                                        (task.completed === 0 || includeCompleted && task.completed === 1)) {
                                                    var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(task.id));
                                                    req.onsuccess = function (evt) {
                                                        var instCurs = evt.target.result;
                                                        if (instCurs) {
                                                            var instance = instCurs.value;
                                                            if ((startTime >= instance.begin && startTime <= instance.end) ||
                                                                    (endTime >= instance.begin && endTime <= instance.end) ||
                                                                    (instance.begin >= startTime && instance.begin <= endTime) ||
                                                                    (instance.end >= startTime && instance.end <= endTime)) {
                                                                var view = makeSearchTaskViews(task, instance);
                                                                if (eventTaskViews['#' + instance.id] === undefined) {
                                                                    eventTaskViews['#' + instance.id] = view;
                                                                }
                                                            }
                                                            instCurs.continue();
                                                        } else {
                                                            taskCurs.continue();
                                                        }
                                                    };
                                                } else {
                                                    taskCurs.continue();
                                                }
                                            } else {
                                                var req = taskStore.index("task_list_id+due_date").openCursor(range);
                                                req.onsuccess = function (evt) {
                                                    var taskCurs = evt.target.result;
                                                    if (taskCurs) {
                                                        var task = taskCurs.value;
                                                        if (!task.deleted && task.status === 1 && (task.completed === 0 || includeCompleted && task.completed === 1)) {
                                                            var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(task.id));
                                                            req.onsuccess = function (evt) {
                                                                var instCurs = evt.target.result;
                                                                if (instCurs) {
                                                                    var instance = instCurs.value;
                                                                    if ((startTime >= instance.begin && startTime <= instance.end) ||
                                                                            (endTime >= instance.begin && endTime <= instance.end) ||
                                                                            (instance.begin >= startTime && instance.begin <= endTime) ||
                                                                            (instance.end >= startTime && instance.end <= endTime)) {
                                                                        var view = makeSearchTaskViews(task, instance);
                                                                        if (eventTaskViews['#' + instance.id] === undefined) {
                                                                            eventTaskViews['#' + instance.id] = view;
                                                                        }
                                                                    }
                                                                    instCurs.continue();
                                                                } else {
                                                                    taskCurs.continue();
                                                                }
                                                            };
                                                        } else {
                                                            taskCurs.continue();
                                                        }
                                                    } else {
                                                        tlCurs.continue();
                                                    }
                                                };
                                            }
                                        };
                                    } else {
                                        resultCB && resultCB(eventTaskViews);
                                    }
                                };
                            },
                            getSingleTasksAndInstancesForSearch: function (task_id, includeCompleted, resultCB) {
                                var trans = jorteDB.getTransaction(
                                        ['task_list', 'task', 'event_instance'],
                                        'readonly',
                                        //Success callback
                                                function () {
                                                    resultCB(eventTaskViews);
                                                },
                                                //Error callback
                                                        function (evt) {
                                                            console.log(evt);
                                                        }
                                                );

                                                var taskListStore = trans.objectStore("task_list");
                                                var taskStore = trans.objectStore("task");
                                                var instanceStore = trans.objectStore("event_instance");
                                                var eventTaskViews = [];
                                                var req = taskStore.get(parseInt(task_id));
                                                req.onsuccess = function (evt) {
                                                    var task = evt.target.result;
                                                    if (task && !task.deleted && task.status === 1 && (task.completed === 0 || includeCompleted && task.completed === 1)) {
                                                        var req2 = taskListStore.get(parseInt(task.task_list_id));
                                                        req2.onsuccess = function (e2) {
                                                            var taskList = e2.target.result;
                                                            if (taskList && taskList.selected === 1) {
                                                                var req = instanceStore.index("task_id").openCursor(IDBKeyRange.only(task.id));
                                                                req.onsuccess = function (evt) {
                                                                    var instCurs = evt.target.result;
                                                                    if (instCurs) {
                                                                        var instance = instCurs.value;
                                                                        var view = makeSearchTaskViews(task, instance);
                                                                        eventTaskViews.push(view);
                                                                        instCurs.continue();
                                                                    }
                                                                };
                                                            }
                                                        };
                                                    }

                                                };

                                            }
                        };
            }]);