'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.template', [])

        // Theme service
        .factory('templateSvc', function() {
            return {
                getTemplates: function(flag, type, txCompleteCB) {
                    var templs = [];
                    var trans = jorteDB.getTransaction(["templates"], "readwrite",
                            function() {
                                txCompleteCB(templs);
                            },
                            function(e) {
                                console.log('getTemplates tx error ', e);
                            });

                    var templStore = trans.objectStore("templates");
                    var req;
                    if (flag) {
                        req = templStore.index("flag+type").openCursor(IDBKeyRange.only([1, type]));
                    } else {
                        req = templStore.index("flag").openCursor(IDBKeyRange.only(0));
                    }
                    req.onsuccess = function(e1) {
                        var templCurs = e1.target.result;
                        if (templCurs) {
                            templs.push(templCurs.value);
                            templCurs.continue();
                        }
                    };
                },
                deleteTemplate: function(templateId, completeCB) {
                    var trans = jorteDB.getTransaction(["templates"], "readwrite",
                            function() {
                                completeCB();
                            },
                            function(e) {
                                console.log('deleteTemplate tx error ', e);
                            });

                    var templStore = trans.objectStore("templates");
                    templStore.delete(parseInt(templateId));
                },
                updateTemplate: function(templateId, name, completeCB) {
                    var trans = jorteDB.getTransaction(["templates"], "readwrite",
                            function() {
                                completeCB();
                            },
                            function(e) {
                                console.log('updateTemplate tx error ', e);
                            });

                    var templStore = trans.objectStore("templates");
                    var req = templStore.get(parseInt(templateId));
                    req.onsuccess = function(e1) {
                        var template = e1.target.result;
                        template.event_name = name;
                        templStore.put(template);
                    };
                },
                createTemplate: function(tempDetail, completeCB) {
                    var trans = jorteDB.getTransaction(["templates"], "readwrite",
                            function() {
                                completeCB();
                            },
                            function(e) {
                                console.log('createTemplate tx error ', e);
                            });

                    var templStore = trans.objectStore("templates");
                    templStore.add(tempDetail);
                },
                createUniqueHistory: function(tempDetail, completeCB) {
                    var trans = jorteDB.getTransaction(["templates"], "readwrite",
                            completeCB,
                            function(e) {
                                console.log('createHistory tx error ', e);
                            });

                    var templStore = trans.objectStore("templates");
                    var count = templStore.index("flag+type+event_name").count([1, tempDetail.type, tempDetail.event_name]);
                    count.onsuccess = function() {
                        if (count.result === 0) {
                            templStore.add(tempDetail);
                        }
                    };
                }
            };
        });

