'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.models.theme', [])

        // Theme service
        .factory('themeSvc', function() {
            return {
                saveTheme: function(theme, content, txCompleteCb) {
                    var themeId;
                    var trans = jorteDB.getTransaction(["theme", "theme_content"], "readwrite",
                            function() {
                                txCompleteCb(themeId);
                            },
                            function(e) {
                                console.log('saveTheme tx error', e);
                            }
                    );

                    var themeStore = trans.objectStore("theme");
                    var themeContentStore = trans.objectStore("theme_content");
                    var req = themeStore.add(theme);
                    req.onsuccess = function(evt) {
                        themeId = evt.target.result;
                        var themeContent = new ThemeContent();
                        themeContent.theme_id = themeId;
                        themeContent.content = content;
                        themeContentStore.add(themeContent);

                    };
                },
                updateTheme: function(themeData, txCompleteCb) {
                    var themeId = null;
                    var trans = jorteDB.getTransaction(["theme", "theme_content"], "readwrite",
                            function() {
                                txCompleteCb();
                            },
                            function(e) {
                                console.log('updateTheme tx error', e);
                            }
                    );
                    var themeStore = trans.objectStore("theme");
                    var themeContentStore = trans.objectStore("theme_content");

                    var req = themeStore.get(parseInt(themeData.themeId));
                    req.onsuccess = function(evt) {
                        var theme = evt.target.result;
                        theme.name = themeData.name, theme.details = themeData.details,
                                theme.author = themeData.author, theme.path = themeData.path,
                                theme.color = themeData.color, theme.file_name = themeData.file_name;
                        var req = themeStore.put(theme);
                        req.onsuccess = function(evt) {
                            themeId = evt.target.result;
                            var req = themeContentStore.get(themeData.themeId);
                            req.onsuccess = function(evt) {
                                var themeContent = evt.target.result;
                                themeContent.content = themeData.content;
                                themeContentStore.put(themeContent);
                            };
                        };
                    };
                },
                getAllThemes: function(txCompleteCB) {
                    var theme_list = [];
                    var trans = jorteDB.getTransaction(["theme", "theme_content"], "readonly", function() {
                        txCompleteCB(theme_list);
                    });

                    var themeStore = trans.objectStore("theme");
                    var themeContentStore = trans.objectStore("theme_content");
                    var req = themeStore.openCursor();
                    req.onerror = function(e) {
                        console.log(e);
                    };
                    req.onsuccess = function(e) {
                        var themeCurs = e.target.result;
                        if (themeCurs) {
                            theme_list.push(themeCurs.value);
                            themeCurs.continue();
                        } else {
                            var req = themeContentStore.openCursor();
                            req.onsuccess = function(evt) {
                                var cursContent = evt.target.result;
                                if (cursContent) {
                                    var themeContent = cursContent.value;
                                    for (var i = 0; i < theme_list.length; i++) {
                                        if (theme_list[i].id === themeContent.theme_id) {
                                            theme_list[i].theme_content = themeContent.content;
                                            break;
                                        }
                                    }
                                    cursContent.continue();
                                }
                            };
                        }
                    };
                },
                getCountOfThemesWithParent: function(parentId, txCompleteCB) {
                    var count = 1;
                    var trans = jorteDB.getTransaction(["theme"], "readonly",
                            function() {
                                txCompleteCB(count);
                            },
                            function(e) {
                                console.log('getCountOfThemesWithParent tx error ', e);
                            }
                    );

                    var themeStore = trans.objectStore("theme");
                    var req = themeStore.index("parent").count(parseInt(parentId));
                    req.onsuccess = function() {
                        count += req.result;
                    };
                },
                deleteTheme: function(themeId, txCompleteCb) {
                    var trans = jorteDB.getTransaction(["theme", "theme_content"], "readwrite",
                            function() {
                                txCompleteCb();
                            },
                            function(e) {
                                console.log('updateTheme tx error', e);
                            }
                    );
                    var themeStore = trans.objectStore("theme");
                    var themeContentStore = trans.objectStore("theme_content");

                    themeStore.delete(parseInt(themeId));
                    themeContentStore.delete(parseInt(themeId));

                }
            };
        });

