'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.notification.helper', [])

        // Notification helper
        .factory('notificationHelperSvc', function() {
            var n;

            return{
                sendNotification: function(title, description, tag, callBack) {
                    var iconUri;
                    title = title ? title : null;
                    description = description ? description : null;

                    try {
                        iconUri = window.location.origin + '/' + jorteConfig.APP_ICON;
                        //Send notification here
                        if ("Notification" in window) {
                            if (Notification.permission !== "denied") {
                                Notification.requestPermission(function(permission) {
                                    if (!("permission" in Notification)) {
                                        Notification.permission = permission;
                                    }
                                });
                            }
                            if (Notification.permission === "granted") {
                                n = new Notification(title, {
                                    body: description,
                                    icon: iconUri,
                                    tag: tag
                                });
                                callBack && callBack(n);
                            }
                        }
                    } catch (err) {
                        console.log(err.name + ": " + err.message);
                    }
                },
                setAlarm: function(alarmTime, taskId) {
                    // The "ignoreTimezone" string makes the alarm ignore timezones and always go off at the same time wherever you are
                    var request = navigator.mozAlarms.add(alarmTime, "ignoreTimezone", {task: taskId});
                    request.onsuccess = function() {
                    };
                    request.onerror = function() {
                        console.log("An error occurred: " + this.error.name);
                    };
                }
            };
        });