'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.notification.notification', [])

        // Notification service
        .factory('notificationSvc', ['$rootScope', 'reminderSvc', 'notificationHelperSvc',function($rootScope, reminderSvc, notificationHelperSvc) {
            var n;
            var snoozePoints = false;
            var snoozePeriod = 5 * 60 * 1000;
            var itemUpdateInterval = 2 * 60 * 60 * 1000;
            function sendNotification(title, description) {
                title = title ? title : null;
                description = description ? description : null;
                notificationHelperSvc.sendNotification(title, description, 'jorteReminderNotifications', function(notifyObj) {
                    n = notifyObj;
                    n.onclick = notifyPopup;
                });
            }

            function notifyPopup(e) {
                e.preventDefault();
                e.stopPropagation();
                //Launching app from background
                var request = window.navigator.mozApps.getSelf();
                request.onsuccess = function() {
                    request.result.launch();
                    $rootScope.$broadcast('openNotification', null);
                    removeNotification();
                };
                request.onerror = function() {
                    console.log("Error: " + request.error.name);
                };
            }

            function removeNotification() {
                try {
                    n.close();
                } catch (err) {
                    console.log(err.name + ": " + err.message);
                }
            }

            function notify(options) {
                var item = options.item;
                var count = options.count;
                var date = options.date;
                var format = 'HH:mm tt';
                var description = (count > 1 ? ' (' + (count - 1) + ' more reminder' + (count !== 2 ? 's' : '') + ')' : '');
                description = description ? jorteUtils.formatDate(date, format) + description : (item.location ? item.location + ' - ' : '') + jorteUtils.formatDate(date, format);
                sendNotification(item.name ? item.name : getMSG('NoSubjectHead'), description);
            }

            function activate(options) {
                var ids = options.ids;
                var date = options.date || false;
                var item = options.item || false;

                reminderSvc.activateReminders(ids, date, item, function(data) {
                    if (data === 0) {
                        removeNotification();
                    } else {
                        notify(data);
                    }
                });
            }

            function updateSnoozePoints(points) {
                snoozePoints = points;
            }

            function snoozer(date) {
                date.setMilliseconds(0);
                var time = date.getTime();
                for (var k in snoozePoints) {
//                if (k <= time) {
                    snoozeAlert(k, snoozePoints[k]);
//                }
                }
            }

            function snoozeAlert(time, ids) {
                reminderSvc.getEventsAndTaskByInstanceId(ids, function(data) {
                    activate({
                        ids: ids,
                        date: new Date(parseInt(time)),
                        item: data[0]
                    });
                    removeSnoozePoint(time);
                });
            }

            function removeSnoozePoint(time) {
                delete snoozePoints[time];
                if ($.isEmptyObject(snoozePoints)) {
                    snoozePoints = false;
                    delete localStorage['snoozePoints'];
                } else {
                    localStorage.snoozePoints = JSON.stringify(snoozePoints);
                }
                updateSnoozePoints(snoozePoints);
            }

            function clearAll() {
                reminderSvc.clearAllReminders(function() {
                    removeNotification();
                });
            }

            function addSnoozePoint(options) {
                var snoozeTime = new Date();
                snoozeTime.setMilliseconds(0);
                snoozeTime = snoozeTime.getTime();
                snoozeTime = snoozeTime + options.time;

                if (!snoozePoints)
                    snoozePoints = {};
                if (snoozePoints[snoozeTime]) {
                    // If the point already exists, merging the new ids
                    $.extend(snoozePoints[snoozeTime], options.ids);
                } else {
                    snoozePoints[snoozeTime] = options.ids;
                }
                localStorage.snoozePoints = JSON.stringify(snoozePoints);
                updateSnoozePoints(snoozePoints);
                addSnoozeReminder(snoozeTime);
            }

            //Snoozed reminder notification
            function addSnoozeReminder(snoozeTime) {
                if (navigator.mozAlarms) {
                    var alarmTime = jorteUtils.formatDate(new Date(snoozeTime), 'MMM dd, yyyy HH:mm:00');
                    notificationHelperSvc.setAlarm(alarmTime, 'reminder_notification');
                } else {
                    console.log("Browser does not support alarm");
                }
            }

            function checkReminder(mozAlarm) {
                if (mozAlarm && mozAlarm.data.task !== 'reminder_notification') {
                    return;
                }
                var cDate = new Date();
                cDate.setSeconds(0, 0);

                reminderSvc.getAllItemsWithReminder(cDate, function(data) {
                    var ids = [];
                    var rs = data;

                    /* Preparing query for updating event status */
                    for (var i = 0, item = null; i < rs.length; i++) {
                        item = rs[i];
                        ids[i] = item.id;
                    }

                    if (i > 0) {
                        activate({
                            ids: ids,
                            date: cDate,
                            item: rs[0]
                        });
                    }
                });
            }

            return{
                init: function(mozAlarm) {
                    checkReminder(mozAlarm);
                    /* Snooze checking */
                    if (snoozePoints) {
                        var cDt = new Date();
                        snoozer(cDt);
                    }

                    /* Initializing snooze points from storage */
                    if (localStorage.snoozePoints) {
                        var cTime = new Date();
                        cTime.setMilliseconds(0);
                        cTime = cTime.getTime();
                        snoozePoints = {};
                        $.each($.parseJSON(localStorage.snoozePoints), function(k, v) {
                            if (k > (cTime - 60 * 1000))
                                snoozePoints[k] = v;
                        });
                        localStorage.snoozePoints = JSON.stringify(snoozePoints);
                    }
                    updateSnoozePoints(snoozePoints);
                },
                itemUpdateStatusCheck: function(itemId, isEvent) {
                    var dateA = (new Date()).getTime();
                    var dateB = dateA - itemUpdateInterval;
                    reminderSvc.inspectItemInstances(itemId, isEvent, dateA, dateB, function(data) {
                        if (data.length === 0) {
                            return;
                        }
                        addSnoozePoint({time: 5 * 1000, ids: [data[0].id]});
                    });
                },
                dismissAll: function() {
                    clearAll();
                    return false;
                },
                snoozeAll: function() {
                    reminderSvc.getInstancesHavingReminder(function(data) {
                        var items = [];
                        var rs = data;
                        for (var i = 0; i < rs.length; i++)
                            items[i] = rs[i];
                        addSnoozePoint({
                            time: snoozePeriod,
                            ids: items
                        });
                        clearAll();
                    });
                    return false;
                }
            };
        }]);