
'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.oauth.googleAuth', [])

        // googleAuth service
        .factory('googleAuthSvc', ['$http', function($http) {
                var cWindow = '';
                var config = {
                    authUri: "https://accounts.google.com/o/oauth2/auth",
                    tokenUri: "https://accounts.google.com/o/oauth2/token",
                    responseType: "code",
                    grantTypes: {
                        AUTHORIZE: "authorization_code",
                        REFRESH: "refresh_token"
                    },
                    accessType: "offline",
                    state: "jorte-firefox"
                };

                var account = null;
                var scope = {
                    CALENDAR: 'https://www.googleapis.com/auth/calendar',
                    USER_EMAIL: 'email',
                    USER_PROFILE: 'profile',
                    TASKS: 'https://www.googleapis.com/auth/tasks',
                    TASKS_READ: 'https://www.googleapis.com/auth/tasks.readonly'
                };

                function autoAuth(uri, cb) {
                    cWindow = window.open('/google-oauth.html', 'auth_window');
                    cWindow.authUrl = uri;
                    cWindow.checkAuth = function(e) {
                        var title = e.detail, res;
                        if (title.indexOf("code=") !== -1) {
                            res = getParameterByName("code", title);
                            cWindow.onunload = null;
                            cWindow.close();
                            cb(true, res);
                        } else if (title.indexOf("error=") !== -1) {
                            res = getParameterByName("error", title);
                            cWindow.onunload = null;
                            cWindow.close();
                            cb(false, res);
                        }
                    };

                    cWindow.onload = function() {
                        cWindow.onunload = function() {
                            cb(false, 'close');
                        };
                    };
                }

                function getParameterByName(name, url) {
                    name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
                    var regexS = "[\\?&]" + name + "=([^&#]*)";
                    var regex = new RegExp(regexS);
                    var results = regex.exec(url);
                    if (!results) {
                        return false;
                    } else
                        return decodeURIComponent(results[1].replace(/\+/g, " "));
                }

                function requestToken(code, cb) {

                    $http({
                        method: 'POST',
                        cache: false,
                        data: $.param({
                            "code": code,
                            "client_id": jorteConfig.GAPI.clientId,
                            "client_secret": jorteConfig.GAPI.clientSecret,
                            "redirect_uri": jorteConfig.GAPI.redirectUri,
                            "grant_type": config.grantTypes.AUTHORIZE
                        }),
                        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'},
                        url: config.tokenUri
                    }).success(function(data, status, headers, config) {
                        saveToken(data);
                        getUser(function(userData) {
                            var status = false;
                            if (userData) {
                                saveUser(userData);
                                status = userData;
                            } else {
                                clearAccount();
                            }
                            cb && cb(status);
                        });
                    }).error(function(data, status, headers, config) {
                        cb && cb(false);
                    });
                }

                function getUser(cb) {
                    apiCall('oauth2/v1/userinfo', {}, 'GET', cb);
                }

                function apiCall(api, params, method, cb) {

                    getAccessToken(function(AT) {

                        if (!AT) {
                            cb && cb(false);
                        } else {
                            var mathod = method || "GET";
                            var request = new XMLHttpRequest({mozSystem: true});
                            request.open(method, 'https://www.googleapis.com/' + api, cb ? true : false);
                            request.setRequestHeader("Authorization", 'Bearer ' + AT);
                            if (mathod === 'POST') {
                                request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                                if (typeof params === 'object') {
                                    var ps = '';
                                    for (var x in params) {
                                        ps += x + '=' + params[x] + '&';
                                    }
                                    params = ps + 'z=z';
                                    request.setRequestHeader("Content-length", params.length);
                                }
                            }
                            var data = params || {};
                            request.onload = function(xhr) {
                                cb && cb(xhr.target.response);
                            };
                            request.onerror = function(xhr) {
                                console.log('API request error : API - ' + api + ' : Msg - ' + xhr.responseText);
                                cb && cb(false);
                            };
                            request.send(data);
                        }
                    });
                }

                function saveUser(data) {
                    data = typeof data === 'string' ? JSON.parse(data) : data;
                    account.profile = {
                        id: data.id,
                        email: data.email,
                        emailVerified: data.verified_email,
                        name: data.name,
                        fName: data.given_name,
                        lName: data.family_name,
                        link: data.link,
                        gender: data.gender,
                        birthday: data.birthday,
                        locale: data.locale
                    };
                    jorteConfig.setGoogleAccount(account);
                }

                function fetchToken() {
                    var ga = account;
                    if (!ga) {
                        return false;
                    }

                    var s = {
                        token: ga.access_token,
                        refresh_token: ga.refresh_token,
                        expiry: ga.expiry
                    };
                    return s;
                }

                function saveToken(data) {
                    data = typeof data === 'string' ? JSON.parse(data) : data;
                    var ga = account || {};
                    ga.access_token = data.access_token;
                    ga.expiry = data.expires_in ? (new Date()).getTime() + (data.expires_in * 1000) : data.expiry;
                    if (typeof data.refresh_token !== 'undefined') {
                        ga.refresh_token = data.refresh_token;
                    }
                    account = ga;
                    jorteConfig.setGoogleAccount(ga);
                }

                function getAccessToken(callBack) {
                    var cTime = (new Date()).getTime();
                    var sToken = fetchToken();
                    var rToken = false;
                    /* Checking if existing Token expired */
                    if (sToken.token && cTime < sToken.expiry) {
                        callBack && callBack(sToken.token);
                    } else {

                        $http({
                            method: 'POST',
                            cache: false,
                            data: $.param({
                                "client_id": jorteConfig.GAPI.clientId,
                                "client_secret": jorteConfig.GAPI.clientSecret,
                                "refresh_token": sToken.refresh_token,
                                "grant_type": config.grantTypes.REFRESH
                            }),
                            headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'},
                            url: config.tokenUri
                        }).success(function(data, status, headers, config) {
                            saveToken(data);
                            rToken = data ? data.access_token : false;
                            callBack && callBack(rToken);
                        }).error(function(data, status, headers, config) {
                            callBack && callBack(rToken);
                        });

                    }

                }
                function clearAccount() {
                    jorteConfig.removeGoogleAccount();
                    jorteConfig.removeGoogleCalendarAutoSync();
                    account = jorteConfig.getGoogleAccount() || null;
                }
                return {
                    init: function() {
                        account = jorteConfig.getGoogleAccount() || null;
                    },
                    auth: function(cb) {
                        var authUri = config.authUri + '?';
                        authUri += 'scope=' + encodeURIComponent(scope.CALENDAR) + '+' + encodeURIComponent(scope.USER_EMAIL) + '+' + encodeURIComponent(scope.USER_PROFILE) + '+' + encodeURIComponent(scope.TASKS);
                        authUri += '&redirect_uri=' + encodeURIComponent(jorteConfig.GAPI.redirectUri);
                        authUri += '&response_type=' + encodeURIComponent(config.responseType);
                        authUri += '&client_id=' + encodeURIComponent(jorteConfig.GAPI.clientId);
                        authUri += '&state=' + encodeURIComponent(config.state);
                        authUri += '&access_type=' + encodeURIComponent(config.accessType);
                        authUri += '&approval_prompt=force';

                        autoAuth(authUri, function(status, val) {
                            if (status) {
                                requestToken(val, function(data) {
                                    if (data) {
                                        cb(data);
                                    } else {
                                        status = false;
                                        val = 'Cannot get authentication token from Google.';
                                    }
                                });
                            } else {
                                cb(false, val);
                            }
                        });
                    },
                    getAccount: function() {
                        return account;
                    },
                    setAccount: function(data) {
                        account = data;
                    },
                    clearAccount: function() {
                        clearAccount();
                    },
                    fetchUserProfile: function() {
                        var ga = account;
                        return ga ? ga.profile : false;
                    },
                    saveLastSyncTime: function() {
                        jorteConfig.setGoogleAccountLastSyncDate(new Date().getTime());
                    },
                    apiCall: function(api, params, method, cb) {
                        apiCall(api, params, method, cb);
                    },
                    getAccessToken: function(cb) {
                        getAccessToken(cb);
                    },
                    saveTmpToken: function(data) {
                        saveToken(data);
                    }
                }
                ;
            }]);