
'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.oauth.jorteAuth', [])

        // jorteAuth service
        .factory('jorteAuthSvc', ['$http', function($http) {

                var account = null;
                function saveUser(data) {
                    account = {
                        'jorteId': data.userCode,
                        'applicationCode': data.applicationCode,
                        'accessToken': data.requestToken
                    };

                    var jSyncStatus = {
                        'status': 1,
                        'jorteId': data.userCode
                    };
                    jorteConfig.setJorteAccount(account);
                    jorteConfig.setJorteSync(jSyncStatus);

                }
                return {
                    init: function() {
                        account = jorteConfig.getJorteAccount() || null;
                    },
                    auth: function(cb, jorte_id, jorte_pwd) {
                        var params = {
                            'userCode': jorte_id,
                            'applicationCode': 'jorte-droid',
                            'password': jorte_pwd
                        };
                        $http({
                            method: 'POST',
                            cache: false,
                            data: $.param({
                                "userCode": params.userCode,
                                "applicationCode": params.applicationCode,
                                "password": params.password
                            }),
                            headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'},
                            url: jorteConfig.JORTE.SERVER_URL + jorteConfig.JORTE.LOGIN_URL
                        }).success(function(data, status, headers, config) {
                            var user_data = {
                                userCode: params.userCode,
                                applicationCode: params.applicationCode,
                                requestToken: data
                            };
                            saveUser(user_data);
                            cb(data);
                        }).error(function(data, status, headers, config) {
                            cb();
                            console.log(' Error ', data);
                            alert(getMSG('jorteInvalidHead'));
                        });
                    },
                    getAccount: function() {
                        return account;
                    },
                    setAccount: function(data) {
                        account = data;
                    },
                    clearAccount: function() {
                        var jSyncStatus = {
                            'status': 0,
                            'jorteId': account.jorteId
                        };

                        jorteConfig.removeJorteAccount();
                        jorteConfig.removeJorteCalendarAutoSync();
                        jorteConfig.setJorteSync(jSyncStatus);
                        this.init();
                    },
                    fetchUserProfile: function() {
                        var ja = account;
                        return ja ? ja : false;
                    },
                    fetchJSyncStatus: function() {
                        var js = jorteConfig.getJorteSync();
                        return js ? js : '';
                    }
                };
            }]);