'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.rrule', [])
        //Repeat rule
        .factory('rruleSvc', function() {
            function weekNum(d) {
                return Math.ceil(new Date(d).getDate() / 7);
            }

            function weekAndDay(d) {
                return Math.ceil(new Date(d).getDate() / 7) + ' ' + cal_string.dayNames[new Date(d).getDay()];
            }

            return {
                getRRule: function(params) {
                    var params = params;
                    var untill = null, countt = null, intervell = null;
                    if (params.specify) {
                        untill = params.specifyDay;
                    } else if (params.endDate) {
                        countt = params.repNum;
                    }
                    intervell = params.repeatInterval;
                    var rule = null;
                    switch (params.type) {
                        case 1:
                            rule = new RRule({
                                freq: RRule.DAILY,
                                until: untill,
                                count: countt,
                                interval: intervell,
                                wkst: RRule.SU
                            });
                            break;
                        case 2:
                            rule = new RRule({
                                freq: RRule.WEEKLY,
                                until: untill,
                                count: countt,
                                byweekday: [RRule.MO, RRule.TU, RRule.WE, RRule.TH, RRule.FR],
                                wkst: RRule.SU
                            });
                            break;
                        case 3:
                            var weekday = null;
                            var currDate = params.currentDate;
                            var day = jorteUtils.formatDate(currDate, 'ddd');
                            if (day === 'Tue' || day === 'Thu') {
                                weekday = [RRule.TU, RRule.TH];
                            } else {
                                weekday = [RRule.MO, RRule.WE, RRule.FR];
                            }
                            rule = new RRule({
                                freq: RRule.WEEKLY,
                                until: untill,
                                count: countt,
                                byweekday: weekday,
                                wkst: RRule.SU
                            });
                            break;
                        case 4:
                            var weekArray = [];
                            (params.weekDays[0].val) ? weekArray[weekArray.length] = RRule.MO : 0;
                            (params.weekDays[1].val) ? weekArray[weekArray.length] = RRule.TU : 0;
                            (params.weekDays[2].val) ? weekArray[weekArray.length] = RRule.WE : 0;
                            (params.weekDays[3].val) ? weekArray[weekArray.length] = RRule.TH : 0;
                            (params.weekDays[4].val) ? weekArray[weekArray.length] = RRule.FR : 0;
                            (params.weekDays[5].val) ? weekArray[weekArray.length] = RRule.SA : 0;
                            (params.weekDays[6].val) ? weekArray[weekArray.length] = RRule.SU : 0;
                            rule = new RRule({
                                freq: RRule.WEEKLY,
                                until: untill,
                                count: countt,
                                byweekday: weekArray,
                                interval: intervell,
                                wkst: RRule.SU
                            });
                            break;
                        case 5:
                            var strtday, dayOfWeek = null;
                            var currDate = params.currentDate;
                            if (params.stdDate) {
                                var daynumber = weekNum(params.currentDate);
                                if (daynumber === 1) {
                                    daynumber = +1;
                                } else if (daynumber === 5) {
                                    daynumber = -1;
                                }
                                var dayy = currDate.getDay();
                                if (dayy === 0) {
                                    strtday = RRule.SU;
                                    dayOfWeek = RRule.SU.nth(daynumber);
                                } else if (dayy === 1) {
                                    strtday = RRule.MO;
                                    dayOfWeek = RRule.MO.nth(daynumber);
                                } else if (dayy === 2) {
                                    strtday = RRule.TU;
                                    dayOfWeek = RRule.TU.nth(daynumber);
                                } else if (dayy === 3) {
                                    strtday = RRule.WE;
                                    dayOfWeek = RRule.WE.nth(daynumber);
                                } else if (dayy === 4) {
                                    strtday = RRule.TH;
                                    dayOfWeek = RRule.TH.nth(daynumber);
                                } else if (dayy === 5) {
                                    strtday = RRule.FR;
                                    dayOfWeek = RRule.FR.nth(daynumber);
                                } else if (dayy === 6) {
                                    strtday = RRule.SA;
                                    dayOfWeek = RRule.SA.nth(daynumber);
                                }
                            } else {
                                strtday = RRule.SU;
                            }

                            if (daynumber) {
                                rule = new RRule({
                                    freq: RRule.MONTHLY,
                                    byweekday: strtday,
                                    until: untill,
                                    count: countt,
                                    interval: intervell,
                                    wkst: strtday,
                                    bysetpos: daynumber
                                });
                            } else {
                                rule = new RRule({
                                    freq: RRule.MONTHLY,
                                    byweekday: dayOfWeek,
                                    until: untill,
                                    count: countt,
                                    interval: intervell,
                                    wkst: strtday
                                });
                            }
                            break;
                        case 6:
                            rule = new RRule({
                                freq: RRule.YEARLY,
                                until: untill,
                                count: countt,
                                interval: intervell,
                                wkst: RRule.SU
                            });
                            break;
                    }
                    if (rule) {
                        return rule;
                    }
                    return null;
                },
                getRRLabel: function(params) {
                    var currDate = params.currentDate;
                    var day = jorteUtils.formatDate(currDate, 'ddd');
                    var new_end_date = null;
                    var add_value, label;
                    var label = null;
                    switch (params.type) {
                        case 0:
                            label = getMSG('OneTimeEventHead');
                            break;
                        case 1: //Daily
                            add_value = parseInt(params.repeatInterval * 5);
                            if (params.specify && params.endDate) {
                                // END DATE
                                var specifyDate = (params.specifyDay) ? params.specifyDay : currDate;
                                if (params.specifyDay) {
                                    new_end_date = new Date(specifyDate);
                                } else {
                                    new_end_date = new Date(currDate.getFullYear(), currDate.getMonth(), currDate.getDate() + add_value);
                                }
                                var new_date = jorteUtils.formatDate(new_end_date, getMSG('LongDateFormat8'), cal_string);
                                if (params.repeatInterval === 1) {
                                    label = getMSG('DailyHead') + ',( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('DaysHead') + ',  ( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                                }
                            } else if (params.endDate && !params.specify) {
                                // NUMBER TIMES
                                if (params.repeatInterval === 1) {
                                    label = getMSG('DailyHead') + ', ' + params.repNum + ' ' + getMSG('timesHead');
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + getMSG('DaysHead') + ', ' + params.repNum + ' ' + getMSG('timesHead');
                                }
                            } else {
                                // NONE
                                if (params.repeatInterval === 1) {
                                    label = getMSG('DailyHead');
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('DaysHead');
                                }
                            }
                            break;
                        case 2: //Every weekday (Mon to Fri)
                            add_value = parseInt(params.repeatInterval * 35);
                            if (params.specify && params.endDate) {
                                // END DATE
                                var specifyDate = (params.specifyDay) ? params.specifyDay : currDate;
                                if (params.specifyDay) {
                                    new_end_date = new Date(specifyDate);
                                } else {
                                    new_end_date = new Date(currDate.getFullYear(), currDate.getMonth(), currDate.getDate() + add_value);
                                }
                                var new_date = jorteUtils.formatDate(new_end_date, getMSG('LongDateFormat8'), cal_string);
                                label = getMSG('EveryHead') + '' + getMSG('WeekdayHead') + ', ( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                            } else if (params.endDate && !params.specify) {
                                // NUMBER TIMES
                                label = getMSG('EveryHead') + ' ' + getMSG('RPTWeekdayHead') + ', ' + params.repNum + ' ' + getMSG('timesHead');
                            } else {
                                // NONE
                                label = getMSG('EveryHead') + ' ' + getMSG('WeekdayHead');
                            }
                            break;
                        case 3:
                            var weeklyLabel, weeklyLabel2;
                            if (day === 'Tue' || day === 'Thu') {
                                weeklyLabel = getMSG('WeeklyTueThuHead');
                                weeklyLabel2 = getMSG('WeeklyTueThuHead2');
                            } else {
                                weeklyLabel = getMSG('WeeklyMonWedFriHead');
                                weeklyLabel2 = getMSG('WeeklyMonWedFriHead');
                            }
                            params.label = weeklyLabel;
                            new_end_date = new Date(currDate.getFullYear(), currDate.getMonth(), currDate.getDate() + 245, 0, 0, 0);
                            // CHANGING OUTLINE DATA BASED ON SELECTED RADIO BUTTON
                            if (params.specify && params.endDate) {
                                // END DATE
                                var specifyDate = (params.specifyDay) ? params.specifyDay : currDate;
                                if (params.specifyDay) {
                                    new_end_date = new Date(specifyDate);
                                } else {
                                    new_end_date = new Date(currDate.getFullYear(), currDate.getMonth(), currDate.getDate() + 245, 0, 0, 0);
                                }
                                var new_date = jorteUtils.formatDate(new_end_date, getMSG('LongDateFormat8'), cal_string);
                                label = weeklyLabel2 + ' ,( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                            } else if (params.endDate && !params.specify) {
                                // NUMBER TIMES
                                label = weeklyLabel2 + ', ' + params.repNum + '' + getMSG('timesHead');
                            } else {
                                // NONE
                                label = weeklyLabel2;
                            }
                            break;
                        case 4: //Week Day
                            var dayLabel = '';
                            for (var i = 0; i < params.weekDays.length; i++) {
                                var weekDay = params.weekDays[i];
                                if (weekDay.val === true) {
                                    dayLabel += ',' + weekDay.label + ' ' + getMSG('DayOfWeekOutline');
                                }
                            }
                            add_value = parseInt(params.repeatInterval * 245);
                            // CHANGING OUTLINE DATA BASED ON SELECTED RADIO BUTTON
                            if (params.specify && params.endDate) {
                                // END DATE
                                var specifyDate = (params.specifyDay) ? params.specifyDay : currDate;
                                if (params.specifyDay) {
                                    new_end_date = new Date(specifyDate);
                                } else {
                                    new_end_date = new Date(currDate.getFullYear(), currDate.getMonth(), currDate.getDate() + add_value, 0, 0, 0);
                                }
                                var new_date = jorteUtils.formatDate(new_end_date, getMSG('LongDateFormat8'), cal_string);
                                if (params.repeatInterval === 1) {
                                    label = getMSG('WeeklyHead') + ' ' + dayLabel + '( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('WeeklyRepeatHead') + ' ' + dayLabel + ', ( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                                }
                            } else if (params.endDate && !params.specify) {
                                // NUMBER TIMES
                                if (params.repeatInterval === 1) {
                                    label = getMSG('WeeklyHead') + ' ' + dayLabel + ', ' + params.repNum + ' ' + getMSG('timesHead');
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + getMSG('WeeklyRepeatHead') + ' ' + dayLabel + ', ' + params.repNum + ' ' + getMSG('timesHead');
                                }
                            } else if (!params.endDate) {
                                // NONE
                                if (params.repeatInterval === 1) {
                                    label = getMSG('WeeklyHead') + ' ' + dayLabel;
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('WeeklyRepeatHead') + ' ' + dayLabel;
                                }
                            }
                            break;
                        case 5: //Monthly
                            var daynumber = weekAndDay(currDate);
                            add_value = parseInt(params.repeatInterval * 35);
                            var day = jorteUtils.formatDate(params.currentDate, 'dd');
                            if (params.specify && params.endDate) {
                                var specifyDate = (params.specifyDay) ? params.specifyDay : currDate;
                                if (params.specifyDay) {
                                    new_end_date = new Date(specifyDate);
                                } else {
                                    new_end_date = new Date(currDate.getFullYear(), currDate.getMonth() + add_value, currDate.getDate(), 0, 0, 0);
                                }
                                var new_date = jorteUtils.formatDate(new_end_date, getMSG('LongDateFormat8'), cal_string);
                                if (params.repeatInterval === 1) {
                                    if (params.stdDate) {
                                        label = getMSG('MonthlyTheHead') + ' ' + daynumber + ' ,( '
                                                + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                                    } else {
                                        label = getMSG('MonthlyHead') + ' ' + day + '' + getMSG('DayHead')
                                                + ', ( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                                    }
                                } else {
                                    if (params.stdDate) {
                                        label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('MonthsTheHead')
                                                + daynumber + ' ,( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                                    } else {
                                        label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('MonthsTheHead') + ',  ' + day
                                                + getMSG('DaysHead') + ',( ' + getMSG('RPTFromToHead', {dateNew: new_date}) + ' )';
                                    }
                                }
                            } else if (params.endDate && !params.specify) {
                                if (params.repeatInterval === 1) {
                                    if (params.stdDate) {
                                        label = getMSG('MonthlyTheHead') + ' ' + daynumber + ',  ' + params.repNum + ' ' + getMSG('timesHead');
                                    } else {
                                        label = getMSG('MonthlyHead') + ' ' + day + ' ' + getMSG('DayHead') + ',  ' + params.repNum + ' ' + getMSG('timesHead');
                                    }
                                } else {
                                    if (params.stdDate) {
                                        label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('MonthsTheHead') + daynumber + ' , ' + params.repNum + ' ' + getMSG('timesHead');
                                    } else {
                                        label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('MonthsTheHead') + ',  ' + day + ' ' + getMSG('DayHead') + ',  ' + params.repNum + ' ' + getMSG('timesHead');
                                    }
                                }
                            } else {
                                if (params.repeatInterval === 1) {
                                    if (params.stdDate) {
                                        label = getMSG('MonthlyTheHead') + ' ' + daynumber;
                                    } else {
                                        label = getMSG('MonthlyHead') + ' ' + day + ' ' + getMSG('DayHead');
                                    }
                                } else {
                                    if (params.stdDate) {
                                        label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + getMSG('MonthsTheHead') + ' ' + daynumber;
                                    } else {
                                        label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + getMSG('MonthsTheHead') + ' ' + day + ' ' + getMSG('DayHead');
                                    }
                                }
                            }
                            break;
                        case 6: //Yearly
                            add_value = parseInt(params.repeatInterval * 5);
                            var day = jorteUtils.formatDate(currDate, getMSG('ShortDateFormat5'));
                            if (params.specify && params.endDate) {
                                // END DATE
                                var specifyDate = (params.specifyDay) ? params.specifyDay : currDate;
                                if (params.specifyDay) {
                                    new_end_date = new Date(specifyDate);
                                } else {
                                    new_end_date = new Date(currDate.getFullYear() + add_value, currDate.getMonth(), currDate.getDate(), 0, 0, 0);
                                }
                                var new_date = jorteUtils.formatDate(new_end_date, getMSG('LongDateFormat8'), cal_string);
                                if (params.repeatInterval === 1) {
                                    label = getMSG('YearlyHead') + ' ' + day + ',(' + getMSG('RPTFromToHead', {dateNew: new_date}) + ')';
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + getMSG('YearlyRepeatHead') + ' ' + day + ',(' + getMSG('RPTFromToHead', {dateNew: new_date}) + ')';
                                }
                            } else if (params.endDate && !params.specify) {
                                // NUMBER TIMES
                                if (params.repeatInterval === 1) {
                                    label = getMSG('YearlyHead') + ' ' + day + ', ' + params.repNum + ' ' + getMSG('timesHead');
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + getMSG('YearlyRepeatHead') + ' ' + day + ', ' + params.repNum + ' ' + getMSG('timesHead');
                                }
                            } else {
                                // NONE
                                if (params.repeatInterval === 1) {
                                    label = getMSG('YearlyHead') + ' ' + day;
                                } else {
                                    label = getMSG('EveryOtherHead') + ' ' + params.repeatInterval + ' ' + getMSG('YearlyRepeatHead') + ' ' + day;
                                }
                            }
                            break;
                    }
                    return {label: label, endDate: new_end_date};
                }
            };
        });