'use strict';
/**
 * Jorte services
 *
 */
angular.module('services.sync.googleSync', [])

        // google sync service
        .factory('googleSyncSvc', ['googleAuthSvc', function (googleAuthSvc) {

                var GAPI = 'https://www.googleapis.com/';
                var API = 'calendar/v3/';
                var api = 'calendar/v3/';
                var TASK_API = 'tasks/v1/';
                var CALENDAR_TYPE = 300;
                var googleAccount = null;
                var COLORS_SEQUENCE = ['#a4bdfc', '#7ae7bf', '#dbadff', '#ff887c', '#fbd75b', '#ffb878', '#46d6db', '#e1e1e1', '#5484ed', '#51b749', '#dc2127'];

                function apiGet(api, params, cb) {
                    googleAuthSvc.apiCall(api, params, 'GET', cb);
                }

                function getTimeZone() {
                    var objLocalZone = new Date();
                    var strLocalZone = '' + objLocalZone;
                    var mySplitResult = strLocalZone.split(" ");
                    var newLocalZone = mySplitResult[5].slice(0, mySplitResult[5].length - 2) + ':' + mySplitResult[5].slice(mySplitResult[5].length - 2, mySplitResult[5].length);
                    return newLocalZone;
                }

                function getSyncEventObj(item) {
                    if (item.deleted === 1||item.deleted_status===1) {
                        var apiUri = 'calendars/' + encodeURIComponent(item.cal_global_id) + '/events/' + item.global_id + '';

                        var req = {
                            requestUri: GAPI + API + apiUri,
                            method: 'DELETE'
                        };
                        return req;
                    }
                  
                    var e = {
                        description: item.content,
                        status: 'confirmed',
                        summary: item.name
                    };
                    if (item.importance && item.completed) {
                        e.summary = item.name + '[!/C]';
                    } else if (item.importance) {
                        e.summary = item.name + '[!]';
                    } else if (item.completed) {
                        e.summary = item.name + '[C]';
                    }   
                    e.start = {};
                    e.end = {};

                    if (item.all_day === 1) {
                        if (item.start_date) {
                            e.start.date = jorteUtils.toDateOnly(item.start_date);
                        }
                        if (item.end_date) {
                            e.end.date = jorteUtils._toDateOnly(item.end_date);
                        }
                    } else {

                        if (item.start_date) {
                            e.start.dateTime = jorteUtils.toRFP3339(item.start_date);
                            e.start.timeZone = item.timezone;
                        }
                        if (item.end_date) {
                            e.end.dateTime = jorteUtils.toRFP3339(item.end_date);
                            e.start.timeZone = item.timezone;
                        }
                    }
                    if (item.reminders && item.reminders.length !== 0) {
                        e.reminders = {};
                        e.reminders.useDefault = "false";
                        var remi = [];
                        for (var r = 0; r < item.reminders.length; r++) {
                            remi[r] = {method: 'email', minutes: item.reminders[r].minutes};
                        }
                        e.reminders.overrides = remi;
                    }
                    if (item.repeat) {
                        e.recurrence = [];
                        e.recurrence[0] = 'RRULE:' + item.repeat;
                        if (e.start.dateTime) {
                            var timezone = getTimeZone();
                            e.start.timeZone = timezone;
                            e.end.timeZone = timezone;
                        }
                    }
                    if ((item.seqno || item.seqno === 0) && item.sync_version) {
                        e.sequence = parseInt(item.seqno, 10) + 1;
                    }else{
                        e.sequence = 0;
                    }
                    
                    if(item.parent && item.parent_global && item.parent_event){
                        e.recurringEventId = item.parent_global;
                        e.originalStartTime = {};
                        if (item.parent_event.all_day === 1) {
                            e.originalStartTime.date  = jorteUtils.toDateOnly(item.originalStartDate);
                        } else {
                            e.originalStartTime.dateTime = jorteUtils.toRFP3339(item.originalStartDate);
                        }
                        if (!item.global_id) {
                            e.sequence = parseInt(item.parent_event.seqno, 10) + 1;
                        }
                    }

                    if (item.color) {
                        var index = COLORS_SEQUENCE.indexOf(item.color);
                        if (index !== -1) {
                            e.colorId = index + 1;
                        }
                    }
                    if (item.location) {
                        e.location = item.location;
                    }
                    var apiUri = 'calendars/' + encodeURIComponent(item.cal_global_id) + '/events' + (item.global_id ? '/' + item.global_id : '');

                    var req = {
                        requestUri: GAPI + API + apiUri,
                        method: (item.global_id ? 'PUT' : 'POST'),
                        data: e
                    };

                    return req;

                }

                function getSyncTaskObj(item) {
                    if (item.deleted === 1) {
                        var apiUri = TASK_API + 'lists/' + encodeURIComponent(item.listid) + '/tasks/' + item.global_id + '';

                        var req = {
                            requestUri: GAPI + apiUri,
                            method: 'DELETE'
                        };
                        return req;
                    }
                    var stat = 'needsAction';
                    if (item.completed === 1) {
                        stat = 'completed';
                    }
                    var e = {
                        title: item.name,
                        status: stat,
                        notes: item.memo
                    };

                    if (item.due_date) {
                        e.due = jorteUtils._toRFP3339(item.due_date);
                    }

                    if (item.global_id) {
                        e.id = item.global_id;
                    }


                    var apiUri = TASK_API + 'lists/' + encodeURIComponent(item.listid) + '/tasks' + (item.global_id ? '/' + item.global_id : '');

                    var req = {
                        requestUri: GAPI + apiUri,
                        method: (item.global_id ? 'PUT' : 'POST'),
                        data: e
                    };
                    return req;
                }

                function getEventParams(item, calTimeZone) {
                    var params = {
                        startDate: null,
                        endDate: null,
                        startTime: null,
                        endTime: null,
                        repeat: null,
                        exdate: null,
                        createDate: null,
                        updateDate: null,
                        allDay: null,
                        day_time: 0,
                        recurringEventId: null,
                        originalTime: null,
                        reminders: null,
                        sequence: null,
                        color: null,
                        timeZone: null
                    };
                    if (!item) {
                        return params;
                    }
                    params.timeZone = item.start && item.start.timeZone ? item.start.timeZone : calTimeZone;
                    if (item.start) {
                        if (item.start.dateTime) {
                            params.startDate = new Date(item.start.dateTime).getTime();
                            params.startTime = new Date(params.startDate);
                            params.startTime.setHours(0, 0, 0, 0);
                            params.startTime = (params.startDate - params.startTime.getTime()) / (60 * 1000);
                        } else if (item.start.date) {
                            params.startDate = (new Date(item.start.date)).getTime();
                        }
                    }
                    if (item.end) {
                        if (item.end.dateTime) {
                            params.endDate = new Date(item.end.dateTime).getTime();
                            params.endTime = new Date(params.endDate);
                            params.endTime.setHours(0, 0, 0, 0);
                            params.endTime = (params.endDate - params.endTime.getTime()) / (60 * 1000);
                        } else if (item.end.date) {
                            var date = new Date(item.end.date);
                            date.setDate(date.getDate() - 1);
                            params.endDate = date.getTime();
                        }
                    }
                    if (item.recurringEventId) {
                        if (item.originalStartTime) {
                            params.recurringEventId = item.recurringEventId;
                            if (item.originalStartTime.date) {
                                var now = new Date();
                                params.originalTime = new Date(item.originalStartTime.date).getTime() + now.getTimezoneOffset() * 60000;
                            }
                            if (item.originalStartTime.dateTime) {
                                params.originalTime = new Date(item.originalStartTime.dateTime).getTime();
                            }
                        }
                    }
                    if (item.reminders) {
                        if (item.reminders.overrides) {
                            params.reminders = item.reminders.overrides;
                        }
                    }
                    if (item.sequence) {
                        params.sequence = item.sequence;
                    } else {
                        params.sequence = 0;
                    }
                    if (item.colorId) {
                        params.color = COLORS_SEQUENCE[parseInt(item.colorId) - 1];
                    }
                    params.createDate = (new Date(item.created)).getTime();
                    params.updateDate = (new Date(item.updated)).getTime();
                    params.allDay = item.all_day;
                    for (var i = 0; item.recurrence && i < item.recurrence.length; i++) {
                        var Str = item.recurrence[i];
                        if (Str.indexOf('RRULE:') > -1) {
                            params.repeat = Str.replace('RRULE:', '');
                        } else if (Str.indexOf("EXDATE") > -1) {
                            params.exdate = Str;
                        }
                    }
                    return params;
                }

                function receiveCalendars(data, resultCB) {
                    var calanders = data.items;
                    var googleCal = [];
                    var i = 0;
                    var sync_account = '';
                    if(googleAccount.profile && googleAccount.profile.email){
                        sync_account = googleAccount.profile.email;
                    }
                    for (var j in calanders) {
                        var cal = calanders[j];
                        cal.etag = cal.etag ? cal.etag.replace('\"', '').replace('\"', '') : null;
                        var calendar = new Calendar();
                        calendar.global_id = cal.id, calendar.calendar_rule = 0, calendar.type = CALENDAR_TYPE,
                                calendar.name = cal.summary || null, calendar.timezone = cal.timeZone || null,
                                calendar.selected = 1, calendar.owner_account = cal.summary || null, calendar.sync_account = sync_account,
                                calendar.seqno = i, calendar.color = cal.backgroundColor || '', calendar.sync_version = cal.etag,
                                calendar.create_date = 0, calendar.update_date = 0, calendar.sync_events = 1;
                        if (cal.accessRole === 'owner') {
                            calendar.is_public = 1;
                            if(cal.primary){
                                calendar.is_share = 0;
                            }else{
                                calendar.is_share = 1;
                            }
                            googleCal.push(calendar);
                            i++;
                        } else if (cal.accessRole === 'reader') {
                            var parts = cal.id.split('#');
                            if (!(parts && parts.length === 2 && parts[1] === 'holiday@group.v.calendar.google.com')) {
                                calendar.is_share = 1;
                                googleCal.push(calendar);
                                i++;
                            }

                        }

                    }
                    resultCB && resultCB(googleCal);
                }
                function sendUpdatedEvents(updateListLocal, googleTargetList, newLocalList, syncEventObjs, callBack) {
                    if (syncEventObjs.length === 0) {
                        callBack && callBack(googleTargetList,newLocalList);
                        return;
                    }
                    googleAuthSvc.getAccessToken(function (AT) {

                        var requestObj = {
                            headers: {
                                'Authorization': 'Bearer ' + AT
                            },
                            requestUri: GAPI + 'batch',
                            method: 'POST',
                            data: {
                                __batchRequests: syncEventObjs
                            }
                        };

                        if (AT && syncEventObjs.length > 0) {
                            OData.request(requestObj, function (data, response) {
                                for (var k in data.__batchResponses) {
                                    if (data.__batchResponses[k].statusCode === '200') {
                                        var items = JSON.parse(data.__batchResponses[k].body);
                                        if (items) {
                                            var global_id = '#' + items.id;
                                            googleTargetList[global_id] = [];
                                            updateListLocal[global_id].dirty = 0;
                                            updateListLocal[global_id].update_date = (new Date()).getTime();
                                            
                                            var newObj = {};
                                            $.extend(newObj, updateListLocal[global_id]);
                                            googleTargetList[global_id] = newObj;
                                            var newObjs = {};
                                            $.extend(newObjs, updateListLocal[global_id]);

                                            newLocalList[global_id] = [];
                                            newLocalList[global_id] = newObjs;
                                            newLocalList[global_id].sync_version = items.etag ? items.etag.replace('\"', '').replace('\"', '') : googleTargetList[global_id].sync_version;
                                            newLocalList[global_id].seqno = items.sequence ? items.sequence : googleTargetList[global_id].seqno;
                                        }
                                    }

                                }

                                callBack && callBack(googleTargetList, newLocalList);
                            }, undefined, OData.batchHandler);
                        } else {
                            callBack && callBack(googleTargetList, newLocalList);
                        }
                    });

                }
                function sendInsertedEvents(insertListLocal, googleTargetList,newLocalList, syncEventObjs, callBack) {
                    if (syncEventObjs.length === 0) {
                        callBack && callBack(googleTargetList,newLocalList);
                        return;
                    }
                    googleAuthSvc.getAccessToken(function (AT) {

                        var requestObj = {
                            headers: {
                                'Authorization': 'Bearer ' + AT
                            },
                            requestUri: GAPI + 'batch',
                            method: 'POST',
                            data: {
                                __batchRequests: syncEventObjs
                            }
                        };
                        if (AT && syncEventObjs.length > 0) {    
                            OData.request(requestObj, function (data, response) {
                                for (var k in data.__batchResponses) {
                                    if (data.__batchResponses[k].statusCode === '200') {
                                        var items = JSON.parse(data.__batchResponses[k].body);
                                        if (items) {
                                            var global_id = '#' + items.id;
                                            googleTargetList[global_id] = [];
                                            insertListLocal[k].global_id = items.id;
                                            insertListLocal[k].dirty = 0;
                                            insertListLocal[k].update_date = (new Date()).getTime();
                                            var newObj = {};
                                            $.extend(newObj, insertListLocal[k]);
                                            googleTargetList[global_id] = newObj;
                                            var newObjs = {};
                                            $.extend(newObjs, insertListLocal[k]);
                                            newLocalList[global_id] = [];
                                            newLocalList[global_id] = newObjs;
                                            newLocalList[global_id].sync_version = items.etag ? items.etag.replace('\"', '').replace('\"', '') : googleTargetList[global_id].sync_version;
                                            newLocalList[global_id].seqno = items.sequence ?items.sequence:0;
                                        }
                                    }
                                }
                                callBack && callBack(googleTargetList,newLocalList);
                            }, undefined, OData.batchHandler);
                        } else {
                            callBack && callBack(googleTargetList,newLocalList);
                        }
                    });
                }

                function sendDeletedEvents(delSyncObjs, callBack) {
                    if (delSyncObjs.length === 0) {
                        callBack && callBack();
                        return;
                    }
                    googleAuthSvc.getAccessToken(function (AT) {

                        var requestObj = {
                            headers: {
                                'Authorization': 'Bearer ' + AT
                            },
                            requestUri: GAPI + 'batch',
                            method: 'POST',
                            data: {
                                __batchRequests: delSyncObjs
                            }
                        };
                        if (AT && delSyncObjs.length > 0) {

                            OData.request(requestObj, function (data, response) {
                                callBack && callBack();

                            }, undefined, OData.batchHandler);

                        } else {
                            callBack && callBack();
                        }

                    });
                }

                function sendEvents(params, callBack) {
                    var delListLocal = params.delListLocal;
                    var insertListLocal = params.insertListLocal;
                    var updateListLocal = params.updateListLocal;
                    var insertListChildrenLocal = params.insertListChildrenLocal;
                    var remainingList = params.remainingList;
                    var newLocalList = [];
                    var updateSyncObjs = [];
                    var delSyncObjs = [];
                    var insertSyncObjs = [];
                    var insertChildSyncObjs = [];

                    for (var i = 0; delListLocal && i < delListLocal.length; i++) {
                        delSyncObjs.push(getSyncEventObj(delListLocal[i]));
                    }
                    for (var i = 0; insertListLocal && i < insertListLocal.length; i++) {
                        insertSyncObjs.push(getSyncEventObj(insertListLocal[i]));
                    }
                    for (var key in updateListLocal) {
                        updateSyncObjs.push(getSyncEventObj(updateListLocal[key]));
                    }

                    sendDeletedEvents(delSyncObjs, function () {
                        sendInsertedEvents(insertListLocal, remainingList, newLocalList, insertSyncObjs, function (remainingList, newLocalList) {
                            if(insertListChildrenLocal){
                                for(var i in newLocalList){
                                    for(var j in insertListChildrenLocal){
                                        if(newLocalList[i] && newLocalList[i].id===insertListChildrenLocal[j].parent){
                                            insertListChildrenLocal[j].parent_global = newLocalList[i].global_id;
                                            insertListChildrenLocal[j].seqno = newLocalList[i].seqno;
                                            insertListChildrenLocal[j].sync_version = newLocalList[i].sync_version;
                                            insertChildSyncObjs.push(getSyncEventObj(insertListChildrenLocal[j]));
                                        }
                                    }
                                }
                            }
                            sendInsertedEvents(insertListChildrenLocal, remainingList, newLocalList, insertChildSyncObjs, function (remainingList, newLocalList) {
                                sendUpdatedEvents(updateListLocal, remainingList, newLocalList, updateSyncObjs, function (remainingList, newLocalList) {
                                    for (var key in updateListLocal) {
                                        if (remainingList[key] === undefined) {
                                            remainingList[key] = updateListLocal[key];
                                        }
                                    }
                                    callBack && callBack(remainingList, newLocalList);
                                });
                            });

                        });
                    });

                }
                function sendInsertedTasks(insertListLocal, googleTargetList, syncTaskObjs, callBack) {
                    if (syncTaskObjs.length === 0) {
                        callBack && callBack(googleTargetList);
                        return;
                    }
                    googleAuthSvc.getAccessToken(function (AT) {

                        var requestObj = {
                            headers: {
                                'Authorization': 'Bearer ' + AT
                            },
                            requestUri: GAPI + 'batch',
                            method: 'POST',
                            data: {
                                __batchRequests: syncTaskObjs
                            }
                        };
                        if (AT && syncTaskObjs.length > 0) {

                            OData.request(requestObj, function (data, response) {
                                for (var k in data.__batchResponses) {
                                    if (data.__batchResponses[k].statusCode === '200') {
                                        var items = JSON.parse(data.__batchResponses[k].body);
                                        if (items) {
                                            var global_id = '#' + items.id;
                                            googleTargetList[global_id] = insertListLocal[k];
                                            googleTargetList[global_id].dirty = 0;
                                            googleTargetList[global_id].update_date = (new Date()).getTime();
                                            googleTargetList[global_id].global_id = items.id;
                                        }
                                    }

                                }
                                callBack && callBack(googleTargetList);
                            }, undefined, OData.batchHandler);
                        } else {
                            callBack && callBack(googleTargetList);
                        }
                    });

                }
                function sendUpdatedTasks(updateListLocal, googleTargetList, syncTaskObjs, callBack) {
                    if (syncTaskObjs.length === 0) {
                        callBack && callBack(googleTargetList);
                        return;
                    }
                    googleAuthSvc.getAccessToken(function (AT) {

                        var requestObj = {
                            headers: {
                                'Authorization': 'Bearer ' + AT
                            },
                            requestUri: GAPI + 'batch',
                            method: 'POST',
                            data: {
                                __batchRequests: syncTaskObjs
                            }
                        };

                        if (AT && syncTaskObjs.length > 0) {

                            OData.request(requestObj, function (data, response) {
                                for (var k in data.__batchResponses) {
                                    if (data.__batchResponses[k].statusCode === '200') {
                                        var items = JSON.parse(data.__batchResponses[k].body);

                                        if (items) {
                                            var global_id = '#' + items.id;
                                            googleTargetList[global_id] = updateListLocal[global_id];
                                            googleTargetList[global_id].dirty = 0;
                                            googleTargetList[global_id].update_date = (new Date()).getTime();
                                        }
                                    }

                                }
                                callBack && callBack(googleTargetList);
                            }, undefined, OData.batchHandler);
                        } else {
                            callBack && callBack(googleTargetList);

                        }
                    });

                }

                function sendDeletedTasks(delSyncObjs, callBack) {
                    if (delSyncObjs.length === 0) {
                        callBack && callBack();
                        return;
                    }
                    googleAuthSvc.getAccessToken(function (AT) {

                        var requestObj = {
                            headers: {
                                'Authorization': 'Bearer ' + AT
                            },
                            requestUri: GAPI + 'batch',
                            method: 'POST',
                            data: {
                                __batchRequests: delSyncObjs
                            }
                        };
                        if (AT && delSyncObjs.length > 0) {

                            OData.request(requestObj, function (data, response) {

                                callBack && callBack();

                            }, undefined, OData.batchHandler);
                        } else {
                            callBack && callBack();
                        }

                    });

                }

                function sendTasks(params, callBack) {
                    var delListLocal = params.delListLocal;
                    var insertListLocal = params.insertListLocal;
                    var updateListLocal = params.updateListLocal;
                    var remainingList = params.remainingList;
                    var updateSyncObjs = [];
                    var delSyncObjs = [];
                    var insertSyncObjs = [];

                    for (var i = 0; delListLocal && i < delListLocal.length; i++) {
                        delSyncObjs.push(getSyncTaskObj(delListLocal[i]));
                    }
                    for (var i = 0; insertListLocal && i < insertListLocal.length; i++) {
                        insertSyncObjs.push(getSyncTaskObj(insertListLocal[i]));
                    }
                    for (var key in updateListLocal) {
                        updateSyncObjs.push(getSyncTaskObj(updateListLocal[key]));
                    }
                    sendDeletedTasks(delSyncObjs, function () {

                        sendInsertedTasks(insertListLocal, remainingList, insertSyncObjs, function (remainingList) {

                            sendUpdatedTasks(updateListLocal, remainingList, updateSyncObjs, function (remainingList) {

                                callBack && callBack(remainingList);
                            });
                        });
                    });

                }

                function getTaskObject(param, taskList) {
                    var tasksObj = param.tasks;
                    var task_listData = param.task_list;
                    var tasks = tasksObj.items;
                    for (var i = 0; tasks && i < tasks.length; i++) {
                        var item = tasks[i];
                        if (!item || item.status === 'cancelled' || item.deleted === true) {
                            continue;
                        }

                        var completed = 0;
                        if (item.status === 'completed') {
                            completed = 1;
                        }
                        var due = null;
                        if (item.due) {
                            due = new Date(item.due).getTime();
                        }

                        var t = new TaskJorte();
                        t.global_id = item.id;
                        t.calendar_id = task_listData.id;
                        t.task_list_id = task_listData.id;
                        t.name = item.title;
                        t.memo = item.notes;
                        t.due_date = due;
                        t.start_date = due;
                        t.update_date = (new Date()).getTime();
                        t.dirty = 0;
                        t.type = CALENDAR_TYPE;
                        t.timezone = 'UTC';
                        t.completed = completed;
                        t.importance = 0;
                        t.sync_version = item.etag ? item.etag.replace('\"', '').replace('\"', '') : null;
                        t.status = 1;
                        t.instances = [];
                        t.reminders = [];

                        var end = 0;
                        var begin = 0;
                        if (due) {
                            begin = due;
                            end = begin;
                        }
                        var inst = new EventInstance();
                        inst.begin = begin, inst.end = end;
                        t.instances.push(inst);

                        taskList.unshift(t);
                    }
                }

                function getEventObject(param, eventList, cancelledEventList, updatedEventList) {
                    var calData = param.calendar;
                    var eventsObj = param.events;
                    var calTimeZone = eventsObj.timeZone;
                    var events = eventsObj.items;
                    for (var i = 0; i < events.length; i++) {
                        var item = events[i];
                        var iParams = getEventParams(item, calTimeZone);
                        if (!item) {
                            continue;
                        }
                        if (item.status === 'cancelled') {
                            var c = {};
                            c.global_id = item.id;
                            c.sync_version = item.etag ? item.etag.replace('\"', '').replace('\"', '') : null;
                            c.recurringEventId = iParams.recurringEventId;
                            c.originalTime = iParams.originalTime;
                            cancelledEventList.push(c);
                            continue;
                        }
                        var allDay = 0;
                        if (!iParams.startTime && !iParams.endTime) {
                            allDay = 1;
                            var d = new Date(iParams.startDate);
                            d.setHours(0);
                            d.setMinutes(0);
                            d.setSeconds(0);
                            iParams.startDate = d.getTime();
                            d = new Date(iParams.endDate);
                            d.setHours(23);
                            d.setMinutes(59);
                            d.setSeconds(59);
                            iParams.endDate = d.getTime();
                            iParams.day_time = 1;
                        }

                        var start_dateObj = iParams.startDate ? new Date(iParams.startDate) : null;
                        var end_dateObj = iParams.endDate ? new Date(iParams.endDate) : null;

                        var date_diff = end_dateObj.getTime() - start_dateObj.getTime();
                        var instance_dates = [start_dateObj];
                        var length = instance_dates.length;

                        var repeat = iParams.repeat;
                        var repeatSelectObj = null;
                        var rule = null;
                        var repeatFlag = false;
                        var long_flag = false;
                        if (repeat) {
                            repeat = repeat.toString();
                            repeatSelectObj = RRule.parseString(repeat);
                            if (!repeatSelectObj.count && !repeatSelectObj.until) {
                                repeatSelectObj.count = 90;
                                repeatFlag = true;
                            }
                            repeatSelectObj.dtstart = start_dateObj;
                            rule = new RRule(repeatSelectObj);
                        }
                        var instance_dates = [start_dateObj.toString()];
                        var last_date = null;
                        if (rule) {
                            instance_dates = rule.all();
                            instance_dates = instance_dates.toString().split(',');
                            if(!instance_dates || instance_dates.length===1 && instance_dates[0]===""){
                                instance_dates = [start_dateObj.toString()];
                            }
                            if (iParams.exdate) {
                                var str_list = iParams.exdate.split('EXDATE;');
                                var dateList = [];
                                if (str_list.length > 1) {
                                    if (str_list[1].indexOf('TZID') > -1) {
                                        var new_list = str_list[1].split(':');
                                        var exdate_list = new_list[1];
                                        var tzid = new_list[0].split('=')[1];

                                        exdate_list = exdate_list.split(',');
                                        for (var j = 0; exdate_list && j < exdate_list.length; j++) {
                                            var dateStr = exdate_list[j];
                                            var yyyyMMdd = null, HHmmss = null, year = null, month = null, day = null, hour = 0, minute = 0, second = 0, date = null;

                                            if (exdate_list[j].indexOf('T') > -1) {
                                                var s_list = exdate_list[j].split('T');
                                                if (s_list.length > 1) {
                                                    yyyyMMdd = s_list[0].toString();
                                                    HHmmss = s_list[1].toString();
                                                }
                                            } else {
                                                yyyyMMdd = exdate_list[j].toString();
                                            }
                                            if (yyyyMMdd && yyyyMMdd.length === 8) {
                                                year = parseInt(dateStr.substring(0, 4));
                                                month = parseInt(dateStr.substring(4, 6));
                                                day = parseInt(dateStr.substring(6, 8));
                                            }
                                            if (HHmmss && HHmmss.length === 6) {
                                                hour = parseInt(HHmmss.substring(0, 2));
                                                minute = parseInt(HHmmss.substring(2, 4));
                                                second = parseInt(HHmmss.substring(4, 6));
                                            }
                                            if (year && month && day) {
                                                date = new Date(year, month - 1, day, hour, minute, second);
                                                var new_date = jorteUtils.calcTime(tzid, date.getTime());
                                                dateList.push(new_date.getTime());
                                            }
                                        }
                                        if (instance_dates) {
                                            for (var k = 0; k < instance_dates.length; k++) {
                                                if (dateList.indexOf(new Date(instance_dates[k]).getTime()) > -1) {
                                                    instance_dates.splice(k, 1);
                                                    k--;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            length = instance_dates.length;
                            if (repeatFlag && instance_dates.length !== 0) {
                                length = instance_dates.length - 1;
                            }
                            if (instance_dates) {
                                last_date = new Date(instance_dates[length]).getTime();
                            }
                        }

                        if ((iParams.endDate - iParams.startDate) > (1000 * 60 * 60 * 24)) {
                            long_flag = true;
                        }

                        var e = new EventJorte();
                        e.calendar_id = calData.id;
                        e.global_id = item.id;
                        e.name = item.summary || null;
                        e.content = item.description || null;
                        e.start_date = iParams.startDate;
                        e.start_time = iParams.startTime;
                        e.end_date = iParams.endDate;
                        e.end_time = iParams.endTime;
                        e.repeat = iParams.repeat;
                        e.exdate = iParams.exdate;
                        e.location = item.location || '';
                        e.create_date = item.createDate;
                        e.update_date = (new Date()).getTime();
                        e.dirty = 0;
                        e.all_day = allDay;
                        e.timezone = iParams.timeZone;
                        e.day_time = iParams.day_time;
                        e.seqno = iParams.sequence;
                        e.color = iParams.color;
                        e.sync_version = item.etag ? item.etag.replace('\"', '').replace('\"', '') : null;
                        e.type = CALENDAR_TYPE;
                        e.instances = [];
                        e.reminders = [];
                        e.completed = 0;
                        e.importance = 0;
                        if(item.summary){
                            var icList = item.summary.split('[!/C]');
                            if(icList.length > 1){
                                e.importance = 1;
                                e.completed = 1;
                                e.name = icList[0];
                            }else{
                                var ciList = item.summary.split('[C/!]');
                                if (ciList.length > 1) {
                                    e.importance = 1;
                                    e.completed = 1;
                                    e.name = ciList[0];
                                }
                            }
                            var iList = item.summary.split('[!]');
                            if(iList.length > 1){
                                e.importance = 1;
                                e.name = iList[0];
                            }
                            var cList = item.summary.split('[C]');
                            if(cList.length>1){
                                e.completed = 1;
                                e.name = cList[0];
                            }
                        }
                        
                        e.rep_flag = repeat ? 1 : 0;
                        e.long_flag = long_flag ? 1 : 0;
                        e.last_date = last_date;
                        e.cancelled = null;
                        
                        var begin, end, beginDates = [];
                        for (var j = 0; j < length; j++) {
                            begin = new Date(instance_dates[j]).getTime();
                            beginDates.push(begin); //For setting alarm/notification
                            end = begin + date_diff;
                            var inst = new EventInstance();
                            inst.begin = begin, inst.end = end;
                            e.instances.push(inst);
                        }


                        if (iParams.reminders) {
                            for (var k = 0; k < iParams.reminders.length; k++) {
                                if (!iParams.reminders[k]) {
                                    continue;
                                }
                                var rem = new ReminderJorte();
                                rem.id = new Date().getTime(), rem.minutes = iParams.reminders[k].minutes, rem.type = iParams.reminders[k].minutes;
                                rem.beginDates = beginDates;
                                e.reminders.push(rem);
                            }

                        }
                        var global_id = '#' + item.id;
                        if (iParams.recurringEventId) {
                            e.parent_global = iParams.recurringEventId;
                            e.originalStartDate = iParams.originalTime;
                            updatedEventList[global_id] = e;
                        }else {
                            eventList[global_id] = e;
                        }
                    }
                }
                function proceessCancelledEvents(syncEventList, cancelledEventList, updatedEventList) {
                    for (var i = 0; i < cancelledEventList.length; i++) {
                        var c_event = cancelledEventList[i];
                        if (c_event.recurringEventId) {
                            var cancelledItems = [];
                            var globalId = '#' + c_event.recurringEventId;
                            if (updatedEventList[globalId] !== undefined) {
                                cancelledEventList.splice(i, 1);
                                i--;
                            } else if (syncEventList[globalId] !== undefined) {
                                var instances = syncEventList[globalId].instances;
                                if (instances) {
                                    for (var k = 0; k < instances.length; k++) {
                                        if (instances[k].begin === new Date(c_event.originalTime).getTime()) {
                                            instances.splice(k, 1);
                                            k--;
                                        }
                                    }
                                    var len = instances.length;
                                    syncEventList[globalId].instances = instances;
                                    syncEventList[globalId].last_date = len > 0 ? instances[len - 1].begin : syncEventList[globalId].last_date;
                                    if (!syncEventList[globalId].cancelled) {
                                        syncEventList[globalId].cancelled = [];
                                    } else {
                                        cancelledItems = syncEventList[globalId].cancelled;
                                    }
                                    cancelledItems.push(c_event.originalTime);
                                    syncEventList[globalId].cancelled = cancelledItems;

                                }
                            }
                            if (syncEventList[globalId] && (!syncEventList[globalId].instances || syncEventList[globalId].instances.length === 0)) {
                                delete syncEventList[globalId];

                            }
                        }
                    }
                }
                function receiveEvents(calendarList, resultCB, errorCB) {
                    var k = 0;
                    var syncEventList = [];
                    var cancelledEventList = [];
                    var updatedEventList = [];
                    function collectAPIData(dataStr) {
                        var data = JSON.parse(dataStr);
                        getEventObject({events: data, calendar: calendarList[k]}, syncEventList, cancelledEventList,updatedEventList);
                        if (data.nextPageToken) {
                            getEventsPagination(data.nextPageToken);
                        } else {
                            k++;
                            if (k >= calendarList.length) {
                                if (cancelledEventList.length > 0) {
                                    proceessCancelledEvents(syncEventList,cancelledEventList,updatedEventList);
                                    resultCB && resultCB(syncEventList,updatedEventList);
                                } else {
                                    resultCB && resultCB(syncEventList,updatedEventList);
                                }
                                return;
                            }
                            getEventsPagination(null);
                        }
                    }

                    function getEventsPagination(pageToken) {
                        var url = API + 'calendars/' + encodeURIComponent(calendarList[k].global_id) + '/events?maxResults=2500';
                        if (pageToken) {
                            url += '&pageToken=' + pageToken;
                        }
                        apiGet(url, {}, collectAPIData, function (error) {
                            errorCB && errorCB(error);
                        });
                    }

                    getEventsPagination(null);
                }
                function receiveTasks(task_listList, resultCB, errorCB) {
                    var k = 0;
                    var syncTaskList = [];

                    function collectAPIData(dataStr) {
                        var data = JSON.parse(dataStr);
                        getTaskObject({tasks: data, task_list: task_listList[k]}, syncTaskList);
                        if (data.nextPageToken) {
                            getTasksPagination(data.nextPageToken);
                        } else {
                            k++;
                            if (k >= task_listList.length) {
                                resultCB && resultCB(syncTaskList);
                                return;
                            }
                            getTasksPagination(null);
                        }
                    }

                    function getTasksPagination(pageToken) {
                        var url = TASK_API + 'lists/' + encodeURIComponent(task_listList[k].global_id) + '/tasks?maxResults=100';
                        if (pageToken) {
                            url += '&pageToken=' + pageToken;
                        }
                        apiGet(url, {}, collectAPIData, function (error) {
                            errorCB && errorCB(error);
                        });
                    }

                    getTasksPagination(null);
                }
                function receiveTaskLists(data, resultCB) {
                    var taskLists = data.items;
                    var googleTaskList = [];
                    for (var j in taskLists) {
                        var tList = taskLists[j];
                        tList.etag = tList.etag ? tList.etag.replace('\"', '').replace('\"', '') : null;
                        var task_list = new TaskListJorte();
                        task_list.global_id = tList.id, task_list.type = CALENDAR_TYPE,
                                task_list.name = tList.title || null, task_list.color = '#181c7b',
                                task_list.selected = 1, task_list.create_date = 0, task_list.update_date = 0,
                                task_list.sync_version = tList.etag,
                                task_list.sync_status = 1, task_list.status = 1, task_list.dirty = 0;
                        googleTaskList.push(task_list);

                    }
                    resultCB && resultCB(googleTaskList);

                }

                return {
                    getGoogleAuth: function (params, resultCB) {
                        googleAuthSvc.init();
                        googleAccount = googleAuthSvc.getAccount();
                        if (googleAccount) {
                            googleAuthSvc.saveTmpToken(googleAccount);
                            resultCB && resultCB(true);
                        } else {
                            resultCB && resultCB(false);
                        }
                    },
                    syncCalendars: function (params, resultCB, errorCB) {
                        var googleTargetList = params.list;

                        apiGet(API + 'users/me/calendarList', {
                            minAccessRole: 'owner'
                        }, function (data) {
                            receiveCalendars(JSON.parse(data), function (googleAllCalendars) {
                                for (var i = 0; i < googleTargetList.length; i++) {
                                    var syncItem = googleTargetList[i];
                                    for (var j = 0; j < googleAllCalendars.length; j++) {
                                        var anItem = googleAllCalendars[j];
                                        if (syncItem.global_id === anItem.global_id) {
                                            anItem.id = syncItem.id;
                                            break;
                                        }
                                    }
                                }
                                resultCB(googleAllCalendars);
                            });

                        }, function (error) {
                            errorCB && errorCB(error);
                        });
                    },
                    syncEvents: function (params, resultCB, errorCB) {
                        var calendarList = params.calendarList;
                            sendEvents(params, function (list, newLocalList) {
                                receiveEvents(calendarList, function (googleAllEvents,googleChildEvents) {
                                    resultCB(googleAllEvents,googleChildEvents, list);
                                }, function (error) {
                                    errorCB && errorCB(error);
                                });

                            }, function (error) {
                                errorCB && errorCB(error);
                            });
                    },
                    syncTaskLists: function (params, resultCB, errorCB) {
                        var googleTargetList = params.list;
                        apiGet(TASK_API + 'users/@me/lists?key={' + jorteConfig.GAPI.clientId + '}', {}, function (data) {
                            receiveTaskLists(JSON.parse(data), function (googleAllTaskLists) {
                                for (var i = 0; i < googleTargetList.length; i++) {
                                    var syncItem = googleTargetList[i];
                                    for (var j = 0; j < googleAllTaskLists.length; j++) {
                                        var anItem = googleAllTaskLists[j];
                                        if (syncItem.global_id === anItem.global_id) {
                                            anItem.id = syncItem.id;
                                            break;
                                        }
                                    }
                                }
                                resultCB(googleAllTaskLists);
                            });
                        }, function (error) {
                            errorCB && errorCB(error);
                        });

                    },
                    syncTasks: function (params, resultCB, errorCB) {
                        var task_listList = params.task_listList;
                        sendTasks(params, function (list) {
                            receiveTasks(task_listList, function (googleAllTasks) {
                                resultCB(googleAllTasks, list);
                            }, function (error) {
                                errorCB && errorCB(error);
                            });

                        });
                    },
                    syncSingleEvent: function (params, resultCB) {
                        sendEvents(params, function (googleSyncList, newLocalList) {
                            var result = null;
                            for (var key in newLocalList) {
                                result = newLocalList[key];
                            }
                            resultCB(result);
                        });

                    },
                    syncSingleTask: function (params, resultCB) {
                        sendTasks(params, function (googleSyncList) {
                            var result = null;
                            for (var key in googleSyncList) {
                                result = googleSyncList[key];
                            }
                            resultCB(result);
                        });
                    }
                };
            }]);